#
# @file    TestConsistencyChecks.py
# @brief   Reads test-data/inconsistent.xml into memory and tests it.
#
# @author  Akiya Jouraku (Python conversion)
# @author  Sarah Keating 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestConsistencyChecks.cpp
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestConsistencyChecks(unittest.TestCase):


  def test_consistency_checks(self):
    reader = libsbml.SBMLReader()
    filename = "../../sbml/test/test-data/"
    filename += "inconsistent.xml"
    d = reader.readSBML(filename)
    if (d == None):
      pass    
    errors = d.checkConsistency()
    self.assert_( errors == 1 )
    self.assert_( d.getError(0).getErrorId() == 10301 )
    d.getErrorLog().clearLog()
    d.setConsistencyChecks(libsbml.LIBSBML_CAT_IDENTIFIER_CONSISTENCY,False)
    errors = d.checkConsistency()
    self.assert_( errors == 2 )
    self.assert_( d.getError(0).getErrorId() == 10214 )
    self.assert_( d.getError(1).getErrorId() == 20612 )
    d.getErrorLog().clearLog()
    d.setConsistencyChecks(libsbml.LIBSBML_CAT_GENERAL_CONSISTENCY,False)
    errors = d.checkConsistency()
    self.assert_( errors == 1 )
    self.assert_( d.getError(0).getErrorId() == 10701 )
    d.getErrorLog().clearLog()
    d.setConsistencyChecks(libsbml.LIBSBML_CAT_SBO_CONSISTENCY,False)
    errors = d.checkConsistency()
    self.assert_( errors == 1 )
    self.assert_( d.getError(0).getErrorId() == 10214 )
    d.getErrorLog().clearLog()
    d.setConsistencyChecks(libsbml.LIBSBML_CAT_MATHML_CONSISTENCY,False)
    errors = d.checkConsistency()
    self.assert_( errors == 4 )
    self.assert_( d.getError(0).getErrorId() == 99505 )
    self.assert_( d.getError(1).getErrorId() == 99505 )
    self.assert_( d.getError(2).getErrorId() == 99505 )
    self.assert_( d.getError(3).getErrorId() == 80701 )
    d.getErrorLog().clearLog()
    d.setConsistencyChecks(libsbml.LIBSBML_CAT_UNITS_CONSISTENCY,False)
    errors = d.checkConsistency()
    self.assert_( errors == 0 )
    d = None
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestConsistencyChecks))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
