;Testname=avx512f; Arguments=-fbin -oavx512f.bin -O0 -DSRC; Files=stdout stderr avx512f.bin
; AVX-512F testcases from gas
;------------------------
;
; This file is taken from there
;     https://gnu.googlesource.com/binutils/+/master/gas/testsuite/gas/i386/x86-64-avx512f-intel.d
; So the original author is "H.J. Lu" <hongjiu dot lu at intel dot com>
;
; Jin Kyu Song converted it for the nasm testing suite using gas2nasm.py

%macro testcase 2
 %ifdef BIN
  db %1
 %endif
 %ifdef SRC
  %2
 %endif
%endmacro


bits 64

testcase	{ 0x62, 0x01, 0x95, 0x40, 0x58, 0xf4                                     }, { vaddpd zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0x58, 0xf4                                     }, { vaddpd zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0x58, 0xf4                                     }, { vaddpd zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x95, 0x10, 0x58, 0xf4                                     }, { vaddpd zmm30,zmm29,zmm28,{rn-sae}                            }
testcase	{ 0x62, 0x01, 0x95, 0x50, 0x58, 0xf4                                     }, { vaddpd zmm30,zmm29,zmm28,{ru-sae}                            }
testcase	{ 0x62, 0x01, 0x95, 0x30, 0x58, 0xf4                                     }, { vaddpd zmm30,zmm29,zmm28,{rd-sae}                            }
testcase	{ 0x62, 0x01, 0x95, 0x70, 0x58, 0xf4                                     }, { vaddpd zmm30,zmm29,zmm28,{rz-sae}                            }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x58, 0x31                                     }, { vaddpd zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0x58, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vaddpd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x58, 0x31                                     }, { vaddpd zmm30,zmm29,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x58, 0x72, 0x7f                               }, { vaddpd zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x58, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vaddpd zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x58, 0x72, 0x80                               }, { vaddpd zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x58, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vaddpd zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x58, 0x72, 0x7f                               }, { vaddpd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x58, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vaddpd zmm30,zmm29,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x58, 0x72, 0x80                               }, { vaddpd zmm30,zmm29,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x58, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vaddpd zmm30,zmm29,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x01, 0x14, 0x40, 0x58, 0xf4                                     }, { vaddps zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x14, 0x47, 0x58, 0xf4                                     }, { vaddps zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x14, 0xc7, 0x58, 0xf4                                     }, { vaddps zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x14, 0x10, 0x58, 0xf4                                     }, { vaddps zmm30,zmm29,zmm28,{rn-sae}                            }
testcase	{ 0x62, 0x01, 0x14, 0x50, 0x58, 0xf4                                     }, { vaddps zmm30,zmm29,zmm28,{ru-sae}                            }
testcase	{ 0x62, 0x01, 0x14, 0x30, 0x58, 0xf4                                     }, { vaddps zmm30,zmm29,zmm28,{rd-sae}                            }
testcase	{ 0x62, 0x01, 0x14, 0x70, 0x58, 0xf4                                     }, { vaddps zmm30,zmm29,zmm28,{rz-sae}                            }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x58, 0x31                                     }, { vaddps zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x14, 0x40, 0x58, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vaddps zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x58, 0x31                                     }, { vaddps zmm30,zmm29,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x58, 0x72, 0x7f                               }, { vaddps zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x58, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vaddps zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x58, 0x72, 0x80                               }, { vaddps zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x58, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vaddps zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x58, 0x72, 0x7f                               }, { vaddps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x58, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vaddps zmm30,zmm29,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x58, 0x72, 0x80                               }, { vaddps zmm30,zmm29,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x58, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vaddps zmm30,zmm29,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x01, 0x97, 0x07, 0x58, 0xf4                                     }, { vaddsd xmm30{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x97, 0x87, 0x58, 0xf4                                     }, { vaddsd xmm30{k7}{z},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x97, 0x17, 0x58, 0xf4                                     }, { vaddsd xmm30{k7},xmm29,xmm28,{rn-sae}                        }
testcase	{ 0x62, 0x01, 0x97, 0x57, 0x58, 0xf4                                     }, { vaddsd xmm30{k7},xmm29,xmm28,{ru-sae}                        }
testcase	{ 0x62, 0x01, 0x97, 0x37, 0x58, 0xf4                                     }, { vaddsd xmm30{k7},xmm29,xmm28,{rd-sae}                        }
testcase	{ 0x62, 0x01, 0x97, 0x77, 0x58, 0xf4                                     }, { vaddsd xmm30{k7},xmm29,xmm28,{rz-sae}                        }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x58, 0x31                                     }, { vaddsd xmm30{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x97, 0x07, 0x58, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vaddsd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x58, 0x72, 0x7f                               }, { vaddsd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x58, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vaddsd xmm30{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x58, 0x72, 0x80                               }, { vaddsd xmm30{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x58, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vaddsd xmm30{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x01, 0x16, 0x07, 0x58, 0xf4                                     }, { vaddss xmm30{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x16, 0x87, 0x58, 0xf4                                     }, { vaddss xmm30{k7}{z},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x16, 0x17, 0x58, 0xf4                                     }, { vaddss xmm30{k7},xmm29,xmm28,{rn-sae}                        }
testcase	{ 0x62, 0x01, 0x16, 0x57, 0x58, 0xf4                                     }, { vaddss xmm30{k7},xmm29,xmm28,{ru-sae}                        }
testcase	{ 0x62, 0x01, 0x16, 0x37, 0x58, 0xf4                                     }, { vaddss xmm30{k7},xmm29,xmm28,{rd-sae}                        }
testcase	{ 0x62, 0x01, 0x16, 0x77, 0x58, 0xf4                                     }, { vaddss xmm30{k7},xmm29,xmm28,{rz-sae}                        }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x58, 0x31                                     }, { vaddss xmm30{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x16, 0x07, 0x58, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vaddss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x58, 0x72, 0x7f                               }, { vaddss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x58, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vaddss xmm30{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x58, 0x72, 0x80                               }, { vaddss xmm30{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x58, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vaddss xmm30{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x03, 0x15, 0x40, 0x03, 0xf4, 0xab                               }, { valignd zmm30,zmm29,zmm28,0xab                               }
testcase	{ 0x62, 0x03, 0x15, 0x47, 0x03, 0xf4, 0xab                               }, { valignd zmm30{k7},zmm29,zmm28,0xab                           }
testcase	{ 0x62, 0x03, 0x15, 0xc7, 0x03, 0xf4, 0xab                               }, { valignd zmm30{k7}{z},zmm29,zmm28,0xab                        }
testcase	{ 0x62, 0x03, 0x15, 0x40, 0x03, 0xf4, 0x7b                               }, { valignd zmm30,zmm29,zmm28,0x7b                               }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x03, 0x31, 0x7b                               }, { valignd zmm30,zmm29,ZWORD [rcx],0x7b                         }
testcase	{ 0x62, 0x23, 0x15, 0x40, 0x03, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { valignd zmm30,zmm29,ZWORD [rax+r14*8+0x123],0x7b             }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x03, 0x31, 0x7b                               }, { valignd zmm30,zmm29,DWORD [rcx]{1to16},0x7b                  }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x03, 0x72, 0x7f, 0x7b                         }, { valignd zmm30,zmm29,ZWORD [rdx+0x1fc0],0x7b                  }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x03, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { valignd zmm30,zmm29,ZWORD [rdx+0x2000],0x7b                  }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x03, 0x72, 0x80, 0x7b                         }, { valignd zmm30,zmm29,ZWORD [rdx-0x2000],0x7b                  }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x03, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { valignd zmm30,zmm29,ZWORD [rdx-0x2040],0x7b                  }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x03, 0x72, 0x7f, 0x7b                         }, { valignd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16},0x7b            }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x03, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { valignd zmm30,zmm29,DWORD [rdx+0x200]{1to16},0x7b            }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x03, 0x72, 0x80, 0x7b                         }, { valignd zmm30,zmm29,DWORD [rdx-0x200]{1to16},0x7b            }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x03, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { valignd zmm30,zmm29,DWORD [rdx-0x204]{1to16},0x7b            }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x65, 0xf4                                     }, { vblendmpd zmm30,zmm29,zmm28                                  }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x65, 0xf4                                     }, { vblendmpd zmm30{k7},zmm29,zmm28                              }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x65, 0xf4                                     }, { vblendmpd zmm30{k7}{z},zmm29,zmm28                           }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x65, 0x31                                     }, { vblendmpd zmm30,zmm29,ZWORD [rcx]                            }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x65, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vblendmpd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x65, 0x31                                     }, { vblendmpd zmm30,zmm29,QWORD [rcx]{1to8}                      }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x65, 0x72, 0x7f                               }, { vblendmpd zmm30,zmm29,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x65, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vblendmpd zmm30,zmm29,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x65, 0x72, 0x80                               }, { vblendmpd zmm30,zmm29,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x65, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vblendmpd zmm30,zmm29,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x65, 0x72, 0x7f                               }, { vblendmpd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x65, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vblendmpd zmm30,zmm29,QWORD [rdx+0x400]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x65, 0x72, 0x80                               }, { vblendmpd zmm30,zmm29,QWORD [rdx-0x400]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x65, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vblendmpd zmm30,zmm29,QWORD [rdx-0x408]{1to8}                }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x65, 0xf4                                     }, { vblendmps zmm30,zmm29,zmm28                                  }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x65, 0xf4                                     }, { vblendmps zmm30{k7},zmm29,zmm28                              }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x65, 0xf4                                     }, { vblendmps zmm30{k7}{z},zmm29,zmm28                           }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x65, 0x31                                     }, { vblendmps zmm30,zmm29,ZWORD [rcx]                            }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x65, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vblendmps zmm30,zmm29,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x65, 0x31                                     }, { vblendmps zmm30,zmm29,DWORD [rcx]{1to16}                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x65, 0x72, 0x7f                               }, { vblendmps zmm30,zmm29,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x65, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vblendmps zmm30,zmm29,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x65, 0x72, 0x80                               }, { vblendmps zmm30,zmm29,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x65, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vblendmps zmm30,zmm29,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x65, 0x72, 0x7f                               }, { vblendmps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x65, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vblendmps zmm30,zmm29,DWORD [rdx+0x200]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x65, 0x72, 0x80                               }, { vblendmps zmm30,zmm29,DWORD [rdx-0x200]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x65, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vblendmps zmm30,zmm29,DWORD [rdx-0x204]{1to16}               }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x1a, 0x31                                     }, { vbroadcastf32x4 zmm30,OWORD [rcx]                            }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x1a, 0x31                                     }, { vbroadcastf32x4 zmm30{k7},OWORD [rcx]                        }
testcase	{ 0x62, 0x62, 0x7d, 0xcf, 0x1a, 0x31                                     }, { vbroadcastf32x4 zmm30{k7}{z},OWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0x7d, 0x48, 0x1a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vbroadcastf32x4 zmm30,OWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x1a, 0x72, 0x7f                               }, { vbroadcastf32x4 zmm30,OWORD [rdx+0x7f0]                      }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x1a, 0xb2, 0x00, 0x08, 0x00, 0x00             }, { vbroadcastf32x4 zmm30,OWORD [rdx+0x800]                      }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x1a, 0x72, 0x80                               }, { vbroadcastf32x4 zmm30,OWORD [rdx-0x800]                      }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x1a, 0xb2, 0xf0, 0xf7, 0xff, 0xff             }, { vbroadcastf32x4 zmm30,OWORD [rdx-0x810]                      }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x1b, 0x31                                     }, { vbroadcastf64x4 zmm30,YWORD [rcx]                            }
testcase	{ 0x62, 0x62, 0xfd, 0x4f, 0x1b, 0x31                                     }, { vbroadcastf64x4 zmm30{k7},YWORD [rcx]                        }
testcase	{ 0x62, 0x62, 0xfd, 0xcf, 0x1b, 0x31                                     }, { vbroadcastf64x4 zmm30{k7}{z},YWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0xfd, 0x48, 0x1b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vbroadcastf64x4 zmm30,YWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x1b, 0x72, 0x7f                               }, { vbroadcastf64x4 zmm30,YWORD [rdx+0xfe0]                      }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x1b, 0xb2, 0x00, 0x10, 0x00, 0x00             }, { vbroadcastf64x4 zmm30,YWORD [rdx+0x1000]                     }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x1b, 0x72, 0x80                               }, { vbroadcastf64x4 zmm30,YWORD [rdx-0x1000]                     }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x1b, 0xb2, 0xe0, 0xef, 0xff, 0xff             }, { vbroadcastf64x4 zmm30,YWORD [rdx-0x1020]                     }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x5a, 0x31                                     }, { vbroadcasti32x4 zmm30,OWORD [rcx]                            }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x5a, 0x31                                     }, { vbroadcasti32x4 zmm30{k7},OWORD [rcx]                        }
testcase	{ 0x62, 0x62, 0x7d, 0xcf, 0x5a, 0x31                                     }, { vbroadcasti32x4 zmm30{k7}{z},OWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0x7d, 0x48, 0x5a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vbroadcasti32x4 zmm30,OWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x5a, 0x72, 0x7f                               }, { vbroadcasti32x4 zmm30,OWORD [rdx+0x7f0]                      }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x5a, 0xb2, 0x00, 0x08, 0x00, 0x00             }, { vbroadcasti32x4 zmm30,OWORD [rdx+0x800]                      }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x5a, 0x72, 0x80                               }, { vbroadcasti32x4 zmm30,OWORD [rdx-0x800]                      }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x5a, 0xb2, 0xf0, 0xf7, 0xff, 0xff             }, { vbroadcasti32x4 zmm30,OWORD [rdx-0x810]                      }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x5b, 0x31                                     }, { vbroadcasti64x4 zmm30,YWORD [rcx]                            }
testcase	{ 0x62, 0x62, 0xfd, 0x4f, 0x5b, 0x31                                     }, { vbroadcasti64x4 zmm30{k7},YWORD [rcx]                        }
testcase	{ 0x62, 0x62, 0xfd, 0xcf, 0x5b, 0x31                                     }, { vbroadcasti64x4 zmm30{k7}{z},YWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0xfd, 0x48, 0x5b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vbroadcasti64x4 zmm30,YWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x5b, 0x72, 0x7f                               }, { vbroadcasti64x4 zmm30,YWORD [rdx+0xfe0]                      }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x5b, 0xb2, 0x00, 0x10, 0x00, 0x00             }, { vbroadcasti64x4 zmm30,YWORD [rdx+0x1000]                     }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x5b, 0x72, 0x80                               }, { vbroadcasti64x4 zmm30,YWORD [rdx-0x1000]                     }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x5b, 0xb2, 0xe0, 0xef, 0xff, 0xff             }, { vbroadcasti64x4 zmm30,YWORD [rdx-0x1020]                     }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x19, 0x31                                     }, { vbroadcastsd zmm30,QWORD [rcx]                               }
testcase	{ 0x62, 0x62, 0xfd, 0x4f, 0x19, 0x31                                     }, { vbroadcastsd zmm30{k7},QWORD [rcx]                           }
testcase	{ 0x62, 0x62, 0xfd, 0xcf, 0x19, 0x31                                     }, { vbroadcastsd zmm30{k7}{z},QWORD [rcx]                        }
testcase	{ 0x62, 0x22, 0xfd, 0x48, 0x19, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vbroadcastsd zmm30,QWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x19, 0x72, 0x7f                               }, { vbroadcastsd zmm30,QWORD [rdx+0x3f8]                         }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x19, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vbroadcastsd zmm30,QWORD [rdx+0x400]                         }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x19, 0x72, 0x80                               }, { vbroadcastsd zmm30,QWORD [rdx-0x400]                         }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x19, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vbroadcastsd zmm30,QWORD [rdx-0x408]                         }
testcase	{ 0x62, 0x02, 0xfd, 0x4f, 0x19, 0xf5                                     }, { vbroadcastsd zmm30{k7},xmm29                                 }
testcase	{ 0x62, 0x02, 0xfd, 0xcf, 0x19, 0xf5                                     }, { vbroadcastsd zmm30{k7}{z},xmm29                              }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x18, 0x31                                     }, { vbroadcastss zmm30,DWORD [rcx]                               }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x18, 0x31                                     }, { vbroadcastss zmm30{k7},DWORD [rcx]                           }
testcase	{ 0x62, 0x62, 0x7d, 0xcf, 0x18, 0x31                                     }, { vbroadcastss zmm30{k7}{z},DWORD [rcx]                        }
testcase	{ 0x62, 0x22, 0x7d, 0x48, 0x18, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vbroadcastss zmm30,DWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x18, 0x72, 0x7f                               }, { vbroadcastss zmm30,DWORD [rdx+0x1fc]                         }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x18, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vbroadcastss zmm30,DWORD [rdx+0x200]                         }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x18, 0x72, 0x80                               }, { vbroadcastss zmm30,DWORD [rdx-0x200]                         }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x18, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vbroadcastss zmm30,DWORD [rdx-0x204]                         }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x18, 0xf5                                     }, { vbroadcastss zmm30{k7},xmm29                                 }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x18, 0xf5                                     }, { vbroadcastss zmm30{k7}{z},xmm29                              }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0xab                               }, { vcmppd k5,zmm30,zmm29,0xab                                   }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0xab                               }, { vcmppd k5{k7},zmm30,zmm29,0xab                               }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0xab                               }, { vcmppd k5,zmm30,zmm29,{sae},0xab                             }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x7b                               }, { vcmppd k5,zmm30,zmm29,0x7b                                   }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x7b                               }, { vcmppd k5,zmm30,zmm29,{sae},0x7b                             }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x7b                               }, { vcmppd k5,zmm30,ZWORD [rcx],0x7b                             }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vcmppd k5,zmm30,ZWORD [rax+r14*8+0x123],0x7b                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x7b                               }, { vcmppd k5,zmm30,QWORD [rcx]{1to8},0x7b                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x7b                         }, { vcmppd k5,zmm30,ZWORD [rdx+0x1fc0],0x7b                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vcmppd k5,zmm30,ZWORD [rdx+0x2000],0x7b                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x7b                         }, { vcmppd k5,zmm30,ZWORD [rdx-0x2000],0x7b                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vcmppd k5,zmm30,ZWORD [rdx-0x2040],0x7b                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x7b                         }, { vcmppd k5,zmm30,QWORD [rdx+0x3f8]{1to8},0x7b                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vcmppd k5,zmm30,QWORD [rdx+0x400]{1to8},0x7b                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x7b                         }, { vcmppd k5,zmm30,QWORD [rdx-0x400]{1to8},0x7b                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vcmppd k5,zmm30,QWORD [rdx-0x408]{1to8},0x7b                 }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x00                               }, { vcmpeqpd k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x00                               }, { vcmpeqpd k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x00                               }, { vcmpeqpd k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x00                               }, { vcmpeqpd k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x00 }, { vcmpeqpd k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x00                               }, { vcmpeqpd k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x00                         }, { vcmpeqpd k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x00       }, { vcmpeqpd k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x00                         }, { vcmpeqpd k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x00       }, { vcmpeqpd k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x00                         }, { vcmpeqpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x00       }, { vcmpeqpd k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x00                         }, { vcmpeqpd k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x00       }, { vcmpeqpd k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x00                               }, { vcmpeqpd k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x00                               }, { vcmpeqpd k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x00                               }, { vcmpeqpd k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x00                               }, { vcmpeqpd k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x00 }, { vcmpeqpd k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x00                               }, { vcmpeqpd k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x00                         }, { vcmpeqpd k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x00       }, { vcmpeqpd k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x00                         }, { vcmpeqpd k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x00       }, { vcmpeqpd k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x00                         }, { vcmpeqpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x00       }, { vcmpeqpd k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x00                         }, { vcmpeqpd k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x00       }, { vcmpeqpd k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x01                               }, { vcmpltpd k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x01                               }, { vcmpltpd k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x01                               }, { vcmpltpd k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x01                               }, { vcmpltpd k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x01 }, { vcmpltpd k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x01                               }, { vcmpltpd k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x01                         }, { vcmpltpd k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x01       }, { vcmpltpd k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x01                         }, { vcmpltpd k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x01       }, { vcmpltpd k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x01                         }, { vcmpltpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x01       }, { vcmpltpd k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x01                         }, { vcmpltpd k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x01       }, { vcmpltpd k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x01                               }, { vcmpltpd k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x01                               }, { vcmpltpd k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x01                               }, { vcmpltpd k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x01                               }, { vcmpltpd k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x01 }, { vcmpltpd k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x01                               }, { vcmpltpd k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x01                         }, { vcmpltpd k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x01       }, { vcmpltpd k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x01                         }, { vcmpltpd k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x01       }, { vcmpltpd k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x01                         }, { vcmpltpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x01       }, { vcmpltpd k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x01                         }, { vcmpltpd k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x01       }, { vcmpltpd k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x02                               }, { vcmplepd k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x02                               }, { vcmplepd k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x02                               }, { vcmplepd k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x02                               }, { vcmplepd k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x02 }, { vcmplepd k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x02                               }, { vcmplepd k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x02                         }, { vcmplepd k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x02       }, { vcmplepd k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x02                         }, { vcmplepd k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x02       }, { vcmplepd k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x02                         }, { vcmplepd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x02       }, { vcmplepd k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x02                         }, { vcmplepd k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x02       }, { vcmplepd k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x02                               }, { vcmplepd k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x02                               }, { vcmplepd k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x02                               }, { vcmplepd k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x02                               }, { vcmplepd k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x02 }, { vcmplepd k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x02                               }, { vcmplepd k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x02                         }, { vcmplepd k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x02       }, { vcmplepd k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x02                         }, { vcmplepd k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x02       }, { vcmplepd k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x02                         }, { vcmplepd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x02       }, { vcmplepd k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x02                         }, { vcmplepd k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x02       }, { vcmplepd k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x03                               }, { vcmpunordpd k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x03                               }, { vcmpunordpd k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x03                               }, { vcmpunordpd k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x03                               }, { vcmpunordpd k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x03 }, { vcmpunordpd k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x03                               }, { vcmpunordpd k5,zmm30,QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x03                         }, { vcmpunordpd k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x03       }, { vcmpunordpd k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x03                         }, { vcmpunordpd k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x03       }, { vcmpunordpd k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x03                         }, { vcmpunordpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x03       }, { vcmpunordpd k5,zmm30,QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x03                         }, { vcmpunordpd k5,zmm30,QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x03       }, { vcmpunordpd k5,zmm30,QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x03                               }, { vcmpunordpd k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x03                               }, { vcmpunordpd k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x03                               }, { vcmpunordpd k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x03                               }, { vcmpunordpd k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x03 }, { vcmpunordpd k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x03                               }, { vcmpunordpd k5,zmm30,QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x03                         }, { vcmpunordpd k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x03       }, { vcmpunordpd k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x03                         }, { vcmpunordpd k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x03       }, { vcmpunordpd k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x03                         }, { vcmpunordpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x03       }, { vcmpunordpd k5,zmm30,QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x03                         }, { vcmpunordpd k5,zmm30,QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x03       }, { vcmpunordpd k5,zmm30,QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x04                               }, { vcmpneqpd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x04                               }, { vcmpneqpd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x04                               }, { vcmpneqpd k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x04                               }, { vcmpneqpd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x04 }, { vcmpneqpd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x04                               }, { vcmpneqpd k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x04                         }, { vcmpneqpd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x04       }, { vcmpneqpd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x04                         }, { vcmpneqpd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x04       }, { vcmpneqpd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x04                         }, { vcmpneqpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x04       }, { vcmpneqpd k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x04                         }, { vcmpneqpd k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x04       }, { vcmpneqpd k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x04                               }, { vcmpneqpd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x04                               }, { vcmpneqpd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x04                               }, { vcmpneqpd k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x04                               }, { vcmpneqpd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x04 }, { vcmpneqpd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x04                               }, { vcmpneqpd k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x04                         }, { vcmpneqpd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x04       }, { vcmpneqpd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x04                         }, { vcmpneqpd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x04       }, { vcmpneqpd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x04                         }, { vcmpneqpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x04       }, { vcmpneqpd k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x04                         }, { vcmpneqpd k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x04       }, { vcmpneqpd k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x05                               }, { vcmpnltpd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x05                               }, { vcmpnltpd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x05                               }, { vcmpnltpd k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x05                               }, { vcmpnltpd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x05 }, { vcmpnltpd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x05                               }, { vcmpnltpd k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x05                         }, { vcmpnltpd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x05       }, { vcmpnltpd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x05                         }, { vcmpnltpd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x05       }, { vcmpnltpd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x05                         }, { vcmpnltpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x05       }, { vcmpnltpd k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x05                         }, { vcmpnltpd k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x05       }, { vcmpnltpd k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x05                               }, { vcmpnltpd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x05                               }, { vcmpnltpd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x05                               }, { vcmpnltpd k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x05                               }, { vcmpnltpd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x05 }, { vcmpnltpd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x05                               }, { vcmpnltpd k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x05                         }, { vcmpnltpd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x05       }, { vcmpnltpd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x05                         }, { vcmpnltpd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x05       }, { vcmpnltpd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x05                         }, { vcmpnltpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x05       }, { vcmpnltpd k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x05                         }, { vcmpnltpd k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x05       }, { vcmpnltpd k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x06                               }, { vcmpnlepd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x06                               }, { vcmpnlepd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x06                               }, { vcmpnlepd k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x06                               }, { vcmpnlepd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x06 }, { vcmpnlepd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x06                               }, { vcmpnlepd k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x06                         }, { vcmpnlepd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x06       }, { vcmpnlepd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x06                         }, { vcmpnlepd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x06       }, { vcmpnlepd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x06                         }, { vcmpnlepd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x06       }, { vcmpnlepd k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x06                         }, { vcmpnlepd k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x06       }, { vcmpnlepd k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x06                               }, { vcmpnlepd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x06                               }, { vcmpnlepd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x06                               }, { vcmpnlepd k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x06                               }, { vcmpnlepd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x06 }, { vcmpnlepd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x06                               }, { vcmpnlepd k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x06                         }, { vcmpnlepd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x06       }, { vcmpnlepd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x06                         }, { vcmpnlepd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x06       }, { vcmpnlepd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x06                         }, { vcmpnlepd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x06       }, { vcmpnlepd k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x06                         }, { vcmpnlepd k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x06       }, { vcmpnlepd k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x07                               }, { vcmpordpd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x07                               }, { vcmpordpd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x07                               }, { vcmpordpd k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x07                               }, { vcmpordpd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x07 }, { vcmpordpd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x07                               }, { vcmpordpd k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x07                         }, { vcmpordpd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x07       }, { vcmpordpd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x07                         }, { vcmpordpd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x07       }, { vcmpordpd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x07                         }, { vcmpordpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x07       }, { vcmpordpd k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x07                         }, { vcmpordpd k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x07       }, { vcmpordpd k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x07                               }, { vcmpordpd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x07                               }, { vcmpordpd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x07                               }, { vcmpordpd k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x07                               }, { vcmpordpd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x07 }, { vcmpordpd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x07                               }, { vcmpordpd k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x07                         }, { vcmpordpd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x07       }, { vcmpordpd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x07                         }, { vcmpordpd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x07       }, { vcmpordpd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x07                         }, { vcmpordpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x07       }, { vcmpordpd k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x07                         }, { vcmpordpd k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x07       }, { vcmpordpd k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x08                               }, { vcmpeq_uqpd k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x08                               }, { vcmpeq_uqpd k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x08                               }, { vcmpeq_uqpd k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x08                               }, { vcmpeq_uqpd k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x08 }, { vcmpeq_uqpd k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x08                               }, { vcmpeq_uqpd k5,zmm30,QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x08                         }, { vcmpeq_uqpd k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x08       }, { vcmpeq_uqpd k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x08                         }, { vcmpeq_uqpd k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x08       }, { vcmpeq_uqpd k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x08                         }, { vcmpeq_uqpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x08       }, { vcmpeq_uqpd k5,zmm30,QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x08                         }, { vcmpeq_uqpd k5,zmm30,QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x08       }, { vcmpeq_uqpd k5,zmm30,QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x09                               }, { vcmpngepd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x09                               }, { vcmpngepd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x09                               }, { vcmpngepd k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x09                               }, { vcmpngepd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x09 }, { vcmpngepd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x09                               }, { vcmpngepd k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x09                         }, { vcmpngepd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x09       }, { vcmpngepd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x09                         }, { vcmpngepd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x09       }, { vcmpngepd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x09                         }, { vcmpngepd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x09       }, { vcmpngepd k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x09                         }, { vcmpngepd k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x09       }, { vcmpngepd k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x09                               }, { vcmpngepd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x09                               }, { vcmpngepd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x09                               }, { vcmpngepd k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x09                               }, { vcmpngepd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x09 }, { vcmpngepd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x09                               }, { vcmpngepd k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x09                         }, { vcmpngepd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x09       }, { vcmpngepd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x09                         }, { vcmpngepd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x09       }, { vcmpngepd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x09                         }, { vcmpngepd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x09       }, { vcmpngepd k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x09                         }, { vcmpngepd k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x09       }, { vcmpngepd k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x0a                               }, { vcmpngtpd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x0a                               }, { vcmpngtpd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x0a                               }, { vcmpngtpd k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x0a                               }, { vcmpngtpd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0a }, { vcmpngtpd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x0a                               }, { vcmpngtpd k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x0a                         }, { vcmpngtpd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0a       }, { vcmpngtpd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x0a                         }, { vcmpngtpd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0a       }, { vcmpngtpd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x0a                         }, { vcmpngtpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0a       }, { vcmpngtpd k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x0a                         }, { vcmpngtpd k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0a       }, { vcmpngtpd k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x0a                               }, { vcmpngtpd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x0a                               }, { vcmpngtpd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x0a                               }, { vcmpngtpd k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x0a                               }, { vcmpngtpd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0a }, { vcmpngtpd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x0a                               }, { vcmpngtpd k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x0a                         }, { vcmpngtpd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0a       }, { vcmpngtpd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x0a                         }, { vcmpngtpd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0a       }, { vcmpngtpd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x0a                         }, { vcmpngtpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0a       }, { vcmpngtpd k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x0a                         }, { vcmpngtpd k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0a       }, { vcmpngtpd k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x0b                               }, { vcmpfalsepd k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x0b                               }, { vcmpfalsepd k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x0b                               }, { vcmpfalsepd k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x0b                               }, { vcmpfalsepd k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0b }, { vcmpfalsepd k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x0b                               }, { vcmpfalsepd k5,zmm30,QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x0b                         }, { vcmpfalsepd k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0b       }, { vcmpfalsepd k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x0b                         }, { vcmpfalsepd k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0b       }, { vcmpfalsepd k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x0b                         }, { vcmpfalsepd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0b       }, { vcmpfalsepd k5,zmm30,QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x0b                         }, { vcmpfalsepd k5,zmm30,QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0b       }, { vcmpfalsepd k5,zmm30,QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x0b                               }, { vcmpfalsepd k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x0b                               }, { vcmpfalsepd k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x0b                               }, { vcmpfalsepd k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x0b                               }, { vcmpfalsepd k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0b }, { vcmpfalsepd k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x0b                               }, { vcmpfalsepd k5,zmm30,QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x0b                         }, { vcmpfalsepd k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0b       }, { vcmpfalsepd k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x0b                         }, { vcmpfalsepd k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0b       }, { vcmpfalsepd k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x0b                         }, { vcmpfalsepd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0b       }, { vcmpfalsepd k5,zmm30,QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x0b                         }, { vcmpfalsepd k5,zmm30,QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0b       }, { vcmpfalsepd k5,zmm30,QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x0c                               }, { vcmpneq_oqpd k5,zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x0c                               }, { vcmpneq_oqpd k5{k7},zmm30,zmm29                              }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x0c                               }, { vcmpneq_oqpd k5,zmm30,zmm29,{sae}                            }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x0c                               }, { vcmpneq_oqpd k5,zmm30,ZWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0c }, { vcmpneq_oqpd k5,zmm30,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x0c                               }, { vcmpneq_oqpd k5,zmm30,QWORD [rcx]{1to8}                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x0c                         }, { vcmpneq_oqpd k5,zmm30,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0c       }, { vcmpneq_oqpd k5,zmm30,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x0c                         }, { vcmpneq_oqpd k5,zmm30,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0c       }, { vcmpneq_oqpd k5,zmm30,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x0c                         }, { vcmpneq_oqpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0c       }, { vcmpneq_oqpd k5,zmm30,QWORD [rdx+0x400]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x0c                         }, { vcmpneq_oqpd k5,zmm30,QWORD [rdx-0x400]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0c       }, { vcmpneq_oqpd k5,zmm30,QWORD [rdx-0x408]{1to8}                }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x0d                               }, { vcmpgepd k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x0d                               }, { vcmpgepd k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x0d                               }, { vcmpgepd k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x0d                               }, { vcmpgepd k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0d }, { vcmpgepd k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x0d                               }, { vcmpgepd k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x0d                         }, { vcmpgepd k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0d       }, { vcmpgepd k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x0d                         }, { vcmpgepd k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0d       }, { vcmpgepd k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x0d                         }, { vcmpgepd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0d       }, { vcmpgepd k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x0d                         }, { vcmpgepd k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0d       }, { vcmpgepd k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x0d                               }, { vcmpgepd k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x0d                               }, { vcmpgepd k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x0d                               }, { vcmpgepd k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x0d                               }, { vcmpgepd k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0d }, { vcmpgepd k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x0d                               }, { vcmpgepd k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x0d                         }, { vcmpgepd k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0d       }, { vcmpgepd k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x0d                         }, { vcmpgepd k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0d       }, { vcmpgepd k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x0d                         }, { vcmpgepd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0d       }, { vcmpgepd k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x0d                         }, { vcmpgepd k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0d       }, { vcmpgepd k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x0e                               }, { vcmpgtpd k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x0e                               }, { vcmpgtpd k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x0e                               }, { vcmpgtpd k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x0e                               }, { vcmpgtpd k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0e }, { vcmpgtpd k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x0e                               }, { vcmpgtpd k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x0e                         }, { vcmpgtpd k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0e       }, { vcmpgtpd k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x0e                         }, { vcmpgtpd k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0e       }, { vcmpgtpd k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x0e                         }, { vcmpgtpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0e       }, { vcmpgtpd k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x0e                         }, { vcmpgtpd k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0e       }, { vcmpgtpd k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x0e                               }, { vcmpgtpd k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x0e                               }, { vcmpgtpd k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x0e                               }, { vcmpgtpd k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x0e                               }, { vcmpgtpd k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0e }, { vcmpgtpd k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x0e                               }, { vcmpgtpd k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x0e                         }, { vcmpgtpd k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0e       }, { vcmpgtpd k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x0e                         }, { vcmpgtpd k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0e       }, { vcmpgtpd k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x0e                         }, { vcmpgtpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0e       }, { vcmpgtpd k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x0e                         }, { vcmpgtpd k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0e       }, { vcmpgtpd k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x0f                               }, { vcmptruepd k5,zmm30,zmm29                                    }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x0f                               }, { vcmptruepd k5{k7},zmm30,zmm29                                }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x0f                               }, { vcmptruepd k5,zmm30,zmm29,{sae}                              }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x0f                               }, { vcmptruepd k5,zmm30,ZWORD [rcx]                              }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0f }, { vcmptruepd k5,zmm30,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x0f                               }, { vcmptruepd k5,zmm30,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x0f                         }, { vcmptruepd k5,zmm30,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0f       }, { vcmptruepd k5,zmm30,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x0f                         }, { vcmptruepd k5,zmm30,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0f       }, { vcmptruepd k5,zmm30,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x0f                         }, { vcmptruepd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0f       }, { vcmptruepd k5,zmm30,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x0f                         }, { vcmptruepd k5,zmm30,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0f       }, { vcmptruepd k5,zmm30,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x0f                               }, { vcmptruepd k5,zmm30,zmm29                                    }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x0f                               }, { vcmptruepd k5{k7},zmm30,zmm29                                }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x0f                               }, { vcmptruepd k5,zmm30,zmm29,{sae}                              }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x0f                               }, { vcmptruepd k5,zmm30,ZWORD [rcx]                              }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0f }, { vcmptruepd k5,zmm30,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x0f                               }, { vcmptruepd k5,zmm30,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x0f                         }, { vcmptruepd k5,zmm30,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0f       }, { vcmptruepd k5,zmm30,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x0f                         }, { vcmptruepd k5,zmm30,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0f       }, { vcmptruepd k5,zmm30,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x0f                         }, { vcmptruepd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0f       }, { vcmptruepd k5,zmm30,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x0f                         }, { vcmptruepd k5,zmm30,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0f       }, { vcmptruepd k5,zmm30,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x10                               }, { vcmpeq_ospd k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x10                               }, { vcmpeq_ospd k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x10                               }, { vcmpeq_ospd k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x10                               }, { vcmpeq_ospd k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x10 }, { vcmpeq_ospd k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x10                               }, { vcmpeq_ospd k5,zmm30,QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x10                         }, { vcmpeq_ospd k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x10       }, { vcmpeq_ospd k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x10                         }, { vcmpeq_ospd k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x10       }, { vcmpeq_ospd k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x10                         }, { vcmpeq_ospd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x10       }, { vcmpeq_ospd k5,zmm30,QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x10                         }, { vcmpeq_ospd k5,zmm30,QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x10       }, { vcmpeq_ospd k5,zmm30,QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x11                               }, { vcmplt_oqpd k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x11                               }, { vcmplt_oqpd k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x11                               }, { vcmplt_oqpd k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x11                               }, { vcmplt_oqpd k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x11 }, { vcmplt_oqpd k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x11                               }, { vcmplt_oqpd k5,zmm30,QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x11                         }, { vcmplt_oqpd k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x11       }, { vcmplt_oqpd k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x11                         }, { vcmplt_oqpd k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x11       }, { vcmplt_oqpd k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x11                         }, { vcmplt_oqpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x11       }, { vcmplt_oqpd k5,zmm30,QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x11                         }, { vcmplt_oqpd k5,zmm30,QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x11       }, { vcmplt_oqpd k5,zmm30,QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x12                               }, { vcmple_oqpd k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x12                               }, { vcmple_oqpd k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x12                               }, { vcmple_oqpd k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x12                               }, { vcmple_oqpd k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x12 }, { vcmple_oqpd k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x12                               }, { vcmple_oqpd k5,zmm30,QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x12                         }, { vcmple_oqpd k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x12       }, { vcmple_oqpd k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x12                         }, { vcmple_oqpd k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x12       }, { vcmple_oqpd k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x12                         }, { vcmple_oqpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x12       }, { vcmple_oqpd k5,zmm30,QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x12                         }, { vcmple_oqpd k5,zmm30,QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x12       }, { vcmple_oqpd k5,zmm30,QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x13                               }, { vcmpunord_spd k5,zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x13                               }, { vcmpunord_spd k5{k7},zmm30,zmm29                             }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x13                               }, { vcmpunord_spd k5,zmm30,zmm29,{sae}                           }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x13                               }, { vcmpunord_spd k5,zmm30,ZWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x13 }, { vcmpunord_spd k5,zmm30,ZWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x13                               }, { vcmpunord_spd k5,zmm30,QWORD [rcx]{1to8}                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x13                         }, { vcmpunord_spd k5,zmm30,ZWORD [rdx+0x1fc0]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x13       }, { vcmpunord_spd k5,zmm30,ZWORD [rdx+0x2000]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x13                         }, { vcmpunord_spd k5,zmm30,ZWORD [rdx-0x2000]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x13       }, { vcmpunord_spd k5,zmm30,ZWORD [rdx-0x2040]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x13                         }, { vcmpunord_spd k5,zmm30,QWORD [rdx+0x3f8]{1to8}               }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x13       }, { vcmpunord_spd k5,zmm30,QWORD [rdx+0x400]{1to8}               }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x13                         }, { vcmpunord_spd k5,zmm30,QWORD [rdx-0x400]{1to8}               }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x13       }, { vcmpunord_spd k5,zmm30,QWORD [rdx-0x408]{1to8}               }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x14                               }, { vcmpneq_uspd k5,zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x14                               }, { vcmpneq_uspd k5{k7},zmm30,zmm29                              }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x14                               }, { vcmpneq_uspd k5,zmm30,zmm29,{sae}                            }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x14                               }, { vcmpneq_uspd k5,zmm30,ZWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x14 }, { vcmpneq_uspd k5,zmm30,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x14                               }, { vcmpneq_uspd k5,zmm30,QWORD [rcx]{1to8}                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x14                         }, { vcmpneq_uspd k5,zmm30,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x14       }, { vcmpneq_uspd k5,zmm30,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x14                         }, { vcmpneq_uspd k5,zmm30,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x14       }, { vcmpneq_uspd k5,zmm30,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x14                         }, { vcmpneq_uspd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x14       }, { vcmpneq_uspd k5,zmm30,QWORD [rdx+0x400]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x14                         }, { vcmpneq_uspd k5,zmm30,QWORD [rdx-0x400]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x14       }, { vcmpneq_uspd k5,zmm30,QWORD [rdx-0x408]{1to8}                }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x15                               }, { vcmpnlt_uqpd k5,zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x15                               }, { vcmpnlt_uqpd k5{k7},zmm30,zmm29                              }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x15                               }, { vcmpnlt_uqpd k5,zmm30,zmm29,{sae}                            }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x15                               }, { vcmpnlt_uqpd k5,zmm30,ZWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x15 }, { vcmpnlt_uqpd k5,zmm30,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x15                               }, { vcmpnlt_uqpd k5,zmm30,QWORD [rcx]{1to8}                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x15                         }, { vcmpnlt_uqpd k5,zmm30,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x15       }, { vcmpnlt_uqpd k5,zmm30,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x15                         }, { vcmpnlt_uqpd k5,zmm30,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x15       }, { vcmpnlt_uqpd k5,zmm30,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x15                         }, { vcmpnlt_uqpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x15       }, { vcmpnlt_uqpd k5,zmm30,QWORD [rdx+0x400]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x15                         }, { vcmpnlt_uqpd k5,zmm30,QWORD [rdx-0x400]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x15       }, { vcmpnlt_uqpd k5,zmm30,QWORD [rdx-0x408]{1to8}                }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x16                               }, { vcmpnle_uqpd k5,zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x16                               }, { vcmpnle_uqpd k5{k7},zmm30,zmm29                              }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x16                               }, { vcmpnle_uqpd k5,zmm30,zmm29,{sae}                            }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x16                               }, { vcmpnle_uqpd k5,zmm30,ZWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x16 }, { vcmpnle_uqpd k5,zmm30,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x16                               }, { vcmpnle_uqpd k5,zmm30,QWORD [rcx]{1to8}                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x16                         }, { vcmpnle_uqpd k5,zmm30,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x16       }, { vcmpnle_uqpd k5,zmm30,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x16                         }, { vcmpnle_uqpd k5,zmm30,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x16       }, { vcmpnle_uqpd k5,zmm30,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x16                         }, { vcmpnle_uqpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x16       }, { vcmpnle_uqpd k5,zmm30,QWORD [rdx+0x400]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x16                         }, { vcmpnle_uqpd k5,zmm30,QWORD [rdx-0x400]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x16       }, { vcmpnle_uqpd k5,zmm30,QWORD [rdx-0x408]{1to8}                }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x17                               }, { vcmpord_spd k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x17                               }, { vcmpord_spd k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x17                               }, { vcmpord_spd k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x17                               }, { vcmpord_spd k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x17 }, { vcmpord_spd k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x17                               }, { vcmpord_spd k5,zmm30,QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x17                         }, { vcmpord_spd k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x17       }, { vcmpord_spd k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x17                         }, { vcmpord_spd k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x17       }, { vcmpord_spd k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x17                         }, { vcmpord_spd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x17       }, { vcmpord_spd k5,zmm30,QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x17                         }, { vcmpord_spd k5,zmm30,QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x17       }, { vcmpord_spd k5,zmm30,QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x18                               }, { vcmpeq_uspd k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x18                               }, { vcmpeq_uspd k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x18                               }, { vcmpeq_uspd k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x18                               }, { vcmpeq_uspd k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x18 }, { vcmpeq_uspd k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x18                               }, { vcmpeq_uspd k5,zmm30,QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x18                         }, { vcmpeq_uspd k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x18       }, { vcmpeq_uspd k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x18                         }, { vcmpeq_uspd k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x18       }, { vcmpeq_uspd k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x18                         }, { vcmpeq_uspd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x18       }, { vcmpeq_uspd k5,zmm30,QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x18                         }, { vcmpeq_uspd k5,zmm30,QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x18       }, { vcmpeq_uspd k5,zmm30,QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x19                               }, { vcmpnge_uqpd k5,zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x19                               }, { vcmpnge_uqpd k5{k7},zmm30,zmm29                              }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x19                               }, { vcmpnge_uqpd k5,zmm30,zmm29,{sae}                            }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x19                               }, { vcmpnge_uqpd k5,zmm30,ZWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x19 }, { vcmpnge_uqpd k5,zmm30,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x19                               }, { vcmpnge_uqpd k5,zmm30,QWORD [rcx]{1to8}                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x19                         }, { vcmpnge_uqpd k5,zmm30,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x19       }, { vcmpnge_uqpd k5,zmm30,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x19                         }, { vcmpnge_uqpd k5,zmm30,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x19       }, { vcmpnge_uqpd k5,zmm30,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x19                         }, { vcmpnge_uqpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x19       }, { vcmpnge_uqpd k5,zmm30,QWORD [rdx+0x400]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x19                         }, { vcmpnge_uqpd k5,zmm30,QWORD [rdx-0x400]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x19       }, { vcmpnge_uqpd k5,zmm30,QWORD [rdx-0x408]{1to8}                }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x1a                               }, { vcmpngt_uqpd k5,zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x1a                               }, { vcmpngt_uqpd k5{k7},zmm30,zmm29                              }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x1a                               }, { vcmpngt_uqpd k5,zmm30,zmm29,{sae}                            }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x1a                               }, { vcmpngt_uqpd k5,zmm30,ZWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1a }, { vcmpngt_uqpd k5,zmm30,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x1a                               }, { vcmpngt_uqpd k5,zmm30,QWORD [rcx]{1to8}                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x1a                         }, { vcmpngt_uqpd k5,zmm30,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x1a       }, { vcmpngt_uqpd k5,zmm30,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x1a                         }, { vcmpngt_uqpd k5,zmm30,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x1a       }, { vcmpngt_uqpd k5,zmm30,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x1a                         }, { vcmpngt_uqpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x1a       }, { vcmpngt_uqpd k5,zmm30,QWORD [rdx+0x400]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x1a                         }, { vcmpngt_uqpd k5,zmm30,QWORD [rdx-0x400]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x1a       }, { vcmpngt_uqpd k5,zmm30,QWORD [rdx-0x408]{1to8}                }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x1b                               }, { vcmpfalse_ospd k5,zmm30,zmm29                                }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x1b                               }, { vcmpfalse_ospd k5{k7},zmm30,zmm29                            }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x1b                               }, { vcmpfalse_ospd k5,zmm30,zmm29,{sae}                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x1b                               }, { vcmpfalse_ospd k5,zmm30,ZWORD [rcx]                          }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1b }, { vcmpfalse_ospd k5,zmm30,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x1b                               }, { vcmpfalse_ospd k5,zmm30,QWORD [rcx]{1to8}                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x1b                         }, { vcmpfalse_ospd k5,zmm30,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x1b       }, { vcmpfalse_ospd k5,zmm30,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x1b                         }, { vcmpfalse_ospd k5,zmm30,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x1b       }, { vcmpfalse_ospd k5,zmm30,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x1b                         }, { vcmpfalse_ospd k5,zmm30,QWORD [rdx+0x3f8]{1to8}              }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x1b       }, { vcmpfalse_ospd k5,zmm30,QWORD [rdx+0x400]{1to8}              }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x1b                         }, { vcmpfalse_ospd k5,zmm30,QWORD [rdx-0x400]{1to8}              }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x1b       }, { vcmpfalse_ospd k5,zmm30,QWORD [rdx-0x408]{1to8}              }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x1c                               }, { vcmpneq_ospd k5,zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x1c                               }, { vcmpneq_ospd k5{k7},zmm30,zmm29                              }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x1c                               }, { vcmpneq_ospd k5,zmm30,zmm29,{sae}                            }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x1c                               }, { vcmpneq_ospd k5,zmm30,ZWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1c }, { vcmpneq_ospd k5,zmm30,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x1c                               }, { vcmpneq_ospd k5,zmm30,QWORD [rcx]{1to8}                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x1c                         }, { vcmpneq_ospd k5,zmm30,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x1c       }, { vcmpneq_ospd k5,zmm30,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x1c                         }, { vcmpneq_ospd k5,zmm30,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x1c       }, { vcmpneq_ospd k5,zmm30,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x1c                         }, { vcmpneq_ospd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x1c       }, { vcmpneq_ospd k5,zmm30,QWORD [rdx+0x400]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x1c                         }, { vcmpneq_ospd k5,zmm30,QWORD [rdx-0x400]{1to8}                }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x1c       }, { vcmpneq_ospd k5,zmm30,QWORD [rdx-0x408]{1to8}                }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x1d                               }, { vcmpge_oqpd k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x1d                               }, { vcmpge_oqpd k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x1d                               }, { vcmpge_oqpd k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x1d                               }, { vcmpge_oqpd k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1d }, { vcmpge_oqpd k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x1d                               }, { vcmpge_oqpd k5,zmm30,QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x1d                         }, { vcmpge_oqpd k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x1d       }, { vcmpge_oqpd k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x1d                         }, { vcmpge_oqpd k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x1d       }, { vcmpge_oqpd k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x1d                         }, { vcmpge_oqpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x1d       }, { vcmpge_oqpd k5,zmm30,QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x1d                         }, { vcmpge_oqpd k5,zmm30,QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x1d       }, { vcmpge_oqpd k5,zmm30,QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x1e                               }, { vcmpgt_oqpd k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x1e                               }, { vcmpgt_oqpd k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x1e                               }, { vcmpgt_oqpd k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x1e                               }, { vcmpgt_oqpd k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1e }, { vcmpgt_oqpd k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x1e                               }, { vcmpgt_oqpd k5,zmm30,QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x1e                         }, { vcmpgt_oqpd k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x1e       }, { vcmpgt_oqpd k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x1e                         }, { vcmpgt_oqpd k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x1e       }, { vcmpgt_oqpd k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x1e                         }, { vcmpgt_oqpd k5,zmm30,QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x1e       }, { vcmpgt_oqpd k5,zmm30,QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x1e                         }, { vcmpgt_oqpd k5,zmm30,QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x1e       }, { vcmpgt_oqpd k5,zmm30,QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0xc2, 0xed, 0x1f                               }, { vcmptrue_uspd k5,zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0xc2, 0xed, 0x1f                               }, { vcmptrue_uspd k5{k7},zmm30,zmm29                             }
testcase	{ 0x62, 0x91, 0x8d, 0x10, 0xc2, 0xed, 0x1f                               }, { vcmptrue_uspd k5,zmm30,zmm29,{sae}                           }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x29, 0x1f                               }, { vcmptrue_uspd k5,zmm30,ZWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1f }, { vcmptrue_uspd k5,zmm30,ZWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x29, 0x1f                               }, { vcmptrue_uspd k5,zmm30,QWORD [rcx]{1to8}                     }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x7f, 0x1f                         }, { vcmptrue_uspd k5,zmm30,ZWORD [rdx+0x1fc0]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x1f       }, { vcmptrue_uspd k5,zmm30,ZWORD [rdx+0x2000]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0x6a, 0x80, 0x1f                         }, { vcmptrue_uspd k5,zmm30,ZWORD [rdx-0x2000]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x1f       }, { vcmptrue_uspd k5,zmm30,ZWORD [rdx-0x2040]                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x7f, 0x1f                         }, { vcmptrue_uspd k5,zmm30,QWORD [rdx+0x3f8]{1to8}               }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x1f       }, { vcmptrue_uspd k5,zmm30,QWORD [rdx+0x400]{1to8}               }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0x6a, 0x80, 0x1f                         }, { vcmptrue_uspd k5,zmm30,QWORD [rdx-0x400]{1to8}               }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x1f       }, { vcmptrue_uspd k5,zmm30,QWORD [rdx-0x408]{1to8}               }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0xab                               }, { vcmpps k5,zmm30,zmm29,0xab                                   }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0xab                               }, { vcmpps k5{k7},zmm30,zmm29,0xab                               }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0xab                               }, { vcmpps k5,zmm30,zmm29,{sae},0xab                             }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x7b                               }, { vcmpps k5,zmm30,zmm29,0x7b                                   }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x7b                               }, { vcmpps k5,zmm30,zmm29,{sae},0x7b                             }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x7b                               }, { vcmpps k5,zmm30,ZWORD [rcx],0x7b                             }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vcmpps k5,zmm30,ZWORD [rax+r14*8+0x123],0x7b                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x7b                               }, { vcmpps k5,zmm30,DWORD [rcx]{1to16},0x7b                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x7b                         }, { vcmpps k5,zmm30,ZWORD [rdx+0x1fc0],0x7b                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vcmpps k5,zmm30,ZWORD [rdx+0x2000],0x7b                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x7b                         }, { vcmpps k5,zmm30,ZWORD [rdx-0x2000],0x7b                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vcmpps k5,zmm30,ZWORD [rdx-0x2040],0x7b                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x7b                         }, { vcmpps k5,zmm30,DWORD [rdx+0x1fc]{1to16},0x7b                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vcmpps k5,zmm30,DWORD [rdx+0x200]{1to16},0x7b                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x7b                         }, { vcmpps k5,zmm30,DWORD [rdx-0x200]{1to16},0x7b                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vcmpps k5,zmm30,DWORD [rdx-0x204]{1to16},0x7b                }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x00                               }, { vcmpeqps k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x00                               }, { vcmpeqps k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x00                               }, { vcmpeqps k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x00                               }, { vcmpeqps k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x00 }, { vcmpeqps k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x00                               }, { vcmpeqps k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x00                         }, { vcmpeqps k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x00       }, { vcmpeqps k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x00                         }, { vcmpeqps k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x00       }, { vcmpeqps k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x00                         }, { vcmpeqps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x00       }, { vcmpeqps k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x00                         }, { vcmpeqps k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x00       }, { vcmpeqps k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x00                               }, { vcmpeqps k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x00                               }, { vcmpeqps k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x00                               }, { vcmpeqps k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x00                               }, { vcmpeqps k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x00 }, { vcmpeqps k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x00                               }, { vcmpeqps k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x00                         }, { vcmpeqps k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x00       }, { vcmpeqps k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x00                         }, { vcmpeqps k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x00       }, { vcmpeqps k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x00                         }, { vcmpeqps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x00       }, { vcmpeqps k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x00                         }, { vcmpeqps k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x00       }, { vcmpeqps k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x01                               }, { vcmpltps k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x01                               }, { vcmpltps k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x01                               }, { vcmpltps k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x01                               }, { vcmpltps k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x01 }, { vcmpltps k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x01                               }, { vcmpltps k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x01                         }, { vcmpltps k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x01       }, { vcmpltps k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x01                         }, { vcmpltps k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x01       }, { vcmpltps k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x01                         }, { vcmpltps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x01       }, { vcmpltps k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x01                         }, { vcmpltps k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x01       }, { vcmpltps k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x01                               }, { vcmpltps k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x01                               }, { vcmpltps k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x01                               }, { vcmpltps k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x01                               }, { vcmpltps k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x01 }, { vcmpltps k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x01                               }, { vcmpltps k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x01                         }, { vcmpltps k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x01       }, { vcmpltps k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x01                         }, { vcmpltps k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x01       }, { vcmpltps k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x01                         }, { vcmpltps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x01       }, { vcmpltps k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x01                         }, { vcmpltps k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x01       }, { vcmpltps k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x02                               }, { vcmpleps k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x02                               }, { vcmpleps k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x02                               }, { vcmpleps k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x02                               }, { vcmpleps k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x02 }, { vcmpleps k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x02                               }, { vcmpleps k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x02                         }, { vcmpleps k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x02       }, { vcmpleps k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x02                         }, { vcmpleps k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x02       }, { vcmpleps k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x02                         }, { vcmpleps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x02       }, { vcmpleps k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x02                         }, { vcmpleps k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x02       }, { vcmpleps k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x02                               }, { vcmpleps k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x02                               }, { vcmpleps k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x02                               }, { vcmpleps k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x02                               }, { vcmpleps k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x02 }, { vcmpleps k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x02                               }, { vcmpleps k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x02                         }, { vcmpleps k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x02       }, { vcmpleps k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x02                         }, { vcmpleps k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x02       }, { vcmpleps k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x02                         }, { vcmpleps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x02       }, { vcmpleps k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x02                         }, { vcmpleps k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x02       }, { vcmpleps k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x03                               }, { vcmpunordps k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x03                               }, { vcmpunordps k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x03                               }, { vcmpunordps k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x03                               }, { vcmpunordps k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x03 }, { vcmpunordps k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x03                               }, { vcmpunordps k5,zmm30,DWORD [rcx]{1to16}                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x03                         }, { vcmpunordps k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x03       }, { vcmpunordps k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x03                         }, { vcmpunordps k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x03       }, { vcmpunordps k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x03                         }, { vcmpunordps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x03       }, { vcmpunordps k5,zmm30,DWORD [rdx+0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x03                         }, { vcmpunordps k5,zmm30,DWORD [rdx-0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x03       }, { vcmpunordps k5,zmm30,DWORD [rdx-0x204]{1to16}                }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x03                               }, { vcmpunordps k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x03                               }, { vcmpunordps k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x03                               }, { vcmpunordps k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x03                               }, { vcmpunordps k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x03 }, { vcmpunordps k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x03                               }, { vcmpunordps k5,zmm30,DWORD [rcx]{1to16}                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x03                         }, { vcmpunordps k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x03       }, { vcmpunordps k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x03                         }, { vcmpunordps k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x03       }, { vcmpunordps k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x03                         }, { vcmpunordps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x03       }, { vcmpunordps k5,zmm30,DWORD [rdx+0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x03                         }, { vcmpunordps k5,zmm30,DWORD [rdx-0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x03       }, { vcmpunordps k5,zmm30,DWORD [rdx-0x204]{1to16}                }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x04                               }, { vcmpneqps k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x04                               }, { vcmpneqps k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x04                               }, { vcmpneqps k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x04                               }, { vcmpneqps k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x04 }, { vcmpneqps k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x04                               }, { vcmpneqps k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x04                         }, { vcmpneqps k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x04       }, { vcmpneqps k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x04                         }, { vcmpneqps k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x04       }, { vcmpneqps k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x04                         }, { vcmpneqps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x04       }, { vcmpneqps k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x04                         }, { vcmpneqps k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x04       }, { vcmpneqps k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x04                               }, { vcmpneqps k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x04                               }, { vcmpneqps k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x04                               }, { vcmpneqps k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x04                               }, { vcmpneqps k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x04 }, { vcmpneqps k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x04                               }, { vcmpneqps k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x04                         }, { vcmpneqps k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x04       }, { vcmpneqps k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x04                         }, { vcmpneqps k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x04       }, { vcmpneqps k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x04                         }, { vcmpneqps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x04       }, { vcmpneqps k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x04                         }, { vcmpneqps k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x04       }, { vcmpneqps k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x05                               }, { vcmpnltps k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x05                               }, { vcmpnltps k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x05                               }, { vcmpnltps k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x05                               }, { vcmpnltps k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x05 }, { vcmpnltps k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x05                               }, { vcmpnltps k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x05                         }, { vcmpnltps k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x05       }, { vcmpnltps k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x05                         }, { vcmpnltps k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x05       }, { vcmpnltps k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x05                         }, { vcmpnltps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x05       }, { vcmpnltps k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x05                         }, { vcmpnltps k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x05       }, { vcmpnltps k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x05                               }, { vcmpnltps k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x05                               }, { vcmpnltps k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x05                               }, { vcmpnltps k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x05                               }, { vcmpnltps k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x05 }, { vcmpnltps k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x05                               }, { vcmpnltps k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x05                         }, { vcmpnltps k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x05       }, { vcmpnltps k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x05                         }, { vcmpnltps k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x05       }, { vcmpnltps k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x05                         }, { vcmpnltps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x05       }, { vcmpnltps k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x05                         }, { vcmpnltps k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x05       }, { vcmpnltps k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x06                               }, { vcmpnleps k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x06                               }, { vcmpnleps k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x06                               }, { vcmpnleps k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x06                               }, { vcmpnleps k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x06 }, { vcmpnleps k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x06                               }, { vcmpnleps k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x06                         }, { vcmpnleps k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x06       }, { vcmpnleps k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x06                         }, { vcmpnleps k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x06       }, { vcmpnleps k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x06                         }, { vcmpnleps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x06       }, { vcmpnleps k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x06                         }, { vcmpnleps k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x06       }, { vcmpnleps k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x06                               }, { vcmpnleps k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x06                               }, { vcmpnleps k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x06                               }, { vcmpnleps k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x06                               }, { vcmpnleps k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x06 }, { vcmpnleps k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x06                               }, { vcmpnleps k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x06                         }, { vcmpnleps k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x06       }, { vcmpnleps k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x06                         }, { vcmpnleps k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x06       }, { vcmpnleps k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x06                         }, { vcmpnleps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x06       }, { vcmpnleps k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x06                         }, { vcmpnleps k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x06       }, { vcmpnleps k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x07                               }, { vcmpordps k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x07                               }, { vcmpordps k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x07                               }, { vcmpordps k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x07                               }, { vcmpordps k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x07 }, { vcmpordps k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x07                               }, { vcmpordps k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x07                         }, { vcmpordps k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x07       }, { vcmpordps k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x07                         }, { vcmpordps k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x07       }, { vcmpordps k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x07                         }, { vcmpordps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x07       }, { vcmpordps k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x07                         }, { vcmpordps k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x07       }, { vcmpordps k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x07                               }, { vcmpordps k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x07                               }, { vcmpordps k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x07                               }, { vcmpordps k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x07                               }, { vcmpordps k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x07 }, { vcmpordps k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x07                               }, { vcmpordps k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x07                         }, { vcmpordps k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x07       }, { vcmpordps k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x07                         }, { vcmpordps k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x07       }, { vcmpordps k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x07                         }, { vcmpordps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x07       }, { vcmpordps k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x07                         }, { vcmpordps k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x07       }, { vcmpordps k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x08                               }, { vcmpeq_uqps k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x08                               }, { vcmpeq_uqps k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x08                               }, { vcmpeq_uqps k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x08                               }, { vcmpeq_uqps k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x08 }, { vcmpeq_uqps k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x08                               }, { vcmpeq_uqps k5,zmm30,DWORD [rcx]{1to16}                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x08                         }, { vcmpeq_uqps k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x08       }, { vcmpeq_uqps k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x08                         }, { vcmpeq_uqps k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x08       }, { vcmpeq_uqps k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x08                         }, { vcmpeq_uqps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x08       }, { vcmpeq_uqps k5,zmm30,DWORD [rdx+0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x08                         }, { vcmpeq_uqps k5,zmm30,DWORD [rdx-0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x08       }, { vcmpeq_uqps k5,zmm30,DWORD [rdx-0x204]{1to16}                }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x09                               }, { vcmpngeps k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x09                               }, { vcmpngeps k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x09                               }, { vcmpngeps k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x09                               }, { vcmpngeps k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x09 }, { vcmpngeps k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x09                               }, { vcmpngeps k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x09                         }, { vcmpngeps k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x09       }, { vcmpngeps k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x09                         }, { vcmpngeps k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x09       }, { vcmpngeps k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x09                         }, { vcmpngeps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x09       }, { vcmpngeps k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x09                         }, { vcmpngeps k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x09       }, { vcmpngeps k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x09                               }, { vcmpngeps k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x09                               }, { vcmpngeps k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x09                               }, { vcmpngeps k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x09                               }, { vcmpngeps k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x09 }, { vcmpngeps k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x09                               }, { vcmpngeps k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x09                         }, { vcmpngeps k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x09       }, { vcmpngeps k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x09                         }, { vcmpngeps k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x09       }, { vcmpngeps k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x09                         }, { vcmpngeps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x09       }, { vcmpngeps k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x09                         }, { vcmpngeps k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x09       }, { vcmpngeps k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x0a                               }, { vcmpngtps k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x0a                               }, { vcmpngtps k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x0a                               }, { vcmpngtps k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x0a                               }, { vcmpngtps k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0a }, { vcmpngtps k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x0a                               }, { vcmpngtps k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x0a                         }, { vcmpngtps k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0a       }, { vcmpngtps k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x0a                         }, { vcmpngtps k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0a       }, { vcmpngtps k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x0a                         }, { vcmpngtps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0a       }, { vcmpngtps k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x0a                         }, { vcmpngtps k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0a       }, { vcmpngtps k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x0a                               }, { vcmpngtps k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x0a                               }, { vcmpngtps k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x0a                               }, { vcmpngtps k5,zmm30,zmm29,{sae}                               }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x0a                               }, { vcmpngtps k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0a }, { vcmpngtps k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x0a                               }, { vcmpngtps k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x0a                         }, { vcmpngtps k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0a       }, { vcmpngtps k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x0a                         }, { vcmpngtps k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0a       }, { vcmpngtps k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x0a                         }, { vcmpngtps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0a       }, { vcmpngtps k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x0a                         }, { vcmpngtps k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0a       }, { vcmpngtps k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x0b                               }, { vcmpfalseps k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x0b                               }, { vcmpfalseps k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x0b                               }, { vcmpfalseps k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x0b                               }, { vcmpfalseps k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0b }, { vcmpfalseps k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x0b                               }, { vcmpfalseps k5,zmm30,DWORD [rcx]{1to16}                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x0b                         }, { vcmpfalseps k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0b       }, { vcmpfalseps k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x0b                         }, { vcmpfalseps k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0b       }, { vcmpfalseps k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x0b                         }, { vcmpfalseps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0b       }, { vcmpfalseps k5,zmm30,DWORD [rdx+0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x0b                         }, { vcmpfalseps k5,zmm30,DWORD [rdx-0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0b       }, { vcmpfalseps k5,zmm30,DWORD [rdx-0x204]{1to16}                }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x0b                               }, { vcmpfalseps k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x0b                               }, { vcmpfalseps k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x0b                               }, { vcmpfalseps k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x0b                               }, { vcmpfalseps k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0b }, { vcmpfalseps k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x0b                               }, { vcmpfalseps k5,zmm30,DWORD [rcx]{1to16}                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x0b                         }, { vcmpfalseps k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0b       }, { vcmpfalseps k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x0b                         }, { vcmpfalseps k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0b       }, { vcmpfalseps k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x0b                         }, { vcmpfalseps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0b       }, { vcmpfalseps k5,zmm30,DWORD [rdx+0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x0b                         }, { vcmpfalseps k5,zmm30,DWORD [rdx-0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0b       }, { vcmpfalseps k5,zmm30,DWORD [rdx-0x204]{1to16}                }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x0c                               }, { vcmpneq_oqps k5,zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x0c                               }, { vcmpneq_oqps k5{k7},zmm30,zmm29                              }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x0c                               }, { vcmpneq_oqps k5,zmm30,zmm29,{sae}                            }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x0c                               }, { vcmpneq_oqps k5,zmm30,ZWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0c }, { vcmpneq_oqps k5,zmm30,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x0c                               }, { vcmpneq_oqps k5,zmm30,DWORD [rcx]{1to16}                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x0c                         }, { vcmpneq_oqps k5,zmm30,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0c       }, { vcmpneq_oqps k5,zmm30,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x0c                         }, { vcmpneq_oqps k5,zmm30,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0c       }, { vcmpneq_oqps k5,zmm30,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x0c                         }, { vcmpneq_oqps k5,zmm30,DWORD [rdx+0x1fc]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0c       }, { vcmpneq_oqps k5,zmm30,DWORD [rdx+0x200]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x0c                         }, { vcmpneq_oqps k5,zmm30,DWORD [rdx-0x200]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0c       }, { vcmpneq_oqps k5,zmm30,DWORD [rdx-0x204]{1to16}               }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x0d                               }, { vcmpgeps k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x0d                               }, { vcmpgeps k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x0d                               }, { vcmpgeps k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x0d                               }, { vcmpgeps k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0d }, { vcmpgeps k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x0d                               }, { vcmpgeps k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x0d                         }, { vcmpgeps k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0d       }, { vcmpgeps k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x0d                         }, { vcmpgeps k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0d       }, { vcmpgeps k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x0d                         }, { vcmpgeps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0d       }, { vcmpgeps k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x0d                         }, { vcmpgeps k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0d       }, { vcmpgeps k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x0d                               }, { vcmpgeps k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x0d                               }, { vcmpgeps k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x0d                               }, { vcmpgeps k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x0d                               }, { vcmpgeps k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0d }, { vcmpgeps k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x0d                               }, { vcmpgeps k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x0d                         }, { vcmpgeps k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0d       }, { vcmpgeps k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x0d                         }, { vcmpgeps k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0d       }, { vcmpgeps k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x0d                         }, { vcmpgeps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0d       }, { vcmpgeps k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x0d                         }, { vcmpgeps k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0d       }, { vcmpgeps k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x0e                               }, { vcmpgtps k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x0e                               }, { vcmpgtps k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x0e                               }, { vcmpgtps k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x0e                               }, { vcmpgtps k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0e }, { vcmpgtps k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x0e                               }, { vcmpgtps k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x0e                         }, { vcmpgtps k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0e       }, { vcmpgtps k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x0e                         }, { vcmpgtps k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0e       }, { vcmpgtps k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x0e                         }, { vcmpgtps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0e       }, { vcmpgtps k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x0e                         }, { vcmpgtps k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0e       }, { vcmpgtps k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x0e                               }, { vcmpgtps k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x0e                               }, { vcmpgtps k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x0e                               }, { vcmpgtps k5,zmm30,zmm29,{sae}                                }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x0e                               }, { vcmpgtps k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0e }, { vcmpgtps k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x0e                               }, { vcmpgtps k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x0e                         }, { vcmpgtps k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0e       }, { vcmpgtps k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x0e                         }, { vcmpgtps k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0e       }, { vcmpgtps k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x0e                         }, { vcmpgtps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0e       }, { vcmpgtps k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x0e                         }, { vcmpgtps k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0e       }, { vcmpgtps k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x0f                               }, { vcmptrueps k5,zmm30,zmm29                                    }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x0f                               }, { vcmptrueps k5{k7},zmm30,zmm29                                }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x0f                               }, { vcmptrueps k5,zmm30,zmm29,{sae}                              }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x0f                               }, { vcmptrueps k5,zmm30,ZWORD [rcx]                              }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0f }, { vcmptrueps k5,zmm30,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x0f                               }, { vcmptrueps k5,zmm30,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x0f                         }, { vcmptrueps k5,zmm30,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0f       }, { vcmptrueps k5,zmm30,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x0f                         }, { vcmptrueps k5,zmm30,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0f       }, { vcmptrueps k5,zmm30,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x0f                         }, { vcmptrueps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0f       }, { vcmptrueps k5,zmm30,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x0f                         }, { vcmptrueps k5,zmm30,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0f       }, { vcmptrueps k5,zmm30,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x0f                               }, { vcmptrueps k5,zmm30,zmm29                                    }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x0f                               }, { vcmptrueps k5{k7},zmm30,zmm29                                }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x0f                               }, { vcmptrueps k5,zmm30,zmm29,{sae}                              }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x0f                               }, { vcmptrueps k5,zmm30,ZWORD [rcx]                              }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0f }, { vcmptrueps k5,zmm30,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x0f                               }, { vcmptrueps k5,zmm30,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x0f                         }, { vcmptrueps k5,zmm30,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x0f       }, { vcmptrueps k5,zmm30,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x0f                         }, { vcmptrueps k5,zmm30,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x0f       }, { vcmptrueps k5,zmm30,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x0f                         }, { vcmptrueps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0f       }, { vcmptrueps k5,zmm30,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x0f                         }, { vcmptrueps k5,zmm30,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0f       }, { vcmptrueps k5,zmm30,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x10                               }, { vcmpeq_osps k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x10                               }, { vcmpeq_osps k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x10                               }, { vcmpeq_osps k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x10                               }, { vcmpeq_osps k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x10 }, { vcmpeq_osps k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x10                               }, { vcmpeq_osps k5,zmm30,DWORD [rcx]{1to16}                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x10                         }, { vcmpeq_osps k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x10       }, { vcmpeq_osps k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x10                         }, { vcmpeq_osps k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x10       }, { vcmpeq_osps k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x10                         }, { vcmpeq_osps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x10       }, { vcmpeq_osps k5,zmm30,DWORD [rdx+0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x10                         }, { vcmpeq_osps k5,zmm30,DWORD [rdx-0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x10       }, { vcmpeq_osps k5,zmm30,DWORD [rdx-0x204]{1to16}                }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x11                               }, { vcmplt_oqps k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x11                               }, { vcmplt_oqps k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x11                               }, { vcmplt_oqps k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x11                               }, { vcmplt_oqps k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x11 }, { vcmplt_oqps k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x11                               }, { vcmplt_oqps k5,zmm30,DWORD [rcx]{1to16}                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x11                         }, { vcmplt_oqps k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x11       }, { vcmplt_oqps k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x11                         }, { vcmplt_oqps k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x11       }, { vcmplt_oqps k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x11                         }, { vcmplt_oqps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x11       }, { vcmplt_oqps k5,zmm30,DWORD [rdx+0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x11                         }, { vcmplt_oqps k5,zmm30,DWORD [rdx-0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x11       }, { vcmplt_oqps k5,zmm30,DWORD [rdx-0x204]{1to16}                }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x12                               }, { vcmple_oqps k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x12                               }, { vcmple_oqps k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x12                               }, { vcmple_oqps k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x12                               }, { vcmple_oqps k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x12 }, { vcmple_oqps k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x12                               }, { vcmple_oqps k5,zmm30,DWORD [rcx]{1to16}                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x12                         }, { vcmple_oqps k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x12       }, { vcmple_oqps k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x12                         }, { vcmple_oqps k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x12       }, { vcmple_oqps k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x12                         }, { vcmple_oqps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x12       }, { vcmple_oqps k5,zmm30,DWORD [rdx+0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x12                         }, { vcmple_oqps k5,zmm30,DWORD [rdx-0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x12       }, { vcmple_oqps k5,zmm30,DWORD [rdx-0x204]{1to16}                }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x13                               }, { vcmpunord_sps k5,zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x13                               }, { vcmpunord_sps k5{k7},zmm30,zmm29                             }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x13                               }, { vcmpunord_sps k5,zmm30,zmm29,{sae}                           }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x13                               }, { vcmpunord_sps k5,zmm30,ZWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x13 }, { vcmpunord_sps k5,zmm30,ZWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x13                               }, { vcmpunord_sps k5,zmm30,DWORD [rcx]{1to16}                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x13                         }, { vcmpunord_sps k5,zmm30,ZWORD [rdx+0x1fc0]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x13       }, { vcmpunord_sps k5,zmm30,ZWORD [rdx+0x2000]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x13                         }, { vcmpunord_sps k5,zmm30,ZWORD [rdx-0x2000]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x13       }, { vcmpunord_sps k5,zmm30,ZWORD [rdx-0x2040]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x13                         }, { vcmpunord_sps k5,zmm30,DWORD [rdx+0x1fc]{1to16}              }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x13       }, { vcmpunord_sps k5,zmm30,DWORD [rdx+0x200]{1to16}              }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x13                         }, { vcmpunord_sps k5,zmm30,DWORD [rdx-0x200]{1to16}              }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x13       }, { vcmpunord_sps k5,zmm30,DWORD [rdx-0x204]{1to16}              }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x14                               }, { vcmpneq_usps k5,zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x14                               }, { vcmpneq_usps k5{k7},zmm30,zmm29                              }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x14                               }, { vcmpneq_usps k5,zmm30,zmm29,{sae}                            }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x14                               }, { vcmpneq_usps k5,zmm30,ZWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x14 }, { vcmpneq_usps k5,zmm30,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x14                               }, { vcmpneq_usps k5,zmm30,DWORD [rcx]{1to16}                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x14                         }, { vcmpneq_usps k5,zmm30,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x14       }, { vcmpneq_usps k5,zmm30,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x14                         }, { vcmpneq_usps k5,zmm30,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x14       }, { vcmpneq_usps k5,zmm30,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x14                         }, { vcmpneq_usps k5,zmm30,DWORD [rdx+0x1fc]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x14       }, { vcmpneq_usps k5,zmm30,DWORD [rdx+0x200]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x14                         }, { vcmpneq_usps k5,zmm30,DWORD [rdx-0x200]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x14       }, { vcmpneq_usps k5,zmm30,DWORD [rdx-0x204]{1to16}               }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x15                               }, { vcmpnlt_uqps k5,zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x15                               }, { vcmpnlt_uqps k5{k7},zmm30,zmm29                              }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x15                               }, { vcmpnlt_uqps k5,zmm30,zmm29,{sae}                            }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x15                               }, { vcmpnlt_uqps k5,zmm30,ZWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x15 }, { vcmpnlt_uqps k5,zmm30,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x15                               }, { vcmpnlt_uqps k5,zmm30,DWORD [rcx]{1to16}                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x15                         }, { vcmpnlt_uqps k5,zmm30,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x15       }, { vcmpnlt_uqps k5,zmm30,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x15                         }, { vcmpnlt_uqps k5,zmm30,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x15       }, { vcmpnlt_uqps k5,zmm30,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x15                         }, { vcmpnlt_uqps k5,zmm30,DWORD [rdx+0x1fc]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x15       }, { vcmpnlt_uqps k5,zmm30,DWORD [rdx+0x200]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x15                         }, { vcmpnlt_uqps k5,zmm30,DWORD [rdx-0x200]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x15       }, { vcmpnlt_uqps k5,zmm30,DWORD [rdx-0x204]{1to16}               }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x16                               }, { vcmpnle_uqps k5,zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x16                               }, { vcmpnle_uqps k5{k7},zmm30,zmm29                              }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x16                               }, { vcmpnle_uqps k5,zmm30,zmm29,{sae}                            }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x16                               }, { vcmpnle_uqps k5,zmm30,ZWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x16 }, { vcmpnle_uqps k5,zmm30,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x16                               }, { vcmpnle_uqps k5,zmm30,DWORD [rcx]{1to16}                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x16                         }, { vcmpnle_uqps k5,zmm30,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x16       }, { vcmpnle_uqps k5,zmm30,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x16                         }, { vcmpnle_uqps k5,zmm30,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x16       }, { vcmpnle_uqps k5,zmm30,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x16                         }, { vcmpnle_uqps k5,zmm30,DWORD [rdx+0x1fc]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x16       }, { vcmpnle_uqps k5,zmm30,DWORD [rdx+0x200]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x16                         }, { vcmpnle_uqps k5,zmm30,DWORD [rdx-0x200]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x16       }, { vcmpnle_uqps k5,zmm30,DWORD [rdx-0x204]{1to16}               }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x17                               }, { vcmpord_sps k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x17                               }, { vcmpord_sps k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x17                               }, { vcmpord_sps k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x17                               }, { vcmpord_sps k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x17 }, { vcmpord_sps k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x17                               }, { vcmpord_sps k5,zmm30,DWORD [rcx]{1to16}                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x17                         }, { vcmpord_sps k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x17       }, { vcmpord_sps k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x17                         }, { vcmpord_sps k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x17       }, { vcmpord_sps k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x17                         }, { vcmpord_sps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x17       }, { vcmpord_sps k5,zmm30,DWORD [rdx+0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x17                         }, { vcmpord_sps k5,zmm30,DWORD [rdx-0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x17       }, { vcmpord_sps k5,zmm30,DWORD [rdx-0x204]{1to16}                }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x18                               }, { vcmpeq_usps k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x18                               }, { vcmpeq_usps k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x18                               }, { vcmpeq_usps k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x18                               }, { vcmpeq_usps k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x18 }, { vcmpeq_usps k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x18                               }, { vcmpeq_usps k5,zmm30,DWORD [rcx]{1to16}                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x18                         }, { vcmpeq_usps k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x18       }, { vcmpeq_usps k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x18                         }, { vcmpeq_usps k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x18       }, { vcmpeq_usps k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x18                         }, { vcmpeq_usps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x18       }, { vcmpeq_usps k5,zmm30,DWORD [rdx+0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x18                         }, { vcmpeq_usps k5,zmm30,DWORD [rdx-0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x18       }, { vcmpeq_usps k5,zmm30,DWORD [rdx-0x204]{1to16}                }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x19                               }, { vcmpnge_uqps k5,zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x19                               }, { vcmpnge_uqps k5{k7},zmm30,zmm29                              }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x19                               }, { vcmpnge_uqps k5,zmm30,zmm29,{sae}                            }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x19                               }, { vcmpnge_uqps k5,zmm30,ZWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x19 }, { vcmpnge_uqps k5,zmm30,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x19                               }, { vcmpnge_uqps k5,zmm30,DWORD [rcx]{1to16}                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x19                         }, { vcmpnge_uqps k5,zmm30,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x19       }, { vcmpnge_uqps k5,zmm30,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x19                         }, { vcmpnge_uqps k5,zmm30,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x19       }, { vcmpnge_uqps k5,zmm30,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x19                         }, { vcmpnge_uqps k5,zmm30,DWORD [rdx+0x1fc]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x19       }, { vcmpnge_uqps k5,zmm30,DWORD [rdx+0x200]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x19                         }, { vcmpnge_uqps k5,zmm30,DWORD [rdx-0x200]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x19       }, { vcmpnge_uqps k5,zmm30,DWORD [rdx-0x204]{1to16}               }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x1a                               }, { vcmpngt_uqps k5,zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x1a                               }, { vcmpngt_uqps k5{k7},zmm30,zmm29                              }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x1a                               }, { vcmpngt_uqps k5,zmm30,zmm29,{sae}                            }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x1a                               }, { vcmpngt_uqps k5,zmm30,ZWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1a }, { vcmpngt_uqps k5,zmm30,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x1a                               }, { vcmpngt_uqps k5,zmm30,DWORD [rcx]{1to16}                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x1a                         }, { vcmpngt_uqps k5,zmm30,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x1a       }, { vcmpngt_uqps k5,zmm30,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x1a                         }, { vcmpngt_uqps k5,zmm30,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x1a       }, { vcmpngt_uqps k5,zmm30,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x1a                         }, { vcmpngt_uqps k5,zmm30,DWORD [rdx+0x1fc]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x1a       }, { vcmpngt_uqps k5,zmm30,DWORD [rdx+0x200]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x1a                         }, { vcmpngt_uqps k5,zmm30,DWORD [rdx-0x200]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x1a       }, { vcmpngt_uqps k5,zmm30,DWORD [rdx-0x204]{1to16}               }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x1b                               }, { vcmpfalse_osps k5,zmm30,zmm29                                }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x1b                               }, { vcmpfalse_osps k5{k7},zmm30,zmm29                            }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x1b                               }, { vcmpfalse_osps k5,zmm30,zmm29,{sae}                          }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x1b                               }, { vcmpfalse_osps k5,zmm30,ZWORD [rcx]                          }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1b }, { vcmpfalse_osps k5,zmm30,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x1b                               }, { vcmpfalse_osps k5,zmm30,DWORD [rcx]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x1b                         }, { vcmpfalse_osps k5,zmm30,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x1b       }, { vcmpfalse_osps k5,zmm30,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x1b                         }, { vcmpfalse_osps k5,zmm30,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x1b       }, { vcmpfalse_osps k5,zmm30,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x1b                         }, { vcmpfalse_osps k5,zmm30,DWORD [rdx+0x1fc]{1to16}             }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x1b       }, { vcmpfalse_osps k5,zmm30,DWORD [rdx+0x200]{1to16}             }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x1b                         }, { vcmpfalse_osps k5,zmm30,DWORD [rdx-0x200]{1to16}             }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x1b       }, { vcmpfalse_osps k5,zmm30,DWORD [rdx-0x204]{1to16}             }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x1c                               }, { vcmpneq_osps k5,zmm30,zmm29                                  }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x1c                               }, { vcmpneq_osps k5{k7},zmm30,zmm29                              }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x1c                               }, { vcmpneq_osps k5,zmm30,zmm29,{sae}                            }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x1c                               }, { vcmpneq_osps k5,zmm30,ZWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1c }, { vcmpneq_osps k5,zmm30,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x1c                               }, { vcmpneq_osps k5,zmm30,DWORD [rcx]{1to16}                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x1c                         }, { vcmpneq_osps k5,zmm30,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x1c       }, { vcmpneq_osps k5,zmm30,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x1c                         }, { vcmpneq_osps k5,zmm30,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x1c       }, { vcmpneq_osps k5,zmm30,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x1c                         }, { vcmpneq_osps k5,zmm30,DWORD [rdx+0x1fc]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x1c       }, { vcmpneq_osps k5,zmm30,DWORD [rdx+0x200]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x1c                         }, { vcmpneq_osps k5,zmm30,DWORD [rdx-0x200]{1to16}               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x1c       }, { vcmpneq_osps k5,zmm30,DWORD [rdx-0x204]{1to16}               }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x1d                               }, { vcmpge_oqps k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x1d                               }, { vcmpge_oqps k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x1d                               }, { vcmpge_oqps k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x1d                               }, { vcmpge_oqps k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1d }, { vcmpge_oqps k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x1d                               }, { vcmpge_oqps k5,zmm30,DWORD [rcx]{1to16}                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x1d                         }, { vcmpge_oqps k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x1d       }, { vcmpge_oqps k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x1d                         }, { vcmpge_oqps k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x1d       }, { vcmpge_oqps k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x1d                         }, { vcmpge_oqps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x1d       }, { vcmpge_oqps k5,zmm30,DWORD [rdx+0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x1d                         }, { vcmpge_oqps k5,zmm30,DWORD [rdx-0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x1d       }, { vcmpge_oqps k5,zmm30,DWORD [rdx-0x204]{1to16}                }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x1e                               }, { vcmpgt_oqps k5,zmm30,zmm29                                   }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x1e                               }, { vcmpgt_oqps k5{k7},zmm30,zmm29                               }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x1e                               }, { vcmpgt_oqps k5,zmm30,zmm29,{sae}                             }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x1e                               }, { vcmpgt_oqps k5,zmm30,ZWORD [rcx]                             }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1e }, { vcmpgt_oqps k5,zmm30,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x1e                               }, { vcmpgt_oqps k5,zmm30,DWORD [rcx]{1to16}                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x1e                         }, { vcmpgt_oqps k5,zmm30,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x1e       }, { vcmpgt_oqps k5,zmm30,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x1e                         }, { vcmpgt_oqps k5,zmm30,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x1e       }, { vcmpgt_oqps k5,zmm30,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x1e                         }, { vcmpgt_oqps k5,zmm30,DWORD [rdx+0x1fc]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x1e       }, { vcmpgt_oqps k5,zmm30,DWORD [rdx+0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x1e                         }, { vcmpgt_oqps k5,zmm30,DWORD [rdx-0x200]{1to16}                }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x1e       }, { vcmpgt_oqps k5,zmm30,DWORD [rdx-0x204]{1to16}                }
testcase	{ 0x62, 0x91, 0x0c, 0x40, 0xc2, 0xed, 0x1f                               }, { vcmptrue_usps k5,zmm30,zmm29                                 }
testcase	{ 0x62, 0x91, 0x0c, 0x47, 0xc2, 0xed, 0x1f                               }, { vcmptrue_usps k5{k7},zmm30,zmm29                             }
testcase	{ 0x62, 0x91, 0x0c, 0x10, 0xc2, 0xed, 0x1f                               }, { vcmptrue_usps k5,zmm30,zmm29,{sae}                           }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x29, 0x1f                               }, { vcmptrue_usps k5,zmm30,ZWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x0c, 0x40, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1f }, { vcmptrue_usps k5,zmm30,ZWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x29, 0x1f                               }, { vcmptrue_usps k5,zmm30,DWORD [rcx]{1to16}                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x7f, 0x1f                         }, { vcmptrue_usps k5,zmm30,ZWORD [rdx+0x1fc0]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x1f       }, { vcmptrue_usps k5,zmm30,ZWORD [rdx+0x2000]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0x6a, 0x80, 0x1f                         }, { vcmptrue_usps k5,zmm30,ZWORD [rdx-0x2000]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x40, 0xc2, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x1f       }, { vcmptrue_usps k5,zmm30,ZWORD [rdx-0x2040]                    }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x7f, 0x1f                         }, { vcmptrue_usps k5,zmm30,DWORD [rdx+0x1fc]{1to16}              }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x1f       }, { vcmptrue_usps k5,zmm30,DWORD [rdx+0x200]{1to16}              }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0x6a, 0x80, 0x1f                         }, { vcmptrue_usps k5,zmm30,DWORD [rdx-0x200]{1to16}              }
testcase	{ 0x62, 0xf1, 0x0c, 0x50, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x1f       }, { vcmptrue_usps k5,zmm30,DWORD [rdx-0x204]{1to16}              }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0xab                               }, { vcmpsd k5{k7},xmm29,xmm28,0xab                               }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0xab                               }, { vcmpsd k5{k7},xmm29,xmm28,{sae},0xab                         }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x7b                               }, { vcmpsd k5{k7},xmm29,xmm28,0x7b                               }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x7b                               }, { vcmpsd k5{k7},xmm29,xmm28,{sae},0x7b                         }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x7b                               }, { vcmpsd k5{k7},xmm29,QWORD [rcx],0x7b                         }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vcmpsd k5{k7},xmm29,QWORD [rax+r14*8+0x123],0x7b             }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x7b                         }, { vcmpsd k5{k7},xmm29,QWORD [rdx+0x3f8],0x7b                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vcmpsd k5{k7},xmm29,QWORD [rdx+0x400],0x7b                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x7b                         }, { vcmpsd k5{k7},xmm29,QWORD [rdx-0x400],0x7b                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vcmpsd k5{k7},xmm29,QWORD [rdx-0x408],0x7b                   }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x00                               }, { vcmpeqsd k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x00                               }, { vcmpeqsd k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x00                               }, { vcmpeqsd k5{k7},xmm29,QWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x00 }, { vcmpeqsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x00                         }, { vcmpeqsd k5{k7},xmm29,QWORD [rdx+0x3f8]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x00       }, { vcmpeqsd k5{k7},xmm29,QWORD [rdx+0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x00                         }, { vcmpeqsd k5{k7},xmm29,QWORD [rdx-0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x00       }, { vcmpeqsd k5{k7},xmm29,QWORD [rdx-0x408]                      }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x00                               }, { vcmpeqsd k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x00                               }, { vcmpeqsd k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x00                               }, { vcmpeqsd k5{k7},xmm29,QWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x00 }, { vcmpeqsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x00                         }, { vcmpeqsd k5{k7},xmm29,QWORD [rdx+0x3f8]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x00       }, { vcmpeqsd k5{k7},xmm29,QWORD [rdx+0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x00                         }, { vcmpeqsd k5{k7},xmm29,QWORD [rdx-0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x00       }, { vcmpeqsd k5{k7},xmm29,QWORD [rdx-0x408]                      }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x01                               }, { vcmpltsd k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x01                               }, { vcmpltsd k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x01                               }, { vcmpltsd k5{k7},xmm29,QWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x01 }, { vcmpltsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x01                         }, { vcmpltsd k5{k7},xmm29,QWORD [rdx+0x3f8]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x01       }, { vcmpltsd k5{k7},xmm29,QWORD [rdx+0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x01                         }, { vcmpltsd k5{k7},xmm29,QWORD [rdx-0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x01       }, { vcmpltsd k5{k7},xmm29,QWORD [rdx-0x408]                      }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x01                               }, { vcmpltsd k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x01                               }, { vcmpltsd k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x01                               }, { vcmpltsd k5{k7},xmm29,QWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x01 }, { vcmpltsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x01                         }, { vcmpltsd k5{k7},xmm29,QWORD [rdx+0x3f8]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x01       }, { vcmpltsd k5{k7},xmm29,QWORD [rdx+0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x01                         }, { vcmpltsd k5{k7},xmm29,QWORD [rdx-0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x01       }, { vcmpltsd k5{k7},xmm29,QWORD [rdx-0x408]                      }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x02                               }, { vcmplesd k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x02                               }, { vcmplesd k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x02                               }, { vcmplesd k5{k7},xmm29,QWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x02 }, { vcmplesd k5{k7},xmm29,QWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x02                         }, { vcmplesd k5{k7},xmm29,QWORD [rdx+0x3f8]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x02       }, { vcmplesd k5{k7},xmm29,QWORD [rdx+0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x02                         }, { vcmplesd k5{k7},xmm29,QWORD [rdx-0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x02       }, { vcmplesd k5{k7},xmm29,QWORD [rdx-0x408]                      }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x02                               }, { vcmplesd k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x02                               }, { vcmplesd k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x02                               }, { vcmplesd k5{k7},xmm29,QWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x02 }, { vcmplesd k5{k7},xmm29,QWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x02                         }, { vcmplesd k5{k7},xmm29,QWORD [rdx+0x3f8]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x02       }, { vcmplesd k5{k7},xmm29,QWORD [rdx+0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x02                         }, { vcmplesd k5{k7},xmm29,QWORD [rdx-0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x02       }, { vcmplesd k5{k7},xmm29,QWORD [rdx-0x408]                      }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x03                               }, { vcmpunordsd k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x03                               }, { vcmpunordsd k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x03                               }, { vcmpunordsd k5{k7},xmm29,QWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x03 }, { vcmpunordsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x03                         }, { vcmpunordsd k5{k7},xmm29,QWORD [rdx+0x3f8]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x03       }, { vcmpunordsd k5{k7},xmm29,QWORD [rdx+0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x03                         }, { vcmpunordsd k5{k7},xmm29,QWORD [rdx-0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x03       }, { vcmpunordsd k5{k7},xmm29,QWORD [rdx-0x408]                   }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x03                               }, { vcmpunordsd k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x03                               }, { vcmpunordsd k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x03                               }, { vcmpunordsd k5{k7},xmm29,QWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x03 }, { vcmpunordsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x03                         }, { vcmpunordsd k5{k7},xmm29,QWORD [rdx+0x3f8]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x03       }, { vcmpunordsd k5{k7},xmm29,QWORD [rdx+0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x03                         }, { vcmpunordsd k5{k7},xmm29,QWORD [rdx-0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x03       }, { vcmpunordsd k5{k7},xmm29,QWORD [rdx-0x408]                   }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x04                               }, { vcmpneqsd k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x04                               }, { vcmpneqsd k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x04                               }, { vcmpneqsd k5{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x04 }, { vcmpneqsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x04                         }, { vcmpneqsd k5{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x04       }, { vcmpneqsd k5{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x04                         }, { vcmpneqsd k5{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x04       }, { vcmpneqsd k5{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x04                               }, { vcmpneqsd k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x04                               }, { vcmpneqsd k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x04                               }, { vcmpneqsd k5{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x04 }, { vcmpneqsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x04                         }, { vcmpneqsd k5{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x04       }, { vcmpneqsd k5{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x04                         }, { vcmpneqsd k5{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x04       }, { vcmpneqsd k5{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x05                               }, { vcmpnltsd k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x05                               }, { vcmpnltsd k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x05                               }, { vcmpnltsd k5{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x05 }, { vcmpnltsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x05                         }, { vcmpnltsd k5{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x05       }, { vcmpnltsd k5{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x05                         }, { vcmpnltsd k5{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x05       }, { vcmpnltsd k5{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x05                               }, { vcmpnltsd k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x05                               }, { vcmpnltsd k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x05                               }, { vcmpnltsd k5{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x05 }, { vcmpnltsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x05                         }, { vcmpnltsd k5{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x05       }, { vcmpnltsd k5{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x05                         }, { vcmpnltsd k5{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x05       }, { vcmpnltsd k5{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x06                               }, { vcmpnlesd k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x06                               }, { vcmpnlesd k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x06                               }, { vcmpnlesd k5{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x06 }, { vcmpnlesd k5{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x06                         }, { vcmpnlesd k5{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x06       }, { vcmpnlesd k5{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x06                         }, { vcmpnlesd k5{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x06       }, { vcmpnlesd k5{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x06                               }, { vcmpnlesd k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x06                               }, { vcmpnlesd k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x06                               }, { vcmpnlesd k5{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x06 }, { vcmpnlesd k5{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x06                         }, { vcmpnlesd k5{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x06       }, { vcmpnlesd k5{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x06                         }, { vcmpnlesd k5{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x06       }, { vcmpnlesd k5{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x07                               }, { vcmpordsd k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x07                               }, { vcmpordsd k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x07                               }, { vcmpordsd k5{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x07 }, { vcmpordsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x07                         }, { vcmpordsd k5{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x07       }, { vcmpordsd k5{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x07                         }, { vcmpordsd k5{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x07       }, { vcmpordsd k5{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x07                               }, { vcmpordsd k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x07                               }, { vcmpordsd k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x07                               }, { vcmpordsd k5{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x07 }, { vcmpordsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x07                         }, { vcmpordsd k5{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x07       }, { vcmpordsd k5{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x07                         }, { vcmpordsd k5{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x07       }, { vcmpordsd k5{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x08                               }, { vcmpeq_uqsd k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x08                               }, { vcmpeq_uqsd k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x08                               }, { vcmpeq_uqsd k5{k7},xmm29,QWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x08 }, { vcmpeq_uqsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x08                         }, { vcmpeq_uqsd k5{k7},xmm29,QWORD [rdx+0x3f8]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x08       }, { vcmpeq_uqsd k5{k7},xmm29,QWORD [rdx+0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x08                         }, { vcmpeq_uqsd k5{k7},xmm29,QWORD [rdx-0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x08       }, { vcmpeq_uqsd k5{k7},xmm29,QWORD [rdx-0x408]                   }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x09                               }, { vcmpngesd k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x09                               }, { vcmpngesd k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x09                               }, { vcmpngesd k5{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x09 }, { vcmpngesd k5{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x09                         }, { vcmpngesd k5{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x09       }, { vcmpngesd k5{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x09                         }, { vcmpngesd k5{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x09       }, { vcmpngesd k5{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x09                               }, { vcmpngesd k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x09                               }, { vcmpngesd k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x09                               }, { vcmpngesd k5{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x09 }, { vcmpngesd k5{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x09                         }, { vcmpngesd k5{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x09       }, { vcmpngesd k5{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x09                         }, { vcmpngesd k5{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x09       }, { vcmpngesd k5{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x0a                               }, { vcmpngtsd k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x0a                               }, { vcmpngtsd k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x0a                               }, { vcmpngtsd k5{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0a }, { vcmpngtsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x0a                         }, { vcmpngtsd k5{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0a       }, { vcmpngtsd k5{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x0a                         }, { vcmpngtsd k5{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0a       }, { vcmpngtsd k5{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x0a                               }, { vcmpngtsd k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x0a                               }, { vcmpngtsd k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x0a                               }, { vcmpngtsd k5{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0a }, { vcmpngtsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x0a                         }, { vcmpngtsd k5{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0a       }, { vcmpngtsd k5{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x0a                         }, { vcmpngtsd k5{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0a       }, { vcmpngtsd k5{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x0b                               }, { vcmpfalsesd k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x0b                               }, { vcmpfalsesd k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x0b                               }, { vcmpfalsesd k5{k7},xmm29,QWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0b }, { vcmpfalsesd k5{k7},xmm29,QWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x0b                         }, { vcmpfalsesd k5{k7},xmm29,QWORD [rdx+0x3f8]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0b       }, { vcmpfalsesd k5{k7},xmm29,QWORD [rdx+0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x0b                         }, { vcmpfalsesd k5{k7},xmm29,QWORD [rdx-0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0b       }, { vcmpfalsesd k5{k7},xmm29,QWORD [rdx-0x408]                   }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x0b                               }, { vcmpfalsesd k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x0b                               }, { vcmpfalsesd k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x0b                               }, { vcmpfalsesd k5{k7},xmm29,QWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0b }, { vcmpfalsesd k5{k7},xmm29,QWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x0b                         }, { vcmpfalsesd k5{k7},xmm29,QWORD [rdx+0x3f8]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0b       }, { vcmpfalsesd k5{k7},xmm29,QWORD [rdx+0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x0b                         }, { vcmpfalsesd k5{k7},xmm29,QWORD [rdx-0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0b       }, { vcmpfalsesd k5{k7},xmm29,QWORD [rdx-0x408]                   }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x0c                               }, { vcmpneq_oqsd k5{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x0c                               }, { vcmpneq_oqsd k5{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x0c                               }, { vcmpneq_oqsd k5{k7},xmm29,QWORD [rcx]                        }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0c }, { vcmpneq_oqsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x0c                         }, { vcmpneq_oqsd k5{k7},xmm29,QWORD [rdx+0x3f8]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0c       }, { vcmpneq_oqsd k5{k7},xmm29,QWORD [rdx+0x400]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x0c                         }, { vcmpneq_oqsd k5{k7},xmm29,QWORD [rdx-0x400]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0c       }, { vcmpneq_oqsd k5{k7},xmm29,QWORD [rdx-0x408]                  }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x0d                               }, { vcmpgesd k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x0d                               }, { vcmpgesd k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x0d                               }, { vcmpgesd k5{k7},xmm29,QWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0d }, { vcmpgesd k5{k7},xmm29,QWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x0d                         }, { vcmpgesd k5{k7},xmm29,QWORD [rdx+0x3f8]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0d       }, { vcmpgesd k5{k7},xmm29,QWORD [rdx+0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x0d                         }, { vcmpgesd k5{k7},xmm29,QWORD [rdx-0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0d       }, { vcmpgesd k5{k7},xmm29,QWORD [rdx-0x408]                      }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x0d                               }, { vcmpgesd k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x0d                               }, { vcmpgesd k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x0d                               }, { vcmpgesd k5{k7},xmm29,QWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0d }, { vcmpgesd k5{k7},xmm29,QWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x0d                         }, { vcmpgesd k5{k7},xmm29,QWORD [rdx+0x3f8]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0d       }, { vcmpgesd k5{k7},xmm29,QWORD [rdx+0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x0d                         }, { vcmpgesd k5{k7},xmm29,QWORD [rdx-0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0d       }, { vcmpgesd k5{k7},xmm29,QWORD [rdx-0x408]                      }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x0e                               }, { vcmpgtsd k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x0e                               }, { vcmpgtsd k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x0e                               }, { vcmpgtsd k5{k7},xmm29,QWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0e }, { vcmpgtsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x0e                         }, { vcmpgtsd k5{k7},xmm29,QWORD [rdx+0x3f8]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0e       }, { vcmpgtsd k5{k7},xmm29,QWORD [rdx+0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x0e                         }, { vcmpgtsd k5{k7},xmm29,QWORD [rdx-0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0e       }, { vcmpgtsd k5{k7},xmm29,QWORD [rdx-0x408]                      }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x0e                               }, { vcmpgtsd k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x0e                               }, { vcmpgtsd k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x0e                               }, { vcmpgtsd k5{k7},xmm29,QWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0e }, { vcmpgtsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x0e                         }, { vcmpgtsd k5{k7},xmm29,QWORD [rdx+0x3f8]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0e       }, { vcmpgtsd k5{k7},xmm29,QWORD [rdx+0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x0e                         }, { vcmpgtsd k5{k7},xmm29,QWORD [rdx-0x400]                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0e       }, { vcmpgtsd k5{k7},xmm29,QWORD [rdx-0x408]                      }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x0f                               }, { vcmptruesd k5{k7},xmm29,xmm28                                }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x0f                               }, { vcmptruesd k5{k7},xmm29,xmm28,{sae}                          }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x0f                               }, { vcmptruesd k5{k7},xmm29,QWORD [rcx]                          }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0f }, { vcmptruesd k5{k7},xmm29,QWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x0f                         }, { vcmptruesd k5{k7},xmm29,QWORD [rdx+0x3f8]                    }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0f       }, { vcmptruesd k5{k7},xmm29,QWORD [rdx+0x400]                    }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x0f                         }, { vcmptruesd k5{k7},xmm29,QWORD [rdx-0x400]                    }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0f       }, { vcmptruesd k5{k7},xmm29,QWORD [rdx-0x408]                    }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x0f                               }, { vcmptruesd k5{k7},xmm29,xmm28                                }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x0f                               }, { vcmptruesd k5{k7},xmm29,xmm28,{sae}                          }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x0f                               }, { vcmptruesd k5{k7},xmm29,QWORD [rcx]                          }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0f }, { vcmptruesd k5{k7},xmm29,QWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x0f                         }, { vcmptruesd k5{k7},xmm29,QWORD [rdx+0x3f8]                    }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x0f       }, { vcmptruesd k5{k7},xmm29,QWORD [rdx+0x400]                    }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x0f                         }, { vcmptruesd k5{k7},xmm29,QWORD [rdx-0x400]                    }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x0f       }, { vcmptruesd k5{k7},xmm29,QWORD [rdx-0x408]                    }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x10                               }, { vcmpeq_ossd k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x10                               }, { vcmpeq_ossd k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x10                               }, { vcmpeq_ossd k5{k7},xmm29,QWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x10 }, { vcmpeq_ossd k5{k7},xmm29,QWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x10                         }, { vcmpeq_ossd k5{k7},xmm29,QWORD [rdx+0x3f8]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x10       }, { vcmpeq_ossd k5{k7},xmm29,QWORD [rdx+0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x10                         }, { vcmpeq_ossd k5{k7},xmm29,QWORD [rdx-0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x10       }, { vcmpeq_ossd k5{k7},xmm29,QWORD [rdx-0x408]                   }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x11                               }, { vcmplt_oqsd k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x11                               }, { vcmplt_oqsd k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x11                               }, { vcmplt_oqsd k5{k7},xmm29,QWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x11 }, { vcmplt_oqsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x11                         }, { vcmplt_oqsd k5{k7},xmm29,QWORD [rdx+0x3f8]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x11       }, { vcmplt_oqsd k5{k7},xmm29,QWORD [rdx+0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x11                         }, { vcmplt_oqsd k5{k7},xmm29,QWORD [rdx-0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x11       }, { vcmplt_oqsd k5{k7},xmm29,QWORD [rdx-0x408]                   }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x12                               }, { vcmple_oqsd k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x12                               }, { vcmple_oqsd k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x12                               }, { vcmple_oqsd k5{k7},xmm29,QWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x12 }, { vcmple_oqsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x12                         }, { vcmple_oqsd k5{k7},xmm29,QWORD [rdx+0x3f8]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x12       }, { vcmple_oqsd k5{k7},xmm29,QWORD [rdx+0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x12                         }, { vcmple_oqsd k5{k7},xmm29,QWORD [rdx-0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x12       }, { vcmple_oqsd k5{k7},xmm29,QWORD [rdx-0x408]                   }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x13                               }, { vcmpunord_ssd k5{k7},xmm29,xmm28                             }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x13                               }, { vcmpunord_ssd k5{k7},xmm29,xmm28,{sae}                       }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x13                               }, { vcmpunord_ssd k5{k7},xmm29,QWORD [rcx]                       }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x13 }, { vcmpunord_ssd k5{k7},xmm29,QWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x13                         }, { vcmpunord_ssd k5{k7},xmm29,QWORD [rdx+0x3f8]                 }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x13       }, { vcmpunord_ssd k5{k7},xmm29,QWORD [rdx+0x400]                 }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x13                         }, { vcmpunord_ssd k5{k7},xmm29,QWORD [rdx-0x400]                 }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x13       }, { vcmpunord_ssd k5{k7},xmm29,QWORD [rdx-0x408]                 }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x14                               }, { vcmpneq_ussd k5{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x14                               }, { vcmpneq_ussd k5{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x14                               }, { vcmpneq_ussd k5{k7},xmm29,QWORD [rcx]                        }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x14 }, { vcmpneq_ussd k5{k7},xmm29,QWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x14                         }, { vcmpneq_ussd k5{k7},xmm29,QWORD [rdx+0x3f8]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x14       }, { vcmpneq_ussd k5{k7},xmm29,QWORD [rdx+0x400]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x14                         }, { vcmpneq_ussd k5{k7},xmm29,QWORD [rdx-0x400]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x14       }, { vcmpneq_ussd k5{k7},xmm29,QWORD [rdx-0x408]                  }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x15                               }, { vcmpnlt_uqsd k5{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x15                               }, { vcmpnlt_uqsd k5{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x15                               }, { vcmpnlt_uqsd k5{k7},xmm29,QWORD [rcx]                        }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x15 }, { vcmpnlt_uqsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x15                         }, { vcmpnlt_uqsd k5{k7},xmm29,QWORD [rdx+0x3f8]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x15       }, { vcmpnlt_uqsd k5{k7},xmm29,QWORD [rdx+0x400]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x15                         }, { vcmpnlt_uqsd k5{k7},xmm29,QWORD [rdx-0x400]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x15       }, { vcmpnlt_uqsd k5{k7},xmm29,QWORD [rdx-0x408]                  }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x16                               }, { vcmpnle_uqsd k5{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x16                               }, { vcmpnle_uqsd k5{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x16                               }, { vcmpnle_uqsd k5{k7},xmm29,QWORD [rcx]                        }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x16 }, { vcmpnle_uqsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x16                         }, { vcmpnle_uqsd k5{k7},xmm29,QWORD [rdx+0x3f8]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x16       }, { vcmpnle_uqsd k5{k7},xmm29,QWORD [rdx+0x400]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x16                         }, { vcmpnle_uqsd k5{k7},xmm29,QWORD [rdx-0x400]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x16       }, { vcmpnle_uqsd k5{k7},xmm29,QWORD [rdx-0x408]                  }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x17                               }, { vcmpord_ssd k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x17                               }, { vcmpord_ssd k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x17                               }, { vcmpord_ssd k5{k7},xmm29,QWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x17 }, { vcmpord_ssd k5{k7},xmm29,QWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x17                         }, { vcmpord_ssd k5{k7},xmm29,QWORD [rdx+0x3f8]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x17       }, { vcmpord_ssd k5{k7},xmm29,QWORD [rdx+0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x17                         }, { vcmpord_ssd k5{k7},xmm29,QWORD [rdx-0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x17       }, { vcmpord_ssd k5{k7},xmm29,QWORD [rdx-0x408]                   }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x18                               }, { vcmpeq_ussd k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x18                               }, { vcmpeq_ussd k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x18                               }, { vcmpeq_ussd k5{k7},xmm29,QWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x18 }, { vcmpeq_ussd k5{k7},xmm29,QWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x18                         }, { vcmpeq_ussd k5{k7},xmm29,QWORD [rdx+0x3f8]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x18       }, { vcmpeq_ussd k5{k7},xmm29,QWORD [rdx+0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x18                         }, { vcmpeq_ussd k5{k7},xmm29,QWORD [rdx-0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x18       }, { vcmpeq_ussd k5{k7},xmm29,QWORD [rdx-0x408]                   }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x19                               }, { vcmpnge_uqsd k5{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x19                               }, { vcmpnge_uqsd k5{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x19                               }, { vcmpnge_uqsd k5{k7},xmm29,QWORD [rcx]                        }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x19 }, { vcmpnge_uqsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x19                         }, { vcmpnge_uqsd k5{k7},xmm29,QWORD [rdx+0x3f8]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x19       }, { vcmpnge_uqsd k5{k7},xmm29,QWORD [rdx+0x400]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x19                         }, { vcmpnge_uqsd k5{k7},xmm29,QWORD [rdx-0x400]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x19       }, { vcmpnge_uqsd k5{k7},xmm29,QWORD [rdx-0x408]                  }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x1a                               }, { vcmpngt_uqsd k5{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x1a                               }, { vcmpngt_uqsd k5{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x1a                               }, { vcmpngt_uqsd k5{k7},xmm29,QWORD [rcx]                        }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1a }, { vcmpngt_uqsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x1a                         }, { vcmpngt_uqsd k5{k7},xmm29,QWORD [rdx+0x3f8]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x1a       }, { vcmpngt_uqsd k5{k7},xmm29,QWORD [rdx+0x400]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x1a                         }, { vcmpngt_uqsd k5{k7},xmm29,QWORD [rdx-0x400]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x1a       }, { vcmpngt_uqsd k5{k7},xmm29,QWORD [rdx-0x408]                  }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x1b                               }, { vcmpfalse_ossd k5{k7},xmm29,xmm28                            }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x1b                               }, { vcmpfalse_ossd k5{k7},xmm29,xmm28,{sae}                      }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x1b                               }, { vcmpfalse_ossd k5{k7},xmm29,QWORD [rcx]                      }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1b }, { vcmpfalse_ossd k5{k7},xmm29,QWORD [rax+r14*8+0x123]          }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x1b                         }, { vcmpfalse_ossd k5{k7},xmm29,QWORD [rdx+0x3f8]                }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x1b       }, { vcmpfalse_ossd k5{k7},xmm29,QWORD [rdx+0x400]                }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x1b                         }, { vcmpfalse_ossd k5{k7},xmm29,QWORD [rdx-0x400]                }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x1b       }, { vcmpfalse_ossd k5{k7},xmm29,QWORD [rdx-0x408]                }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x1c                               }, { vcmpneq_ossd k5{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x1c                               }, { vcmpneq_ossd k5{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x1c                               }, { vcmpneq_ossd k5{k7},xmm29,QWORD [rcx]                        }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1c }, { vcmpneq_ossd k5{k7},xmm29,QWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x1c                         }, { vcmpneq_ossd k5{k7},xmm29,QWORD [rdx+0x3f8]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x1c       }, { vcmpneq_ossd k5{k7},xmm29,QWORD [rdx+0x400]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x1c                         }, { vcmpneq_ossd k5{k7},xmm29,QWORD [rdx-0x400]                  }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x1c       }, { vcmpneq_ossd k5{k7},xmm29,QWORD [rdx-0x408]                  }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x1d                               }, { vcmpge_oqsd k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x1d                               }, { vcmpge_oqsd k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x1d                               }, { vcmpge_oqsd k5{k7},xmm29,QWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1d }, { vcmpge_oqsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x1d                         }, { vcmpge_oqsd k5{k7},xmm29,QWORD [rdx+0x3f8]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x1d       }, { vcmpge_oqsd k5{k7},xmm29,QWORD [rdx+0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x1d                         }, { vcmpge_oqsd k5{k7},xmm29,QWORD [rdx-0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x1d       }, { vcmpge_oqsd k5{k7},xmm29,QWORD [rdx-0x408]                   }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x1e                               }, { vcmpgt_oqsd k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x1e                               }, { vcmpgt_oqsd k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x1e                               }, { vcmpgt_oqsd k5{k7},xmm29,QWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1e }, { vcmpgt_oqsd k5{k7},xmm29,QWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x1e                         }, { vcmpgt_oqsd k5{k7},xmm29,QWORD [rdx+0x3f8]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x1e       }, { vcmpgt_oqsd k5{k7},xmm29,QWORD [rdx+0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x1e                         }, { vcmpgt_oqsd k5{k7},xmm29,QWORD [rdx-0x400]                   }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x1e       }, { vcmpgt_oqsd k5{k7},xmm29,QWORD [rdx-0x408]                   }
testcase	{ 0x62, 0x91, 0x97, 0x07, 0xc2, 0xec, 0x1f                               }, { vcmptrue_ussd k5{k7},xmm29,xmm28                             }
testcase	{ 0x62, 0x91, 0x97, 0x17, 0xc2, 0xec, 0x1f                               }, { vcmptrue_ussd k5{k7},xmm29,xmm28,{sae}                       }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x29, 0x1f                               }, { vcmptrue_ussd k5{k7},xmm29,QWORD [rcx]                       }
testcase	{ 0x62, 0xb1, 0x97, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1f }, { vcmptrue_ussd k5{k7},xmm29,QWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x7f, 0x1f                         }, { vcmptrue_ussd k5{k7},xmm29,QWORD [rdx+0x3f8]                 }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x1f       }, { vcmptrue_ussd k5{k7},xmm29,QWORD [rdx+0x400]                 }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0x6a, 0x80, 0x1f                         }, { vcmptrue_ussd k5{k7},xmm29,QWORD [rdx-0x400]                 }
testcase	{ 0x62, 0xf1, 0x97, 0x07, 0xc2, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x1f       }, { vcmptrue_ussd k5{k7},xmm29,QWORD [rdx-0x408]                 }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0xab                               }, { vcmpss k5{k7},xmm29,xmm28,0xab                               }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0xab                               }, { vcmpss k5{k7},xmm29,xmm28,{sae},0xab                         }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x7b                               }, { vcmpss k5{k7},xmm29,xmm28,0x7b                               }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x7b                               }, { vcmpss k5{k7},xmm29,xmm28,{sae},0x7b                         }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x7b                               }, { vcmpss k5{k7},xmm29,DWORD [rcx],0x7b                         }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vcmpss k5{k7},xmm29,DWORD [rax+r14*8+0x123],0x7b             }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x7b                         }, { vcmpss k5{k7},xmm29,DWORD [rdx+0x1fc],0x7b                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vcmpss k5{k7},xmm29,DWORD [rdx+0x200],0x7b                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x7b                         }, { vcmpss k5{k7},xmm29,DWORD [rdx-0x200],0x7b                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vcmpss k5{k7},xmm29,DWORD [rdx-0x204],0x7b                   }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x00                               }, { vcmpeqss k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x00                               }, { vcmpeqss k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x00                               }, { vcmpeqss k5{k7},xmm29,DWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x00 }, { vcmpeqss k5{k7},xmm29,DWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x00                         }, { vcmpeqss k5{k7},xmm29,DWORD [rdx+0x1fc]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x00       }, { vcmpeqss k5{k7},xmm29,DWORD [rdx+0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x00                         }, { vcmpeqss k5{k7},xmm29,DWORD [rdx-0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x00       }, { vcmpeqss k5{k7},xmm29,DWORD [rdx-0x204]                      }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x00                               }, { vcmpeqss k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x00                               }, { vcmpeqss k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x00                               }, { vcmpeqss k5{k7},xmm29,DWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x00 }, { vcmpeqss k5{k7},xmm29,DWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x00                         }, { vcmpeqss k5{k7},xmm29,DWORD [rdx+0x1fc]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x00       }, { vcmpeqss k5{k7},xmm29,DWORD [rdx+0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x00                         }, { vcmpeqss k5{k7},xmm29,DWORD [rdx-0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x00       }, { vcmpeqss k5{k7},xmm29,DWORD [rdx-0x204]                      }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x01                               }, { vcmpltss k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x01                               }, { vcmpltss k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x01                               }, { vcmpltss k5{k7},xmm29,DWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x01 }, { vcmpltss k5{k7},xmm29,DWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x01                         }, { vcmpltss k5{k7},xmm29,DWORD [rdx+0x1fc]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x01       }, { vcmpltss k5{k7},xmm29,DWORD [rdx+0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x01                         }, { vcmpltss k5{k7},xmm29,DWORD [rdx-0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x01       }, { vcmpltss k5{k7},xmm29,DWORD [rdx-0x204]                      }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x01                               }, { vcmpltss k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x01                               }, { vcmpltss k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x01                               }, { vcmpltss k5{k7},xmm29,DWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x01 }, { vcmpltss k5{k7},xmm29,DWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x01                         }, { vcmpltss k5{k7},xmm29,DWORD [rdx+0x1fc]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x01       }, { vcmpltss k5{k7},xmm29,DWORD [rdx+0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x01                         }, { vcmpltss k5{k7},xmm29,DWORD [rdx-0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x01       }, { vcmpltss k5{k7},xmm29,DWORD [rdx-0x204]                      }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x02                               }, { vcmpless k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x02                               }, { vcmpless k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x02                               }, { vcmpless k5{k7},xmm29,DWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x02 }, { vcmpless k5{k7},xmm29,DWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x02                         }, { vcmpless k5{k7},xmm29,DWORD [rdx+0x1fc]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x02       }, { vcmpless k5{k7},xmm29,DWORD [rdx+0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x02                         }, { vcmpless k5{k7},xmm29,DWORD [rdx-0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x02       }, { vcmpless k5{k7},xmm29,DWORD [rdx-0x204]                      }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x02                               }, { vcmpless k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x02                               }, { vcmpless k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x02                               }, { vcmpless k5{k7},xmm29,DWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x02 }, { vcmpless k5{k7},xmm29,DWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x02                         }, { vcmpless k5{k7},xmm29,DWORD [rdx+0x1fc]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x02       }, { vcmpless k5{k7},xmm29,DWORD [rdx+0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x02                         }, { vcmpless k5{k7},xmm29,DWORD [rdx-0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x02       }, { vcmpless k5{k7},xmm29,DWORD [rdx-0x204]                      }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x03                               }, { vcmpunordss k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x03                               }, { vcmpunordss k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x03                               }, { vcmpunordss k5{k7},xmm29,DWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x03 }, { vcmpunordss k5{k7},xmm29,DWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x03                         }, { vcmpunordss k5{k7},xmm29,DWORD [rdx+0x1fc]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x03       }, { vcmpunordss k5{k7},xmm29,DWORD [rdx+0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x03                         }, { vcmpunordss k5{k7},xmm29,DWORD [rdx-0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x03       }, { vcmpunordss k5{k7},xmm29,DWORD [rdx-0x204]                   }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x03                               }, { vcmpunordss k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x03                               }, { vcmpunordss k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x03                               }, { vcmpunordss k5{k7},xmm29,DWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x03 }, { vcmpunordss k5{k7},xmm29,DWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x03                         }, { vcmpunordss k5{k7},xmm29,DWORD [rdx+0x1fc]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x03       }, { vcmpunordss k5{k7},xmm29,DWORD [rdx+0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x03                         }, { vcmpunordss k5{k7},xmm29,DWORD [rdx-0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x03       }, { vcmpunordss k5{k7},xmm29,DWORD [rdx-0x204]                   }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x04                               }, { vcmpneqss k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x04                               }, { vcmpneqss k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x04                               }, { vcmpneqss k5{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x04 }, { vcmpneqss k5{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x04                         }, { vcmpneqss k5{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x04       }, { vcmpneqss k5{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x04                         }, { vcmpneqss k5{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x04       }, { vcmpneqss k5{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x04                               }, { vcmpneqss k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x04                               }, { vcmpneqss k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x04                               }, { vcmpneqss k5{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x04 }, { vcmpneqss k5{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x04                         }, { vcmpneqss k5{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x04       }, { vcmpneqss k5{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x04                         }, { vcmpneqss k5{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x04       }, { vcmpneqss k5{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x05                               }, { vcmpnltss k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x05                               }, { vcmpnltss k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x05                               }, { vcmpnltss k5{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x05 }, { vcmpnltss k5{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x05                         }, { vcmpnltss k5{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x05       }, { vcmpnltss k5{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x05                         }, { vcmpnltss k5{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x05       }, { vcmpnltss k5{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x05                               }, { vcmpnltss k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x05                               }, { vcmpnltss k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x05                               }, { vcmpnltss k5{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x05 }, { vcmpnltss k5{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x05                         }, { vcmpnltss k5{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x05       }, { vcmpnltss k5{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x05                         }, { vcmpnltss k5{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x05       }, { vcmpnltss k5{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x06                               }, { vcmpnless k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x06                               }, { vcmpnless k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x06                               }, { vcmpnless k5{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x06 }, { vcmpnless k5{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x06                         }, { vcmpnless k5{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x06       }, { vcmpnless k5{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x06                         }, { vcmpnless k5{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x06       }, { vcmpnless k5{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x06                               }, { vcmpnless k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x06                               }, { vcmpnless k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x06                               }, { vcmpnless k5{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x06 }, { vcmpnless k5{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x06                         }, { vcmpnless k5{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x06       }, { vcmpnless k5{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x06                         }, { vcmpnless k5{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x06       }, { vcmpnless k5{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x07                               }, { vcmpordss k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x07                               }, { vcmpordss k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x07                               }, { vcmpordss k5{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x07 }, { vcmpordss k5{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x07                         }, { vcmpordss k5{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x07       }, { vcmpordss k5{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x07                         }, { vcmpordss k5{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x07       }, { vcmpordss k5{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x07                               }, { vcmpordss k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x07                               }, { vcmpordss k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x07                               }, { vcmpordss k5{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x07 }, { vcmpordss k5{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x07                         }, { vcmpordss k5{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x07       }, { vcmpordss k5{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x07                         }, { vcmpordss k5{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x07       }, { vcmpordss k5{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x08                               }, { vcmpeq_uqss k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x08                               }, { vcmpeq_uqss k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x08                               }, { vcmpeq_uqss k5{k7},xmm29,DWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x08 }, { vcmpeq_uqss k5{k7},xmm29,DWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x08                         }, { vcmpeq_uqss k5{k7},xmm29,DWORD [rdx+0x1fc]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x08       }, { vcmpeq_uqss k5{k7},xmm29,DWORD [rdx+0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x08                         }, { vcmpeq_uqss k5{k7},xmm29,DWORD [rdx-0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x08       }, { vcmpeq_uqss k5{k7},xmm29,DWORD [rdx-0x204]                   }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x09                               }, { vcmpngess k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x09                               }, { vcmpngess k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x09                               }, { vcmpngess k5{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x09 }, { vcmpngess k5{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x09                         }, { vcmpngess k5{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x09       }, { vcmpngess k5{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x09                         }, { vcmpngess k5{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x09       }, { vcmpngess k5{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x09                               }, { vcmpngess k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x09                               }, { vcmpngess k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x09                               }, { vcmpngess k5{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x09 }, { vcmpngess k5{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x09                         }, { vcmpngess k5{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x09       }, { vcmpngess k5{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x09                         }, { vcmpngess k5{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x09       }, { vcmpngess k5{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x0a                               }, { vcmpngtss k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x0a                               }, { vcmpngtss k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x0a                               }, { vcmpngtss k5{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0a }, { vcmpngtss k5{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x0a                         }, { vcmpngtss k5{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0a       }, { vcmpngtss k5{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x0a                         }, { vcmpngtss k5{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0a       }, { vcmpngtss k5{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x0a                               }, { vcmpngtss k5{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x0a                               }, { vcmpngtss k5{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x0a                               }, { vcmpngtss k5{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0a }, { vcmpngtss k5{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x0a                         }, { vcmpngtss k5{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0a       }, { vcmpngtss k5{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x0a                         }, { vcmpngtss k5{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0a       }, { vcmpngtss k5{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x0b                               }, { vcmpfalsess k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x0b                               }, { vcmpfalsess k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x0b                               }, { vcmpfalsess k5{k7},xmm29,DWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0b }, { vcmpfalsess k5{k7},xmm29,DWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x0b                         }, { vcmpfalsess k5{k7},xmm29,DWORD [rdx+0x1fc]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0b       }, { vcmpfalsess k5{k7},xmm29,DWORD [rdx+0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x0b                         }, { vcmpfalsess k5{k7},xmm29,DWORD [rdx-0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0b       }, { vcmpfalsess k5{k7},xmm29,DWORD [rdx-0x204]                   }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x0b                               }, { vcmpfalsess k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x0b                               }, { vcmpfalsess k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x0b                               }, { vcmpfalsess k5{k7},xmm29,DWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0b }, { vcmpfalsess k5{k7},xmm29,DWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x0b                         }, { vcmpfalsess k5{k7},xmm29,DWORD [rdx+0x1fc]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0b       }, { vcmpfalsess k5{k7},xmm29,DWORD [rdx+0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x0b                         }, { vcmpfalsess k5{k7},xmm29,DWORD [rdx-0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0b       }, { vcmpfalsess k5{k7},xmm29,DWORD [rdx-0x204]                   }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x0c                               }, { vcmpneq_oqss k5{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x0c                               }, { vcmpneq_oqss k5{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x0c                               }, { vcmpneq_oqss k5{k7},xmm29,DWORD [rcx]                        }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0c }, { vcmpneq_oqss k5{k7},xmm29,DWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x0c                         }, { vcmpneq_oqss k5{k7},xmm29,DWORD [rdx+0x1fc]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0c       }, { vcmpneq_oqss k5{k7},xmm29,DWORD [rdx+0x200]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x0c                         }, { vcmpneq_oqss k5{k7},xmm29,DWORD [rdx-0x200]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0c       }, { vcmpneq_oqss k5{k7},xmm29,DWORD [rdx-0x204]                  }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x0d                               }, { vcmpgess k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x0d                               }, { vcmpgess k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x0d                               }, { vcmpgess k5{k7},xmm29,DWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0d }, { vcmpgess k5{k7},xmm29,DWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x0d                         }, { vcmpgess k5{k7},xmm29,DWORD [rdx+0x1fc]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0d       }, { vcmpgess k5{k7},xmm29,DWORD [rdx+0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x0d                         }, { vcmpgess k5{k7},xmm29,DWORD [rdx-0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0d       }, { vcmpgess k5{k7},xmm29,DWORD [rdx-0x204]                      }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x0d                               }, { vcmpgess k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x0d                               }, { vcmpgess k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x0d                               }, { vcmpgess k5{k7},xmm29,DWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0d }, { vcmpgess k5{k7},xmm29,DWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x0d                         }, { vcmpgess k5{k7},xmm29,DWORD [rdx+0x1fc]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0d       }, { vcmpgess k5{k7},xmm29,DWORD [rdx+0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x0d                         }, { vcmpgess k5{k7},xmm29,DWORD [rdx-0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0d       }, { vcmpgess k5{k7},xmm29,DWORD [rdx-0x204]                      }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x0e                               }, { vcmpgtss k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x0e                               }, { vcmpgtss k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x0e                               }, { vcmpgtss k5{k7},xmm29,DWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0e }, { vcmpgtss k5{k7},xmm29,DWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x0e                         }, { vcmpgtss k5{k7},xmm29,DWORD [rdx+0x1fc]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0e       }, { vcmpgtss k5{k7},xmm29,DWORD [rdx+0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x0e                         }, { vcmpgtss k5{k7},xmm29,DWORD [rdx-0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0e       }, { vcmpgtss k5{k7},xmm29,DWORD [rdx-0x204]                      }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x0e                               }, { vcmpgtss k5{k7},xmm29,xmm28                                  }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x0e                               }, { vcmpgtss k5{k7},xmm29,xmm28,{sae}                            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x0e                               }, { vcmpgtss k5{k7},xmm29,DWORD [rcx]                            }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0e }, { vcmpgtss k5{k7},xmm29,DWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x0e                         }, { vcmpgtss k5{k7},xmm29,DWORD [rdx+0x1fc]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0e       }, { vcmpgtss k5{k7},xmm29,DWORD [rdx+0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x0e                         }, { vcmpgtss k5{k7},xmm29,DWORD [rdx-0x200]                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0e       }, { vcmpgtss k5{k7},xmm29,DWORD [rdx-0x204]                      }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x0f                               }, { vcmptruess k5{k7},xmm29,xmm28                                }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x0f                               }, { vcmptruess k5{k7},xmm29,xmm28,{sae}                          }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x0f                               }, { vcmptruess k5{k7},xmm29,DWORD [rcx]                          }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0f }, { vcmptruess k5{k7},xmm29,DWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x0f                         }, { vcmptruess k5{k7},xmm29,DWORD [rdx+0x1fc]                    }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0f       }, { vcmptruess k5{k7},xmm29,DWORD [rdx+0x200]                    }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x0f                         }, { vcmptruess k5{k7},xmm29,DWORD [rdx-0x200]                    }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0f       }, { vcmptruess k5{k7},xmm29,DWORD [rdx-0x204]                    }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x0f                               }, { vcmptruess k5{k7},xmm29,xmm28                                }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x0f                               }, { vcmptruess k5{k7},xmm29,xmm28,{sae}                          }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x0f                               }, { vcmptruess k5{k7},xmm29,DWORD [rcx]                          }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x0f }, { vcmptruess k5{k7},xmm29,DWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x0f                         }, { vcmptruess k5{k7},xmm29,DWORD [rdx+0x1fc]                    }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x0f       }, { vcmptruess k5{k7},xmm29,DWORD [rdx+0x200]                    }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x0f                         }, { vcmptruess k5{k7},xmm29,DWORD [rdx-0x200]                    }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x0f       }, { vcmptruess k5{k7},xmm29,DWORD [rdx-0x204]                    }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x10                               }, { vcmpeq_osss k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x10                               }, { vcmpeq_osss k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x10                               }, { vcmpeq_osss k5{k7},xmm29,DWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x10 }, { vcmpeq_osss k5{k7},xmm29,DWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x10                         }, { vcmpeq_osss k5{k7},xmm29,DWORD [rdx+0x1fc]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x10       }, { vcmpeq_osss k5{k7},xmm29,DWORD [rdx+0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x10                         }, { vcmpeq_osss k5{k7},xmm29,DWORD [rdx-0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x10       }, { vcmpeq_osss k5{k7},xmm29,DWORD [rdx-0x204]                   }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x11                               }, { vcmplt_oqss k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x11                               }, { vcmplt_oqss k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x11                               }, { vcmplt_oqss k5{k7},xmm29,DWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x11 }, { vcmplt_oqss k5{k7},xmm29,DWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x11                         }, { vcmplt_oqss k5{k7},xmm29,DWORD [rdx+0x1fc]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x11       }, { vcmplt_oqss k5{k7},xmm29,DWORD [rdx+0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x11                         }, { vcmplt_oqss k5{k7},xmm29,DWORD [rdx-0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x11       }, { vcmplt_oqss k5{k7},xmm29,DWORD [rdx-0x204]                   }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x12                               }, { vcmple_oqss k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x12                               }, { vcmple_oqss k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x12                               }, { vcmple_oqss k5{k7},xmm29,DWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x12 }, { vcmple_oqss k5{k7},xmm29,DWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x12                         }, { vcmple_oqss k5{k7},xmm29,DWORD [rdx+0x1fc]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x12       }, { vcmple_oqss k5{k7},xmm29,DWORD [rdx+0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x12                         }, { vcmple_oqss k5{k7},xmm29,DWORD [rdx-0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x12       }, { vcmple_oqss k5{k7},xmm29,DWORD [rdx-0x204]                   }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x13                               }, { vcmpunord_sss k5{k7},xmm29,xmm28                             }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x13                               }, { vcmpunord_sss k5{k7},xmm29,xmm28,{sae}                       }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x13                               }, { vcmpunord_sss k5{k7},xmm29,DWORD [rcx]                       }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x13 }, { vcmpunord_sss k5{k7},xmm29,DWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x13                         }, { vcmpunord_sss k5{k7},xmm29,DWORD [rdx+0x1fc]                 }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x13       }, { vcmpunord_sss k5{k7},xmm29,DWORD [rdx+0x200]                 }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x13                         }, { vcmpunord_sss k5{k7},xmm29,DWORD [rdx-0x200]                 }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x13       }, { vcmpunord_sss k5{k7},xmm29,DWORD [rdx-0x204]                 }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x14                               }, { vcmpneq_usss k5{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x14                               }, { vcmpneq_usss k5{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x14                               }, { vcmpneq_usss k5{k7},xmm29,DWORD [rcx]                        }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x14 }, { vcmpneq_usss k5{k7},xmm29,DWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x14                         }, { vcmpneq_usss k5{k7},xmm29,DWORD [rdx+0x1fc]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x14       }, { vcmpneq_usss k5{k7},xmm29,DWORD [rdx+0x200]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x14                         }, { vcmpneq_usss k5{k7},xmm29,DWORD [rdx-0x200]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x14       }, { vcmpneq_usss k5{k7},xmm29,DWORD [rdx-0x204]                  }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x15                               }, { vcmpnlt_uqss k5{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x15                               }, { vcmpnlt_uqss k5{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x15                               }, { vcmpnlt_uqss k5{k7},xmm29,DWORD [rcx]                        }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x15 }, { vcmpnlt_uqss k5{k7},xmm29,DWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x15                         }, { vcmpnlt_uqss k5{k7},xmm29,DWORD [rdx+0x1fc]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x15       }, { vcmpnlt_uqss k5{k7},xmm29,DWORD [rdx+0x200]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x15                         }, { vcmpnlt_uqss k5{k7},xmm29,DWORD [rdx-0x200]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x15       }, { vcmpnlt_uqss k5{k7},xmm29,DWORD [rdx-0x204]                  }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x16                               }, { vcmpnle_uqss k5{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x16                               }, { vcmpnle_uqss k5{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x16                               }, { vcmpnle_uqss k5{k7},xmm29,DWORD [rcx]                        }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x16 }, { vcmpnle_uqss k5{k7},xmm29,DWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x16                         }, { vcmpnle_uqss k5{k7},xmm29,DWORD [rdx+0x1fc]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x16       }, { vcmpnle_uqss k5{k7},xmm29,DWORD [rdx+0x200]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x16                         }, { vcmpnle_uqss k5{k7},xmm29,DWORD [rdx-0x200]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x16       }, { vcmpnle_uqss k5{k7},xmm29,DWORD [rdx-0x204]                  }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x17                               }, { vcmpord_sss k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x17                               }, { vcmpord_sss k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x17                               }, { vcmpord_sss k5{k7},xmm29,DWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x17 }, { vcmpord_sss k5{k7},xmm29,DWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x17                         }, { vcmpord_sss k5{k7},xmm29,DWORD [rdx+0x1fc]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x17       }, { vcmpord_sss k5{k7},xmm29,DWORD [rdx+0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x17                         }, { vcmpord_sss k5{k7},xmm29,DWORD [rdx-0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x17       }, { vcmpord_sss k5{k7},xmm29,DWORD [rdx-0x204]                   }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x18                               }, { vcmpeq_usss k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x18                               }, { vcmpeq_usss k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x18                               }, { vcmpeq_usss k5{k7},xmm29,DWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x18 }, { vcmpeq_usss k5{k7},xmm29,DWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x18                         }, { vcmpeq_usss k5{k7},xmm29,DWORD [rdx+0x1fc]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x18       }, { vcmpeq_usss k5{k7},xmm29,DWORD [rdx+0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x18                         }, { vcmpeq_usss k5{k7},xmm29,DWORD [rdx-0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x18       }, { vcmpeq_usss k5{k7},xmm29,DWORD [rdx-0x204]                   }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x19                               }, { vcmpnge_uqss k5{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x19                               }, { vcmpnge_uqss k5{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x19                               }, { vcmpnge_uqss k5{k7},xmm29,DWORD [rcx]                        }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x19 }, { vcmpnge_uqss k5{k7},xmm29,DWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x19                         }, { vcmpnge_uqss k5{k7},xmm29,DWORD [rdx+0x1fc]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x19       }, { vcmpnge_uqss k5{k7},xmm29,DWORD [rdx+0x200]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x19                         }, { vcmpnge_uqss k5{k7},xmm29,DWORD [rdx-0x200]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x19       }, { vcmpnge_uqss k5{k7},xmm29,DWORD [rdx-0x204]                  }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x1a                               }, { vcmpngt_uqss k5{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x1a                               }, { vcmpngt_uqss k5{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x1a                               }, { vcmpngt_uqss k5{k7},xmm29,DWORD [rcx]                        }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1a }, { vcmpngt_uqss k5{k7},xmm29,DWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x1a                         }, { vcmpngt_uqss k5{k7},xmm29,DWORD [rdx+0x1fc]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x1a       }, { vcmpngt_uqss k5{k7},xmm29,DWORD [rdx+0x200]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x1a                         }, { vcmpngt_uqss k5{k7},xmm29,DWORD [rdx-0x200]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x1a       }, { vcmpngt_uqss k5{k7},xmm29,DWORD [rdx-0x204]                  }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x1b                               }, { vcmpfalse_osss k5{k7},xmm29,xmm28                            }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x1b                               }, { vcmpfalse_osss k5{k7},xmm29,xmm28,{sae}                      }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x1b                               }, { vcmpfalse_osss k5{k7},xmm29,DWORD [rcx]                      }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1b }, { vcmpfalse_osss k5{k7},xmm29,DWORD [rax+r14*8+0x123]          }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x1b                         }, { vcmpfalse_osss k5{k7},xmm29,DWORD [rdx+0x1fc]                }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x1b       }, { vcmpfalse_osss k5{k7},xmm29,DWORD [rdx+0x200]                }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x1b                         }, { vcmpfalse_osss k5{k7},xmm29,DWORD [rdx-0x200]                }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x1b       }, { vcmpfalse_osss k5{k7},xmm29,DWORD [rdx-0x204]                }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x1c                               }, { vcmpneq_osss k5{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x1c                               }, { vcmpneq_osss k5{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x1c                               }, { vcmpneq_osss k5{k7},xmm29,DWORD [rcx]                        }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1c }, { vcmpneq_osss k5{k7},xmm29,DWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x1c                         }, { vcmpneq_osss k5{k7},xmm29,DWORD [rdx+0x1fc]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x1c       }, { vcmpneq_osss k5{k7},xmm29,DWORD [rdx+0x200]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x1c                         }, { vcmpneq_osss k5{k7},xmm29,DWORD [rdx-0x200]                  }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x1c       }, { vcmpneq_osss k5{k7},xmm29,DWORD [rdx-0x204]                  }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x1d                               }, { vcmpge_oqss k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x1d                               }, { vcmpge_oqss k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x1d                               }, { vcmpge_oqss k5{k7},xmm29,DWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1d }, { vcmpge_oqss k5{k7},xmm29,DWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x1d                         }, { vcmpge_oqss k5{k7},xmm29,DWORD [rdx+0x1fc]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x1d       }, { vcmpge_oqss k5{k7},xmm29,DWORD [rdx+0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x1d                         }, { vcmpge_oqss k5{k7},xmm29,DWORD [rdx-0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x1d       }, { vcmpge_oqss k5{k7},xmm29,DWORD [rdx-0x204]                   }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x1e                               }, { vcmpgt_oqss k5{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x1e                               }, { vcmpgt_oqss k5{k7},xmm29,xmm28,{sae}                         }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x1e                               }, { vcmpgt_oqss k5{k7},xmm29,DWORD [rcx]                         }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1e }, { vcmpgt_oqss k5{k7},xmm29,DWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x1e                         }, { vcmpgt_oqss k5{k7},xmm29,DWORD [rdx+0x1fc]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x1e       }, { vcmpgt_oqss k5{k7},xmm29,DWORD [rdx+0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x1e                         }, { vcmpgt_oqss k5{k7},xmm29,DWORD [rdx-0x200]                   }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x1e       }, { vcmpgt_oqss k5{k7},xmm29,DWORD [rdx-0x204]                   }
testcase	{ 0x62, 0x91, 0x16, 0x07, 0xc2, 0xec, 0x1f                               }, { vcmptrue_usss k5{k7},xmm29,xmm28                             }
testcase	{ 0x62, 0x91, 0x16, 0x17, 0xc2, 0xec, 0x1f                               }, { vcmptrue_usss k5{k7},xmm29,xmm28,{sae}                       }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x29, 0x1f                               }, { vcmptrue_usss k5{k7},xmm29,DWORD [rcx]                       }
testcase	{ 0x62, 0xb1, 0x16, 0x07, 0xc2, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x1f }, { vcmptrue_usss k5{k7},xmm29,DWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x7f, 0x1f                         }, { vcmptrue_usss k5{k7},xmm29,DWORD [rdx+0x1fc]                 }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x1f       }, { vcmptrue_usss k5{k7},xmm29,DWORD [rdx+0x200]                 }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0x6a, 0x80, 0x1f                         }, { vcmptrue_usss k5{k7},xmm29,DWORD [rdx-0x200]                 }
testcase	{ 0x62, 0xf1, 0x16, 0x07, 0xc2, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x1f       }, { vcmptrue_usss k5{k7},xmm29,DWORD [rdx-0x204]                 }
testcase	{ 0x62, 0x01, 0xfd, 0x08, 0x2f, 0xf5                                     }, { vcomisd xmm30,xmm29                                          }
testcase	{ 0x62, 0x01, 0xfd, 0x18, 0x2f, 0xf5                                     }, { vcomisd xmm30,xmm29,{sae}                                    }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x2f, 0x31                                     }, { vcomisd xmm30,QWORD [rcx]                                    }
testcase	{ 0x62, 0x21, 0xfd, 0x08, 0x2f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcomisd xmm30,QWORD [rax+r14*8+0x123]                        }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x2f, 0x72, 0x7f                               }, { vcomisd xmm30,QWORD [rdx+0x3f8]                              }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x2f, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vcomisd xmm30,QWORD [rdx+0x400]                              }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x2f, 0x72, 0x80                               }, { vcomisd xmm30,QWORD [rdx-0x400]                              }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x2f, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vcomisd xmm30,QWORD [rdx-0x408]                              }
testcase	{ 0x62, 0x01, 0x7c, 0x08, 0x2f, 0xf5                                     }, { vcomiss xmm30,xmm29                                          }
testcase	{ 0x62, 0x01, 0x7c, 0x18, 0x2f, 0xf5                                     }, { vcomiss xmm30,xmm29,{sae}                                    }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x2f, 0x31                                     }, { vcomiss xmm30,DWORD [rcx]                                    }
testcase	{ 0x62, 0x21, 0x7c, 0x08, 0x2f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcomiss xmm30,DWORD [rax+r14*8+0x123]                        }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x2f, 0x72, 0x7f                               }, { vcomiss xmm30,DWORD [rdx+0x1fc]                              }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x2f, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcomiss xmm30,DWORD [rdx+0x200]                              }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x2f, 0x72, 0x80                               }, { vcomiss xmm30,DWORD [rdx-0x200]                              }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x2f, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcomiss xmm30,DWORD [rdx-0x204]                              }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x8a, 0x31                                     }, { vcompresspd ZWORD [rcx],zmm30                                }
testcase	{ 0x62, 0x62, 0xfd, 0x4f, 0x8a, 0x31                                     }, { vcompresspd ZWORD [rcx]{k7},zmm30                            }
testcase	{ 0x62, 0x22, 0xfd, 0x48, 0x8a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcompresspd ZWORD [rax+r14*8+0x123],zmm30                    }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x8a, 0x72, 0x7f                               }, { vcompresspd ZWORD [rdx+0x3f8],zmm30                          }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x8a, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vcompresspd ZWORD [rdx+0x400],zmm30                          }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x8a, 0x72, 0x80                               }, { vcompresspd ZWORD [rdx-0x400],zmm30                          }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x8a, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vcompresspd ZWORD [rdx-0x408],zmm30                          }
testcase	{ 0x62, 0x02, 0xfd, 0x48, 0x8a, 0xee                                     }, { vcompresspd zmm30,zmm29                                      }
testcase	{ 0x62, 0x02, 0xfd, 0x4f, 0x8a, 0xee                                     }, { vcompresspd zmm30{k7},zmm29                                  }
testcase	{ 0x62, 0x02, 0xfd, 0xcf, 0x8a, 0xee                                     }, { vcompresspd zmm30{k7}{z},zmm29                               }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x8a, 0x31                                     }, { vcompressps ZWORD [rcx],zmm30                                }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x8a, 0x31                                     }, { vcompressps ZWORD [rcx]{k7},zmm30                            }
testcase	{ 0x62, 0x22, 0x7d, 0x48, 0x8a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcompressps ZWORD [rax+r14*8+0x123],zmm30                    }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x8a, 0x72, 0x7f                               }, { vcompressps ZWORD [rdx+0x1fc],zmm30                          }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x8a, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcompressps ZWORD [rdx+0x200],zmm30                          }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x8a, 0x72, 0x80                               }, { vcompressps ZWORD [rdx-0x200],zmm30                          }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x8a, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcompressps ZWORD [rdx-0x204],zmm30                          }
testcase	{ 0x62, 0x02, 0x7d, 0x48, 0x8a, 0xee                                     }, { vcompressps zmm30,zmm29                                      }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x8a, 0xee                                     }, { vcompressps zmm30{k7},zmm29                                  }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x8a, 0xee                                     }, { vcompressps zmm30{k7}{z},zmm29                               }
testcase	{ 0x62, 0x01, 0x7e, 0x4f, 0xe6, 0xf5                                     }, { vcvtdq2pd zmm30{k7},ymm29                                    }
testcase	{ 0x62, 0x01, 0x7e, 0xcf, 0xe6, 0xf5                                     }, { vcvtdq2pd zmm30{k7}{z},ymm29                                 }
testcase	{ 0x62, 0x61, 0x7e, 0x4f, 0xe6, 0x31                                     }, { vcvtdq2pd zmm30{k7},YWORD [rcx]                              }
testcase	{ 0x62, 0x21, 0x7e, 0x4f, 0xe6, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtdq2pd zmm30{k7},YWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x61, 0x7e, 0x5f, 0xe6, 0x31                                     }, { vcvtdq2pd zmm30{k7},DWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x61, 0x7e, 0x4f, 0xe6, 0x72, 0x7f                               }, { vcvtdq2pd zmm30{k7},YWORD [rdx+0xfe0]                        }
testcase	{ 0x62, 0x61, 0x7e, 0x4f, 0xe6, 0xb2, 0x00, 0x10, 0x00, 0x00             }, { vcvtdq2pd zmm30{k7},YWORD [rdx+0x1000]                       }
testcase	{ 0x62, 0x61, 0x7e, 0x4f, 0xe6, 0x72, 0x80                               }, { vcvtdq2pd zmm30{k7},YWORD [rdx-0x1000]                       }
testcase	{ 0x62, 0x61, 0x7e, 0x4f, 0xe6, 0xb2, 0xe0, 0xef, 0xff, 0xff             }, { vcvtdq2pd zmm30{k7},YWORD [rdx-0x1020]                       }
testcase	{ 0x62, 0x61, 0x7e, 0x5f, 0xe6, 0x72, 0x7f                               }, { vcvtdq2pd zmm30{k7},DWORD [rdx+0x1fc]{1to8}                  }
testcase	{ 0x62, 0x61, 0x7e, 0x5f, 0xe6, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcvtdq2pd zmm30{k7},DWORD [rdx+0x200]{1to8}                  }
testcase	{ 0x62, 0x61, 0x7e, 0x5f, 0xe6, 0x72, 0x80                               }, { vcvtdq2pd zmm30{k7},DWORD [rdx-0x200]{1to8}                  }
testcase	{ 0x62, 0x61, 0x7e, 0x5f, 0xe6, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtdq2pd zmm30{k7},DWORD [rdx-0x204]{1to8}                  }
testcase	{ 0x62, 0x01, 0x7c, 0x48, 0x5b, 0xf5                                     }, { vcvtdq2ps zmm30,zmm29                                        }
testcase	{ 0x62, 0x01, 0x7c, 0x4f, 0x5b, 0xf5                                     }, { vcvtdq2ps zmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x01, 0x7c, 0xcf, 0x5b, 0xf5                                     }, { vcvtdq2ps zmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x01, 0x7c, 0x18, 0x5b, 0xf5                                     }, { vcvtdq2ps zmm30,zmm29,{rn-sae}                               }
testcase	{ 0x62, 0x01, 0x7c, 0x58, 0x5b, 0xf5                                     }, { vcvtdq2ps zmm30,zmm29,{ru-sae}                               }
testcase	{ 0x62, 0x01, 0x7c, 0x38, 0x5b, 0xf5                                     }, { vcvtdq2ps zmm30,zmm29,{rd-sae}                               }
testcase	{ 0x62, 0x01, 0x7c, 0x78, 0x5b, 0xf5                                     }, { vcvtdq2ps zmm30,zmm29,{rz-sae}                               }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x5b, 0x31                                     }, { vcvtdq2ps zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x21, 0x7c, 0x48, 0x5b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtdq2ps zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x5b, 0x31                                     }, { vcvtdq2ps zmm30,DWORD [rcx]{1to16}                           }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x5b, 0x72, 0x7f                               }, { vcvtdq2ps zmm30,ZWORD [rdx+0x1fc0]                           }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x5b, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vcvtdq2ps zmm30,ZWORD [rdx+0x2000]                           }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x5b, 0x72, 0x80                               }, { vcvtdq2ps zmm30,ZWORD [rdx-0x2000]                           }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x5b, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vcvtdq2ps zmm30,ZWORD [rdx-0x2040]                           }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x5b, 0x72, 0x7f                               }, { vcvtdq2ps zmm30,DWORD [rdx+0x1fc]{1to16}                     }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x5b, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcvtdq2ps zmm30,DWORD [rdx+0x200]{1to16}                     }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x5b, 0x72, 0x80                               }, { vcvtdq2ps zmm30,DWORD [rdx-0x200]{1to16}                     }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x5b, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtdq2ps zmm30,DWORD [rdx-0x204]{1to16}                     }
testcase	{ 0x62, 0x01, 0xff, 0x4f, 0xe6, 0xf5                                     }, { vcvtpd2dq ymm30{k7},zmm29                                    }
testcase	{ 0x62, 0x01, 0xff, 0xcf, 0xe6, 0xf5                                     }, { vcvtpd2dq ymm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x01, 0xff, 0x1f, 0xe6, 0xf5                                     }, { vcvtpd2dq ymm30{k7},zmm29,{rn-sae}                           }
testcase	{ 0x62, 0x01, 0xff, 0x5f, 0xe6, 0xf5                                     }, { vcvtpd2dq ymm30{k7},zmm29,{ru-sae}                           }
testcase	{ 0x62, 0x01, 0xff, 0x3f, 0xe6, 0xf5                                     }, { vcvtpd2dq ymm30{k7},zmm29,{rd-sae}                           }
testcase	{ 0x62, 0x01, 0xff, 0x7f, 0xe6, 0xf5                                     }, { vcvtpd2dq ymm30{k7},zmm29,{rz-sae}                           }
testcase	{ 0x62, 0x61, 0xff, 0x4f, 0xe6, 0x31                                     }, { vcvtpd2dq ymm30{k7},ZWORD [rcx]                              }
testcase	{ 0x62, 0x21, 0xff, 0x4f, 0xe6, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtpd2dq ymm30{k7},ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x61, 0xff, 0x5f, 0xe6, 0x31                                     }, { vcvtpd2dq ymm30{k7},QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x61, 0xff, 0x4f, 0xe6, 0x72, 0x7f                               }, { vcvtpd2dq ymm30{k7},ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x61, 0xff, 0x4f, 0xe6, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vcvtpd2dq ymm30{k7},ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x61, 0xff, 0x4f, 0xe6, 0x72, 0x80                               }, { vcvtpd2dq ymm30{k7},ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x61, 0xff, 0x4f, 0xe6, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vcvtpd2dq ymm30{k7},ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x61, 0xff, 0x5f, 0xe6, 0x72, 0x7f                               }, { vcvtpd2dq ymm30{k7},QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0x61, 0xff, 0x5f, 0xe6, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vcvtpd2dq ymm30{k7},QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0x61, 0xff, 0x5f, 0xe6, 0x72, 0x80                               }, { vcvtpd2dq ymm30{k7},QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0x61, 0xff, 0x5f, 0xe6, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vcvtpd2dq ymm30{k7},QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x01, 0xfd, 0x4f, 0x5a, 0xf5                                     }, { vcvtpd2ps ymm30{k7},zmm29                                    }
testcase	{ 0x62, 0x01, 0xfd, 0xcf, 0x5a, 0xf5                                     }, { vcvtpd2ps ymm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x01, 0xfd, 0x1f, 0x5a, 0xf5                                     }, { vcvtpd2ps ymm30{k7},zmm29,{rn-sae}                           }
testcase	{ 0x62, 0x01, 0xfd, 0x5f, 0x5a, 0xf5                                     }, { vcvtpd2ps ymm30{k7},zmm29,{ru-sae}                           }
testcase	{ 0x62, 0x01, 0xfd, 0x3f, 0x5a, 0xf5                                     }, { vcvtpd2ps ymm30{k7},zmm29,{rd-sae}                           }
testcase	{ 0x62, 0x01, 0xfd, 0x7f, 0x5a, 0xf5                                     }, { vcvtpd2ps ymm30{k7},zmm29,{rz-sae}                           }
testcase	{ 0x62, 0x61, 0xfd, 0x4f, 0x5a, 0x31                                     }, { vcvtpd2ps ymm30{k7},ZWORD [rcx]                              }
testcase	{ 0x62, 0x21, 0xfd, 0x4f, 0x5a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtpd2ps ymm30{k7},ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x61, 0xfd, 0x5f, 0x5a, 0x31                                     }, { vcvtpd2ps ymm30{k7},QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x61, 0xfd, 0x4f, 0x5a, 0x72, 0x7f                               }, { vcvtpd2ps ymm30{k7},ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x61, 0xfd, 0x4f, 0x5a, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vcvtpd2ps ymm30{k7},ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x61, 0xfd, 0x4f, 0x5a, 0x72, 0x80                               }, { vcvtpd2ps ymm30{k7},ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x61, 0xfd, 0x4f, 0x5a, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vcvtpd2ps ymm30{k7},ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x61, 0xfd, 0x5f, 0x5a, 0x72, 0x7f                               }, { vcvtpd2ps ymm30{k7},QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0x61, 0xfd, 0x5f, 0x5a, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vcvtpd2ps ymm30{k7},QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0x61, 0xfd, 0x5f, 0x5a, 0x72, 0x80                               }, { vcvtpd2ps ymm30{k7},QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0x61, 0xfd, 0x5f, 0x5a, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vcvtpd2ps ymm30{k7},QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x01, 0xfc, 0x4f, 0x79, 0xf5                                     }, { vcvtpd2udq ymm30{k7},zmm29                                   }
testcase	{ 0x62, 0x01, 0xfc, 0xcf, 0x79, 0xf5                                     }, { vcvtpd2udq ymm30{k7}{z},zmm29                                }
testcase	{ 0x62, 0x01, 0xfc, 0x1f, 0x79, 0xf5                                     }, { vcvtpd2udq ymm30{k7},zmm29,{rn-sae}                          }
testcase	{ 0x62, 0x01, 0xfc, 0x5f, 0x79, 0xf5                                     }, { vcvtpd2udq ymm30{k7},zmm29,{ru-sae}                          }
testcase	{ 0x62, 0x01, 0xfc, 0x3f, 0x79, 0xf5                                     }, { vcvtpd2udq ymm30{k7},zmm29,{rd-sae}                          }
testcase	{ 0x62, 0x01, 0xfc, 0x7f, 0x79, 0xf5                                     }, { vcvtpd2udq ymm30{k7},zmm29,{rz-sae}                          }
testcase	{ 0x62, 0x61, 0xfc, 0x4f, 0x79, 0x31                                     }, { vcvtpd2udq ymm30{k7},ZWORD [rcx]                             }
testcase	{ 0x62, 0x21, 0xfc, 0x4f, 0x79, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtpd2udq ymm30{k7},ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0x61, 0xfc, 0x5f, 0x79, 0x31                                     }, { vcvtpd2udq ymm30{k7},QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0x61, 0xfc, 0x4f, 0x79, 0x72, 0x7f                               }, { vcvtpd2udq ymm30{k7},ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0x61, 0xfc, 0x4f, 0x79, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vcvtpd2udq ymm30{k7},ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0x61, 0xfc, 0x4f, 0x79, 0x72, 0x80                               }, { vcvtpd2udq ymm30{k7},ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0x61, 0xfc, 0x4f, 0x79, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vcvtpd2udq ymm30{k7},ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0x61, 0xfc, 0x5f, 0x79, 0x72, 0x7f                               }, { vcvtpd2udq ymm30{k7},QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0x61, 0xfc, 0x5f, 0x79, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vcvtpd2udq ymm30{k7},QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0x61, 0xfc, 0x5f, 0x79, 0x72, 0x80                               }, { vcvtpd2udq ymm30{k7},QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0x61, 0xfc, 0x5f, 0x79, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vcvtpd2udq ymm30{k7},QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x13, 0xf5                                     }, { vcvtph2ps zmm30{k7},ymm29                                    }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x13, 0xf5                                     }, { vcvtph2ps zmm30{k7}{z},ymm29                                 }
testcase	{ 0x62, 0x02, 0x7d, 0x1f, 0x13, 0xf5                                     }, { vcvtph2ps zmm30{k7},ymm29,{sae}                              }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x13, 0x31                                     }, { vcvtph2ps zmm30{k7},YWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x7d, 0x4f, 0x13, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtph2ps zmm30{k7},YWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x13, 0x72, 0x7f                               }, { vcvtph2ps zmm30{k7},YWORD [rdx+0xfe0]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x13, 0xb2, 0x00, 0x10, 0x00, 0x00             }, { vcvtph2ps zmm30{k7},YWORD [rdx+0x1000]                       }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x13, 0x72, 0x80                               }, { vcvtph2ps zmm30{k7},YWORD [rdx-0x1000]                       }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x13, 0xb2, 0xe0, 0xef, 0xff, 0xff             }, { vcvtph2ps zmm30{k7},YWORD [rdx-0x1020]                       }
testcase	{ 0x62, 0x01, 0x7d, 0x48, 0x5b, 0xf5                                     }, { vcvtps2dq zmm30,zmm29                                        }
testcase	{ 0x62, 0x01, 0x7d, 0x4f, 0x5b, 0xf5                                     }, { vcvtps2dq zmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x01, 0x7d, 0xcf, 0x5b, 0xf5                                     }, { vcvtps2dq zmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x01, 0x7d, 0x18, 0x5b, 0xf5                                     }, { vcvtps2dq zmm30,zmm29,{rn-sae}                               }
testcase	{ 0x62, 0x01, 0x7d, 0x58, 0x5b, 0xf5                                     }, { vcvtps2dq zmm30,zmm29,{ru-sae}                               }
testcase	{ 0x62, 0x01, 0x7d, 0x38, 0x5b, 0xf5                                     }, { vcvtps2dq zmm30,zmm29,{rd-sae}                               }
testcase	{ 0x62, 0x01, 0x7d, 0x78, 0x5b, 0xf5                                     }, { vcvtps2dq zmm30,zmm29,{rz-sae}                               }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x5b, 0x31                                     }, { vcvtps2dq zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x21, 0x7d, 0x48, 0x5b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtps2dq zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x61, 0x7d, 0x58, 0x5b, 0x31                                     }, { vcvtps2dq zmm30,DWORD [rcx]{1to16}                           }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x5b, 0x72, 0x7f                               }, { vcvtps2dq zmm30,ZWORD [rdx+0x1fc0]                           }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x5b, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vcvtps2dq zmm30,ZWORD [rdx+0x2000]                           }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x5b, 0x72, 0x80                               }, { vcvtps2dq zmm30,ZWORD [rdx-0x2000]                           }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x5b, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vcvtps2dq zmm30,ZWORD [rdx-0x2040]                           }
testcase	{ 0x62, 0x61, 0x7d, 0x58, 0x5b, 0x72, 0x7f                               }, { vcvtps2dq zmm30,DWORD [rdx+0x1fc]{1to16}                     }
testcase	{ 0x62, 0x61, 0x7d, 0x58, 0x5b, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcvtps2dq zmm30,DWORD [rdx+0x200]{1to16}                     }
testcase	{ 0x62, 0x61, 0x7d, 0x58, 0x5b, 0x72, 0x80                               }, { vcvtps2dq zmm30,DWORD [rdx-0x200]{1to16}                     }
testcase	{ 0x62, 0x61, 0x7d, 0x58, 0x5b, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtps2dq zmm30,DWORD [rdx-0x204]{1to16}                     }
testcase	{ 0x62, 0x01, 0x7c, 0x4f, 0x5a, 0xf5                                     }, { vcvtps2pd zmm30{k7},ymm29                                    }
testcase	{ 0x62, 0x01, 0x7c, 0xcf, 0x5a, 0xf5                                     }, { vcvtps2pd zmm30{k7}{z},ymm29                                 }
testcase	{ 0x62, 0x01, 0x7c, 0x1f, 0x5a, 0xf5                                     }, { vcvtps2pd zmm30{k7},ymm29,{sae}                              }
testcase	{ 0x62, 0x61, 0x7c, 0x4f, 0x5a, 0x31                                     }, { vcvtps2pd zmm30{k7},YWORD [rcx]                              }
testcase	{ 0x62, 0x21, 0x7c, 0x4f, 0x5a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtps2pd zmm30{k7},YWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x61, 0x7c, 0x5f, 0x5a, 0x31                                     }, { vcvtps2pd zmm30{k7},DWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x61, 0x7c, 0x4f, 0x5a, 0x72, 0x7f                               }, { vcvtps2pd zmm30{k7},YWORD [rdx+0xfe0]                        }
testcase	{ 0x62, 0x61, 0x7c, 0x4f, 0x5a, 0xb2, 0x00, 0x10, 0x00, 0x00             }, { vcvtps2pd zmm30{k7},YWORD [rdx+0x1000]                       }
testcase	{ 0x62, 0x61, 0x7c, 0x4f, 0x5a, 0x72, 0x80                               }, { vcvtps2pd zmm30{k7},YWORD [rdx-0x1000]                       }
testcase	{ 0x62, 0x61, 0x7c, 0x4f, 0x5a, 0xb2, 0xe0, 0xef, 0xff, 0xff             }, { vcvtps2pd zmm30{k7},YWORD [rdx-0x1020]                       }
testcase	{ 0x62, 0x61, 0x7c, 0x5f, 0x5a, 0x72, 0x7f                               }, { vcvtps2pd zmm30{k7},DWORD [rdx+0x1fc]{1to8}                  }
testcase	{ 0x62, 0x61, 0x7c, 0x5f, 0x5a, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcvtps2pd zmm30{k7},DWORD [rdx+0x200]{1to8}                  }
testcase	{ 0x62, 0x61, 0x7c, 0x5f, 0x5a, 0x72, 0x80                               }, { vcvtps2pd zmm30{k7},DWORD [rdx-0x200]{1to8}                  }
testcase	{ 0x62, 0x61, 0x7c, 0x5f, 0x5a, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtps2pd zmm30{k7},DWORD [rdx-0x204]{1to8}                  }
testcase	{ 0x62, 0x03, 0x7d, 0x4f, 0x1d, 0xee, 0xab                               }, { vcvtps2ph ymm30{k7},zmm29,0xab                               }
testcase	{ 0x62, 0x03, 0x7d, 0xcf, 0x1d, 0xee, 0xab                               }, { vcvtps2ph ymm30{k7}{z},zmm29,0xab                            }
testcase	{ 0x62, 0x03, 0x7d, 0x1f, 0x1d, 0xee, 0xab                               }, { vcvtps2ph ymm30{k7},zmm29,{sae},0xab                         }
testcase	{ 0x62, 0x03, 0x7d, 0x4f, 0x1d, 0xee, 0x7b                               }, { vcvtps2ph ymm30{k7},zmm29,0x7b                               }
testcase	{ 0x62, 0x03, 0x7d, 0x1f, 0x1d, 0xee, 0x7b                               }, { vcvtps2ph ymm30{k7},zmm29,{sae},0x7b                         }
testcase	{ 0x62, 0x01, 0x7c, 0x48, 0x79, 0xf5                                     }, { vcvtps2udq zmm30,zmm29                                       }
testcase	{ 0x62, 0x01, 0x7c, 0x4f, 0x79, 0xf5                                     }, { vcvtps2udq zmm30{k7},zmm29                                   }
testcase	{ 0x62, 0x01, 0x7c, 0xcf, 0x79, 0xf5                                     }, { vcvtps2udq zmm30{k7}{z},zmm29                                }
testcase	{ 0x62, 0x01, 0x7c, 0x18, 0x79, 0xf5                                     }, { vcvtps2udq zmm30,zmm29,{rn-sae}                              }
testcase	{ 0x62, 0x01, 0x7c, 0x58, 0x79, 0xf5                                     }, { vcvtps2udq zmm30,zmm29,{ru-sae}                              }
testcase	{ 0x62, 0x01, 0x7c, 0x38, 0x79, 0xf5                                     }, { vcvtps2udq zmm30,zmm29,{rd-sae}                              }
testcase	{ 0x62, 0x01, 0x7c, 0x78, 0x79, 0xf5                                     }, { vcvtps2udq zmm30,zmm29,{rz-sae}                              }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x79, 0x31                                     }, { vcvtps2udq zmm30,ZWORD [rcx]                                 }
testcase	{ 0x62, 0x21, 0x7c, 0x48, 0x79, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtps2udq zmm30,ZWORD [rax+r14*8+0x123]                     }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x79, 0x31                                     }, { vcvtps2udq zmm30,DWORD [rcx]{1to16}                          }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x79, 0x72, 0x7f                               }, { vcvtps2udq zmm30,ZWORD [rdx+0x1fc0]                          }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x79, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vcvtps2udq zmm30,ZWORD [rdx+0x2000]                          }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x79, 0x72, 0x80                               }, { vcvtps2udq zmm30,ZWORD [rdx-0x2000]                          }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x79, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vcvtps2udq zmm30,ZWORD [rdx-0x2040]                          }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x79, 0x72, 0x7f                               }, { vcvtps2udq zmm30,DWORD [rdx+0x1fc]{1to16}                    }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x79, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcvtps2udq zmm30,DWORD [rdx+0x200]{1to16}                    }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x79, 0x72, 0x80                               }, { vcvtps2udq zmm30,DWORD [rdx-0x200]{1to16}                    }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x79, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtps2udq zmm30,DWORD [rdx-0x204]{1to16}                    }
testcase	{ 0x62, 0x91, 0x7f, 0x18, 0x2d, 0xc6                                     }, { vcvtsd2si eax,xmm30,{rn-sae}                                 }
testcase	{ 0x62, 0x91, 0x7f, 0x58, 0x2d, 0xc6                                     }, { vcvtsd2si eax,xmm30,{ru-sae}                                 }
testcase	{ 0x62, 0x91, 0x7f, 0x38, 0x2d, 0xc6                                     }, { vcvtsd2si eax,xmm30,{rd-sae}                                 }
testcase	{ 0x62, 0x91, 0x7f, 0x78, 0x2d, 0xc6                                     }, { vcvtsd2si eax,xmm30,{rz-sae}                                 }
testcase	{ 0x62, 0x91, 0x7f, 0x18, 0x2d, 0xee                                     }, { vcvtsd2si ebp,xmm30,{rn-sae}                                 }
testcase	{ 0x62, 0x91, 0x7f, 0x58, 0x2d, 0xee                                     }, { vcvtsd2si ebp,xmm30,{ru-sae}                                 }
testcase	{ 0x62, 0x91, 0x7f, 0x38, 0x2d, 0xee                                     }, { vcvtsd2si ebp,xmm30,{rd-sae}                                 }
testcase	{ 0x62, 0x91, 0x7f, 0x78, 0x2d, 0xee                                     }, { vcvtsd2si ebp,xmm30,{rz-sae}                                 }
testcase	{ 0x62, 0x11, 0x7f, 0x18, 0x2d, 0xee                                     }, { vcvtsd2si r13d,xmm30,{rn-sae}                                }
testcase	{ 0x62, 0x11, 0x7f, 0x58, 0x2d, 0xee                                     }, { vcvtsd2si r13d,xmm30,{ru-sae}                                }
testcase	{ 0x62, 0x11, 0x7f, 0x38, 0x2d, 0xee                                     }, { vcvtsd2si r13d,xmm30,{rd-sae}                                }
testcase	{ 0x62, 0x11, 0x7f, 0x78, 0x2d, 0xee                                     }, { vcvtsd2si r13d,xmm30,{rz-sae}                                }
testcase	{ 0x62, 0x91, 0xff, 0x18, 0x2d, 0xc6                                     }, { vcvtsd2si rax,xmm30,{rn-sae}                                 }
testcase	{ 0x62, 0x91, 0xff, 0x58, 0x2d, 0xc6                                     }, { vcvtsd2si rax,xmm30,{ru-sae}                                 }
testcase	{ 0x62, 0x91, 0xff, 0x38, 0x2d, 0xc6                                     }, { vcvtsd2si rax,xmm30,{rd-sae}                                 }
testcase	{ 0x62, 0x91, 0xff, 0x78, 0x2d, 0xc6                                     }, { vcvtsd2si rax,xmm30,{rz-sae}                                 }
testcase	{ 0x62, 0x11, 0xff, 0x18, 0x2d, 0xc6                                     }, { vcvtsd2si r8,xmm30,{rn-sae}                                  }
testcase	{ 0x62, 0x11, 0xff, 0x58, 0x2d, 0xc6                                     }, { vcvtsd2si r8,xmm30,{ru-sae}                                  }
testcase	{ 0x62, 0x11, 0xff, 0x38, 0x2d, 0xc6                                     }, { vcvtsd2si r8,xmm30,{rd-sae}                                  }
testcase	{ 0x62, 0x11, 0xff, 0x78, 0x2d, 0xc6                                     }, { vcvtsd2si r8,xmm30,{rz-sae}                                  }
testcase	{ 0x62, 0x01, 0x97, 0x07, 0x5a, 0xf4                                     }, { vcvtsd2ss xmm30{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x97, 0x87, 0x5a, 0xf4                                     }, { vcvtsd2ss xmm30{k7}{z},xmm29,xmm28                           }
testcase	{ 0x62, 0x01, 0x97, 0x17, 0x5a, 0xf4                                     }, { vcvtsd2ss xmm30{k7},xmm29,xmm28,{rn-sae}                     }
testcase	{ 0x62, 0x01, 0x97, 0x57, 0x5a, 0xf4                                     }, { vcvtsd2ss xmm30{k7},xmm29,xmm28,{ru-sae}                     }
testcase	{ 0x62, 0x01, 0x97, 0x37, 0x5a, 0xf4                                     }, { vcvtsd2ss xmm30{k7},xmm29,xmm28,{rd-sae}                     }
testcase	{ 0x62, 0x01, 0x97, 0x77, 0x5a, 0xf4                                     }, { vcvtsd2ss xmm30{k7},xmm29,xmm28,{rz-sae}                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5a, 0x31                                     }, { vcvtsd2ss xmm30{k7},xmm29,QWORD [rcx]                        }
testcase	{ 0x62, 0x21, 0x97, 0x07, 0x5a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtsd2ss xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5a, 0x72, 0x7f                               }, { vcvtsd2ss xmm30{k7},xmm29,QWORD [rdx+0x3f8]                  }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5a, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vcvtsd2ss xmm30{k7},xmm29,QWORD [rdx+0x400]                  }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5a, 0x72, 0x80                               }, { vcvtsd2ss xmm30{k7},xmm29,QWORD [rdx-0x400]                  }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5a, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vcvtsd2ss xmm30{k7},xmm29,QWORD [rdx-0x408]                  }
testcase	{ 0x62, 0x61, 0x17, 0x00, 0x2a, 0xf0                                     }, { vcvtsi2sd xmm30,xmm29,eax                                    }
testcase	{ 0x62, 0x61, 0x17, 0x00, 0x2a, 0xf5                                     }, { vcvtsi2sd xmm30,xmm29,ebp                                    }
testcase	{ 0x62, 0x41, 0x17, 0x00, 0x2a, 0xf5                                     }, { vcvtsi2sd xmm30,xmm29,r13d                                   }
testcase	{ 0x62, 0x61, 0x17, 0x00, 0x2a, 0x31                                     }, { vcvtsi2sd xmm30,xmm29,DWORD [rcx]                            }
testcase	{ 0x62, 0x21, 0x17, 0x00, 0x2a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtsi2sd xmm30,xmm29,DWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x61, 0x17, 0x00, 0x2a, 0x72, 0x7f                               }, { vcvtsi2sd xmm30,xmm29,DWORD [rdx+0x1fc]                      }
testcase	{ 0x62, 0x61, 0x17, 0x00, 0x2a, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcvtsi2sd xmm30,xmm29,DWORD [rdx+0x200]                      }
testcase	{ 0x62, 0x61, 0x17, 0x00, 0x2a, 0x72, 0x80                               }, { vcvtsi2sd xmm30,xmm29,DWORD [rdx-0x200]                      }
testcase	{ 0x62, 0x61, 0x17, 0x00, 0x2a, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtsi2sd xmm30,xmm29,DWORD [rdx-0x204]                      }
testcase	{ 0x62, 0x61, 0x97, 0x00, 0x2a, 0xf0                                     }, { vcvtsi2sd xmm30,xmm29,rax                                    }
testcase	{ 0x62, 0x61, 0x97, 0x10, 0x2a, 0xf0                                     }, { vcvtsi2sd xmm30,xmm29,{rn-sae},rax                           }
testcase	{ 0x62, 0x61, 0x97, 0x50, 0x2a, 0xf0                                     }, { vcvtsi2sd xmm30,xmm29,{ru-sae},rax                           }
testcase	{ 0x62, 0x61, 0x97, 0x30, 0x2a, 0xf0                                     }, { vcvtsi2sd xmm30,xmm29,{rd-sae},rax                           }
testcase	{ 0x62, 0x61, 0x97, 0x70, 0x2a, 0xf0                                     }, { vcvtsi2sd xmm30,xmm29,{rz-sae},rax                           }
testcase	{ 0x62, 0x41, 0x97, 0x00, 0x2a, 0xf0                                     }, { vcvtsi2sd xmm30,xmm29,r8                                     }
testcase	{ 0x62, 0x41, 0x97, 0x10, 0x2a, 0xf0                                     }, { vcvtsi2sd xmm30,xmm29,{rn-sae},r8                            }
testcase	{ 0x62, 0x41, 0x97, 0x50, 0x2a, 0xf0                                     }, { vcvtsi2sd xmm30,xmm29,{ru-sae},r8                            }
testcase	{ 0x62, 0x41, 0x97, 0x30, 0x2a, 0xf0                                     }, { vcvtsi2sd xmm30,xmm29,{rd-sae},r8                            }
testcase	{ 0x62, 0x41, 0x97, 0x70, 0x2a, 0xf0                                     }, { vcvtsi2sd xmm30,xmm29,{rz-sae},r8                            }
testcase	{ 0x62, 0x61, 0x97, 0x00, 0x2a, 0x31                                     }, { vcvtsi2sd xmm30,xmm29,QWORD [rcx]                            }
testcase	{ 0x62, 0x21, 0x97, 0x00, 0x2a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtsi2sd xmm30,xmm29,QWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x61, 0x97, 0x00, 0x2a, 0x72, 0x7f                               }, { vcvtsi2sd xmm30,xmm29,QWORD [rdx+0x3f8]                      }
testcase	{ 0x62, 0x61, 0x97, 0x00, 0x2a, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vcvtsi2sd xmm30,xmm29,QWORD [rdx+0x400]                      }
testcase	{ 0x62, 0x61, 0x97, 0x00, 0x2a, 0x72, 0x80                               }, { vcvtsi2sd xmm30,xmm29,QWORD [rdx-0x400]                      }
testcase	{ 0x62, 0x61, 0x97, 0x00, 0x2a, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vcvtsi2sd xmm30,xmm29,QWORD [rdx-0x408]                      }
testcase	{ 0x62, 0x61, 0x16, 0x00, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,eax                                    }
testcase	{ 0x62, 0x61, 0x16, 0x10, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,{rn-sae},eax                           }
testcase	{ 0x62, 0x61, 0x16, 0x50, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,{ru-sae},eax                           }
testcase	{ 0x62, 0x61, 0x16, 0x30, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,{rd-sae},eax                           }
testcase	{ 0x62, 0x61, 0x16, 0x70, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,{rz-sae},eax                           }
testcase	{ 0x62, 0x61, 0x16, 0x00, 0x2a, 0xf5                                     }, { vcvtsi2ss xmm30,xmm29,ebp                                    }
testcase	{ 0x62, 0x61, 0x16, 0x10, 0x2a, 0xf5                                     }, { vcvtsi2ss xmm30,xmm29,{rn-sae},ebp                           }
testcase	{ 0x62, 0x61, 0x16, 0x50, 0x2a, 0xf5                                     }, { vcvtsi2ss xmm30,xmm29,{ru-sae},ebp                           }
testcase	{ 0x62, 0x61, 0x16, 0x30, 0x2a, 0xf5                                     }, { vcvtsi2ss xmm30,xmm29,{rd-sae},ebp                           }
testcase	{ 0x62, 0x61, 0x16, 0x70, 0x2a, 0xf5                                     }, { vcvtsi2ss xmm30,xmm29,{rz-sae},ebp                           }
testcase	{ 0x62, 0x41, 0x16, 0x00, 0x2a, 0xf5                                     }, { vcvtsi2ss xmm30,xmm29,r13d                                   }
testcase	{ 0x62, 0x41, 0x16, 0x10, 0x2a, 0xf5                                     }, { vcvtsi2ss xmm30,xmm29,{rn-sae},r13d                          }
testcase	{ 0x62, 0x41, 0x16, 0x50, 0x2a, 0xf5                                     }, { vcvtsi2ss xmm30,xmm29,{ru-sae},r13d                          }
testcase	{ 0x62, 0x41, 0x16, 0x30, 0x2a, 0xf5                                     }, { vcvtsi2ss xmm30,xmm29,{rd-sae},r13d                          }
testcase	{ 0x62, 0x41, 0x16, 0x70, 0x2a, 0xf5                                     }, { vcvtsi2ss xmm30,xmm29,{rz-sae},r13d                          }
testcase	{ 0x62, 0x61, 0x16, 0x00, 0x2a, 0x31                                     }, { vcvtsi2ss xmm30,xmm29,DWORD [rcx]                            }
testcase	{ 0x62, 0x21, 0x16, 0x00, 0x2a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtsi2ss xmm30,xmm29,DWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x61, 0x16, 0x00, 0x2a, 0x72, 0x7f                               }, { vcvtsi2ss xmm30,xmm29,DWORD [rdx+0x1fc]                      }
testcase	{ 0x62, 0x61, 0x16, 0x00, 0x2a, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcvtsi2ss xmm30,xmm29,DWORD [rdx+0x200]                      }
testcase	{ 0x62, 0x61, 0x16, 0x00, 0x2a, 0x72, 0x80                               }, { vcvtsi2ss xmm30,xmm29,DWORD [rdx-0x200]                      }
testcase	{ 0x62, 0x61, 0x16, 0x00, 0x2a, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtsi2ss xmm30,xmm29,DWORD [rdx-0x204]                      }
testcase	{ 0x62, 0x61, 0x96, 0x00, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,rax                                    }
testcase	{ 0x62, 0x61, 0x96, 0x10, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,{rn-sae},rax                           }
testcase	{ 0x62, 0x61, 0x96, 0x50, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,{ru-sae},rax                           }
testcase	{ 0x62, 0x61, 0x96, 0x30, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,{rd-sae},rax                           }
testcase	{ 0x62, 0x61, 0x96, 0x70, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,{rz-sae},rax                           }
testcase	{ 0x62, 0x41, 0x96, 0x00, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,r8                                     }
testcase	{ 0x62, 0x41, 0x96, 0x10, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,{rn-sae},r8                            }
testcase	{ 0x62, 0x41, 0x96, 0x50, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,{ru-sae},r8                            }
testcase	{ 0x62, 0x41, 0x96, 0x30, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,{rd-sae},r8                            }
testcase	{ 0x62, 0x41, 0x96, 0x70, 0x2a, 0xf0                                     }, { vcvtsi2ss xmm30,xmm29,{rz-sae},r8                            }
testcase	{ 0x62, 0x61, 0x96, 0x00, 0x2a, 0x31                                     }, { vcvtsi2ss xmm30,xmm29,QWORD [rcx]                            }
testcase	{ 0x62, 0x21, 0x96, 0x00, 0x2a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtsi2ss xmm30,xmm29,QWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x61, 0x96, 0x00, 0x2a, 0x72, 0x7f                               }, { vcvtsi2ss xmm30,xmm29,QWORD [rdx+0x3f8]                      }
testcase	{ 0x62, 0x61, 0x96, 0x00, 0x2a, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vcvtsi2ss xmm30,xmm29,QWORD [rdx+0x400]                      }
testcase	{ 0x62, 0x61, 0x96, 0x00, 0x2a, 0x72, 0x80                               }, { vcvtsi2ss xmm30,xmm29,QWORD [rdx-0x400]                      }
testcase	{ 0x62, 0x61, 0x96, 0x00, 0x2a, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vcvtsi2ss xmm30,xmm29,QWORD [rdx-0x408]                      }
testcase	{ 0x62, 0x01, 0x16, 0x07, 0x5a, 0xf4                                     }, { vcvtss2sd xmm30{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x16, 0x87, 0x5a, 0xf4                                     }, { vcvtss2sd xmm30{k7}{z},xmm29,xmm28                           }
testcase	{ 0x62, 0x01, 0x16, 0x17, 0x5a, 0xf4                                     }, { vcvtss2sd xmm30{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5a, 0x31                                     }, { vcvtss2sd xmm30{k7},xmm29,DWORD [rcx]                        }
testcase	{ 0x62, 0x21, 0x16, 0x07, 0x5a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtss2sd xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5a, 0x72, 0x7f                               }, { vcvtss2sd xmm30{k7},xmm29,DWORD [rdx+0x1fc]                  }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5a, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcvtss2sd xmm30{k7},xmm29,DWORD [rdx+0x200]                  }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5a, 0x72, 0x80                               }, { vcvtss2sd xmm30{k7},xmm29,DWORD [rdx-0x200]                  }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5a, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtss2sd xmm30{k7},xmm29,DWORD [rdx-0x204]                  }
testcase	{ 0x62, 0x91, 0x7e, 0x18, 0x2d, 0xc6                                     }, { vcvtss2si eax,xmm30,{rn-sae}                                 }
testcase	{ 0x62, 0x91, 0x7e, 0x58, 0x2d, 0xc6                                     }, { vcvtss2si eax,xmm30,{ru-sae}                                 }
testcase	{ 0x62, 0x91, 0x7e, 0x38, 0x2d, 0xc6                                     }, { vcvtss2si eax,xmm30,{rd-sae}                                 }
testcase	{ 0x62, 0x91, 0x7e, 0x78, 0x2d, 0xc6                                     }, { vcvtss2si eax,xmm30,{rz-sae}                                 }
testcase	{ 0x62, 0x91, 0x7e, 0x18, 0x2d, 0xee                                     }, { vcvtss2si ebp,xmm30,{rn-sae}                                 }
testcase	{ 0x62, 0x91, 0x7e, 0x58, 0x2d, 0xee                                     }, { vcvtss2si ebp,xmm30,{ru-sae}                                 }
testcase	{ 0x62, 0x91, 0x7e, 0x38, 0x2d, 0xee                                     }, { vcvtss2si ebp,xmm30,{rd-sae}                                 }
testcase	{ 0x62, 0x91, 0x7e, 0x78, 0x2d, 0xee                                     }, { vcvtss2si ebp,xmm30,{rz-sae}                                 }
testcase	{ 0x62, 0x11, 0x7e, 0x18, 0x2d, 0xee                                     }, { vcvtss2si r13d,xmm30,{rn-sae}                                }
testcase	{ 0x62, 0x11, 0x7e, 0x58, 0x2d, 0xee                                     }, { vcvtss2si r13d,xmm30,{ru-sae}                                }
testcase	{ 0x62, 0x11, 0x7e, 0x38, 0x2d, 0xee                                     }, { vcvtss2si r13d,xmm30,{rd-sae}                                }
testcase	{ 0x62, 0x11, 0x7e, 0x78, 0x2d, 0xee                                     }, { vcvtss2si r13d,xmm30,{rz-sae}                                }
testcase	{ 0x62, 0x91, 0xfe, 0x18, 0x2d, 0xc6                                     }, { vcvtss2si rax,xmm30,{rn-sae}                                 }
testcase	{ 0x62, 0x91, 0xfe, 0x58, 0x2d, 0xc6                                     }, { vcvtss2si rax,xmm30,{ru-sae}                                 }
testcase	{ 0x62, 0x91, 0xfe, 0x38, 0x2d, 0xc6                                     }, { vcvtss2si rax,xmm30,{rd-sae}                                 }
testcase	{ 0x62, 0x91, 0xfe, 0x78, 0x2d, 0xc6                                     }, { vcvtss2si rax,xmm30,{rz-sae}                                 }
testcase	{ 0x62, 0x11, 0xfe, 0x18, 0x2d, 0xc6                                     }, { vcvtss2si r8,xmm30,{rn-sae}                                  }
testcase	{ 0x62, 0x11, 0xfe, 0x58, 0x2d, 0xc6                                     }, { vcvtss2si r8,xmm30,{ru-sae}                                  }
testcase	{ 0x62, 0x11, 0xfe, 0x38, 0x2d, 0xc6                                     }, { vcvtss2si r8,xmm30,{rd-sae}                                  }
testcase	{ 0x62, 0x11, 0xfe, 0x78, 0x2d, 0xc6                                     }, { vcvtss2si r8,xmm30,{rz-sae}                                  }
testcase	{ 0x62, 0x01, 0xfd, 0x4f, 0xe6, 0xf5                                     }, { vcvttpd2dq ymm30{k7},zmm29                                   }
testcase	{ 0x62, 0x01, 0xfd, 0xcf, 0xe6, 0xf5                                     }, { vcvttpd2dq ymm30{k7}{z},zmm29                                }
testcase	{ 0x62, 0x01, 0xfd, 0x1f, 0xe6, 0xf5                                     }, { vcvttpd2dq ymm30{k7},zmm29,{sae}                             }
testcase	{ 0x62, 0x61, 0xfd, 0x4f, 0xe6, 0x31                                     }, { vcvttpd2dq ymm30{k7},ZWORD [rcx]                             }
testcase	{ 0x62, 0x21, 0xfd, 0x4f, 0xe6, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvttpd2dq ymm30{k7},ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0x61, 0xfd, 0x5f, 0xe6, 0x31                                     }, { vcvttpd2dq ymm30{k7},QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0x61, 0xfd, 0x4f, 0xe6, 0x72, 0x7f                               }, { vcvttpd2dq ymm30{k7},ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0x61, 0xfd, 0x4f, 0xe6, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vcvttpd2dq ymm30{k7},ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0x61, 0xfd, 0x4f, 0xe6, 0x72, 0x80                               }, { vcvttpd2dq ymm30{k7},ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0x61, 0xfd, 0x4f, 0xe6, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vcvttpd2dq ymm30{k7},ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0x61, 0xfd, 0x5f, 0xe6, 0x72, 0x7f                               }, { vcvttpd2dq ymm30{k7},QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0x61, 0xfd, 0x5f, 0xe6, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vcvttpd2dq ymm30{k7},QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0x61, 0xfd, 0x5f, 0xe6, 0x72, 0x80                               }, { vcvttpd2dq ymm30{k7},QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0x61, 0xfd, 0x5f, 0xe6, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vcvttpd2dq ymm30{k7},QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x01, 0x7e, 0x48, 0x5b, 0xf5                                     }, { vcvttps2dq zmm30,zmm29                                       }
testcase	{ 0x62, 0x01, 0x7e, 0x4f, 0x5b, 0xf5                                     }, { vcvttps2dq zmm30{k7},zmm29                                   }
testcase	{ 0x62, 0x01, 0x7e, 0xcf, 0x5b, 0xf5                                     }, { vcvttps2dq zmm30{k7}{z},zmm29                                }
testcase	{ 0x62, 0x01, 0x7e, 0x18, 0x5b, 0xf5                                     }, { vcvttps2dq zmm30,zmm29,{sae}                                 }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x5b, 0x31                                     }, { vcvttps2dq zmm30,ZWORD [rcx]                                 }
testcase	{ 0x62, 0x21, 0x7e, 0x48, 0x5b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvttps2dq zmm30,ZWORD [rax+r14*8+0x123]                     }
testcase	{ 0x62, 0x61, 0x7e, 0x58, 0x5b, 0x31                                     }, { vcvttps2dq zmm30,DWORD [rcx]{1to16}                          }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x5b, 0x72, 0x7f                               }, { vcvttps2dq zmm30,ZWORD [rdx+0x1fc0]                          }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x5b, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vcvttps2dq zmm30,ZWORD [rdx+0x2000]                          }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x5b, 0x72, 0x80                               }, { vcvttps2dq zmm30,ZWORD [rdx-0x2000]                          }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x5b, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vcvttps2dq zmm30,ZWORD [rdx-0x2040]                          }
testcase	{ 0x62, 0x61, 0x7e, 0x58, 0x5b, 0x72, 0x7f                               }, { vcvttps2dq zmm30,DWORD [rdx+0x1fc]{1to16}                    }
testcase	{ 0x62, 0x61, 0x7e, 0x58, 0x5b, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcvttps2dq zmm30,DWORD [rdx+0x200]{1to16}                    }
testcase	{ 0x62, 0x61, 0x7e, 0x58, 0x5b, 0x72, 0x80                               }, { vcvttps2dq zmm30,DWORD [rdx-0x200]{1to16}                    }
testcase	{ 0x62, 0x61, 0x7e, 0x58, 0x5b, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcvttps2dq zmm30,DWORD [rdx-0x204]{1to16}                    }
testcase	{ 0x62, 0x91, 0x7f, 0x18, 0x2c, 0xc6                                     }, { vcvttsd2si eax,xmm30,{sae}                                   }
testcase	{ 0x62, 0x91, 0x7f, 0x18, 0x2c, 0xee                                     }, { vcvttsd2si ebp,xmm30,{sae}                                   }
testcase	{ 0x62, 0x11, 0x7f, 0x18, 0x2c, 0xee                                     }, { vcvttsd2si r13d,xmm30,{sae}                                  }
testcase	{ 0x62, 0x91, 0xff, 0x18, 0x2c, 0xc6                                     }, { vcvttsd2si rax,xmm30,{sae}                                   }
testcase	{ 0x62, 0x11, 0xff, 0x18, 0x2c, 0xc6                                     }, { vcvttsd2si r8,xmm30,{sae}                                    }
testcase	{ 0x62, 0x91, 0x7e, 0x18, 0x2c, 0xc6                                     }, { vcvttss2si eax,xmm30,{sae}                                   }
testcase	{ 0x62, 0x91, 0x7e, 0x18, 0x2c, 0xee                                     }, { vcvttss2si ebp,xmm30,{sae}                                   }
testcase	{ 0x62, 0x11, 0x7e, 0x18, 0x2c, 0xee                                     }, { vcvttss2si r13d,xmm30,{sae}                                  }
testcase	{ 0x62, 0x91, 0xfe, 0x18, 0x2c, 0xc6                                     }, { vcvttss2si rax,xmm30,{sae}                                   }
testcase	{ 0x62, 0x11, 0xfe, 0x18, 0x2c, 0xc6                                     }, { vcvttss2si r8,xmm30,{sae}                                    }
testcase	{ 0x62, 0x01, 0x7e, 0x4f, 0x7a, 0xf5                                     }, { vcvtudq2pd zmm30{k7},ymm29                                   }
testcase	{ 0x62, 0x01, 0x7e, 0xcf, 0x7a, 0xf5                                     }, { vcvtudq2pd zmm30{k7}{z},ymm29                                }
testcase	{ 0x62, 0x61, 0x7e, 0x4f, 0x7a, 0x31                                     }, { vcvtudq2pd zmm30{k7},YWORD [rcx]                             }
testcase	{ 0x62, 0x21, 0x7e, 0x4f, 0x7a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtudq2pd zmm30{k7},YWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0x61, 0x7e, 0x5f, 0x7a, 0x31                                     }, { vcvtudq2pd zmm30{k7},DWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0x61, 0x7e, 0x4f, 0x7a, 0x72, 0x7f                               }, { vcvtudq2pd zmm30{k7},YWORD [rdx+0xfe0]                       }
testcase	{ 0x62, 0x61, 0x7e, 0x4f, 0x7a, 0xb2, 0x00, 0x10, 0x00, 0x00             }, { vcvtudq2pd zmm30{k7},YWORD [rdx+0x1000]                      }
testcase	{ 0x62, 0x61, 0x7e, 0x4f, 0x7a, 0x72, 0x80                               }, { vcvtudq2pd zmm30{k7},YWORD [rdx-0x1000]                      }
testcase	{ 0x62, 0x61, 0x7e, 0x4f, 0x7a, 0xb2, 0xe0, 0xef, 0xff, 0xff             }, { vcvtudq2pd zmm30{k7},YWORD [rdx-0x1020]                      }
testcase	{ 0x62, 0x61, 0x7e, 0x5f, 0x7a, 0x72, 0x7f                               }, { vcvtudq2pd zmm30{k7},DWORD [rdx+0x1fc]{1to8}                 }
testcase	{ 0x62, 0x61, 0x7e, 0x5f, 0x7a, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcvtudq2pd zmm30{k7},DWORD [rdx+0x200]{1to8}                 }
testcase	{ 0x62, 0x61, 0x7e, 0x5f, 0x7a, 0x72, 0x80                               }, { vcvtudq2pd zmm30{k7},DWORD [rdx-0x200]{1to8}                 }
testcase	{ 0x62, 0x61, 0x7e, 0x5f, 0x7a, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtudq2pd zmm30{k7},DWORD [rdx-0x204]{1to8}                 }
testcase	{ 0x62, 0x01, 0x7f, 0x48, 0x7a, 0xf5                                     }, { vcvtudq2ps zmm30,zmm29                                       }
testcase	{ 0x62, 0x01, 0x7f, 0x4f, 0x7a, 0xf5                                     }, { vcvtudq2ps zmm30{k7},zmm29                                   }
testcase	{ 0x62, 0x01, 0x7f, 0xcf, 0x7a, 0xf5                                     }, { vcvtudq2ps zmm30{k7}{z},zmm29                                }
testcase	{ 0x62, 0x01, 0x7f, 0x18, 0x7a, 0xf5                                     }, { vcvtudq2ps zmm30,zmm29,{rn-sae}                              }
testcase	{ 0x62, 0x01, 0x7f, 0x58, 0x7a, 0xf5                                     }, { vcvtudq2ps zmm30,zmm29,{ru-sae}                              }
testcase	{ 0x62, 0x01, 0x7f, 0x38, 0x7a, 0xf5                                     }, { vcvtudq2ps zmm30,zmm29,{rd-sae}                              }
testcase	{ 0x62, 0x01, 0x7f, 0x78, 0x7a, 0xf5                                     }, { vcvtudq2ps zmm30,zmm29,{rz-sae}                              }
testcase	{ 0x62, 0x61, 0x7f, 0x48, 0x7a, 0x31                                     }, { vcvtudq2ps zmm30,ZWORD [rcx]                                 }
testcase	{ 0x62, 0x21, 0x7f, 0x48, 0x7a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtudq2ps zmm30,ZWORD [rax+r14*8+0x123]                     }
testcase	{ 0x62, 0x61, 0x7f, 0x58, 0x7a, 0x31                                     }, { vcvtudq2ps zmm30,DWORD [rcx]{1to16}                          }
testcase	{ 0x62, 0x61, 0x7f, 0x48, 0x7a, 0x72, 0x7f                               }, { vcvtudq2ps zmm30,ZWORD [rdx+0x1fc0]                          }
testcase	{ 0x62, 0x61, 0x7f, 0x48, 0x7a, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vcvtudq2ps zmm30,ZWORD [rdx+0x2000]                          }
testcase	{ 0x62, 0x61, 0x7f, 0x48, 0x7a, 0x72, 0x80                               }, { vcvtudq2ps zmm30,ZWORD [rdx-0x2000]                          }
testcase	{ 0x62, 0x61, 0x7f, 0x48, 0x7a, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vcvtudq2ps zmm30,ZWORD [rdx-0x2040]                          }
testcase	{ 0x62, 0x61, 0x7f, 0x58, 0x7a, 0x72, 0x7f                               }, { vcvtudq2ps zmm30,DWORD [rdx+0x1fc]{1to16}                    }
testcase	{ 0x62, 0x61, 0x7f, 0x58, 0x7a, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcvtudq2ps zmm30,DWORD [rdx+0x200]{1to16}                    }
testcase	{ 0x62, 0x61, 0x7f, 0x58, 0x7a, 0x72, 0x80                               }, { vcvtudq2ps zmm30,DWORD [rdx-0x200]{1to16}                    }
testcase	{ 0x62, 0x61, 0x7f, 0x58, 0x7a, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtudq2ps zmm30,DWORD [rdx-0x204]{1to16}                    }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0x5e, 0xf4                                     }, { vdivpd zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0x5e, 0xf4                                     }, { vdivpd zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0x5e, 0xf4                                     }, { vdivpd zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x95, 0x10, 0x5e, 0xf4                                     }, { vdivpd zmm30,zmm29,zmm28,{rn-sae}                            }
testcase	{ 0x62, 0x01, 0x95, 0x50, 0x5e, 0xf4                                     }, { vdivpd zmm30,zmm29,zmm28,{ru-sae}                            }
testcase	{ 0x62, 0x01, 0x95, 0x30, 0x5e, 0xf4                                     }, { vdivpd zmm30,zmm29,zmm28,{rd-sae}                            }
testcase	{ 0x62, 0x01, 0x95, 0x70, 0x5e, 0xf4                                     }, { vdivpd zmm30,zmm29,zmm28,{rz-sae}                            }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5e, 0x31                                     }, { vdivpd zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0x5e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vdivpd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5e, 0x31                                     }, { vdivpd zmm30,zmm29,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5e, 0x72, 0x7f                               }, { vdivpd zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5e, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vdivpd zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5e, 0x72, 0x80                               }, { vdivpd zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5e, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vdivpd zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5e, 0x72, 0x7f                               }, { vdivpd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5e, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vdivpd zmm30,zmm29,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5e, 0x72, 0x80                               }, { vdivpd zmm30,zmm29,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5e, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vdivpd zmm30,zmm29,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x01, 0x14, 0x40, 0x5e, 0xf4                                     }, { vdivps zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x14, 0x47, 0x5e, 0xf4                                     }, { vdivps zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x14, 0xc7, 0x5e, 0xf4                                     }, { vdivps zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x14, 0x10, 0x5e, 0xf4                                     }, { vdivps zmm30,zmm29,zmm28,{rn-sae}                            }
testcase	{ 0x62, 0x01, 0x14, 0x50, 0x5e, 0xf4                                     }, { vdivps zmm30,zmm29,zmm28,{ru-sae}                            }
testcase	{ 0x62, 0x01, 0x14, 0x30, 0x5e, 0xf4                                     }, { vdivps zmm30,zmm29,zmm28,{rd-sae}                            }
testcase	{ 0x62, 0x01, 0x14, 0x70, 0x5e, 0xf4                                     }, { vdivps zmm30,zmm29,zmm28,{rz-sae}                            }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5e, 0x31                                     }, { vdivps zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x14, 0x40, 0x5e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vdivps zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5e, 0x31                                     }, { vdivps zmm30,zmm29,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5e, 0x72, 0x7f                               }, { vdivps zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5e, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vdivps zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5e, 0x72, 0x80                               }, { vdivps zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5e, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vdivps zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5e, 0x72, 0x7f                               }, { vdivps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5e, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vdivps zmm30,zmm29,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5e, 0x72, 0x80                               }, { vdivps zmm30,zmm29,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5e, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vdivps zmm30,zmm29,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x01, 0x97, 0x07, 0x5e, 0xf4                                     }, { vdivsd xmm30{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x97, 0x87, 0x5e, 0xf4                                     }, { vdivsd xmm30{k7}{z},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x97, 0x17, 0x5e, 0xf4                                     }, { vdivsd xmm30{k7},xmm29,xmm28,{rn-sae}                        }
testcase	{ 0x62, 0x01, 0x97, 0x57, 0x5e, 0xf4                                     }, { vdivsd xmm30{k7},xmm29,xmm28,{ru-sae}                        }
testcase	{ 0x62, 0x01, 0x97, 0x37, 0x5e, 0xf4                                     }, { vdivsd xmm30{k7},xmm29,xmm28,{rd-sae}                        }
testcase	{ 0x62, 0x01, 0x97, 0x77, 0x5e, 0xf4                                     }, { vdivsd xmm30{k7},xmm29,xmm28,{rz-sae}                        }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5e, 0x31                                     }, { vdivsd xmm30{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x97, 0x07, 0x5e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vdivsd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5e, 0x72, 0x7f                               }, { vdivsd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5e, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vdivsd xmm30{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5e, 0x72, 0x80                               }, { vdivsd xmm30{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5e, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vdivsd xmm30{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x01, 0x16, 0x07, 0x5e, 0xf4                                     }, { vdivss xmm30{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x16, 0x87, 0x5e, 0xf4                                     }, { vdivss xmm30{k7}{z},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x16, 0x17, 0x5e, 0xf4                                     }, { vdivss xmm30{k7},xmm29,xmm28,{rn-sae}                        }
testcase	{ 0x62, 0x01, 0x16, 0x57, 0x5e, 0xf4                                     }, { vdivss xmm30{k7},xmm29,xmm28,{ru-sae}                        }
testcase	{ 0x62, 0x01, 0x16, 0x37, 0x5e, 0xf4                                     }, { vdivss xmm30{k7},xmm29,xmm28,{rd-sae}                        }
testcase	{ 0x62, 0x01, 0x16, 0x77, 0x5e, 0xf4                                     }, { vdivss xmm30{k7},xmm29,xmm28,{rz-sae}                        }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5e, 0x31                                     }, { vdivss xmm30{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x16, 0x07, 0x5e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vdivss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5e, 0x72, 0x7f                               }, { vdivss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5e, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vdivss xmm30{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5e, 0x72, 0x80                               }, { vdivss xmm30{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5e, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vdivss xmm30{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x88, 0x31                                     }, { vexpandpd zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x62, 0xfd, 0x4f, 0x88, 0x31                                     }, { vexpandpd zmm30{k7},ZWORD [rcx]                              }
testcase	{ 0x62, 0x62, 0xfd, 0xcf, 0x88, 0x31                                     }, { vexpandpd zmm30{k7}{z},ZWORD [rcx]                           }
testcase	{ 0x62, 0x22, 0xfd, 0x48, 0x88, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vexpandpd zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x88, 0x72, 0x7f                               }, { vexpandpd zmm30,ZWORD [rdx+0x3f8]                            }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x88, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vexpandpd zmm30,ZWORD [rdx+0x400]                            }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x88, 0x72, 0x80                               }, { vexpandpd zmm30,ZWORD [rdx-0x400]                            }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x88, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vexpandpd zmm30,ZWORD [rdx-0x408]                            }
testcase	{ 0x62, 0x02, 0xfd, 0x48, 0x88, 0xf5                                     }, { vexpandpd zmm30,zmm29                                        }
testcase	{ 0x62, 0x02, 0xfd, 0x4f, 0x88, 0xf5                                     }, { vexpandpd zmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x02, 0xfd, 0xcf, 0x88, 0xf5                                     }, { vexpandpd zmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x88, 0x31                                     }, { vexpandps zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x88, 0x31                                     }, { vexpandps zmm30{k7},ZWORD [rcx]                              }
testcase	{ 0x62, 0x62, 0x7d, 0xcf, 0x88, 0x31                                     }, { vexpandps zmm30{k7}{z},ZWORD [rcx]                           }
testcase	{ 0x62, 0x22, 0x7d, 0x48, 0x88, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vexpandps zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x88, 0x72, 0x7f                               }, { vexpandps zmm30,ZWORD [rdx+0x1fc]                            }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x88, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vexpandps zmm30,ZWORD [rdx+0x200]                            }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x88, 0x72, 0x80                               }, { vexpandps zmm30,ZWORD [rdx-0x200]                            }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x88, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vexpandps zmm30,ZWORD [rdx-0x204]                            }
testcase	{ 0x62, 0x02, 0x7d, 0x48, 0x88, 0xf5                                     }, { vexpandps zmm30,zmm29                                        }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x88, 0xf5                                     }, { vexpandps zmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x88, 0xf5                                     }, { vexpandps zmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x03, 0x7d, 0x4f, 0x19, 0xee, 0xab                               }, { vextractf32x4 xmm30{k7},zmm29,0xab                           }
testcase	{ 0x62, 0x03, 0x7d, 0xcf, 0x19, 0xee, 0xab                               }, { vextractf32x4 xmm30{k7}{z},zmm29,0xab                        }
testcase	{ 0x62, 0x03, 0x7d, 0x4f, 0x19, 0xee, 0x7b                               }, { vextractf32x4 xmm30{k7},zmm29,0x7b                           }
testcase	{ 0x62, 0x03, 0xfd, 0x4f, 0x1b, 0xee, 0xab                               }, { vextractf64x4 ymm30{k7},zmm29,0xab                           }
testcase	{ 0x62, 0x03, 0xfd, 0xcf, 0x1b, 0xee, 0xab                               }, { vextractf64x4 ymm30{k7}{z},zmm29,0xab                        }
testcase	{ 0x62, 0x03, 0xfd, 0x4f, 0x1b, 0xee, 0x7b                               }, { vextractf64x4 ymm30{k7},zmm29,0x7b                           }
testcase	{ 0x62, 0x03, 0x7d, 0x4f, 0x39, 0xee, 0xab                               }, { vextracti32x4 xmm30{k7},zmm29,0xab                           }
testcase	{ 0x62, 0x03, 0x7d, 0xcf, 0x39, 0xee, 0xab                               }, { vextracti32x4 xmm30{k7}{z},zmm29,0xab                        }
testcase	{ 0x62, 0x03, 0x7d, 0x4f, 0x39, 0xee, 0x7b                               }, { vextracti32x4 xmm30{k7},zmm29,0x7b                           }
testcase	{ 0x62, 0x03, 0xfd, 0x4f, 0x3b, 0xee, 0xab                               }, { vextracti64x4 ymm30{k7},zmm29,0xab                           }
testcase	{ 0x62, 0x03, 0xfd, 0xcf, 0x3b, 0xee, 0xab                               }, { vextracti64x4 ymm30{k7}{z},zmm29,0xab                        }
testcase	{ 0x62, 0x03, 0xfd, 0x4f, 0x3b, 0xee, 0x7b                               }, { vextracti64x4 ymm30{k7},zmm29,0x7b                           }
testcase	{ 0x62, 0x63, 0xfd, 0x08, 0x17, 0xe8, 0xab                               }, { vextractps rax,xmm29,0xab                                    }
testcase	{ 0x62, 0x63, 0xfd, 0x08, 0x17, 0xe8, 0x7b                               }, { vextractps rax,xmm29,0x7b                                    }
testcase	{ 0x62, 0x43, 0xfd, 0x08, 0x17, 0xe8, 0x7b                               }, { vextractps r8,xmm29,0x7b                                     }
testcase	{ 0x62, 0x63, 0x7d, 0x08, 0x17, 0x29, 0x7b                               }, { vextractps DWORD [rcx],xmm29,0x7b                            }
testcase	{ 0x62, 0x23, 0x7d, 0x08, 0x17, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vextractps DWORD [rax+r14*8+0x123],xmm29,0x7b                }
testcase	{ 0x62, 0x63, 0x7d, 0x08, 0x17, 0x6a, 0x7f, 0x7b                         }, { vextractps DWORD [rdx+0x1fc],xmm29,0x7b                      }
testcase	{ 0x62, 0x63, 0x7d, 0x08, 0x17, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vextractps DWORD [rdx+0x200],xmm29,0x7b                      }
testcase	{ 0x62, 0x63, 0x7d, 0x08, 0x17, 0x6a, 0x80, 0x7b                         }, { vextractps DWORD [rdx-0x200],xmm29,0x7b                      }
testcase	{ 0x62, 0x63, 0x7d, 0x08, 0x17, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vextractps DWORD [rdx-0x204],xmm29,0x7b                      }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x98, 0xf4                                     }, { vfmadd132pd zmm30,zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x98, 0xf4                                     }, { vfmadd132pd zmm30{k7},zmm29,zmm28                            }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x98, 0xf4                                     }, { vfmadd132pd zmm30{k7}{z},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0x98, 0xf4                                     }, { vfmadd132pd zmm30,zmm29,zmm28,{rn-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0x98, 0xf4                                     }, { vfmadd132pd zmm30,zmm29,zmm28,{ru-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0x98, 0xf4                                     }, { vfmadd132pd zmm30,zmm29,zmm28,{rd-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0x98, 0xf4                                     }, { vfmadd132pd zmm30,zmm29,zmm28,{rz-sae}                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x98, 0x31                                     }, { vfmadd132pd zmm30,zmm29,ZWORD [rcx]                          }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x98, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmadd132pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x98, 0x31                                     }, { vfmadd132pd zmm30,zmm29,QWORD [rcx]{1to8}                    }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x98, 0x72, 0x7f                               }, { vfmadd132pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x98, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmadd132pd zmm30,zmm29,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x98, 0x72, 0x80                               }, { vfmadd132pd zmm30,zmm29,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x98, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmadd132pd zmm30,zmm29,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x98, 0x72, 0x7f                               }, { vfmadd132pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x98, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmadd132pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x98, 0x72, 0x80                               }, { vfmadd132pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x98, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmadd132pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}              }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x98, 0xf4                                     }, { vfmadd132ps zmm30,zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x98, 0xf4                                     }, { vfmadd132ps zmm30{k7},zmm29,zmm28                            }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x98, 0xf4                                     }, { vfmadd132ps zmm30{k7}{z},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0x98, 0xf4                                     }, { vfmadd132ps zmm30,zmm29,zmm28,{rn-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0x98, 0xf4                                     }, { vfmadd132ps zmm30,zmm29,zmm28,{ru-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0x98, 0xf4                                     }, { vfmadd132ps zmm30,zmm29,zmm28,{rd-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0x98, 0xf4                                     }, { vfmadd132ps zmm30,zmm29,zmm28,{rz-sae}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x98, 0x31                                     }, { vfmadd132ps zmm30,zmm29,ZWORD [rcx]                          }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x98, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmadd132ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x98, 0x31                                     }, { vfmadd132ps zmm30,zmm29,DWORD [rcx]{1to16}                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x98, 0x72, 0x7f                               }, { vfmadd132ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x98, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmadd132ps zmm30,zmm29,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x98, 0x72, 0x80                               }, { vfmadd132ps zmm30,zmm29,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x98, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmadd132ps zmm30,zmm29,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x98, 0x72, 0x7f                               }, { vfmadd132ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x98, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmadd132ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x98, 0x72, 0x80                               }, { vfmadd132ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x98, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmadd132ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}             }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0x99, 0xf4                                     }, { vfmadd132sd xmm30{k7},xmm29,xmm28                            }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0x99, 0xf4                                     }, { vfmadd132sd xmm30{k7}{z},xmm29,xmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0x17, 0x99, 0xf4                                     }, { vfmadd132sd xmm30{k7},xmm29,xmm28,{rn-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x57, 0x99, 0xf4                                     }, { vfmadd132sd xmm30{k7},xmm29,xmm28,{ru-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x37, 0x99, 0xf4                                     }, { vfmadd132sd xmm30{k7},xmm29,xmm28,{rd-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x77, 0x99, 0xf4                                     }, { vfmadd132sd xmm30{k7},xmm29,xmm28,{rz-sae}                   }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x99, 0x31                                     }, { vfmadd132sd xmm30{k7},xmm29,QWORD [rcx]                      }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0x99, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmadd132sd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]          }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x99, 0x72, 0x7f                               }, { vfmadd132sd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x99, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmadd132sd xmm30{k7},xmm29,QWORD [rdx+0x400]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x99, 0x72, 0x80                               }, { vfmadd132sd xmm30{k7},xmm29,QWORD [rdx-0x400]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x99, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmadd132sd xmm30{k7},xmm29,QWORD [rdx-0x408]                }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0x99, 0xf4                                     }, { vfmadd132ss xmm30{k7},xmm29,xmm28                            }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0x99, 0xf4                                     }, { vfmadd132ss xmm30{k7}{z},xmm29,xmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0x17, 0x99, 0xf4                                     }, { vfmadd132ss xmm30{k7},xmm29,xmm28,{rn-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x57, 0x99, 0xf4                                     }, { vfmadd132ss xmm30{k7},xmm29,xmm28,{ru-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x37, 0x99, 0xf4                                     }, { vfmadd132ss xmm30{k7},xmm29,xmm28,{rd-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x77, 0x99, 0xf4                                     }, { vfmadd132ss xmm30{k7},xmm29,xmm28,{rz-sae}                   }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x99, 0x31                                     }, { vfmadd132ss xmm30{k7},xmm29,DWORD [rcx]                      }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0x99, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmadd132ss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]          }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x99, 0x72, 0x7f                               }, { vfmadd132ss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x99, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmadd132ss xmm30{k7},xmm29,DWORD [rdx+0x200]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x99, 0x72, 0x80                               }, { vfmadd132ss xmm30{k7},xmm29,DWORD [rdx-0x200]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x99, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmadd132ss xmm30{k7},xmm29,DWORD [rdx-0x204]                }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0xa8, 0xf4                                     }, { vfmadd213pd zmm30,zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0xa8, 0xf4                                     }, { vfmadd213pd zmm30{k7},zmm29,zmm28                            }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0xa8, 0xf4                                     }, { vfmadd213pd zmm30{k7}{z},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0xa8, 0xf4                                     }, { vfmadd213pd zmm30,zmm29,zmm28,{rn-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0xa8, 0xf4                                     }, { vfmadd213pd zmm30,zmm29,zmm28,{ru-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0xa8, 0xf4                                     }, { vfmadd213pd zmm30,zmm29,zmm28,{rd-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0xa8, 0xf4                                     }, { vfmadd213pd zmm30,zmm29,zmm28,{rz-sae}                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa8, 0x31                                     }, { vfmadd213pd zmm30,zmm29,ZWORD [rcx]                          }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0xa8, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmadd213pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa8, 0x31                                     }, { vfmadd213pd zmm30,zmm29,QWORD [rcx]{1to8}                    }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa8, 0x72, 0x7f                               }, { vfmadd213pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa8, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmadd213pd zmm30,zmm29,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa8, 0x72, 0x80                               }, { vfmadd213pd zmm30,zmm29,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa8, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmadd213pd zmm30,zmm29,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa8, 0x72, 0x7f                               }, { vfmadd213pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa8, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmadd213pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa8, 0x72, 0x80                               }, { vfmadd213pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa8, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmadd213pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}              }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0xa8, 0xf4                                     }, { vfmadd213ps zmm30,zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0xa8, 0xf4                                     }, { vfmadd213ps zmm30{k7},zmm29,zmm28                            }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0xa8, 0xf4                                     }, { vfmadd213ps zmm30{k7}{z},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0xa8, 0xf4                                     }, { vfmadd213ps zmm30,zmm29,zmm28,{rn-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0xa8, 0xf4                                     }, { vfmadd213ps zmm30,zmm29,zmm28,{ru-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0xa8, 0xf4                                     }, { vfmadd213ps zmm30,zmm29,zmm28,{rd-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0xa8, 0xf4                                     }, { vfmadd213ps zmm30,zmm29,zmm28,{rz-sae}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa8, 0x31                                     }, { vfmadd213ps zmm30,zmm29,ZWORD [rcx]                          }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0xa8, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmadd213ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa8, 0x31                                     }, { vfmadd213ps zmm30,zmm29,DWORD [rcx]{1to16}                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa8, 0x72, 0x7f                               }, { vfmadd213ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa8, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmadd213ps zmm30,zmm29,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa8, 0x72, 0x80                               }, { vfmadd213ps zmm30,zmm29,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa8, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmadd213ps zmm30,zmm29,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa8, 0x72, 0x7f                               }, { vfmadd213ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa8, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmadd213ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa8, 0x72, 0x80                               }, { vfmadd213ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa8, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmadd213ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}             }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0xa9, 0xf4                                     }, { vfmadd213sd xmm30{k7},xmm29,xmm28                            }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0xa9, 0xf4                                     }, { vfmadd213sd xmm30{k7}{z},xmm29,xmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0x17, 0xa9, 0xf4                                     }, { vfmadd213sd xmm30{k7},xmm29,xmm28,{rn-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x57, 0xa9, 0xf4                                     }, { vfmadd213sd xmm30{k7},xmm29,xmm28,{ru-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x37, 0xa9, 0xf4                                     }, { vfmadd213sd xmm30{k7},xmm29,xmm28,{rd-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x77, 0xa9, 0xf4                                     }, { vfmadd213sd xmm30{k7},xmm29,xmm28,{rz-sae}                   }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xa9, 0x31                                     }, { vfmadd213sd xmm30{k7},xmm29,QWORD [rcx]                      }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0xa9, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmadd213sd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]          }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xa9, 0x72, 0x7f                               }, { vfmadd213sd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xa9, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmadd213sd xmm30{k7},xmm29,QWORD [rdx+0x400]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xa9, 0x72, 0x80                               }, { vfmadd213sd xmm30{k7},xmm29,QWORD [rdx-0x400]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xa9, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmadd213sd xmm30{k7},xmm29,QWORD [rdx-0x408]                }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0xa9, 0xf4                                     }, { vfmadd213ss xmm30{k7},xmm29,xmm28                            }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0xa9, 0xf4                                     }, { vfmadd213ss xmm30{k7}{z},xmm29,xmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0x17, 0xa9, 0xf4                                     }, { vfmadd213ss xmm30{k7},xmm29,xmm28,{rn-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x57, 0xa9, 0xf4                                     }, { vfmadd213ss xmm30{k7},xmm29,xmm28,{ru-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x37, 0xa9, 0xf4                                     }, { vfmadd213ss xmm30{k7},xmm29,xmm28,{rd-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x77, 0xa9, 0xf4                                     }, { vfmadd213ss xmm30{k7},xmm29,xmm28,{rz-sae}                   }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xa9, 0x31                                     }, { vfmadd213ss xmm30{k7},xmm29,DWORD [rcx]                      }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0xa9, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmadd213ss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]          }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xa9, 0x72, 0x7f                               }, { vfmadd213ss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xa9, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmadd213ss xmm30{k7},xmm29,DWORD [rdx+0x200]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xa9, 0x72, 0x80                               }, { vfmadd213ss xmm30{k7},xmm29,DWORD [rdx-0x200]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xa9, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmadd213ss xmm30{k7},xmm29,DWORD [rdx-0x204]                }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0xb8, 0xf4                                     }, { vfmadd231pd zmm30,zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0xb8, 0xf4                                     }, { vfmadd231pd zmm30{k7},zmm29,zmm28                            }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0xb8, 0xf4                                     }, { vfmadd231pd zmm30{k7}{z},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0xb8, 0xf4                                     }, { vfmadd231pd zmm30,zmm29,zmm28,{rn-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0xb8, 0xf4                                     }, { vfmadd231pd zmm30,zmm29,zmm28,{ru-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0xb8, 0xf4                                     }, { vfmadd231pd zmm30,zmm29,zmm28,{rd-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0xb8, 0xf4                                     }, { vfmadd231pd zmm30,zmm29,zmm28,{rz-sae}                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb8, 0x31                                     }, { vfmadd231pd zmm30,zmm29,ZWORD [rcx]                          }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0xb8, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmadd231pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb8, 0x31                                     }, { vfmadd231pd zmm30,zmm29,QWORD [rcx]{1to8}                    }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb8, 0x72, 0x7f                               }, { vfmadd231pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb8, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmadd231pd zmm30,zmm29,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb8, 0x72, 0x80                               }, { vfmadd231pd zmm30,zmm29,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb8, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmadd231pd zmm30,zmm29,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb8, 0x72, 0x7f                               }, { vfmadd231pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb8, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmadd231pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb8, 0x72, 0x80                               }, { vfmadd231pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb8, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmadd231pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}              }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0xb8, 0xf4                                     }, { vfmadd231ps zmm30,zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0xb8, 0xf4                                     }, { vfmadd231ps zmm30{k7},zmm29,zmm28                            }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0xb8, 0xf4                                     }, { vfmadd231ps zmm30{k7}{z},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0xb8, 0xf4                                     }, { vfmadd231ps zmm30,zmm29,zmm28,{rn-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0xb8, 0xf4                                     }, { vfmadd231ps zmm30,zmm29,zmm28,{ru-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0xb8, 0xf4                                     }, { vfmadd231ps zmm30,zmm29,zmm28,{rd-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0xb8, 0xf4                                     }, { vfmadd231ps zmm30,zmm29,zmm28,{rz-sae}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb8, 0x31                                     }, { vfmadd231ps zmm30,zmm29,ZWORD [rcx]                          }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0xb8, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmadd231ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb8, 0x31                                     }, { vfmadd231ps zmm30,zmm29,DWORD [rcx]{1to16}                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb8, 0x72, 0x7f                               }, { vfmadd231ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb8, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmadd231ps zmm30,zmm29,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb8, 0x72, 0x80                               }, { vfmadd231ps zmm30,zmm29,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb8, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmadd231ps zmm30,zmm29,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb8, 0x72, 0x7f                               }, { vfmadd231ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb8, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmadd231ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb8, 0x72, 0x80                               }, { vfmadd231ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb8, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmadd231ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}             }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0xb9, 0xf4                                     }, { vfmadd231sd xmm30{k7},xmm29,xmm28                            }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0xb9, 0xf4                                     }, { vfmadd231sd xmm30{k7}{z},xmm29,xmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0x17, 0xb9, 0xf4                                     }, { vfmadd231sd xmm30{k7},xmm29,xmm28,{rn-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x57, 0xb9, 0xf4                                     }, { vfmadd231sd xmm30{k7},xmm29,xmm28,{ru-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x37, 0xb9, 0xf4                                     }, { vfmadd231sd xmm30{k7},xmm29,xmm28,{rd-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x77, 0xb9, 0xf4                                     }, { vfmadd231sd xmm30{k7},xmm29,xmm28,{rz-sae}                   }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xb9, 0x31                                     }, { vfmadd231sd xmm30{k7},xmm29,QWORD [rcx]                      }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0xb9, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmadd231sd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]          }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xb9, 0x72, 0x7f                               }, { vfmadd231sd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xb9, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmadd231sd xmm30{k7},xmm29,QWORD [rdx+0x400]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xb9, 0x72, 0x80                               }, { vfmadd231sd xmm30{k7},xmm29,QWORD [rdx-0x400]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xb9, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmadd231sd xmm30{k7},xmm29,QWORD [rdx-0x408]                }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0xb9, 0xf4                                     }, { vfmadd231ss xmm30{k7},xmm29,xmm28                            }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0xb9, 0xf4                                     }, { vfmadd231ss xmm30{k7}{z},xmm29,xmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0x17, 0xb9, 0xf4                                     }, { vfmadd231ss xmm30{k7},xmm29,xmm28,{rn-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x57, 0xb9, 0xf4                                     }, { vfmadd231ss xmm30{k7},xmm29,xmm28,{ru-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x37, 0xb9, 0xf4                                     }, { vfmadd231ss xmm30{k7},xmm29,xmm28,{rd-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x77, 0xb9, 0xf4                                     }, { vfmadd231ss xmm30{k7},xmm29,xmm28,{rz-sae}                   }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xb9, 0x31                                     }, { vfmadd231ss xmm30{k7},xmm29,DWORD [rcx]                      }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0xb9, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmadd231ss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]          }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xb9, 0x72, 0x7f                               }, { vfmadd231ss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xb9, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmadd231ss xmm30{k7},xmm29,DWORD [rdx+0x200]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xb9, 0x72, 0x80                               }, { vfmadd231ss xmm30{k7},xmm29,DWORD [rdx-0x200]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xb9, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmadd231ss xmm30{k7},xmm29,DWORD [rdx-0x204]                }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x96, 0xf4                                     }, { vfmaddsub132pd zmm30,zmm29,zmm28                             }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x96, 0xf4                                     }, { vfmaddsub132pd zmm30{k7},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x96, 0xf4                                     }, { vfmaddsub132pd zmm30{k7}{z},zmm29,zmm28                      }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0x96, 0xf4                                     }, { vfmaddsub132pd zmm30,zmm29,zmm28,{rn-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0x96, 0xf4                                     }, { vfmaddsub132pd zmm30,zmm29,zmm28,{ru-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0x96, 0xf4                                     }, { vfmaddsub132pd zmm30,zmm29,zmm28,{rd-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0x96, 0xf4                                     }, { vfmaddsub132pd zmm30,zmm29,zmm28,{rz-sae}                    }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x96, 0x31                                     }, { vfmaddsub132pd zmm30,zmm29,ZWORD [rcx]                       }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x96, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmaddsub132pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x96, 0x31                                     }, { vfmaddsub132pd zmm30,zmm29,QWORD [rcx]{1to8}                 }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x96, 0x72, 0x7f                               }, { vfmaddsub132pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x96, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmaddsub132pd zmm30,zmm29,ZWORD [rdx+0x2000]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x96, 0x72, 0x80                               }, { vfmaddsub132pd zmm30,zmm29,ZWORD [rdx-0x2000]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x96, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmaddsub132pd zmm30,zmm29,ZWORD [rdx-0x2040]                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x96, 0x72, 0x7f                               }, { vfmaddsub132pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x96, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmaddsub132pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x96, 0x72, 0x80                               }, { vfmaddsub132pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x96, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmaddsub132pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}           }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x96, 0xf4                                     }, { vfmaddsub132ps zmm30,zmm29,zmm28                             }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x96, 0xf4                                     }, { vfmaddsub132ps zmm30{k7},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x96, 0xf4                                     }, { vfmaddsub132ps zmm30{k7}{z},zmm29,zmm28                      }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0x96, 0xf4                                     }, { vfmaddsub132ps zmm30,zmm29,zmm28,{rn-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0x96, 0xf4                                     }, { vfmaddsub132ps zmm30,zmm29,zmm28,{ru-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0x96, 0xf4                                     }, { vfmaddsub132ps zmm30,zmm29,zmm28,{rd-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0x96, 0xf4                                     }, { vfmaddsub132ps zmm30,zmm29,zmm28,{rz-sae}                    }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x96, 0x31                                     }, { vfmaddsub132ps zmm30,zmm29,ZWORD [rcx]                       }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x96, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmaddsub132ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x96, 0x31                                     }, { vfmaddsub132ps zmm30,zmm29,DWORD [rcx]{1to16}                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x96, 0x72, 0x7f                               }, { vfmaddsub132ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x96, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmaddsub132ps zmm30,zmm29,ZWORD [rdx+0x2000]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x96, 0x72, 0x80                               }, { vfmaddsub132ps zmm30,zmm29,ZWORD [rdx-0x2000]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x96, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmaddsub132ps zmm30,zmm29,ZWORD [rdx-0x2040]                }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x96, 0x72, 0x7f                               }, { vfmaddsub132ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x96, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmaddsub132ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x96, 0x72, 0x80                               }, { vfmaddsub132ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x96, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmaddsub132ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}          }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0xa6, 0xf4                                     }, { vfmaddsub213pd zmm30,zmm29,zmm28                             }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0xa6, 0xf4                                     }, { vfmaddsub213pd zmm30{k7},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0xa6, 0xf4                                     }, { vfmaddsub213pd zmm30{k7}{z},zmm29,zmm28                      }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0xa6, 0xf4                                     }, { vfmaddsub213pd zmm30,zmm29,zmm28,{rn-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0xa6, 0xf4                                     }, { vfmaddsub213pd zmm30,zmm29,zmm28,{ru-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0xa6, 0xf4                                     }, { vfmaddsub213pd zmm30,zmm29,zmm28,{rd-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0xa6, 0xf4                                     }, { vfmaddsub213pd zmm30,zmm29,zmm28,{rz-sae}                    }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa6, 0x31                                     }, { vfmaddsub213pd zmm30,zmm29,ZWORD [rcx]                       }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0xa6, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmaddsub213pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa6, 0x31                                     }, { vfmaddsub213pd zmm30,zmm29,QWORD [rcx]{1to8}                 }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa6, 0x72, 0x7f                               }, { vfmaddsub213pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa6, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmaddsub213pd zmm30,zmm29,ZWORD [rdx+0x2000]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa6, 0x72, 0x80                               }, { vfmaddsub213pd zmm30,zmm29,ZWORD [rdx-0x2000]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa6, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmaddsub213pd zmm30,zmm29,ZWORD [rdx-0x2040]                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa6, 0x72, 0x7f                               }, { vfmaddsub213pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa6, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmaddsub213pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa6, 0x72, 0x80                               }, { vfmaddsub213pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa6, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmaddsub213pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}           }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0xa6, 0xf4                                     }, { vfmaddsub213ps zmm30,zmm29,zmm28                             }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0xa6, 0xf4                                     }, { vfmaddsub213ps zmm30{k7},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0xa6, 0xf4                                     }, { vfmaddsub213ps zmm30{k7}{z},zmm29,zmm28                      }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0xa6, 0xf4                                     }, { vfmaddsub213ps zmm30,zmm29,zmm28,{rn-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0xa6, 0xf4                                     }, { vfmaddsub213ps zmm30,zmm29,zmm28,{ru-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0xa6, 0xf4                                     }, { vfmaddsub213ps zmm30,zmm29,zmm28,{rd-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0xa6, 0xf4                                     }, { vfmaddsub213ps zmm30,zmm29,zmm28,{rz-sae}                    }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa6, 0x31                                     }, { vfmaddsub213ps zmm30,zmm29,ZWORD [rcx]                       }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0xa6, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmaddsub213ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa6, 0x31                                     }, { vfmaddsub213ps zmm30,zmm29,DWORD [rcx]{1to16}                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa6, 0x72, 0x7f                               }, { vfmaddsub213ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa6, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmaddsub213ps zmm30,zmm29,ZWORD [rdx+0x2000]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa6, 0x72, 0x80                               }, { vfmaddsub213ps zmm30,zmm29,ZWORD [rdx-0x2000]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa6, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmaddsub213ps zmm30,zmm29,ZWORD [rdx-0x2040]                }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa6, 0x72, 0x7f                               }, { vfmaddsub213ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa6, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmaddsub213ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa6, 0x72, 0x80                               }, { vfmaddsub213ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa6, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmaddsub213ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}          }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0xb6, 0xf4                                     }, { vfmaddsub231pd zmm30,zmm29,zmm28                             }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0xb6, 0xf4                                     }, { vfmaddsub231pd zmm30{k7},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0xb6, 0xf4                                     }, { vfmaddsub231pd zmm30{k7}{z},zmm29,zmm28                      }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0xb6, 0xf4                                     }, { vfmaddsub231pd zmm30,zmm29,zmm28,{rn-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0xb6, 0xf4                                     }, { vfmaddsub231pd zmm30,zmm29,zmm28,{ru-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0xb6, 0xf4                                     }, { vfmaddsub231pd zmm30,zmm29,zmm28,{rd-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0xb6, 0xf4                                     }, { vfmaddsub231pd zmm30,zmm29,zmm28,{rz-sae}                    }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb6, 0x31                                     }, { vfmaddsub231pd zmm30,zmm29,ZWORD [rcx]                       }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0xb6, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmaddsub231pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb6, 0x31                                     }, { vfmaddsub231pd zmm30,zmm29,QWORD [rcx]{1to8}                 }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb6, 0x72, 0x7f                               }, { vfmaddsub231pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb6, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmaddsub231pd zmm30,zmm29,ZWORD [rdx+0x2000]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb6, 0x72, 0x80                               }, { vfmaddsub231pd zmm30,zmm29,ZWORD [rdx-0x2000]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb6, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmaddsub231pd zmm30,zmm29,ZWORD [rdx-0x2040]                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb6, 0x72, 0x7f                               }, { vfmaddsub231pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb6, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmaddsub231pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb6, 0x72, 0x80                               }, { vfmaddsub231pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb6, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmaddsub231pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}           }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0xb6, 0xf4                                     }, { vfmaddsub231ps zmm30,zmm29,zmm28                             }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0xb6, 0xf4                                     }, { vfmaddsub231ps zmm30{k7},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0xb6, 0xf4                                     }, { vfmaddsub231ps zmm30{k7}{z},zmm29,zmm28                      }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0xb6, 0xf4                                     }, { vfmaddsub231ps zmm30,zmm29,zmm28,{rn-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0xb6, 0xf4                                     }, { vfmaddsub231ps zmm30,zmm29,zmm28,{ru-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0xb6, 0xf4                                     }, { vfmaddsub231ps zmm30,zmm29,zmm28,{rd-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0xb6, 0xf4                                     }, { vfmaddsub231ps zmm30,zmm29,zmm28,{rz-sae}                    }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb6, 0x31                                     }, { vfmaddsub231ps zmm30,zmm29,ZWORD [rcx]                       }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0xb6, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmaddsub231ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb6, 0x31                                     }, { vfmaddsub231ps zmm30,zmm29,DWORD [rcx]{1to16}                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb6, 0x72, 0x7f                               }, { vfmaddsub231ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb6, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmaddsub231ps zmm30,zmm29,ZWORD [rdx+0x2000]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb6, 0x72, 0x80                               }, { vfmaddsub231ps zmm30,zmm29,ZWORD [rdx-0x2000]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb6, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmaddsub231ps zmm30,zmm29,ZWORD [rdx-0x2040]                }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb6, 0x72, 0x7f                               }, { vfmaddsub231ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb6, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmaddsub231ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb6, 0x72, 0x80                               }, { vfmaddsub231ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb6, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmaddsub231ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}          }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x9a, 0xf4                                     }, { vfmsub132pd zmm30,zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x9a, 0xf4                                     }, { vfmsub132pd zmm30{k7},zmm29,zmm28                            }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x9a, 0xf4                                     }, { vfmsub132pd zmm30{k7}{z},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0x9a, 0xf4                                     }, { vfmsub132pd zmm30,zmm29,zmm28,{rn-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0x9a, 0xf4                                     }, { vfmsub132pd zmm30,zmm29,zmm28,{ru-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0x9a, 0xf4                                     }, { vfmsub132pd zmm30,zmm29,zmm28,{rd-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0x9a, 0xf4                                     }, { vfmsub132pd zmm30,zmm29,zmm28,{rz-sae}                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9a, 0x31                                     }, { vfmsub132pd zmm30,zmm29,ZWORD [rcx]                          }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x9a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsub132pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9a, 0x31                                     }, { vfmsub132pd zmm30,zmm29,QWORD [rcx]{1to8}                    }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9a, 0x72, 0x7f                               }, { vfmsub132pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9a, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmsub132pd zmm30,zmm29,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9a, 0x72, 0x80                               }, { vfmsub132pd zmm30,zmm29,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9a, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmsub132pd zmm30,zmm29,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9a, 0x72, 0x7f                               }, { vfmsub132pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9a, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmsub132pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9a, 0x72, 0x80                               }, { vfmsub132pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9a, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmsub132pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}              }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x9a, 0xf4                                     }, { vfmsub132ps zmm30,zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x9a, 0xf4                                     }, { vfmsub132ps zmm30{k7},zmm29,zmm28                            }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x9a, 0xf4                                     }, { vfmsub132ps zmm30{k7}{z},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0x9a, 0xf4                                     }, { vfmsub132ps zmm30,zmm29,zmm28,{rn-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0x9a, 0xf4                                     }, { vfmsub132ps zmm30,zmm29,zmm28,{ru-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0x9a, 0xf4                                     }, { vfmsub132ps zmm30,zmm29,zmm28,{rd-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0x9a, 0xf4                                     }, { vfmsub132ps zmm30,zmm29,zmm28,{rz-sae}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9a, 0x31                                     }, { vfmsub132ps zmm30,zmm29,ZWORD [rcx]                          }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x9a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsub132ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9a, 0x31                                     }, { vfmsub132ps zmm30,zmm29,DWORD [rcx]{1to16}                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9a, 0x72, 0x7f                               }, { vfmsub132ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9a, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmsub132ps zmm30,zmm29,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9a, 0x72, 0x80                               }, { vfmsub132ps zmm30,zmm29,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9a, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmsub132ps zmm30,zmm29,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9a, 0x72, 0x7f                               }, { vfmsub132ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9a, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmsub132ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9a, 0x72, 0x80                               }, { vfmsub132ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9a, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmsub132ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}             }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0x9b, 0xf4                                     }, { vfmsub132sd xmm30{k7},xmm29,xmm28                            }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0x9b, 0xf4                                     }, { vfmsub132sd xmm30{k7}{z},xmm29,xmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0x17, 0x9b, 0xf4                                     }, { vfmsub132sd xmm30{k7},xmm29,xmm28,{rn-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x57, 0x9b, 0xf4                                     }, { vfmsub132sd xmm30{k7},xmm29,xmm28,{ru-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x37, 0x9b, 0xf4                                     }, { vfmsub132sd xmm30{k7},xmm29,xmm28,{rd-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x77, 0x9b, 0xf4                                     }, { vfmsub132sd xmm30{k7},xmm29,xmm28,{rz-sae}                   }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9b, 0x31                                     }, { vfmsub132sd xmm30{k7},xmm29,QWORD [rcx]                      }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0x9b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsub132sd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]          }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9b, 0x72, 0x7f                               }, { vfmsub132sd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9b, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmsub132sd xmm30{k7},xmm29,QWORD [rdx+0x400]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9b, 0x72, 0x80                               }, { vfmsub132sd xmm30{k7},xmm29,QWORD [rdx-0x400]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9b, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmsub132sd xmm30{k7},xmm29,QWORD [rdx-0x408]                }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0x9b, 0xf4                                     }, { vfmsub132ss xmm30{k7},xmm29,xmm28                            }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0x9b, 0xf4                                     }, { vfmsub132ss xmm30{k7}{z},xmm29,xmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0x17, 0x9b, 0xf4                                     }, { vfmsub132ss xmm30{k7},xmm29,xmm28,{rn-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x57, 0x9b, 0xf4                                     }, { vfmsub132ss xmm30{k7},xmm29,xmm28,{ru-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x37, 0x9b, 0xf4                                     }, { vfmsub132ss xmm30{k7},xmm29,xmm28,{rd-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x77, 0x9b, 0xf4                                     }, { vfmsub132ss xmm30{k7},xmm29,xmm28,{rz-sae}                   }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9b, 0x31                                     }, { vfmsub132ss xmm30{k7},xmm29,DWORD [rcx]                      }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0x9b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsub132ss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]          }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9b, 0x72, 0x7f                               }, { vfmsub132ss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9b, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmsub132ss xmm30{k7},xmm29,DWORD [rdx+0x200]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9b, 0x72, 0x80                               }, { vfmsub132ss xmm30{k7},xmm29,DWORD [rdx-0x200]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9b, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmsub132ss xmm30{k7},xmm29,DWORD [rdx-0x204]                }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0xaa, 0xf4                                     }, { vfmsub213pd zmm30,zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0xaa, 0xf4                                     }, { vfmsub213pd zmm30{k7},zmm29,zmm28                            }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0xaa, 0xf4                                     }, { vfmsub213pd zmm30{k7}{z},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0xaa, 0xf4                                     }, { vfmsub213pd zmm30,zmm29,zmm28,{rn-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0xaa, 0xf4                                     }, { vfmsub213pd zmm30,zmm29,zmm28,{ru-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0xaa, 0xf4                                     }, { vfmsub213pd zmm30,zmm29,zmm28,{rd-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0xaa, 0xf4                                     }, { vfmsub213pd zmm30,zmm29,zmm28,{rz-sae}                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xaa, 0x31                                     }, { vfmsub213pd zmm30,zmm29,ZWORD [rcx]                          }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0xaa, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsub213pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xaa, 0x31                                     }, { vfmsub213pd zmm30,zmm29,QWORD [rcx]{1to8}                    }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xaa, 0x72, 0x7f                               }, { vfmsub213pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xaa, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmsub213pd zmm30,zmm29,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xaa, 0x72, 0x80                               }, { vfmsub213pd zmm30,zmm29,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xaa, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmsub213pd zmm30,zmm29,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xaa, 0x72, 0x7f                               }, { vfmsub213pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xaa, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmsub213pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xaa, 0x72, 0x80                               }, { vfmsub213pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xaa, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmsub213pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}              }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0xaa, 0xf4                                     }, { vfmsub213ps zmm30,zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0xaa, 0xf4                                     }, { vfmsub213ps zmm30{k7},zmm29,zmm28                            }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0xaa, 0xf4                                     }, { vfmsub213ps zmm30{k7}{z},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0xaa, 0xf4                                     }, { vfmsub213ps zmm30,zmm29,zmm28,{rn-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0xaa, 0xf4                                     }, { vfmsub213ps zmm30,zmm29,zmm28,{ru-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0xaa, 0xf4                                     }, { vfmsub213ps zmm30,zmm29,zmm28,{rd-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0xaa, 0xf4                                     }, { vfmsub213ps zmm30,zmm29,zmm28,{rz-sae}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xaa, 0x31                                     }, { vfmsub213ps zmm30,zmm29,ZWORD [rcx]                          }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0xaa, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsub213ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xaa, 0x31                                     }, { vfmsub213ps zmm30,zmm29,DWORD [rcx]{1to16}                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xaa, 0x72, 0x7f                               }, { vfmsub213ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xaa, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmsub213ps zmm30,zmm29,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xaa, 0x72, 0x80                               }, { vfmsub213ps zmm30,zmm29,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xaa, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmsub213ps zmm30,zmm29,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xaa, 0x72, 0x7f                               }, { vfmsub213ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xaa, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmsub213ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xaa, 0x72, 0x80                               }, { vfmsub213ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xaa, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmsub213ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}             }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0xab, 0xf4                                     }, { vfmsub213sd xmm30{k7},xmm29,xmm28                            }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0xab, 0xf4                                     }, { vfmsub213sd xmm30{k7}{z},xmm29,xmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0x17, 0xab, 0xf4                                     }, { vfmsub213sd xmm30{k7},xmm29,xmm28,{rn-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x57, 0xab, 0xf4                                     }, { vfmsub213sd xmm30{k7},xmm29,xmm28,{ru-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x37, 0xab, 0xf4                                     }, { vfmsub213sd xmm30{k7},xmm29,xmm28,{rd-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x77, 0xab, 0xf4                                     }, { vfmsub213sd xmm30{k7},xmm29,xmm28,{rz-sae}                   }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xab, 0x31                                     }, { vfmsub213sd xmm30{k7},xmm29,QWORD [rcx]                      }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0xab, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsub213sd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]          }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xab, 0x72, 0x7f                               }, { vfmsub213sd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xab, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmsub213sd xmm30{k7},xmm29,QWORD [rdx+0x400]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xab, 0x72, 0x80                               }, { vfmsub213sd xmm30{k7},xmm29,QWORD [rdx-0x400]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xab, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmsub213sd xmm30{k7},xmm29,QWORD [rdx-0x408]                }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0xab, 0xf4                                     }, { vfmsub213ss xmm30{k7},xmm29,xmm28                            }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0xab, 0xf4                                     }, { vfmsub213ss xmm30{k7}{z},xmm29,xmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0x17, 0xab, 0xf4                                     }, { vfmsub213ss xmm30{k7},xmm29,xmm28,{rn-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x57, 0xab, 0xf4                                     }, { vfmsub213ss xmm30{k7},xmm29,xmm28,{ru-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x37, 0xab, 0xf4                                     }, { vfmsub213ss xmm30{k7},xmm29,xmm28,{rd-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x77, 0xab, 0xf4                                     }, { vfmsub213ss xmm30{k7},xmm29,xmm28,{rz-sae}                   }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xab, 0x31                                     }, { vfmsub213ss xmm30{k7},xmm29,DWORD [rcx]                      }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0xab, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsub213ss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]          }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xab, 0x72, 0x7f                               }, { vfmsub213ss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xab, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmsub213ss xmm30{k7},xmm29,DWORD [rdx+0x200]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xab, 0x72, 0x80                               }, { vfmsub213ss xmm30{k7},xmm29,DWORD [rdx-0x200]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xab, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmsub213ss xmm30{k7},xmm29,DWORD [rdx-0x204]                }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0xba, 0xf4                                     }, { vfmsub231pd zmm30,zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0xba, 0xf4                                     }, { vfmsub231pd zmm30{k7},zmm29,zmm28                            }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0xba, 0xf4                                     }, { vfmsub231pd zmm30{k7}{z},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0xba, 0xf4                                     }, { vfmsub231pd zmm30,zmm29,zmm28,{rn-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0xba, 0xf4                                     }, { vfmsub231pd zmm30,zmm29,zmm28,{ru-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0xba, 0xf4                                     }, { vfmsub231pd zmm30,zmm29,zmm28,{rd-sae}                       }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0xba, 0xf4                                     }, { vfmsub231pd zmm30,zmm29,zmm28,{rz-sae}                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xba, 0x31                                     }, { vfmsub231pd zmm30,zmm29,ZWORD [rcx]                          }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0xba, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsub231pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xba, 0x31                                     }, { vfmsub231pd zmm30,zmm29,QWORD [rcx]{1to8}                    }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xba, 0x72, 0x7f                               }, { vfmsub231pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xba, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmsub231pd zmm30,zmm29,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xba, 0x72, 0x80                               }, { vfmsub231pd zmm30,zmm29,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xba, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmsub231pd zmm30,zmm29,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xba, 0x72, 0x7f                               }, { vfmsub231pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xba, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmsub231pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xba, 0x72, 0x80                               }, { vfmsub231pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}              }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xba, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmsub231pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}              }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0xba, 0xf4                                     }, { vfmsub231ps zmm30,zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0xba, 0xf4                                     }, { vfmsub231ps zmm30{k7},zmm29,zmm28                            }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0xba, 0xf4                                     }, { vfmsub231ps zmm30{k7}{z},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0xba, 0xf4                                     }, { vfmsub231ps zmm30,zmm29,zmm28,{rn-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0xba, 0xf4                                     }, { vfmsub231ps zmm30,zmm29,zmm28,{ru-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0xba, 0xf4                                     }, { vfmsub231ps zmm30,zmm29,zmm28,{rd-sae}                       }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0xba, 0xf4                                     }, { vfmsub231ps zmm30,zmm29,zmm28,{rz-sae}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xba, 0x31                                     }, { vfmsub231ps zmm30,zmm29,ZWORD [rcx]                          }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0xba, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsub231ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xba, 0x31                                     }, { vfmsub231ps zmm30,zmm29,DWORD [rcx]{1to16}                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xba, 0x72, 0x7f                               }, { vfmsub231ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xba, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmsub231ps zmm30,zmm29,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xba, 0x72, 0x80                               }, { vfmsub231ps zmm30,zmm29,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xba, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmsub231ps zmm30,zmm29,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xba, 0x72, 0x7f                               }, { vfmsub231ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xba, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmsub231ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xba, 0x72, 0x80                               }, { vfmsub231ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xba, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmsub231ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}             }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0xbb, 0xf4                                     }, { vfmsub231sd xmm30{k7},xmm29,xmm28                            }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0xbb, 0xf4                                     }, { vfmsub231sd xmm30{k7}{z},xmm29,xmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0x17, 0xbb, 0xf4                                     }, { vfmsub231sd xmm30{k7},xmm29,xmm28,{rn-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x57, 0xbb, 0xf4                                     }, { vfmsub231sd xmm30{k7},xmm29,xmm28,{ru-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x37, 0xbb, 0xf4                                     }, { vfmsub231sd xmm30{k7},xmm29,xmm28,{rd-sae}                   }
testcase	{ 0x62, 0x02, 0x95, 0x77, 0xbb, 0xf4                                     }, { vfmsub231sd xmm30{k7},xmm29,xmm28,{rz-sae}                   }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbb, 0x31                                     }, { vfmsub231sd xmm30{k7},xmm29,QWORD [rcx]                      }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0xbb, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsub231sd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]          }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbb, 0x72, 0x7f                               }, { vfmsub231sd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbb, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmsub231sd xmm30{k7},xmm29,QWORD [rdx+0x400]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbb, 0x72, 0x80                               }, { vfmsub231sd xmm30{k7},xmm29,QWORD [rdx-0x400]                }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbb, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmsub231sd xmm30{k7},xmm29,QWORD [rdx-0x408]                }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0xbb, 0xf4                                     }, { vfmsub231ss xmm30{k7},xmm29,xmm28                            }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0xbb, 0xf4                                     }, { vfmsub231ss xmm30{k7}{z},xmm29,xmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0x17, 0xbb, 0xf4                                     }, { vfmsub231ss xmm30{k7},xmm29,xmm28,{rn-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x57, 0xbb, 0xf4                                     }, { vfmsub231ss xmm30{k7},xmm29,xmm28,{ru-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x37, 0xbb, 0xf4                                     }, { vfmsub231ss xmm30{k7},xmm29,xmm28,{rd-sae}                   }
testcase	{ 0x62, 0x02, 0x15, 0x77, 0xbb, 0xf4                                     }, { vfmsub231ss xmm30{k7},xmm29,xmm28,{rz-sae}                   }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbb, 0x31                                     }, { vfmsub231ss xmm30{k7},xmm29,DWORD [rcx]                      }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0xbb, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsub231ss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]          }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbb, 0x72, 0x7f                               }, { vfmsub231ss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbb, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmsub231ss xmm30{k7},xmm29,DWORD [rdx+0x200]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbb, 0x72, 0x80                               }, { vfmsub231ss xmm30{k7},xmm29,DWORD [rdx-0x200]                }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbb, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmsub231ss xmm30{k7},xmm29,DWORD [rdx-0x204]                }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x97, 0xf4                                     }, { vfmsubadd132pd zmm30,zmm29,zmm28                             }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x97, 0xf4                                     }, { vfmsubadd132pd zmm30{k7},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x97, 0xf4                                     }, { vfmsubadd132pd zmm30{k7}{z},zmm29,zmm28                      }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0x97, 0xf4                                     }, { vfmsubadd132pd zmm30,zmm29,zmm28,{rn-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0x97, 0xf4                                     }, { vfmsubadd132pd zmm30,zmm29,zmm28,{ru-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0x97, 0xf4                                     }, { vfmsubadd132pd zmm30,zmm29,zmm28,{rd-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0x97, 0xf4                                     }, { vfmsubadd132pd zmm30,zmm29,zmm28,{rz-sae}                    }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x97, 0x31                                     }, { vfmsubadd132pd zmm30,zmm29,ZWORD [rcx]                       }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x97, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsubadd132pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x97, 0x31                                     }, { vfmsubadd132pd zmm30,zmm29,QWORD [rcx]{1to8}                 }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x97, 0x72, 0x7f                               }, { vfmsubadd132pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x97, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmsubadd132pd zmm30,zmm29,ZWORD [rdx+0x2000]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x97, 0x72, 0x80                               }, { vfmsubadd132pd zmm30,zmm29,ZWORD [rdx-0x2000]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x97, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmsubadd132pd zmm30,zmm29,ZWORD [rdx-0x2040]                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x97, 0x72, 0x7f                               }, { vfmsubadd132pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x97, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmsubadd132pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x97, 0x72, 0x80                               }, { vfmsubadd132pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x97, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmsubadd132pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}           }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x97, 0xf4                                     }, { vfmsubadd132ps zmm30,zmm29,zmm28                             }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x97, 0xf4                                     }, { vfmsubadd132ps zmm30{k7},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x97, 0xf4                                     }, { vfmsubadd132ps zmm30{k7}{z},zmm29,zmm28                      }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0x97, 0xf4                                     }, { vfmsubadd132ps zmm30,zmm29,zmm28,{rn-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0x97, 0xf4                                     }, { vfmsubadd132ps zmm30,zmm29,zmm28,{ru-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0x97, 0xf4                                     }, { vfmsubadd132ps zmm30,zmm29,zmm28,{rd-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0x97, 0xf4                                     }, { vfmsubadd132ps zmm30,zmm29,zmm28,{rz-sae}                    }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x97, 0x31                                     }, { vfmsubadd132ps zmm30,zmm29,ZWORD [rcx]                       }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x97, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsubadd132ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x97, 0x31                                     }, { vfmsubadd132ps zmm30,zmm29,DWORD [rcx]{1to16}                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x97, 0x72, 0x7f                               }, { vfmsubadd132ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x97, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmsubadd132ps zmm30,zmm29,ZWORD [rdx+0x2000]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x97, 0x72, 0x80                               }, { vfmsubadd132ps zmm30,zmm29,ZWORD [rdx-0x2000]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x97, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmsubadd132ps zmm30,zmm29,ZWORD [rdx-0x2040]                }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x97, 0x72, 0x7f                               }, { vfmsubadd132ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x97, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmsubadd132ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x97, 0x72, 0x80                               }, { vfmsubadd132ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x97, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmsubadd132ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}          }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0xa7, 0xf4                                     }, { vfmsubadd213pd zmm30,zmm29,zmm28                             }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0xa7, 0xf4                                     }, { vfmsubadd213pd zmm30{k7},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0xa7, 0xf4                                     }, { vfmsubadd213pd zmm30{k7}{z},zmm29,zmm28                      }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0xa7, 0xf4                                     }, { vfmsubadd213pd zmm30,zmm29,zmm28,{rn-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0xa7, 0xf4                                     }, { vfmsubadd213pd zmm30,zmm29,zmm28,{ru-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0xa7, 0xf4                                     }, { vfmsubadd213pd zmm30,zmm29,zmm28,{rd-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0xa7, 0xf4                                     }, { vfmsubadd213pd zmm30,zmm29,zmm28,{rz-sae}                    }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa7, 0x31                                     }, { vfmsubadd213pd zmm30,zmm29,ZWORD [rcx]                       }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0xa7, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsubadd213pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa7, 0x31                                     }, { vfmsubadd213pd zmm30,zmm29,QWORD [rcx]{1to8}                 }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa7, 0x72, 0x7f                               }, { vfmsubadd213pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa7, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmsubadd213pd zmm30,zmm29,ZWORD [rdx+0x2000]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa7, 0x72, 0x80                               }, { vfmsubadd213pd zmm30,zmm29,ZWORD [rdx-0x2000]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xa7, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmsubadd213pd zmm30,zmm29,ZWORD [rdx-0x2040]                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa7, 0x72, 0x7f                               }, { vfmsubadd213pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa7, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmsubadd213pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa7, 0x72, 0x80                               }, { vfmsubadd213pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xa7, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmsubadd213pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}           }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0xa7, 0xf4                                     }, { vfmsubadd213ps zmm30,zmm29,zmm28                             }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0xa7, 0xf4                                     }, { vfmsubadd213ps zmm30{k7},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0xa7, 0xf4                                     }, { vfmsubadd213ps zmm30{k7}{z},zmm29,zmm28                      }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0xa7, 0xf4                                     }, { vfmsubadd213ps zmm30,zmm29,zmm28,{rn-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0xa7, 0xf4                                     }, { vfmsubadd213ps zmm30,zmm29,zmm28,{ru-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0xa7, 0xf4                                     }, { vfmsubadd213ps zmm30,zmm29,zmm28,{rd-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0xa7, 0xf4                                     }, { vfmsubadd213ps zmm30,zmm29,zmm28,{rz-sae}                    }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa7, 0x31                                     }, { vfmsubadd213ps zmm30,zmm29,ZWORD [rcx]                       }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0xa7, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsubadd213ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa7, 0x31                                     }, { vfmsubadd213ps zmm30,zmm29,DWORD [rcx]{1to16}                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa7, 0x72, 0x7f                               }, { vfmsubadd213ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa7, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmsubadd213ps zmm30,zmm29,ZWORD [rdx+0x2000]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa7, 0x72, 0x80                               }, { vfmsubadd213ps zmm30,zmm29,ZWORD [rdx-0x2000]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xa7, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmsubadd213ps zmm30,zmm29,ZWORD [rdx-0x2040]                }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa7, 0x72, 0x7f                               }, { vfmsubadd213ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa7, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmsubadd213ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa7, 0x72, 0x80                               }, { vfmsubadd213ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xa7, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmsubadd213ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}          }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0xb7, 0xf4                                     }, { vfmsubadd231pd zmm30,zmm29,zmm28                             }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0xb7, 0xf4                                     }, { vfmsubadd231pd zmm30{k7},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0xb7, 0xf4                                     }, { vfmsubadd231pd zmm30{k7}{z},zmm29,zmm28                      }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0xb7, 0xf4                                     }, { vfmsubadd231pd zmm30,zmm29,zmm28,{rn-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0xb7, 0xf4                                     }, { vfmsubadd231pd zmm30,zmm29,zmm28,{ru-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0xb7, 0xf4                                     }, { vfmsubadd231pd zmm30,zmm29,zmm28,{rd-sae}                    }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0xb7, 0xf4                                     }, { vfmsubadd231pd zmm30,zmm29,zmm28,{rz-sae}                    }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb7, 0x31                                     }, { vfmsubadd231pd zmm30,zmm29,ZWORD [rcx]                       }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0xb7, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsubadd231pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb7, 0x31                                     }, { vfmsubadd231pd zmm30,zmm29,QWORD [rcx]{1to8}                 }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb7, 0x72, 0x7f                               }, { vfmsubadd231pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb7, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmsubadd231pd zmm30,zmm29,ZWORD [rdx+0x2000]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb7, 0x72, 0x80                               }, { vfmsubadd231pd zmm30,zmm29,ZWORD [rdx-0x2000]                }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xb7, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmsubadd231pd zmm30,zmm29,ZWORD [rdx-0x2040]                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb7, 0x72, 0x7f                               }, { vfmsubadd231pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb7, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfmsubadd231pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb7, 0x72, 0x80                               }, { vfmsubadd231pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}           }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xb7, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfmsubadd231pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}           }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0xb7, 0xf4                                     }, { vfmsubadd231ps zmm30,zmm29,zmm28                             }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0xb7, 0xf4                                     }, { vfmsubadd231ps zmm30{k7},zmm29,zmm28                         }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0xb7, 0xf4                                     }, { vfmsubadd231ps zmm30{k7}{z},zmm29,zmm28                      }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0xb7, 0xf4                                     }, { vfmsubadd231ps zmm30,zmm29,zmm28,{rn-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0xb7, 0xf4                                     }, { vfmsubadd231ps zmm30,zmm29,zmm28,{ru-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0xb7, 0xf4                                     }, { vfmsubadd231ps zmm30,zmm29,zmm28,{rd-sae}                    }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0xb7, 0xf4                                     }, { vfmsubadd231ps zmm30,zmm29,zmm28,{rz-sae}                    }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb7, 0x31                                     }, { vfmsubadd231ps zmm30,zmm29,ZWORD [rcx]                       }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0xb7, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfmsubadd231ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb7, 0x31                                     }, { vfmsubadd231ps zmm30,zmm29,DWORD [rcx]{1to16}                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb7, 0x72, 0x7f                               }, { vfmsubadd231ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb7, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfmsubadd231ps zmm30,zmm29,ZWORD [rdx+0x2000]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb7, 0x72, 0x80                               }, { vfmsubadd231ps zmm30,zmm29,ZWORD [rdx-0x2000]                }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xb7, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfmsubadd231ps zmm30,zmm29,ZWORD [rdx-0x2040]                }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb7, 0x72, 0x7f                               }, { vfmsubadd231ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb7, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfmsubadd231ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb7, 0x72, 0x80                               }, { vfmsubadd231ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}          }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xb7, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfmsubadd231ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}          }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x9c, 0xf4                                     }, { vfnmadd132pd zmm30,zmm29,zmm28                               }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x9c, 0xf4                                     }, { vfnmadd132pd zmm30{k7},zmm29,zmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x9c, 0xf4                                     }, { vfnmadd132pd zmm30{k7}{z},zmm29,zmm28                        }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0x9c, 0xf4                                     }, { vfnmadd132pd zmm30,zmm29,zmm28,{rn-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0x9c, 0xf4                                     }, { vfnmadd132pd zmm30,zmm29,zmm28,{ru-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0x9c, 0xf4                                     }, { vfnmadd132pd zmm30,zmm29,zmm28,{rd-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0x9c, 0xf4                                     }, { vfnmadd132pd zmm30,zmm29,zmm28,{rz-sae}                      }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9c, 0x31                                     }, { vfnmadd132pd zmm30,zmm29,ZWORD [rcx]                         }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x9c, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmadd132pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9c, 0x31                                     }, { vfnmadd132pd zmm30,zmm29,QWORD [rcx]{1to8}                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9c, 0x72, 0x7f                               }, { vfnmadd132pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9c, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfnmadd132pd zmm30,zmm29,ZWORD [rdx+0x2000]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9c, 0x72, 0x80                               }, { vfnmadd132pd zmm30,zmm29,ZWORD [rdx-0x2000]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9c, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfnmadd132pd zmm30,zmm29,ZWORD [rdx-0x2040]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9c, 0x72, 0x7f                               }, { vfnmadd132pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9c, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfnmadd132pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9c, 0x72, 0x80                               }, { vfnmadd132pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9c, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfnmadd132pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}             }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x9c, 0xf4                                     }, { vfnmadd132ps zmm30,zmm29,zmm28                               }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x9c, 0xf4                                     }, { vfnmadd132ps zmm30{k7},zmm29,zmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x9c, 0xf4                                     }, { vfnmadd132ps zmm30{k7}{z},zmm29,zmm28                        }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0x9c, 0xf4                                     }, { vfnmadd132ps zmm30,zmm29,zmm28,{rn-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0x9c, 0xf4                                     }, { vfnmadd132ps zmm30,zmm29,zmm28,{ru-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0x9c, 0xf4                                     }, { vfnmadd132ps zmm30,zmm29,zmm28,{rd-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0x9c, 0xf4                                     }, { vfnmadd132ps zmm30,zmm29,zmm28,{rz-sae}                      }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9c, 0x31                                     }, { vfnmadd132ps zmm30,zmm29,ZWORD [rcx]                         }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x9c, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmadd132ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9c, 0x31                                     }, { vfnmadd132ps zmm30,zmm29,DWORD [rcx]{1to16}                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9c, 0x72, 0x7f                               }, { vfnmadd132ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9c, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfnmadd132ps zmm30,zmm29,ZWORD [rdx+0x2000]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9c, 0x72, 0x80                               }, { vfnmadd132ps zmm30,zmm29,ZWORD [rdx-0x2000]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9c, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfnmadd132ps zmm30,zmm29,ZWORD [rdx-0x2040]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9c, 0x72, 0x7f                               }, { vfnmadd132ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9c, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfnmadd132ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9c, 0x72, 0x80                               }, { vfnmadd132ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9c, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfnmadd132ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}            }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0x9d, 0xf4                                     }, { vfnmadd132sd xmm30{k7},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0x9d, 0xf4                                     }, { vfnmadd132sd xmm30{k7}{z},xmm29,xmm28                        }
testcase	{ 0x62, 0x02, 0x95, 0x17, 0x9d, 0xf4                                     }, { vfnmadd132sd xmm30{k7},xmm29,xmm28,{rn-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x57, 0x9d, 0xf4                                     }, { vfnmadd132sd xmm30{k7},xmm29,xmm28,{ru-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x37, 0x9d, 0xf4                                     }, { vfnmadd132sd xmm30{k7},xmm29,xmm28,{rd-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x77, 0x9d, 0xf4                                     }, { vfnmadd132sd xmm30{k7},xmm29,xmm28,{rz-sae}                  }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9d, 0x31                                     }, { vfnmadd132sd xmm30{k7},xmm29,QWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0x9d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmadd132sd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]         }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9d, 0x72, 0x7f                               }, { vfnmadd132sd xmm30{k7},xmm29,QWORD [rdx+0x3f8]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9d, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfnmadd132sd xmm30{k7},xmm29,QWORD [rdx+0x400]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9d, 0x72, 0x80                               }, { vfnmadd132sd xmm30{k7},xmm29,QWORD [rdx-0x400]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9d, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfnmadd132sd xmm30{k7},xmm29,QWORD [rdx-0x408]               }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0x9d, 0xf4                                     }, { vfnmadd132ss xmm30{k7},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0x9d, 0xf4                                     }, { vfnmadd132ss xmm30{k7}{z},xmm29,xmm28                        }
testcase	{ 0x62, 0x02, 0x15, 0x17, 0x9d, 0xf4                                     }, { vfnmadd132ss xmm30{k7},xmm29,xmm28,{rn-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x57, 0x9d, 0xf4                                     }, { vfnmadd132ss xmm30{k7},xmm29,xmm28,{ru-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x37, 0x9d, 0xf4                                     }, { vfnmadd132ss xmm30{k7},xmm29,xmm28,{rd-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x77, 0x9d, 0xf4                                     }, { vfnmadd132ss xmm30{k7},xmm29,xmm28,{rz-sae}                  }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9d, 0x31                                     }, { vfnmadd132ss xmm30{k7},xmm29,DWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0x9d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmadd132ss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]         }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9d, 0x72, 0x7f                               }, { vfnmadd132ss xmm30{k7},xmm29,DWORD [rdx+0x1fc]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9d, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfnmadd132ss xmm30{k7},xmm29,DWORD [rdx+0x200]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9d, 0x72, 0x80                               }, { vfnmadd132ss xmm30{k7},xmm29,DWORD [rdx-0x200]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9d, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfnmadd132ss xmm30{k7},xmm29,DWORD [rdx-0x204]               }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0xac, 0xf4                                     }, { vfnmadd213pd zmm30,zmm29,zmm28                               }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0xac, 0xf4                                     }, { vfnmadd213pd zmm30{k7},zmm29,zmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0xac, 0xf4                                     }, { vfnmadd213pd zmm30{k7}{z},zmm29,zmm28                        }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0xac, 0xf4                                     }, { vfnmadd213pd zmm30,zmm29,zmm28,{rn-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0xac, 0xf4                                     }, { vfnmadd213pd zmm30,zmm29,zmm28,{ru-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0xac, 0xf4                                     }, { vfnmadd213pd zmm30,zmm29,zmm28,{rd-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0xac, 0xf4                                     }, { vfnmadd213pd zmm30,zmm29,zmm28,{rz-sae}                      }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xac, 0x31                                     }, { vfnmadd213pd zmm30,zmm29,ZWORD [rcx]                         }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0xac, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmadd213pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xac, 0x31                                     }, { vfnmadd213pd zmm30,zmm29,QWORD [rcx]{1to8}                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xac, 0x72, 0x7f                               }, { vfnmadd213pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xac, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfnmadd213pd zmm30,zmm29,ZWORD [rdx+0x2000]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xac, 0x72, 0x80                               }, { vfnmadd213pd zmm30,zmm29,ZWORD [rdx-0x2000]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xac, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfnmadd213pd zmm30,zmm29,ZWORD [rdx-0x2040]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xac, 0x72, 0x7f                               }, { vfnmadd213pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xac, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfnmadd213pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xac, 0x72, 0x80                               }, { vfnmadd213pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xac, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfnmadd213pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}             }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0xac, 0xf4                                     }, { vfnmadd213ps zmm30,zmm29,zmm28                               }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0xac, 0xf4                                     }, { vfnmadd213ps zmm30{k7},zmm29,zmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0xac, 0xf4                                     }, { vfnmadd213ps zmm30{k7}{z},zmm29,zmm28                        }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0xac, 0xf4                                     }, { vfnmadd213ps zmm30,zmm29,zmm28,{rn-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0xac, 0xf4                                     }, { vfnmadd213ps zmm30,zmm29,zmm28,{ru-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0xac, 0xf4                                     }, { vfnmadd213ps zmm30,zmm29,zmm28,{rd-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0xac, 0xf4                                     }, { vfnmadd213ps zmm30,zmm29,zmm28,{rz-sae}                      }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xac, 0x31                                     }, { vfnmadd213ps zmm30,zmm29,ZWORD [rcx]                         }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0xac, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmadd213ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xac, 0x31                                     }, { vfnmadd213ps zmm30,zmm29,DWORD [rcx]{1to16}                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xac, 0x72, 0x7f                               }, { vfnmadd213ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xac, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfnmadd213ps zmm30,zmm29,ZWORD [rdx+0x2000]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xac, 0x72, 0x80                               }, { vfnmadd213ps zmm30,zmm29,ZWORD [rdx-0x2000]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xac, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfnmadd213ps zmm30,zmm29,ZWORD [rdx-0x2040]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xac, 0x72, 0x7f                               }, { vfnmadd213ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xac, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfnmadd213ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xac, 0x72, 0x80                               }, { vfnmadd213ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xac, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfnmadd213ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}            }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0xad, 0xf4                                     }, { vfnmadd213sd xmm30{k7},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0xad, 0xf4                                     }, { vfnmadd213sd xmm30{k7}{z},xmm29,xmm28                        }
testcase	{ 0x62, 0x02, 0x95, 0x17, 0xad, 0xf4                                     }, { vfnmadd213sd xmm30{k7},xmm29,xmm28,{rn-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x57, 0xad, 0xf4                                     }, { vfnmadd213sd xmm30{k7},xmm29,xmm28,{ru-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x37, 0xad, 0xf4                                     }, { vfnmadd213sd xmm30{k7},xmm29,xmm28,{rd-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x77, 0xad, 0xf4                                     }, { vfnmadd213sd xmm30{k7},xmm29,xmm28,{rz-sae}                  }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xad, 0x31                                     }, { vfnmadd213sd xmm30{k7},xmm29,QWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0xad, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmadd213sd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]         }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xad, 0x72, 0x7f                               }, { vfnmadd213sd xmm30{k7},xmm29,QWORD [rdx+0x3f8]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xad, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfnmadd213sd xmm30{k7},xmm29,QWORD [rdx+0x400]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xad, 0x72, 0x80                               }, { vfnmadd213sd xmm30{k7},xmm29,QWORD [rdx-0x400]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xad, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfnmadd213sd xmm30{k7},xmm29,QWORD [rdx-0x408]               }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0xad, 0xf4                                     }, { vfnmadd213ss xmm30{k7},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0xad, 0xf4                                     }, { vfnmadd213ss xmm30{k7}{z},xmm29,xmm28                        }
testcase	{ 0x62, 0x02, 0x15, 0x17, 0xad, 0xf4                                     }, { vfnmadd213ss xmm30{k7},xmm29,xmm28,{rn-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x57, 0xad, 0xf4                                     }, { vfnmadd213ss xmm30{k7},xmm29,xmm28,{ru-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x37, 0xad, 0xf4                                     }, { vfnmadd213ss xmm30{k7},xmm29,xmm28,{rd-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x77, 0xad, 0xf4                                     }, { vfnmadd213ss xmm30{k7},xmm29,xmm28,{rz-sae}                  }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xad, 0x31                                     }, { vfnmadd213ss xmm30{k7},xmm29,DWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0xad, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmadd213ss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]         }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xad, 0x72, 0x7f                               }, { vfnmadd213ss xmm30{k7},xmm29,DWORD [rdx+0x1fc]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xad, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfnmadd213ss xmm30{k7},xmm29,DWORD [rdx+0x200]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xad, 0x72, 0x80                               }, { vfnmadd213ss xmm30{k7},xmm29,DWORD [rdx-0x200]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xad, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfnmadd213ss xmm30{k7},xmm29,DWORD [rdx-0x204]               }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0xbc, 0xf4                                     }, { vfnmadd231pd zmm30,zmm29,zmm28                               }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0xbc, 0xf4                                     }, { vfnmadd231pd zmm30{k7},zmm29,zmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0xbc, 0xf4                                     }, { vfnmadd231pd zmm30{k7}{z},zmm29,zmm28                        }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0xbc, 0xf4                                     }, { vfnmadd231pd zmm30,zmm29,zmm28,{rn-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0xbc, 0xf4                                     }, { vfnmadd231pd zmm30,zmm29,zmm28,{ru-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0xbc, 0xf4                                     }, { vfnmadd231pd zmm30,zmm29,zmm28,{rd-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0xbc, 0xf4                                     }, { vfnmadd231pd zmm30,zmm29,zmm28,{rz-sae}                      }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xbc, 0x31                                     }, { vfnmadd231pd zmm30,zmm29,ZWORD [rcx]                         }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0xbc, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmadd231pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xbc, 0x31                                     }, { vfnmadd231pd zmm30,zmm29,QWORD [rcx]{1to8}                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xbc, 0x72, 0x7f                               }, { vfnmadd231pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xbc, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfnmadd231pd zmm30,zmm29,ZWORD [rdx+0x2000]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xbc, 0x72, 0x80                               }, { vfnmadd231pd zmm30,zmm29,ZWORD [rdx-0x2000]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xbc, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfnmadd231pd zmm30,zmm29,ZWORD [rdx-0x2040]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xbc, 0x72, 0x7f                               }, { vfnmadd231pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xbc, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfnmadd231pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xbc, 0x72, 0x80                               }, { vfnmadd231pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xbc, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfnmadd231pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}             }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0xbc, 0xf4                                     }, { vfnmadd231ps zmm30,zmm29,zmm28                               }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0xbc, 0xf4                                     }, { vfnmadd231ps zmm30{k7},zmm29,zmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0xbc, 0xf4                                     }, { vfnmadd231ps zmm30{k7}{z},zmm29,zmm28                        }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0xbc, 0xf4                                     }, { vfnmadd231ps zmm30,zmm29,zmm28,{rn-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0xbc, 0xf4                                     }, { vfnmadd231ps zmm30,zmm29,zmm28,{ru-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0xbc, 0xf4                                     }, { vfnmadd231ps zmm30,zmm29,zmm28,{rd-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0xbc, 0xf4                                     }, { vfnmadd231ps zmm30,zmm29,zmm28,{rz-sae}                      }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xbc, 0x31                                     }, { vfnmadd231ps zmm30,zmm29,ZWORD [rcx]                         }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0xbc, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmadd231ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xbc, 0x31                                     }, { vfnmadd231ps zmm30,zmm29,DWORD [rcx]{1to16}                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xbc, 0x72, 0x7f                               }, { vfnmadd231ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xbc, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfnmadd231ps zmm30,zmm29,ZWORD [rdx+0x2000]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xbc, 0x72, 0x80                               }, { vfnmadd231ps zmm30,zmm29,ZWORD [rdx-0x2000]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xbc, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfnmadd231ps zmm30,zmm29,ZWORD [rdx-0x2040]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xbc, 0x72, 0x7f                               }, { vfnmadd231ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xbc, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfnmadd231ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xbc, 0x72, 0x80                               }, { vfnmadd231ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xbc, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfnmadd231ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}            }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0xbd, 0xf4                                     }, { vfnmadd231sd xmm30{k7},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0xbd, 0xf4                                     }, { vfnmadd231sd xmm30{k7}{z},xmm29,xmm28                        }
testcase	{ 0x62, 0x02, 0x95, 0x17, 0xbd, 0xf4                                     }, { vfnmadd231sd xmm30{k7},xmm29,xmm28,{rn-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x57, 0xbd, 0xf4                                     }, { vfnmadd231sd xmm30{k7},xmm29,xmm28,{ru-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x37, 0xbd, 0xf4                                     }, { vfnmadd231sd xmm30{k7},xmm29,xmm28,{rd-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x77, 0xbd, 0xf4                                     }, { vfnmadd231sd xmm30{k7},xmm29,xmm28,{rz-sae}                  }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbd, 0x31                                     }, { vfnmadd231sd xmm30{k7},xmm29,QWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0xbd, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmadd231sd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]         }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbd, 0x72, 0x7f                               }, { vfnmadd231sd xmm30{k7},xmm29,QWORD [rdx+0x3f8]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbd, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfnmadd231sd xmm30{k7},xmm29,QWORD [rdx+0x400]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbd, 0x72, 0x80                               }, { vfnmadd231sd xmm30{k7},xmm29,QWORD [rdx-0x400]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbd, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfnmadd231sd xmm30{k7},xmm29,QWORD [rdx-0x408]               }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0xbd, 0xf4                                     }, { vfnmadd231ss xmm30{k7},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0xbd, 0xf4                                     }, { vfnmadd231ss xmm30{k7}{z},xmm29,xmm28                        }
testcase	{ 0x62, 0x02, 0x15, 0x17, 0xbd, 0xf4                                     }, { vfnmadd231ss xmm30{k7},xmm29,xmm28,{rn-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x57, 0xbd, 0xf4                                     }, { vfnmadd231ss xmm30{k7},xmm29,xmm28,{ru-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x37, 0xbd, 0xf4                                     }, { vfnmadd231ss xmm30{k7},xmm29,xmm28,{rd-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x77, 0xbd, 0xf4                                     }, { vfnmadd231ss xmm30{k7},xmm29,xmm28,{rz-sae}                  }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbd, 0x31                                     }, { vfnmadd231ss xmm30{k7},xmm29,DWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0xbd, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmadd231ss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]         }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbd, 0x72, 0x7f                               }, { vfnmadd231ss xmm30{k7},xmm29,DWORD [rdx+0x1fc]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbd, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfnmadd231ss xmm30{k7},xmm29,DWORD [rdx+0x200]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbd, 0x72, 0x80                               }, { vfnmadd231ss xmm30{k7},xmm29,DWORD [rdx-0x200]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbd, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfnmadd231ss xmm30{k7},xmm29,DWORD [rdx-0x204]               }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x9e, 0xf4                                     }, { vfnmsub132pd zmm30,zmm29,zmm28                               }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x9e, 0xf4                                     }, { vfnmsub132pd zmm30{k7},zmm29,zmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x9e, 0xf4                                     }, { vfnmsub132pd zmm30{k7}{z},zmm29,zmm28                        }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0x9e, 0xf4                                     }, { vfnmsub132pd zmm30,zmm29,zmm28,{rn-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0x9e, 0xf4                                     }, { vfnmsub132pd zmm30,zmm29,zmm28,{ru-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0x9e, 0xf4                                     }, { vfnmsub132pd zmm30,zmm29,zmm28,{rd-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0x9e, 0xf4                                     }, { vfnmsub132pd zmm30,zmm29,zmm28,{rz-sae}                      }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9e, 0x31                                     }, { vfnmsub132pd zmm30,zmm29,ZWORD [rcx]                         }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x9e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmsub132pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9e, 0x31                                     }, { vfnmsub132pd zmm30,zmm29,QWORD [rcx]{1to8}                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9e, 0x72, 0x7f                               }, { vfnmsub132pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9e, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfnmsub132pd zmm30,zmm29,ZWORD [rdx+0x2000]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9e, 0x72, 0x80                               }, { vfnmsub132pd zmm30,zmm29,ZWORD [rdx-0x2000]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x9e, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfnmsub132pd zmm30,zmm29,ZWORD [rdx-0x2040]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9e, 0x72, 0x7f                               }, { vfnmsub132pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9e, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfnmsub132pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9e, 0x72, 0x80                               }, { vfnmsub132pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x9e, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfnmsub132pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}             }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x9e, 0xf4                                     }, { vfnmsub132ps zmm30,zmm29,zmm28                               }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x9e, 0xf4                                     }, { vfnmsub132ps zmm30{k7},zmm29,zmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x9e, 0xf4                                     }, { vfnmsub132ps zmm30{k7}{z},zmm29,zmm28                        }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0x9e, 0xf4                                     }, { vfnmsub132ps zmm30,zmm29,zmm28,{rn-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0x9e, 0xf4                                     }, { vfnmsub132ps zmm30,zmm29,zmm28,{ru-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0x9e, 0xf4                                     }, { vfnmsub132ps zmm30,zmm29,zmm28,{rd-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0x9e, 0xf4                                     }, { vfnmsub132ps zmm30,zmm29,zmm28,{rz-sae}                      }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9e, 0x31                                     }, { vfnmsub132ps zmm30,zmm29,ZWORD [rcx]                         }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x9e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmsub132ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9e, 0x31                                     }, { vfnmsub132ps zmm30,zmm29,DWORD [rcx]{1to16}                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9e, 0x72, 0x7f                               }, { vfnmsub132ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9e, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfnmsub132ps zmm30,zmm29,ZWORD [rdx+0x2000]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9e, 0x72, 0x80                               }, { vfnmsub132ps zmm30,zmm29,ZWORD [rdx-0x2000]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x9e, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfnmsub132ps zmm30,zmm29,ZWORD [rdx-0x2040]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9e, 0x72, 0x7f                               }, { vfnmsub132ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9e, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfnmsub132ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9e, 0x72, 0x80                               }, { vfnmsub132ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x9e, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfnmsub132ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}            }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0x9f, 0xf4                                     }, { vfnmsub132sd xmm30{k7},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0x9f, 0xf4                                     }, { vfnmsub132sd xmm30{k7}{z},xmm29,xmm28                        }
testcase	{ 0x62, 0x02, 0x95, 0x17, 0x9f, 0xf4                                     }, { vfnmsub132sd xmm30{k7},xmm29,xmm28,{rn-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x57, 0x9f, 0xf4                                     }, { vfnmsub132sd xmm30{k7},xmm29,xmm28,{ru-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x37, 0x9f, 0xf4                                     }, { vfnmsub132sd xmm30{k7},xmm29,xmm28,{rd-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x77, 0x9f, 0xf4                                     }, { vfnmsub132sd xmm30{k7},xmm29,xmm28,{rz-sae}                  }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9f, 0x31                                     }, { vfnmsub132sd xmm30{k7},xmm29,QWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0x9f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmsub132sd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]         }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9f, 0x72, 0x7f                               }, { vfnmsub132sd xmm30{k7},xmm29,QWORD [rdx+0x3f8]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9f, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfnmsub132sd xmm30{k7},xmm29,QWORD [rdx+0x400]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9f, 0x72, 0x80                               }, { vfnmsub132sd xmm30{k7},xmm29,QWORD [rdx-0x400]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x9f, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfnmsub132sd xmm30{k7},xmm29,QWORD [rdx-0x408]               }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0x9f, 0xf4                                     }, { vfnmsub132ss xmm30{k7},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0x9f, 0xf4                                     }, { vfnmsub132ss xmm30{k7}{z},xmm29,xmm28                        }
testcase	{ 0x62, 0x02, 0x15, 0x17, 0x9f, 0xf4                                     }, { vfnmsub132ss xmm30{k7},xmm29,xmm28,{rn-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x57, 0x9f, 0xf4                                     }, { vfnmsub132ss xmm30{k7},xmm29,xmm28,{ru-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x37, 0x9f, 0xf4                                     }, { vfnmsub132ss xmm30{k7},xmm29,xmm28,{rd-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x77, 0x9f, 0xf4                                     }, { vfnmsub132ss xmm30{k7},xmm29,xmm28,{rz-sae}                  }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9f, 0x31                                     }, { vfnmsub132ss xmm30{k7},xmm29,DWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0x9f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmsub132ss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]         }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9f, 0x72, 0x7f                               }, { vfnmsub132ss xmm30{k7},xmm29,DWORD [rdx+0x1fc]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9f, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfnmsub132ss xmm30{k7},xmm29,DWORD [rdx+0x200]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9f, 0x72, 0x80                               }, { vfnmsub132ss xmm30{k7},xmm29,DWORD [rdx-0x200]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x9f, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfnmsub132ss xmm30{k7},xmm29,DWORD [rdx-0x204]               }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0xae, 0xf4                                     }, { vfnmsub213pd zmm30,zmm29,zmm28                               }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0xae, 0xf4                                     }, { vfnmsub213pd zmm30{k7},zmm29,zmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0xae, 0xf4                                     }, { vfnmsub213pd zmm30{k7}{z},zmm29,zmm28                        }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0xae, 0xf4                                     }, { vfnmsub213pd zmm30,zmm29,zmm28,{rn-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0xae, 0xf4                                     }, { vfnmsub213pd zmm30,zmm29,zmm28,{ru-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0xae, 0xf4                                     }, { vfnmsub213pd zmm30,zmm29,zmm28,{rd-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0xae, 0xf4                                     }, { vfnmsub213pd zmm30,zmm29,zmm28,{rz-sae}                      }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xae, 0x31                                     }, { vfnmsub213pd zmm30,zmm29,ZWORD [rcx]                         }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0xae, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmsub213pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xae, 0x31                                     }, { vfnmsub213pd zmm30,zmm29,QWORD [rcx]{1to8}                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xae, 0x72, 0x7f                               }, { vfnmsub213pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xae, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfnmsub213pd zmm30,zmm29,ZWORD [rdx+0x2000]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xae, 0x72, 0x80                               }, { vfnmsub213pd zmm30,zmm29,ZWORD [rdx-0x2000]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xae, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfnmsub213pd zmm30,zmm29,ZWORD [rdx-0x2040]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xae, 0x72, 0x7f                               }, { vfnmsub213pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xae, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfnmsub213pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xae, 0x72, 0x80                               }, { vfnmsub213pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xae, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfnmsub213pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}             }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0xae, 0xf4                                     }, { vfnmsub213ps zmm30,zmm29,zmm28                               }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0xae, 0xf4                                     }, { vfnmsub213ps zmm30{k7},zmm29,zmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0xae, 0xf4                                     }, { vfnmsub213ps zmm30{k7}{z},zmm29,zmm28                        }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0xae, 0xf4                                     }, { vfnmsub213ps zmm30,zmm29,zmm28,{rn-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0xae, 0xf4                                     }, { vfnmsub213ps zmm30,zmm29,zmm28,{ru-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0xae, 0xf4                                     }, { vfnmsub213ps zmm30,zmm29,zmm28,{rd-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0xae, 0xf4                                     }, { vfnmsub213ps zmm30,zmm29,zmm28,{rz-sae}                      }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xae, 0x31                                     }, { vfnmsub213ps zmm30,zmm29,ZWORD [rcx]                         }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0xae, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmsub213ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xae, 0x31                                     }, { vfnmsub213ps zmm30,zmm29,DWORD [rcx]{1to16}                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xae, 0x72, 0x7f                               }, { vfnmsub213ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xae, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfnmsub213ps zmm30,zmm29,ZWORD [rdx+0x2000]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xae, 0x72, 0x80                               }, { vfnmsub213ps zmm30,zmm29,ZWORD [rdx-0x2000]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xae, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfnmsub213ps zmm30,zmm29,ZWORD [rdx-0x2040]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xae, 0x72, 0x7f                               }, { vfnmsub213ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xae, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfnmsub213ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xae, 0x72, 0x80                               }, { vfnmsub213ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xae, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfnmsub213ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}            }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0xaf, 0xf4                                     }, { vfnmsub213sd xmm30{k7},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0xaf, 0xf4                                     }, { vfnmsub213sd xmm30{k7}{z},xmm29,xmm28                        }
testcase	{ 0x62, 0x02, 0x95, 0x17, 0xaf, 0xf4                                     }, { vfnmsub213sd xmm30{k7},xmm29,xmm28,{rn-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x57, 0xaf, 0xf4                                     }, { vfnmsub213sd xmm30{k7},xmm29,xmm28,{ru-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x37, 0xaf, 0xf4                                     }, { vfnmsub213sd xmm30{k7},xmm29,xmm28,{rd-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x77, 0xaf, 0xf4                                     }, { vfnmsub213sd xmm30{k7},xmm29,xmm28,{rz-sae}                  }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xaf, 0x31                                     }, { vfnmsub213sd xmm30{k7},xmm29,QWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0xaf, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmsub213sd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]         }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xaf, 0x72, 0x7f                               }, { vfnmsub213sd xmm30{k7},xmm29,QWORD [rdx+0x3f8]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xaf, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfnmsub213sd xmm30{k7},xmm29,QWORD [rdx+0x400]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xaf, 0x72, 0x80                               }, { vfnmsub213sd xmm30{k7},xmm29,QWORD [rdx-0x400]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xaf, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfnmsub213sd xmm30{k7},xmm29,QWORD [rdx-0x408]               }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0xaf, 0xf4                                     }, { vfnmsub213ss xmm30{k7},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0xaf, 0xf4                                     }, { vfnmsub213ss xmm30{k7}{z},xmm29,xmm28                        }
testcase	{ 0x62, 0x02, 0x15, 0x17, 0xaf, 0xf4                                     }, { vfnmsub213ss xmm30{k7},xmm29,xmm28,{rn-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x57, 0xaf, 0xf4                                     }, { vfnmsub213ss xmm30{k7},xmm29,xmm28,{ru-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x37, 0xaf, 0xf4                                     }, { vfnmsub213ss xmm30{k7},xmm29,xmm28,{rd-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x77, 0xaf, 0xf4                                     }, { vfnmsub213ss xmm30{k7},xmm29,xmm28,{rz-sae}                  }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xaf, 0x31                                     }, { vfnmsub213ss xmm30{k7},xmm29,DWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0xaf, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmsub213ss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]         }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xaf, 0x72, 0x7f                               }, { vfnmsub213ss xmm30{k7},xmm29,DWORD [rdx+0x1fc]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xaf, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfnmsub213ss xmm30{k7},xmm29,DWORD [rdx+0x200]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xaf, 0x72, 0x80                               }, { vfnmsub213ss xmm30{k7},xmm29,DWORD [rdx-0x200]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xaf, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfnmsub213ss xmm30{k7},xmm29,DWORD [rdx-0x204]               }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0xbe, 0xf4                                     }, { vfnmsub231pd zmm30,zmm29,zmm28                               }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0xbe, 0xf4                                     }, { vfnmsub231pd zmm30{k7},zmm29,zmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0xbe, 0xf4                                     }, { vfnmsub231pd zmm30{k7}{z},zmm29,zmm28                        }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0xbe, 0xf4                                     }, { vfnmsub231pd zmm30,zmm29,zmm28,{rn-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0xbe, 0xf4                                     }, { vfnmsub231pd zmm30,zmm29,zmm28,{ru-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0xbe, 0xf4                                     }, { vfnmsub231pd zmm30,zmm29,zmm28,{rd-sae}                      }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0xbe, 0xf4                                     }, { vfnmsub231pd zmm30,zmm29,zmm28,{rz-sae}                      }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xbe, 0x31                                     }, { vfnmsub231pd zmm30,zmm29,ZWORD [rcx]                         }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0xbe, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmsub231pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xbe, 0x31                                     }, { vfnmsub231pd zmm30,zmm29,QWORD [rcx]{1to8}                   }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xbe, 0x72, 0x7f                               }, { vfnmsub231pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xbe, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfnmsub231pd zmm30,zmm29,ZWORD [rdx+0x2000]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xbe, 0x72, 0x80                               }, { vfnmsub231pd zmm30,zmm29,ZWORD [rdx-0x2000]                  }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0xbe, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfnmsub231pd zmm30,zmm29,ZWORD [rdx-0x2040]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xbe, 0x72, 0x7f                               }, { vfnmsub231pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xbe, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfnmsub231pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xbe, 0x72, 0x80                               }, { vfnmsub231pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}             }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0xbe, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfnmsub231pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}             }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0xbe, 0xf4                                     }, { vfnmsub231ps zmm30,zmm29,zmm28                               }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0xbe, 0xf4                                     }, { vfnmsub231ps zmm30{k7},zmm29,zmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0xbe, 0xf4                                     }, { vfnmsub231ps zmm30{k7}{z},zmm29,zmm28                        }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0xbe, 0xf4                                     }, { vfnmsub231ps zmm30,zmm29,zmm28,{rn-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0xbe, 0xf4                                     }, { vfnmsub231ps zmm30,zmm29,zmm28,{ru-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0xbe, 0xf4                                     }, { vfnmsub231ps zmm30,zmm29,zmm28,{rd-sae}                      }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0xbe, 0xf4                                     }, { vfnmsub231ps zmm30,zmm29,zmm28,{rz-sae}                      }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xbe, 0x31                                     }, { vfnmsub231ps zmm30,zmm29,ZWORD [rcx]                         }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0xbe, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmsub231ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xbe, 0x31                                     }, { vfnmsub231ps zmm30,zmm29,DWORD [rcx]{1to16}                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xbe, 0x72, 0x7f                               }, { vfnmsub231ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xbe, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vfnmsub231ps zmm30,zmm29,ZWORD [rdx+0x2000]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xbe, 0x72, 0x80                               }, { vfnmsub231ps zmm30,zmm29,ZWORD [rdx-0x2000]                  }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0xbe, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vfnmsub231ps zmm30,zmm29,ZWORD [rdx-0x2040]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xbe, 0x72, 0x7f                               }, { vfnmsub231ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xbe, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfnmsub231ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xbe, 0x72, 0x80                               }, { vfnmsub231ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}            }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0xbe, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfnmsub231ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}            }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0xbf, 0xf4                                     }, { vfnmsub231sd xmm30{k7},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0xbf, 0xf4                                     }, { vfnmsub231sd xmm30{k7}{z},xmm29,xmm28                        }
testcase	{ 0x62, 0x02, 0x95, 0x17, 0xbf, 0xf4                                     }, { vfnmsub231sd xmm30{k7},xmm29,xmm28,{rn-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x57, 0xbf, 0xf4                                     }, { vfnmsub231sd xmm30{k7},xmm29,xmm28,{ru-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x37, 0xbf, 0xf4                                     }, { vfnmsub231sd xmm30{k7},xmm29,xmm28,{rd-sae}                  }
testcase	{ 0x62, 0x02, 0x95, 0x77, 0xbf, 0xf4                                     }, { vfnmsub231sd xmm30{k7},xmm29,xmm28,{rz-sae}                  }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbf, 0x31                                     }, { vfnmsub231sd xmm30{k7},xmm29,QWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0xbf, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmsub231sd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]         }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbf, 0x72, 0x7f                               }, { vfnmsub231sd xmm30{k7},xmm29,QWORD [rdx+0x3f8]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbf, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vfnmsub231sd xmm30{k7},xmm29,QWORD [rdx+0x400]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbf, 0x72, 0x80                               }, { vfnmsub231sd xmm30{k7},xmm29,QWORD [rdx-0x400]               }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0xbf, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vfnmsub231sd xmm30{k7},xmm29,QWORD [rdx-0x408]               }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0xbf, 0xf4                                     }, { vfnmsub231ss xmm30{k7},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0xbf, 0xf4                                     }, { vfnmsub231ss xmm30{k7}{z},xmm29,xmm28                        }
testcase	{ 0x62, 0x02, 0x15, 0x17, 0xbf, 0xf4                                     }, { vfnmsub231ss xmm30{k7},xmm29,xmm28,{rn-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x57, 0xbf, 0xf4                                     }, { vfnmsub231ss xmm30{k7},xmm29,xmm28,{ru-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x37, 0xbf, 0xf4                                     }, { vfnmsub231ss xmm30{k7},xmm29,xmm28,{rd-sae}                  }
testcase	{ 0x62, 0x02, 0x15, 0x77, 0xbf, 0xf4                                     }, { vfnmsub231ss xmm30{k7},xmm29,xmm28,{rz-sae}                  }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbf, 0x31                                     }, { vfnmsub231ss xmm30{k7},xmm29,DWORD [rcx]                     }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0xbf, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vfnmsub231ss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]         }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbf, 0x72, 0x7f                               }, { vfnmsub231ss xmm30{k7},xmm29,DWORD [rdx+0x1fc]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbf, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vfnmsub231ss xmm30{k7},xmm29,DWORD [rdx+0x200]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbf, 0x72, 0x80                               }, { vfnmsub231ss xmm30{k7},xmm29,DWORD [rdx-0x200]               }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0xbf, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vfnmsub231ss xmm30{k7},xmm29,DWORD [rdx-0x204]               }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0x92, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vgatherdpd zmm30{k1}, [r14+ymm31*8+0x7b]                     }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0x92, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vgatherdpd zmm30{k1}, [r14+ymm31*8+0x7b]                     }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0x92, 0x74, 0x39, 0x20                         }, { vgatherdpd zmm30{k1}, [r9+ymm31*1+0x100]                     }
testcase	{ 0x62, 0x22, 0xfd, 0x41, 0x92, 0xb4, 0xb9, 0x00, 0x04, 0x00, 0x00       }, { vgatherdpd zmm30{k1}, [rcx+ymm31*4+0x400]                    }
testcase	{ 0x62, 0x02, 0x7d, 0x41, 0x92, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vgatherdps zmm30{k1}, [r14+zmm31*8+0x7b]                     }
testcase	{ 0x62, 0x02, 0x7d, 0x41, 0x92, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vgatherdps zmm30{k1}, [r14+zmm31*8+0x7b]                     }
testcase	{ 0x62, 0x02, 0x7d, 0x41, 0x92, 0x74, 0x39, 0x40                         }, { vgatherdps zmm30{k1}, [r9+zmm31*1+0x100]                     }
testcase	{ 0x62, 0x22, 0x7d, 0x41, 0x92, 0xb4, 0xb9, 0x00, 0x04, 0x00, 0x00       }, { vgatherdps zmm30{k1}, [rcx+zmm31*4+0x400]                    }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0x93, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vgatherqpd zmm30{k1}, [r14+zmm31*8+0x7b]                     }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0x93, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vgatherqpd zmm30{k1}, [r14+zmm31*8+0x7b]                     }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0x93, 0x74, 0x39, 0x20                         }, { vgatherqpd zmm30{k1}, [r9+zmm31*1+0x100]                     }
testcase	{ 0x62, 0x22, 0xfd, 0x41, 0x93, 0xb4, 0xb9, 0x00, 0x04, 0x00, 0x00       }, { vgatherqpd zmm30{k1}, [rcx+zmm31*4+0x400]                    }
testcase	{ 0x62, 0x02, 0xfd, 0x48, 0x42, 0xf5                                     }, { vgetexppd zmm30,zmm29                                        }
testcase	{ 0x62, 0x02, 0xfd, 0x4f, 0x42, 0xf5                                     }, { vgetexppd zmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x02, 0xfd, 0xcf, 0x42, 0xf5                                     }, { vgetexppd zmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x02, 0xfd, 0x18, 0x42, 0xf5                                     }, { vgetexppd zmm30,zmm29,{sae}                                  }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x42, 0x31                                     }, { vgetexppd zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x22, 0xfd, 0x48, 0x42, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vgetexppd zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x42, 0x31                                     }, { vgetexppd zmm30,QWORD [rcx]{1to8}                            }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x42, 0x72, 0x7f                               }, { vgetexppd zmm30,ZWORD [rdx+0x1fc0]                           }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x42, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vgetexppd zmm30,ZWORD [rdx+0x2000]                           }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x42, 0x72, 0x80                               }, { vgetexppd zmm30,ZWORD [rdx-0x2000]                           }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x42, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vgetexppd zmm30,ZWORD [rdx-0x2040]                           }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x42, 0x72, 0x7f                               }, { vgetexppd zmm30,QWORD [rdx+0x3f8]{1to8}                      }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x42, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vgetexppd zmm30,QWORD [rdx+0x400]{1to8}                      }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x42, 0x72, 0x80                               }, { vgetexppd zmm30,QWORD [rdx-0x400]{1to8}                      }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x42, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vgetexppd zmm30,QWORD [rdx-0x408]{1to8}                      }
testcase	{ 0x62, 0x02, 0x7d, 0x48, 0x42, 0xf5                                     }, { vgetexpps zmm30,zmm29                                        }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x42, 0xf5                                     }, { vgetexpps zmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x42, 0xf5                                     }, { vgetexpps zmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x02, 0x7d, 0x18, 0x42, 0xf5                                     }, { vgetexpps zmm30,zmm29,{sae}                                  }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x42, 0x31                                     }, { vgetexpps zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x22, 0x7d, 0x48, 0x42, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vgetexpps zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x42, 0x31                                     }, { vgetexpps zmm30,DWORD [rcx]{1to16}                           }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x42, 0x72, 0x7f                               }, { vgetexpps zmm30,ZWORD [rdx+0x1fc0]                           }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x42, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vgetexpps zmm30,ZWORD [rdx+0x2000]                           }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x42, 0x72, 0x80                               }, { vgetexpps zmm30,ZWORD [rdx-0x2000]                           }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x42, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vgetexpps zmm30,ZWORD [rdx-0x2040]                           }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x42, 0x72, 0x7f                               }, { vgetexpps zmm30,DWORD [rdx+0x1fc]{1to16}                     }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x42, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vgetexpps zmm30,DWORD [rdx+0x200]{1to16}                     }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x42, 0x72, 0x80                               }, { vgetexpps zmm30,DWORD [rdx-0x200]{1to16}                     }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x42, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vgetexpps zmm30,DWORD [rdx-0x204]{1to16}                     }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0x43, 0xf4                                     }, { vgetexpsd xmm30{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0x43, 0xf4                                     }, { vgetexpsd xmm30{k7}{z},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0x17, 0x43, 0xf4                                     }, { vgetexpsd xmm30{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x43, 0x31                                     }, { vgetexpsd xmm30{k7},xmm29,QWORD [rcx]                        }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0x43, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vgetexpsd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x43, 0x72, 0x7f                               }, { vgetexpsd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                  }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x43, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vgetexpsd xmm30{k7},xmm29,QWORD [rdx+0x400]                  }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x43, 0x72, 0x80                               }, { vgetexpsd xmm30{k7},xmm29,QWORD [rdx-0x400]                  }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x43, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vgetexpsd xmm30{k7},xmm29,QWORD [rdx-0x408]                  }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0x43, 0xf4                                     }, { vgetexpss xmm30{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0x43, 0xf4                                     }, { vgetexpss xmm30{k7}{z},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0x17, 0x43, 0xf4                                     }, { vgetexpss xmm30{k7},xmm29,xmm28,{sae}                        }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x43, 0x31                                     }, { vgetexpss xmm30{k7},xmm29,DWORD [rcx]                        }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0x43, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vgetexpss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x43, 0x72, 0x7f                               }, { vgetexpss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                  }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x43, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vgetexpss xmm30{k7},xmm29,DWORD [rdx+0x200]                  }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x43, 0x72, 0x80                               }, { vgetexpss xmm30{k7},xmm29,DWORD [rdx-0x200]                  }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x43, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vgetexpss xmm30{k7},xmm29,DWORD [rdx-0x204]                  }
testcase	{ 0x62, 0x03, 0xfd, 0x48, 0x26, 0xf5, 0xab                               }, { vgetmantpd zmm30,zmm29,0xab                                  }
testcase	{ 0x62, 0x03, 0xfd, 0x4f, 0x26, 0xf5, 0xab                               }, { vgetmantpd zmm30{k7},zmm29,0xab                              }
testcase	{ 0x62, 0x03, 0xfd, 0xcf, 0x26, 0xf5, 0xab                               }, { vgetmantpd zmm30{k7}{z},zmm29,0xab                           }
testcase	{ 0x62, 0x03, 0xfd, 0x18, 0x26, 0xf5, 0xab                               }, { vgetmantpd zmm30,zmm29,{sae},0xab                            }
testcase	{ 0x62, 0x03, 0xfd, 0x48, 0x26, 0xf5, 0x7b                               }, { vgetmantpd zmm30,zmm29,0x7b                                  }
testcase	{ 0x62, 0x03, 0xfd, 0x18, 0x26, 0xf5, 0x7b                               }, { vgetmantpd zmm30,zmm29,{sae},0x7b                            }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x26, 0x31, 0x7b                               }, { vgetmantpd zmm30,ZWORD [rcx],0x7b                            }
testcase	{ 0x62, 0x23, 0xfd, 0x48, 0x26, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vgetmantpd zmm30,ZWORD [rax+r14*8+0x123],0x7b                }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x26, 0x31, 0x7b                               }, { vgetmantpd zmm30,QWORD [rcx]{1to8},0x7b                      }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x26, 0x72, 0x7f, 0x7b                         }, { vgetmantpd zmm30,ZWORD [rdx+0x1fc0],0x7b                     }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x26, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vgetmantpd zmm30,ZWORD [rdx+0x2000],0x7b                     }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x26, 0x72, 0x80, 0x7b                         }, { vgetmantpd zmm30,ZWORD [rdx-0x2000],0x7b                     }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x26, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vgetmantpd zmm30,ZWORD [rdx-0x2040],0x7b                     }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x26, 0x72, 0x7f, 0x7b                         }, { vgetmantpd zmm30,QWORD [rdx+0x3f8]{1to8},0x7b                }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x26, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vgetmantpd zmm30,QWORD [rdx+0x400]{1to8},0x7b                }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x26, 0x72, 0x80, 0x7b                         }, { vgetmantpd zmm30,QWORD [rdx-0x400]{1to8},0x7b                }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x26, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vgetmantpd zmm30,QWORD [rdx-0x408]{1to8},0x7b                }
testcase	{ 0x62, 0x03, 0x7d, 0x48, 0x26, 0xf5, 0xab                               }, { vgetmantps zmm30,zmm29,0xab                                  }
testcase	{ 0x62, 0x03, 0x7d, 0x4f, 0x26, 0xf5, 0xab                               }, { vgetmantps zmm30{k7},zmm29,0xab                              }
testcase	{ 0x62, 0x03, 0x7d, 0xcf, 0x26, 0xf5, 0xab                               }, { vgetmantps zmm30{k7}{z},zmm29,0xab                           }
testcase	{ 0x62, 0x03, 0x7d, 0x18, 0x26, 0xf5, 0xab                               }, { vgetmantps zmm30,zmm29,{sae},0xab                            }
testcase	{ 0x62, 0x03, 0x7d, 0x48, 0x26, 0xf5, 0x7b                               }, { vgetmantps zmm30,zmm29,0x7b                                  }
testcase	{ 0x62, 0x03, 0x7d, 0x18, 0x26, 0xf5, 0x7b                               }, { vgetmantps zmm30,zmm29,{sae},0x7b                            }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x26, 0x31, 0x7b                               }, { vgetmantps zmm30,ZWORD [rcx],0x7b                            }
testcase	{ 0x62, 0x23, 0x7d, 0x48, 0x26, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vgetmantps zmm30,ZWORD [rax+r14*8+0x123],0x7b                }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x26, 0x31, 0x7b                               }, { vgetmantps zmm30,DWORD [rcx]{1to16},0x7b                     }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x26, 0x72, 0x7f, 0x7b                         }, { vgetmantps zmm30,ZWORD [rdx+0x1fc0],0x7b                     }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x26, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vgetmantps zmm30,ZWORD [rdx+0x2000],0x7b                     }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x26, 0x72, 0x80, 0x7b                         }, { vgetmantps zmm30,ZWORD [rdx-0x2000],0x7b                     }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x26, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vgetmantps zmm30,ZWORD [rdx-0x2040],0x7b                     }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x26, 0x72, 0x7f, 0x7b                         }, { vgetmantps zmm30,DWORD [rdx+0x1fc]{1to16},0x7b               }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x26, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vgetmantps zmm30,DWORD [rdx+0x200]{1to16},0x7b               }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x26, 0x72, 0x80, 0x7b                         }, { vgetmantps zmm30,DWORD [rdx-0x200]{1to16},0x7b               }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x26, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vgetmantps zmm30,DWORD [rdx-0x204]{1to16},0x7b               }
testcase	{ 0x62, 0x03, 0x95, 0x07, 0x27, 0xf4, 0xab                               }, { vgetmantsd xmm30{k7},xmm29,xmm28,0xab                        }
testcase	{ 0x62, 0x03, 0x95, 0x87, 0x27, 0xf4, 0xab                               }, { vgetmantsd xmm30{k7}{z},xmm29,xmm28,0xab                     }
testcase	{ 0x62, 0x03, 0x95, 0x17, 0x27, 0xf4, 0xab                               }, { vgetmantsd xmm30{k7},xmm29,xmm28,{sae},0xab                  }
testcase	{ 0x62, 0x03, 0x95, 0x07, 0x27, 0xf4, 0x7b                               }, { vgetmantsd xmm30{k7},xmm29,xmm28,0x7b                        }
testcase	{ 0x62, 0x03, 0x95, 0x17, 0x27, 0xf4, 0x7b                               }, { vgetmantsd xmm30{k7},xmm29,xmm28,{sae},0x7b                  }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x27, 0x31, 0x7b                               }, { vgetmantsd xmm30{k7},xmm29,QWORD [rcx],0x7b                  }
testcase	{ 0x62, 0x23, 0x95, 0x07, 0x27, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vgetmantsd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123],0x7b      }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x27, 0x72, 0x7f, 0x7b                         }, { vgetmantsd xmm30{k7},xmm29,QWORD [rdx+0x3f8],0x7b            }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x27, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vgetmantsd xmm30{k7},xmm29,QWORD [rdx+0x400],0x7b            }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x27, 0x72, 0x80, 0x7b                         }, { vgetmantsd xmm30{k7},xmm29,QWORD [rdx-0x400],0x7b            }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x27, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vgetmantsd xmm30{k7},xmm29,QWORD [rdx-0x408],0x7b            }
testcase	{ 0x62, 0x03, 0x15, 0x07, 0x27, 0xf4, 0xab                               }, { vgetmantss xmm30{k7},xmm29,xmm28,0xab                        }
testcase	{ 0x62, 0x03, 0x15, 0x87, 0x27, 0xf4, 0xab                               }, { vgetmantss xmm30{k7}{z},xmm29,xmm28,0xab                     }
testcase	{ 0x62, 0x03, 0x15, 0x17, 0x27, 0xf4, 0xab                               }, { vgetmantss xmm30{k7},xmm29,xmm28,{sae},0xab                  }
testcase	{ 0x62, 0x03, 0x15, 0x07, 0x27, 0xf4, 0x7b                               }, { vgetmantss xmm30{k7},xmm29,xmm28,0x7b                        }
testcase	{ 0x62, 0x03, 0x15, 0x17, 0x27, 0xf4, 0x7b                               }, { vgetmantss xmm30{k7},xmm29,xmm28,{sae},0x7b                  }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x27, 0x31, 0x7b                               }, { vgetmantss xmm30{k7},xmm29,DWORD [rcx],0x7b                  }
testcase	{ 0x62, 0x23, 0x15, 0x07, 0x27, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vgetmantss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123],0x7b      }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x27, 0x72, 0x7f, 0x7b                         }, { vgetmantss xmm30{k7},xmm29,DWORD [rdx+0x1fc],0x7b            }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x27, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vgetmantss xmm30{k7},xmm29,DWORD [rdx+0x200],0x7b            }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x27, 0x72, 0x80, 0x7b                         }, { vgetmantss xmm30{k7},xmm29,DWORD [rdx-0x200],0x7b            }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x27, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vgetmantss xmm30{k7},xmm29,DWORD [rdx-0x204],0x7b            }
testcase	{ 0x62, 0x03, 0x15, 0x47, 0x18, 0xf4, 0xab                               }, { vinsertf32x4 zmm30{k7},zmm29,xmm28,0xab                      }
testcase	{ 0x62, 0x03, 0x15, 0xc7, 0x18, 0xf4, 0xab                               }, { vinsertf32x4 zmm30{k7}{z},zmm29,xmm28,0xab                   }
testcase	{ 0x62, 0x03, 0x15, 0x47, 0x18, 0xf4, 0x7b                               }, { vinsertf32x4 zmm30{k7},zmm29,xmm28,0x7b                      }
testcase	{ 0x62, 0x63, 0x15, 0x47, 0x18, 0x31, 0x7b                               }, { vinsertf32x4 zmm30{k7},zmm29,OWORD [rcx],0x7b                }
testcase	{ 0x62, 0x23, 0x15, 0x47, 0x18, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vinsertf32x4 zmm30{k7},zmm29,OWORD [rax+r14*8+0x123],0x7b    }
testcase	{ 0x62, 0x63, 0x15, 0x47, 0x18, 0x72, 0x7f, 0x7b                         }, { vinsertf32x4 zmm30{k7},zmm29,OWORD [rdx+0x7f0],0x7b          }
testcase	{ 0x62, 0x63, 0x15, 0x47, 0x18, 0xb2, 0x00, 0x08, 0x00, 0x00, 0x7b       }, { vinsertf32x4 zmm30{k7},zmm29,OWORD [rdx+0x800],0x7b          }
testcase	{ 0x62, 0x63, 0x15, 0x47, 0x18, 0x72, 0x80, 0x7b                         }, { vinsertf32x4 zmm30{k7},zmm29,OWORD [rdx-0x800],0x7b          }
testcase	{ 0x62, 0x63, 0x15, 0x47, 0x18, 0xb2, 0xf0, 0xf7, 0xff, 0xff, 0x7b       }, { vinsertf32x4 zmm30{k7},zmm29,OWORD [rdx-0x810],0x7b          }
testcase	{ 0x62, 0x03, 0x95, 0x47, 0x1a, 0xf4, 0xab                               }, { vinsertf64x4 zmm30{k7},zmm29,ymm28,0xab                      }
testcase	{ 0x62, 0x03, 0x95, 0xc7, 0x1a, 0xf4, 0xab                               }, { vinsertf64x4 zmm30{k7}{z},zmm29,ymm28,0xab                   }
testcase	{ 0x62, 0x03, 0x95, 0x47, 0x1a, 0xf4, 0x7b                               }, { vinsertf64x4 zmm30{k7},zmm29,ymm28,0x7b                      }
testcase	{ 0x62, 0x63, 0x95, 0x47, 0x1a, 0x31, 0x7b                               }, { vinsertf64x4 zmm30{k7},zmm29,YWORD [rcx],0x7b                }
testcase	{ 0x62, 0x23, 0x95, 0x47, 0x1a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vinsertf64x4 zmm30{k7},zmm29,YWORD [rax+r14*8+0x123],0x7b    }
testcase	{ 0x62, 0x63, 0x95, 0x47, 0x1a, 0x72, 0x7f, 0x7b                         }, { vinsertf64x4 zmm30{k7},zmm29,YWORD [rdx+0xfe0],0x7b          }
testcase	{ 0x62, 0x63, 0x95, 0x47, 0x1a, 0xb2, 0x00, 0x10, 0x00, 0x00, 0x7b       }, { vinsertf64x4 zmm30{k7},zmm29,YWORD [rdx+0x1000],0x7b         }
testcase	{ 0x62, 0x63, 0x95, 0x47, 0x1a, 0x72, 0x80, 0x7b                         }, { vinsertf64x4 zmm30{k7},zmm29,YWORD [rdx-0x1000],0x7b         }
testcase	{ 0x62, 0x63, 0x95, 0x47, 0x1a, 0xb2, 0xe0, 0xef, 0xff, 0xff, 0x7b       }, { vinsertf64x4 zmm30{k7},zmm29,YWORD [rdx-0x1020],0x7b         }
testcase	{ 0x62, 0x03, 0x15, 0x47, 0x38, 0xf4, 0xab                               }, { vinserti32x4 zmm30{k7},zmm29,xmm28,0xab                      }
testcase	{ 0x62, 0x03, 0x15, 0xc7, 0x38, 0xf4, 0xab                               }, { vinserti32x4 zmm30{k7}{z},zmm29,xmm28,0xab                   }
testcase	{ 0x62, 0x03, 0x15, 0x47, 0x38, 0xf4, 0x7b                               }, { vinserti32x4 zmm30{k7},zmm29,xmm28,0x7b                      }
testcase	{ 0x62, 0x63, 0x15, 0x47, 0x38, 0x31, 0x7b                               }, { vinserti32x4 zmm30{k7},zmm29,OWORD [rcx],0x7b                }
testcase	{ 0x62, 0x23, 0x15, 0x47, 0x38, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vinserti32x4 zmm30{k7},zmm29,OWORD [rax+r14*8+0x123],0x7b    }
testcase	{ 0x62, 0x63, 0x15, 0x47, 0x38, 0x72, 0x7f, 0x7b                         }, { vinserti32x4 zmm30{k7},zmm29,OWORD [rdx+0x7f0],0x7b          }
testcase	{ 0x62, 0x63, 0x15, 0x47, 0x38, 0xb2, 0x00, 0x08, 0x00, 0x00, 0x7b       }, { vinserti32x4 zmm30{k7},zmm29,OWORD [rdx+0x800],0x7b          }
testcase	{ 0x62, 0x63, 0x15, 0x47, 0x38, 0x72, 0x80, 0x7b                         }, { vinserti32x4 zmm30{k7},zmm29,OWORD [rdx-0x800],0x7b          }
testcase	{ 0x62, 0x63, 0x15, 0x47, 0x38, 0xb2, 0xf0, 0xf7, 0xff, 0xff, 0x7b       }, { vinserti32x4 zmm30{k7},zmm29,OWORD [rdx-0x810],0x7b          }
testcase	{ 0x62, 0x03, 0x95, 0x47, 0x3a, 0xf4, 0xab                               }, { vinserti64x4 zmm30{k7},zmm29,ymm28,0xab                      }
testcase	{ 0x62, 0x03, 0x95, 0xc7, 0x3a, 0xf4, 0xab                               }, { vinserti64x4 zmm30{k7}{z},zmm29,ymm28,0xab                   }
testcase	{ 0x62, 0x03, 0x95, 0x47, 0x3a, 0xf4, 0x7b                               }, { vinserti64x4 zmm30{k7},zmm29,ymm28,0x7b                      }
testcase	{ 0x62, 0x63, 0x95, 0x47, 0x3a, 0x31, 0x7b                               }, { vinserti64x4 zmm30{k7},zmm29,YWORD [rcx],0x7b                }
testcase	{ 0x62, 0x23, 0x95, 0x47, 0x3a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vinserti64x4 zmm30{k7},zmm29,YWORD [rax+r14*8+0x123],0x7b    }
testcase	{ 0x62, 0x63, 0x95, 0x47, 0x3a, 0x72, 0x7f, 0x7b                         }, { vinserti64x4 zmm30{k7},zmm29,YWORD [rdx+0xfe0],0x7b          }
testcase	{ 0x62, 0x63, 0x95, 0x47, 0x3a, 0xb2, 0x00, 0x10, 0x00, 0x00, 0x7b       }, { vinserti64x4 zmm30{k7},zmm29,YWORD [rdx+0x1000],0x7b         }
testcase	{ 0x62, 0x63, 0x95, 0x47, 0x3a, 0x72, 0x80, 0x7b                         }, { vinserti64x4 zmm30{k7},zmm29,YWORD [rdx-0x1000],0x7b         }
testcase	{ 0x62, 0x63, 0x95, 0x47, 0x3a, 0xb2, 0xe0, 0xef, 0xff, 0xff, 0x7b       }, { vinserti64x4 zmm30{k7},zmm29,YWORD [rdx-0x1020],0x7b         }
testcase	{ 0x62, 0x03, 0x15, 0x00, 0x21, 0xf4, 0xab                               }, { vinsertps xmm30,xmm29,xmm28,0xab                             }
testcase	{ 0x62, 0x03, 0x15, 0x00, 0x21, 0xf4, 0x7b                               }, { vinsertps xmm30,xmm29,xmm28,0x7b                             }
testcase	{ 0x62, 0x63, 0x15, 0x00, 0x21, 0x31, 0x7b                               }, { vinsertps xmm30,xmm29,DWORD [rcx],0x7b                       }
testcase	{ 0x62, 0x23, 0x15, 0x00, 0x21, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vinsertps xmm30,xmm29,DWORD [rax+r14*8+0x123],0x7b           }
testcase	{ 0x62, 0x63, 0x15, 0x00, 0x21, 0x72, 0x7f, 0x7b                         }, { vinsertps xmm30,xmm29,DWORD [rdx+0x1fc],0x7b                 }
testcase	{ 0x62, 0x63, 0x15, 0x00, 0x21, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vinsertps xmm30,xmm29,DWORD [rdx+0x200],0x7b                 }
testcase	{ 0x62, 0x63, 0x15, 0x00, 0x21, 0x72, 0x80, 0x7b                         }, { vinsertps xmm30,xmm29,DWORD [rdx-0x200],0x7b                 }
testcase	{ 0x62, 0x63, 0x15, 0x00, 0x21, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vinsertps xmm30,xmm29,DWORD [rdx-0x204],0x7b                 }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0x5f, 0xf4                                     }, { vmaxpd zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0x5f, 0xf4                                     }, { vmaxpd zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0x5f, 0xf4                                     }, { vmaxpd zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x95, 0x10, 0x5f, 0xf4                                     }, { vmaxpd zmm30,zmm29,zmm28,{sae}                               }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5f, 0x31                                     }, { vmaxpd zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0x5f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmaxpd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5f, 0x31                                     }, { vmaxpd zmm30,zmm29,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5f, 0x72, 0x7f                               }, { vmaxpd zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5f, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmaxpd zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5f, 0x72, 0x80                               }, { vmaxpd zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5f, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmaxpd zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5f, 0x72, 0x7f                               }, { vmaxpd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5f, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vmaxpd zmm30,zmm29,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5f, 0x72, 0x80                               }, { vmaxpd zmm30,zmm29,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5f, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vmaxpd zmm30,zmm29,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x01, 0x14, 0x40, 0x5f, 0xf4                                     }, { vmaxps zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x14, 0x47, 0x5f, 0xf4                                     }, { vmaxps zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x14, 0xc7, 0x5f, 0xf4                                     }, { vmaxps zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x14, 0x10, 0x5f, 0xf4                                     }, { vmaxps zmm30,zmm29,zmm28,{sae}                               }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5f, 0x31                                     }, { vmaxps zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x14, 0x40, 0x5f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmaxps zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5f, 0x31                                     }, { vmaxps zmm30,zmm29,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5f, 0x72, 0x7f                               }, { vmaxps zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5f, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmaxps zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5f, 0x72, 0x80                               }, { vmaxps zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5f, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmaxps zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5f, 0x72, 0x7f                               }, { vmaxps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5f, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vmaxps zmm30,zmm29,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5f, 0x72, 0x80                               }, { vmaxps zmm30,zmm29,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5f, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vmaxps zmm30,zmm29,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x01, 0x97, 0x07, 0x5f, 0xf4                                     }, { vmaxsd xmm30{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x97, 0x87, 0x5f, 0xf4                                     }, { vmaxsd xmm30{k7}{z},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x97, 0x17, 0x5f, 0xf4                                     }, { vmaxsd xmm30{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5f, 0x31                                     }, { vmaxsd xmm30{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x97, 0x07, 0x5f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmaxsd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5f, 0x72, 0x7f                               }, { vmaxsd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5f, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vmaxsd xmm30{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5f, 0x72, 0x80                               }, { vmaxsd xmm30{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5f, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vmaxsd xmm30{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x01, 0x16, 0x07, 0x5f, 0xf4                                     }, { vmaxss xmm30{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x16, 0x87, 0x5f, 0xf4                                     }, { vmaxss xmm30{k7}{z},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x16, 0x17, 0x5f, 0xf4                                     }, { vmaxss xmm30{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5f, 0x31                                     }, { vmaxss xmm30{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x16, 0x07, 0x5f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmaxss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5f, 0x72, 0x7f                               }, { vmaxss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5f, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vmaxss xmm30{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5f, 0x72, 0x80                               }, { vmaxss xmm30{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5f, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vmaxss xmm30{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0x5d, 0xf4                                     }, { vminpd zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0x5d, 0xf4                                     }, { vminpd zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0x5d, 0xf4                                     }, { vminpd zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x95, 0x10, 0x5d, 0xf4                                     }, { vminpd zmm30,zmm29,zmm28,{sae}                               }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5d, 0x31                                     }, { vminpd zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0x5d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vminpd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5d, 0x31                                     }, { vminpd zmm30,zmm29,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5d, 0x72, 0x7f                               }, { vminpd zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5d, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vminpd zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5d, 0x72, 0x80                               }, { vminpd zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5d, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vminpd zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5d, 0x72, 0x7f                               }, { vminpd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5d, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vminpd zmm30,zmm29,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5d, 0x72, 0x80                               }, { vminpd zmm30,zmm29,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5d, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vminpd zmm30,zmm29,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x01, 0x14, 0x40, 0x5d, 0xf4                                     }, { vminps zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x14, 0x47, 0x5d, 0xf4                                     }, { vminps zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x14, 0xc7, 0x5d, 0xf4                                     }, { vminps zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x14, 0x10, 0x5d, 0xf4                                     }, { vminps zmm30,zmm29,zmm28,{sae}                               }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5d, 0x31                                     }, { vminps zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x14, 0x40, 0x5d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vminps zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5d, 0x31                                     }, { vminps zmm30,zmm29,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5d, 0x72, 0x7f                               }, { vminps zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5d, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vminps zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5d, 0x72, 0x80                               }, { vminps zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5d, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vminps zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5d, 0x72, 0x7f                               }, { vminps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5d, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vminps zmm30,zmm29,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5d, 0x72, 0x80                               }, { vminps zmm30,zmm29,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5d, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vminps zmm30,zmm29,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x01, 0x97, 0x07, 0x5d, 0xf4                                     }, { vminsd xmm30{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x97, 0x87, 0x5d, 0xf4                                     }, { vminsd xmm30{k7}{z},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x97, 0x17, 0x5d, 0xf4                                     }, { vminsd xmm30{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5d, 0x31                                     }, { vminsd xmm30{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x97, 0x07, 0x5d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vminsd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5d, 0x72, 0x7f                               }, { vminsd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5d, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vminsd xmm30{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5d, 0x72, 0x80                               }, { vminsd xmm30{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5d, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vminsd xmm30{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x01, 0x16, 0x07, 0x5d, 0xf4                                     }, { vminss xmm30{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x16, 0x87, 0x5d, 0xf4                                     }, { vminss xmm30{k7}{z},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x16, 0x17, 0x5d, 0xf4                                     }, { vminss xmm30{k7},xmm29,xmm28,{sae}                           }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5d, 0x31                                     }, { vminss xmm30{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x16, 0x07, 0x5d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vminss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5d, 0x72, 0x7f                               }, { vminss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5d, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vminss xmm30{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5d, 0x72, 0x80                               }, { vminss xmm30{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5d, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vminss xmm30{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x01, 0xfd, 0x48, 0x28, 0xf5                                     }, { vmovapd zmm30,zmm29                                          }
testcase	{ 0x62, 0x01, 0xfd, 0x4f, 0x28, 0xf5                                     }, { vmovapd zmm30{k7},zmm29                                      }
testcase	{ 0x62, 0x01, 0xfd, 0xcf, 0x28, 0xf5                                     }, { vmovapd zmm30{k7}{z},zmm29                                   }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x28, 0x31                                     }, { vmovapd zmm30,ZWORD [rcx]                                    }
testcase	{ 0x62, 0x21, 0xfd, 0x48, 0x28, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovapd zmm30,ZWORD [rax+r14*8+0x123]                        }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x28, 0x72, 0x7f                               }, { vmovapd zmm30,ZWORD [rdx+0x1fc0]                             }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x28, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovapd zmm30,ZWORD [rdx+0x2000]                             }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x28, 0x72, 0x80                               }, { vmovapd zmm30,ZWORD [rdx-0x2000]                             }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x28, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovapd zmm30,ZWORD [rdx-0x2040]                             }
testcase	{ 0x62, 0x01, 0x7c, 0x48, 0x28, 0xf5                                     }, { vmovaps zmm30,zmm29                                          }
testcase	{ 0x62, 0x01, 0x7c, 0x4f, 0x28, 0xf5                                     }, { vmovaps zmm30{k7},zmm29                                      }
testcase	{ 0x62, 0x01, 0x7c, 0xcf, 0x28, 0xf5                                     }, { vmovaps zmm30{k7}{z},zmm29                                   }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x28, 0x31                                     }, { vmovaps zmm30,ZWORD [rcx]                                    }
testcase	{ 0x62, 0x21, 0x7c, 0x48, 0x28, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovaps zmm30,ZWORD [rax+r14*8+0x123]                        }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x28, 0x72, 0x7f                               }, { vmovaps zmm30,ZWORD [rdx+0x1fc0]                             }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x28, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovaps zmm30,ZWORD [rdx+0x2000]                             }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x28, 0x72, 0x80                               }, { vmovaps zmm30,ZWORD [rdx-0x2000]                             }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x28, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovaps zmm30,ZWORD [rdx-0x2040]                             }
testcase	{ 0x62, 0x61, 0x7d, 0x08, 0x6e, 0xf0                                     }, { vmovd  xmm30,eax                                             }
testcase	{ 0x62, 0x61, 0x7d, 0x08, 0x6e, 0xf5                                     }, { vmovd  xmm30,ebp                                             }
testcase	{ 0x62, 0x41, 0x7d, 0x08, 0x6e, 0xf5                                     }, { vmovd  xmm30,r13d                                            }
testcase	{ 0x62, 0x61, 0x7d, 0x08, 0x6e, 0x31                                     }, { vmovd  xmm30,DWORD [rcx]                                     }
testcase	{ 0x62, 0x21, 0x7d, 0x08, 0x6e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovd  xmm30,DWORD [rax+r14*8+0x123]                         }
testcase	{ 0x62, 0x61, 0x7d, 0x08, 0x6e, 0x72, 0x7f                               }, { vmovd  xmm30,DWORD [rdx+0x1fc]                               }
testcase	{ 0x62, 0x61, 0x7d, 0x08, 0x6e, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vmovd  xmm30,DWORD [rdx+0x200]                               }
testcase	{ 0x62, 0x61, 0x7d, 0x08, 0x6e, 0x72, 0x80                               }, { vmovd  xmm30,DWORD [rdx-0x200]                               }
testcase	{ 0x62, 0x61, 0x7d, 0x08, 0x6e, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vmovd  xmm30,DWORD [rdx-0x204]                               }
testcase	{ 0x62, 0x61, 0x7d, 0x08, 0x7e, 0x31                                     }, { vmovd  DWORD [rcx],xmm30                                     }
testcase	{ 0x62, 0x21, 0x7d, 0x08, 0x7e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovd  DWORD [rax+r14*8+0x123],xmm30                         }
testcase	{ 0x62, 0x61, 0x7d, 0x08, 0x7e, 0x72, 0x7f                               }, { vmovd  DWORD [rdx+0x1fc],xmm30                               }
testcase	{ 0x62, 0x61, 0x7d, 0x08, 0x7e, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vmovd  DWORD [rdx+0x200],xmm30                               }
testcase	{ 0x62, 0x61, 0x7d, 0x08, 0x7e, 0x72, 0x80                               }, { vmovd  DWORD [rdx-0x200],xmm30                               }
testcase	{ 0x62, 0x61, 0x7d, 0x08, 0x7e, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vmovd  DWORD [rdx-0x204],xmm30                               }
testcase	{ 0x62, 0x01, 0xff, 0x48, 0x12, 0xf5                                     }, { vmovddup zmm30,zmm29                                         }
testcase	{ 0x62, 0x01, 0xff, 0x4f, 0x12, 0xf5                                     }, { vmovddup zmm30{k7},zmm29                                     }
testcase	{ 0x62, 0x01, 0xff, 0xcf, 0x12, 0xf5                                     }, { vmovddup zmm30{k7}{z},zmm29                                  }
testcase	{ 0x62, 0x61, 0xff, 0x48, 0x12, 0x31                                     }, { vmovddup zmm30,ZWORD [rcx]                                   }
testcase	{ 0x62, 0x21, 0xff, 0x48, 0x12, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovddup zmm30,ZWORD [rax+r14*8+0x123]                       }
testcase	{ 0x62, 0x61, 0xff, 0x48, 0x12, 0x72, 0x7f                               }, { vmovddup zmm30,ZWORD [rdx+0x1fc0]                            }
testcase	{ 0x62, 0x61, 0xff, 0x48, 0x12, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovddup zmm30,ZWORD [rdx+0x2000]                            }
testcase	{ 0x62, 0x61, 0xff, 0x48, 0x12, 0x72, 0x80                               }, { vmovddup zmm30,ZWORD [rdx-0x2000]                            }
testcase	{ 0x62, 0x61, 0xff, 0x48, 0x12, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovddup zmm30,ZWORD [rdx-0x2040]                            }
testcase	{ 0x62, 0x01, 0x7d, 0x48, 0x6f, 0xf5                                     }, { vmovdqa32 zmm30,zmm29                                        }
testcase	{ 0x62, 0x01, 0x7d, 0x4f, 0x6f, 0xf5                                     }, { vmovdqa32 zmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x01, 0x7d, 0xcf, 0x6f, 0xf5                                     }, { vmovdqa32 zmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x6f, 0x31                                     }, { vmovdqa32 zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x21, 0x7d, 0x48, 0x6f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovdqa32 zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x6f, 0x72, 0x7f                               }, { vmovdqa32 zmm30,ZWORD [rdx+0x1fc0]                           }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x6f, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovdqa32 zmm30,ZWORD [rdx+0x2000]                           }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x6f, 0x72, 0x80                               }, { vmovdqa32 zmm30,ZWORD [rdx-0x2000]                           }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x6f, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovdqa32 zmm30,ZWORD [rdx-0x2040]                           }
testcase	{ 0x62, 0x01, 0xfd, 0x48, 0x6f, 0xf5                                     }, { vmovdqa64 zmm30,zmm29                                        }
testcase	{ 0x62, 0x01, 0xfd, 0x4f, 0x6f, 0xf5                                     }, { vmovdqa64 zmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x01, 0xfd, 0xcf, 0x6f, 0xf5                                     }, { vmovdqa64 zmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x6f, 0x31                                     }, { vmovdqa64 zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x21, 0xfd, 0x48, 0x6f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovdqa64 zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x6f, 0x72, 0x7f                               }, { vmovdqa64 zmm30,ZWORD [rdx+0x1fc0]                           }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x6f, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovdqa64 zmm30,ZWORD [rdx+0x2000]                           }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x6f, 0x72, 0x80                               }, { vmovdqa64 zmm30,ZWORD [rdx-0x2000]                           }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x6f, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovdqa64 zmm30,ZWORD [rdx-0x2040]                           }
testcase	{ 0x62, 0x01, 0x7e, 0x48, 0x6f, 0xf5                                     }, { vmovdqu32 zmm30,zmm29                                        }
testcase	{ 0x62, 0x01, 0x7e, 0x4f, 0x6f, 0xf5                                     }, { vmovdqu32 zmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x01, 0x7e, 0xcf, 0x6f, 0xf5                                     }, { vmovdqu32 zmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x6f, 0x31                                     }, { vmovdqu32 zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x21, 0x7e, 0x48, 0x6f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovdqu32 zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x6f, 0x72, 0x7f                               }, { vmovdqu32 zmm30,ZWORD [rdx+0x1fc0]                           }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x6f, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovdqu32 zmm30,ZWORD [rdx+0x2000]                           }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x6f, 0x72, 0x80                               }, { vmovdqu32 zmm30,ZWORD [rdx-0x2000]                           }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x6f, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovdqu32 zmm30,ZWORD [rdx-0x2040]                           }
testcase	{ 0x62, 0x01, 0xfe, 0x48, 0x6f, 0xf5                                     }, { vmovdqu64 zmm30,zmm29                                        }
testcase	{ 0x62, 0x01, 0xfe, 0x4f, 0x6f, 0xf5                                     }, { vmovdqu64 zmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x01, 0xfe, 0xcf, 0x6f, 0xf5                                     }, { vmovdqu64 zmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x61, 0xfe, 0x48, 0x6f, 0x31                                     }, { vmovdqu64 zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x21, 0xfe, 0x48, 0x6f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovdqu64 zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x61, 0xfe, 0x48, 0x6f, 0x72, 0x7f                               }, { vmovdqu64 zmm30,ZWORD [rdx+0x1fc0]                           }
testcase	{ 0x62, 0x61, 0xfe, 0x48, 0x6f, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovdqu64 zmm30,ZWORD [rdx+0x2000]                           }
testcase	{ 0x62, 0x61, 0xfe, 0x48, 0x6f, 0x72, 0x80                               }, { vmovdqu64 zmm30,ZWORD [rdx-0x2000]                           }
testcase	{ 0x62, 0x61, 0xfe, 0x48, 0x6f, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovdqu64 zmm30,ZWORD [rdx-0x2040]                           }
testcase	{ 0x62, 0x01, 0x14, 0x00, 0x12, 0xf4                                     }, { vmovhlps xmm30,xmm29,xmm28                                   }
testcase	{ 0x62, 0x61, 0x8d, 0x00, 0x16, 0x29                                     }, { vmovhpd xmm29,xmm30,QWORD [rcx]                              }
testcase	{ 0x62, 0x21, 0x8d, 0x00, 0x16, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovhpd xmm29,xmm30,QWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x61, 0x8d, 0x00, 0x16, 0x6a, 0x7f                               }, { vmovhpd xmm29,xmm30,QWORD [rdx+0x3f8]                        }
testcase	{ 0x62, 0x61, 0x8d, 0x00, 0x16, 0xaa, 0x00, 0x04, 0x00, 0x00             }, { vmovhpd xmm29,xmm30,QWORD [rdx+0x400]                        }
testcase	{ 0x62, 0x61, 0x8d, 0x00, 0x16, 0x6a, 0x80                               }, { vmovhpd xmm29,xmm30,QWORD [rdx-0x400]                        }
testcase	{ 0x62, 0x61, 0x8d, 0x00, 0x16, 0xaa, 0xf8, 0xfb, 0xff, 0xff             }, { vmovhpd xmm29,xmm30,QWORD [rdx-0x408]                        }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x17, 0x31                                     }, { vmovhpd QWORD [rcx],xmm30                                    }
testcase	{ 0x62, 0x21, 0xfd, 0x08, 0x17, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovhpd QWORD [rax+r14*8+0x123],xmm30                        }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x17, 0x72, 0x7f                               }, { vmovhpd QWORD [rdx+0x3f8],xmm30                              }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x17, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vmovhpd QWORD [rdx+0x400],xmm30                              }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x17, 0x72, 0x80                               }, { vmovhpd QWORD [rdx-0x400],xmm30                              }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x17, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vmovhpd QWORD [rdx-0x408],xmm30                              }
testcase	{ 0x62, 0x61, 0x0c, 0x00, 0x16, 0x29                                     }, { vmovhps xmm29,xmm30,QWORD [rcx]                              }
testcase	{ 0x62, 0x21, 0x0c, 0x00, 0x16, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovhps xmm29,xmm30,QWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x61, 0x0c, 0x00, 0x16, 0x6a, 0x7f                               }, { vmovhps xmm29,xmm30,QWORD [rdx+0x3f8]                        }
testcase	{ 0x62, 0x61, 0x0c, 0x00, 0x16, 0xaa, 0x00, 0x04, 0x00, 0x00             }, { vmovhps xmm29,xmm30,QWORD [rdx+0x400]                        }
testcase	{ 0x62, 0x61, 0x0c, 0x00, 0x16, 0x6a, 0x80                               }, { vmovhps xmm29,xmm30,QWORD [rdx-0x400]                        }
testcase	{ 0x62, 0x61, 0x0c, 0x00, 0x16, 0xaa, 0xf8, 0xfb, 0xff, 0xff             }, { vmovhps xmm29,xmm30,QWORD [rdx-0x408]                        }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x17, 0x31                                     }, { vmovhps QWORD [rcx],xmm30                                    }
testcase	{ 0x62, 0x21, 0x7c, 0x08, 0x17, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovhps QWORD [rax+r14*8+0x123],xmm30                        }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x17, 0x72, 0x7f                               }, { vmovhps QWORD [rdx+0x3f8],xmm30                              }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x17, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vmovhps QWORD [rdx+0x400],xmm30                              }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x17, 0x72, 0x80                               }, { vmovhps QWORD [rdx-0x400],xmm30                              }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x17, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vmovhps QWORD [rdx-0x408],xmm30                              }
testcase	{ 0x62, 0x01, 0x14, 0x00, 0x16, 0xf4                                     }, { vmovlhps xmm30,xmm29,xmm28                                   }
testcase	{ 0x62, 0x61, 0x8d, 0x00, 0x12, 0x29                                     }, { vmovlpd xmm29,xmm30,QWORD [rcx]                              }
testcase	{ 0x62, 0x21, 0x8d, 0x00, 0x12, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovlpd xmm29,xmm30,QWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x61, 0x8d, 0x00, 0x12, 0x6a, 0x7f                               }, { vmovlpd xmm29,xmm30,QWORD [rdx+0x3f8]                        }
testcase	{ 0x62, 0x61, 0x8d, 0x00, 0x12, 0xaa, 0x00, 0x04, 0x00, 0x00             }, { vmovlpd xmm29,xmm30,QWORD [rdx+0x400]                        }
testcase	{ 0x62, 0x61, 0x8d, 0x00, 0x12, 0x6a, 0x80                               }, { vmovlpd xmm29,xmm30,QWORD [rdx-0x400]                        }
testcase	{ 0x62, 0x61, 0x8d, 0x00, 0x12, 0xaa, 0xf8, 0xfb, 0xff, 0xff             }, { vmovlpd xmm29,xmm30,QWORD [rdx-0x408]                        }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x13, 0x31                                     }, { vmovlpd QWORD [rcx],xmm30                                    }
testcase	{ 0x62, 0x21, 0xfd, 0x08, 0x13, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovlpd QWORD [rax+r14*8+0x123],xmm30                        }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x13, 0x72, 0x7f                               }, { vmovlpd QWORD [rdx+0x3f8],xmm30                              }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x13, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vmovlpd QWORD [rdx+0x400],xmm30                              }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x13, 0x72, 0x80                               }, { vmovlpd QWORD [rdx-0x400],xmm30                              }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x13, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vmovlpd QWORD [rdx-0x408],xmm30                              }
testcase	{ 0x62, 0x61, 0x0c, 0x00, 0x12, 0x29                                     }, { vmovlps xmm29,xmm30,QWORD [rcx]                              }
testcase	{ 0x62, 0x21, 0x0c, 0x00, 0x12, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovlps xmm29,xmm30,QWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x61, 0x0c, 0x00, 0x12, 0x6a, 0x7f                               }, { vmovlps xmm29,xmm30,QWORD [rdx+0x3f8]                        }
testcase	{ 0x62, 0x61, 0x0c, 0x00, 0x12, 0xaa, 0x00, 0x04, 0x00, 0x00             }, { vmovlps xmm29,xmm30,QWORD [rdx+0x400]                        }
testcase	{ 0x62, 0x61, 0x0c, 0x00, 0x12, 0x6a, 0x80                               }, { vmovlps xmm29,xmm30,QWORD [rdx-0x400]                        }
testcase	{ 0x62, 0x61, 0x0c, 0x00, 0x12, 0xaa, 0xf8, 0xfb, 0xff, 0xff             }, { vmovlps xmm29,xmm30,QWORD [rdx-0x408]                        }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x13, 0x31                                     }, { vmovlps QWORD [rcx],xmm30                                    }
testcase	{ 0x62, 0x21, 0x7c, 0x08, 0x13, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovlps QWORD [rax+r14*8+0x123],xmm30                        }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x13, 0x72, 0x7f                               }, { vmovlps QWORD [rdx+0x3f8],xmm30                              }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x13, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vmovlps QWORD [rdx+0x400],xmm30                              }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x13, 0x72, 0x80                               }, { vmovlps QWORD [rdx-0x400],xmm30                              }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x13, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vmovlps QWORD [rdx-0x408],xmm30                              }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0xe7, 0x31                                     }, { vmovntdq ZWORD [rcx],zmm30                                   }
testcase	{ 0x62, 0x21, 0x7d, 0x48, 0xe7, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovntdq ZWORD [rax+r14*8+0x123],zmm30                       }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0xe7, 0x72, 0x7f                               }, { vmovntdq ZWORD [rdx+0x1fc0],zmm30                            }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0xe7, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovntdq ZWORD [rdx+0x2000],zmm30                            }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0xe7, 0x72, 0x80                               }, { vmovntdq ZWORD [rdx-0x2000],zmm30                            }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0xe7, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovntdq ZWORD [rdx-0x2040],zmm30                            }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x2a, 0x31                                     }, { vmovntdqa zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x22, 0x7d, 0x48, 0x2a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovntdqa zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x2a, 0x72, 0x7f                               }, { vmovntdqa zmm30,ZWORD [rdx+0x1fc0]                           }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x2a, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovntdqa zmm30,ZWORD [rdx+0x2000]                           }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x2a, 0x72, 0x80                               }, { vmovntdqa zmm30,ZWORD [rdx-0x2000]                           }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x2a, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovntdqa zmm30,ZWORD [rdx-0x2040]                           }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x2b, 0x31                                     }, { vmovntpd ZWORD [rcx],zmm30                                   }
testcase	{ 0x62, 0x21, 0xfd, 0x48, 0x2b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovntpd ZWORD [rax+r14*8+0x123],zmm30                       }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x2b, 0x72, 0x7f                               }, { vmovntpd ZWORD [rdx+0x1fc0],zmm30                            }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x2b, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovntpd ZWORD [rdx+0x2000],zmm30                            }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x2b, 0x72, 0x80                               }, { vmovntpd ZWORD [rdx-0x2000],zmm30                            }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x2b, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovntpd ZWORD [rdx-0x2040],zmm30                            }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x2b, 0x31                                     }, { vmovntps ZWORD [rcx],zmm30                                   }
testcase	{ 0x62, 0x21, 0x7c, 0x48, 0x2b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovntps ZWORD [rax+r14*8+0x123],zmm30                       }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x2b, 0x72, 0x7f                               }, { vmovntps ZWORD [rdx+0x1fc0],zmm30                            }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x2b, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovntps ZWORD [rdx+0x2000],zmm30                            }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x2b, 0x72, 0x80                               }, { vmovntps ZWORD [rdx-0x2000],zmm30                            }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x2b, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovntps ZWORD [rdx-0x2040],zmm30                            }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x6e, 0xf0                                     }, { vmovq  xmm30,rax                                             }
testcase	{ 0x62, 0x41, 0xfd, 0x08, 0x6e, 0xf0                                     }, { vmovq  xmm30,r8                                              }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x6e, 0x31                                     }, { vmovq  xmm30,QWORD [rcx]                                     }
testcase	{ 0x62, 0x21, 0xfd, 0x08, 0x6e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovq  xmm30,QWORD [rax+r14*8+0x123]                         }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x6e, 0x72, 0x7f                               }, { vmovq  xmm30,QWORD [rdx+0x3f8]                               }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x6e, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vmovq  xmm30,QWORD [rdx+0x400]                               }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x6e, 0x72, 0x80                               }, { vmovq  xmm30,QWORD [rdx-0x400]                               }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x6e, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vmovq  xmm30,QWORD [rdx-0x408]                               }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x7e, 0x31                                     }, { vmovq  QWORD [rcx],xmm30                                     }
testcase	{ 0x62, 0x21, 0xfd, 0x08, 0x7e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovq  QWORD [rax+r14*8+0x123],xmm30                         }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x7e, 0x72, 0x7f                               }, { vmovq  QWORD [rdx+0x3f8],xmm30                               }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x7e, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vmovq  QWORD [rdx+0x400],xmm30                               }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x7e, 0x72, 0x80                               }, { vmovq  QWORD [rdx-0x400],xmm30                               }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x7e, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vmovq  QWORD [rdx-0x408],xmm30                               }
testcase	{ 0x62, 0x01, 0xfe, 0x08, 0x7e, 0xf5                                     }, { vmovq  xmm30,xmm29                                           }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x6e, 0x31                                     }, { vmovq  xmm30,QWORD [rcx]                                     }
testcase	{ 0x62, 0x21, 0xfd, 0x08, 0x6e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovq  xmm30,QWORD [rax+r14*8+0x123]                         }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x6e, 0x72, 0x7f                               }, { vmovq  xmm30,QWORD [rdx+0x3f8]                               }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x6e, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vmovq  xmm30,QWORD [rdx+0x400]                               }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x6e, 0x72, 0x80                               }, { vmovq  xmm30,QWORD [rdx-0x400]                               }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x6e, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vmovq  xmm30,QWORD [rdx-0x408]                               }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x7e, 0x29                                     }, { vmovq  QWORD [rcx],xmm29                                     }
testcase	{ 0x62, 0x21, 0xfd, 0x08, 0x7e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovq  QWORD [rax+r14*8+0x123],xmm29                         }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x7e, 0x6a, 0x7f                               }, { vmovq  QWORD [rdx+0x3f8],xmm29                               }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x7e, 0xaa, 0x00, 0x04, 0x00, 0x00             }, { vmovq  QWORD [rdx+0x400],xmm29                               }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x7e, 0x6a, 0x80                               }, { vmovq  QWORD [rdx-0x400],xmm29                               }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x7e, 0xaa, 0xf8, 0xfb, 0xff, 0xff             }, { vmovq  QWORD [rdx-0x408],xmm29                               }
testcase	{ 0x62, 0x61, 0xff, 0x0f, 0x10, 0x31                                     }, { vmovsd xmm30{k7},QWORD [rcx]                                 }
testcase	{ 0x62, 0x61, 0xff, 0x8f, 0x10, 0x31                                     }, { vmovsd xmm30{k7}{z},QWORD [rcx]                              }
testcase	{ 0x62, 0x21, 0xff, 0x0f, 0x10, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovsd xmm30{k7},QWORD [rax+r14*8+0x123]                     }
testcase	{ 0x62, 0x61, 0xff, 0x0f, 0x10, 0x72, 0x7f                               }, { vmovsd xmm30{k7},QWORD [rdx+0x3f8]                           }
testcase	{ 0x62, 0x61, 0xff, 0x0f, 0x10, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vmovsd xmm30{k7},QWORD [rdx+0x400]                           }
testcase	{ 0x62, 0x61, 0xff, 0x0f, 0x10, 0x72, 0x80                               }, { vmovsd xmm30{k7},QWORD [rdx-0x400]                           }
testcase	{ 0x62, 0x61, 0xff, 0x0f, 0x10, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vmovsd xmm30{k7},QWORD [rdx-0x408]                           }
testcase	{ 0x62, 0x61, 0xff, 0x0f, 0x11, 0x31                                     }, { vmovsd QWORD [rcx]{k7},xmm30                                 }
testcase	{ 0x62, 0x21, 0xff, 0x0f, 0x11, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovsd QWORD [rax+r14*8+0x123]{k7},xmm30                     }
testcase	{ 0x62, 0x61, 0xff, 0x0f, 0x11, 0x72, 0x7f                               }, { vmovsd QWORD [rdx+0x3f8]{k7},xmm30                           }
testcase	{ 0x62, 0x61, 0xff, 0x0f, 0x11, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vmovsd QWORD [rdx+0x400]{k7},xmm30                           }
testcase	{ 0x62, 0x61, 0xff, 0x0f, 0x11, 0x72, 0x80                               }, { vmovsd QWORD [rdx-0x400]{k7},xmm30                           }
testcase	{ 0x62, 0x61, 0xff, 0x0f, 0x11, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vmovsd QWORD [rdx-0x408]{k7},xmm30                           }
testcase	{ 0x62, 0x01, 0x97, 0x07, 0x10, 0xf4                                     }, { vmovsd xmm30{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x97, 0x87, 0x10, 0xf4                                     }, { vmovsd xmm30{k7}{z},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x7e, 0x48, 0x16, 0xf5                                     }, { vmovshdup zmm30,zmm29                                        }
testcase	{ 0x62, 0x01, 0x7e, 0x4f, 0x16, 0xf5                                     }, { vmovshdup zmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x01, 0x7e, 0xcf, 0x16, 0xf5                                     }, { vmovshdup zmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x16, 0x31                                     }, { vmovshdup zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x21, 0x7e, 0x48, 0x16, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovshdup zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x16, 0x72, 0x7f                               }, { vmovshdup zmm30,ZWORD [rdx+0x1fc0]                           }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x16, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovshdup zmm30,ZWORD [rdx+0x2000]                           }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x16, 0x72, 0x80                               }, { vmovshdup zmm30,ZWORD [rdx-0x2000]                           }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x16, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovshdup zmm30,ZWORD [rdx-0x2040]                           }
testcase	{ 0x62, 0x01, 0x7e, 0x48, 0x12, 0xf5                                     }, { vmovsldup zmm30,zmm29                                        }
testcase	{ 0x62, 0x01, 0x7e, 0x4f, 0x12, 0xf5                                     }, { vmovsldup zmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x01, 0x7e, 0xcf, 0x12, 0xf5                                     }, { vmovsldup zmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x12, 0x31                                     }, { vmovsldup zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x21, 0x7e, 0x48, 0x12, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovsldup zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x12, 0x72, 0x7f                               }, { vmovsldup zmm30,ZWORD [rdx+0x1fc0]                           }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x12, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovsldup zmm30,ZWORD [rdx+0x2000]                           }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x12, 0x72, 0x80                               }, { vmovsldup zmm30,ZWORD [rdx-0x2000]                           }
testcase	{ 0x62, 0x61, 0x7e, 0x48, 0x12, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovsldup zmm30,ZWORD [rdx-0x2040]                           }
testcase	{ 0x62, 0x61, 0x7e, 0x0f, 0x10, 0x31                                     }, { vmovss xmm30{k7},DWORD [rcx]                                 }
testcase	{ 0x62, 0x61, 0x7e, 0x8f, 0x10, 0x31                                     }, { vmovss xmm30{k7}{z},DWORD [rcx]                              }
testcase	{ 0x62, 0x21, 0x7e, 0x0f, 0x10, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovss xmm30{k7},DWORD [rax+r14*8+0x123]                     }
testcase	{ 0x62, 0x61, 0x7e, 0x0f, 0x10, 0x72, 0x7f                               }, { vmovss xmm30{k7},DWORD [rdx+0x1fc]                           }
testcase	{ 0x62, 0x61, 0x7e, 0x0f, 0x10, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vmovss xmm30{k7},DWORD [rdx+0x200]                           }
testcase	{ 0x62, 0x61, 0x7e, 0x0f, 0x10, 0x72, 0x80                               }, { vmovss xmm30{k7},DWORD [rdx-0x200]                           }
testcase	{ 0x62, 0x61, 0x7e, 0x0f, 0x10, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vmovss xmm30{k7},DWORD [rdx-0x204]                           }
testcase	{ 0x62, 0x61, 0x7e, 0x0f, 0x11, 0x31                                     }, { vmovss DWORD [rcx]{k7},xmm30                                 }
testcase	{ 0x62, 0x21, 0x7e, 0x0f, 0x11, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovss DWORD [rax+r14*8+0x123]{k7},xmm30                     }
testcase	{ 0x62, 0x61, 0x7e, 0x0f, 0x11, 0x72, 0x7f                               }, { vmovss DWORD [rdx+0x1fc]{k7},xmm30                           }
testcase	{ 0x62, 0x61, 0x7e, 0x0f, 0x11, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vmovss DWORD [rdx+0x200]{k7},xmm30                           }
testcase	{ 0x62, 0x61, 0x7e, 0x0f, 0x11, 0x72, 0x80                               }, { vmovss DWORD [rdx-0x200]{k7},xmm30                           }
testcase	{ 0x62, 0x61, 0x7e, 0x0f, 0x11, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vmovss DWORD [rdx-0x204]{k7},xmm30                           }
testcase	{ 0x62, 0x01, 0x16, 0x07, 0x10, 0xf4                                     }, { vmovss xmm30{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x16, 0x87, 0x10, 0xf4                                     }, { vmovss xmm30{k7}{z},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0xfd, 0x48, 0x10, 0xf5                                     }, { vmovupd zmm30,zmm29                                          }
testcase	{ 0x62, 0x01, 0xfd, 0x4f, 0x10, 0xf5                                     }, { vmovupd zmm30{k7},zmm29                                      }
testcase	{ 0x62, 0x01, 0xfd, 0xcf, 0x10, 0xf5                                     }, { vmovupd zmm30{k7}{z},zmm29                                   }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x10, 0x31                                     }, { vmovupd zmm30,ZWORD [rcx]                                    }
testcase	{ 0x62, 0x21, 0xfd, 0x48, 0x10, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovupd zmm30,ZWORD [rax+r14*8+0x123]                        }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x10, 0x72, 0x7f                               }, { vmovupd zmm30,ZWORD [rdx+0x1fc0]                             }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x10, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovupd zmm30,ZWORD [rdx+0x2000]                             }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x10, 0x72, 0x80                               }, { vmovupd zmm30,ZWORD [rdx-0x2000]                             }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x10, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovupd zmm30,ZWORD [rdx-0x2040]                             }
testcase	{ 0x62, 0x01, 0x7c, 0x48, 0x10, 0xf5                                     }, { vmovups zmm30,zmm29                                          }
testcase	{ 0x62, 0x01, 0x7c, 0x4f, 0x10, 0xf5                                     }, { vmovups zmm30{k7},zmm29                                      }
testcase	{ 0x62, 0x01, 0x7c, 0xcf, 0x10, 0xf5                                     }, { vmovups zmm30{k7}{z},zmm29                                   }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x10, 0x31                                     }, { vmovups zmm30,ZWORD [rcx]                                    }
testcase	{ 0x62, 0x21, 0x7c, 0x48, 0x10, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovups zmm30,ZWORD [rax+r14*8+0x123]                        }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x10, 0x72, 0x7f                               }, { vmovups zmm30,ZWORD [rdx+0x1fc0]                             }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x10, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovups zmm30,ZWORD [rdx+0x2000]                             }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x10, 0x72, 0x80                               }, { vmovups zmm30,ZWORD [rdx-0x2000]                             }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x10, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovups zmm30,ZWORD [rdx-0x2040]                             }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0x59, 0xf4                                     }, { vmulpd zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0x59, 0xf4                                     }, { vmulpd zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0x59, 0xf4                                     }, { vmulpd zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x95, 0x10, 0x59, 0xf4                                     }, { vmulpd zmm30,zmm29,zmm28,{rn-sae}                            }
testcase	{ 0x62, 0x01, 0x95, 0x50, 0x59, 0xf4                                     }, { vmulpd zmm30,zmm29,zmm28,{ru-sae}                            }
testcase	{ 0x62, 0x01, 0x95, 0x30, 0x59, 0xf4                                     }, { vmulpd zmm30,zmm29,zmm28,{rd-sae}                            }
testcase	{ 0x62, 0x01, 0x95, 0x70, 0x59, 0xf4                                     }, { vmulpd zmm30,zmm29,zmm28,{rz-sae}                            }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x59, 0x31                                     }, { vmulpd zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0x59, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmulpd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x59, 0x31                                     }, { vmulpd zmm30,zmm29,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x59, 0x72, 0x7f                               }, { vmulpd zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x59, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmulpd zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x59, 0x72, 0x80                               }, { vmulpd zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x59, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmulpd zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x59, 0x72, 0x7f                               }, { vmulpd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x59, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vmulpd zmm30,zmm29,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x59, 0x72, 0x80                               }, { vmulpd zmm30,zmm29,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x59, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vmulpd zmm30,zmm29,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x01, 0x14, 0x40, 0x59, 0xf4                                     }, { vmulps zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x14, 0x47, 0x59, 0xf4                                     }, { vmulps zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x14, 0xc7, 0x59, 0xf4                                     }, { vmulps zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x14, 0x10, 0x59, 0xf4                                     }, { vmulps zmm30,zmm29,zmm28,{rn-sae}                            }
testcase	{ 0x62, 0x01, 0x14, 0x50, 0x59, 0xf4                                     }, { vmulps zmm30,zmm29,zmm28,{ru-sae}                            }
testcase	{ 0x62, 0x01, 0x14, 0x30, 0x59, 0xf4                                     }, { vmulps zmm30,zmm29,zmm28,{rd-sae}                            }
testcase	{ 0x62, 0x01, 0x14, 0x70, 0x59, 0xf4                                     }, { vmulps zmm30,zmm29,zmm28,{rz-sae}                            }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x59, 0x31                                     }, { vmulps zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x14, 0x40, 0x59, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmulps zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x59, 0x31                                     }, { vmulps zmm30,zmm29,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x59, 0x72, 0x7f                               }, { vmulps zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x59, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmulps zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x59, 0x72, 0x80                               }, { vmulps zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x59, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmulps zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x59, 0x72, 0x7f                               }, { vmulps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x59, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vmulps zmm30,zmm29,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x59, 0x72, 0x80                               }, { vmulps zmm30,zmm29,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x59, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vmulps zmm30,zmm29,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x01, 0x97, 0x07, 0x59, 0xf4                                     }, { vmulsd xmm30{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x97, 0x87, 0x59, 0xf4                                     }, { vmulsd xmm30{k7}{z},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x97, 0x17, 0x59, 0xf4                                     }, { vmulsd xmm30{k7},xmm29,xmm28,{rn-sae}                        }
testcase	{ 0x62, 0x01, 0x97, 0x57, 0x59, 0xf4                                     }, { vmulsd xmm30{k7},xmm29,xmm28,{ru-sae}                        }
testcase	{ 0x62, 0x01, 0x97, 0x37, 0x59, 0xf4                                     }, { vmulsd xmm30{k7},xmm29,xmm28,{rd-sae}                        }
testcase	{ 0x62, 0x01, 0x97, 0x77, 0x59, 0xf4                                     }, { vmulsd xmm30{k7},xmm29,xmm28,{rz-sae}                        }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x59, 0x31                                     }, { vmulsd xmm30{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x97, 0x07, 0x59, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmulsd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x59, 0x72, 0x7f                               }, { vmulsd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x59, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vmulsd xmm30{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x59, 0x72, 0x80                               }, { vmulsd xmm30{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x59, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vmulsd xmm30{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x01, 0x16, 0x07, 0x59, 0xf4                                     }, { vmulss xmm30{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x16, 0x87, 0x59, 0xf4                                     }, { vmulss xmm30{k7}{z},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x16, 0x17, 0x59, 0xf4                                     }, { vmulss xmm30{k7},xmm29,xmm28,{rn-sae}                        }
testcase	{ 0x62, 0x01, 0x16, 0x57, 0x59, 0xf4                                     }, { vmulss xmm30{k7},xmm29,xmm28,{ru-sae}                        }
testcase	{ 0x62, 0x01, 0x16, 0x37, 0x59, 0xf4                                     }, { vmulss xmm30{k7},xmm29,xmm28,{rd-sae}                        }
testcase	{ 0x62, 0x01, 0x16, 0x77, 0x59, 0xf4                                     }, { vmulss xmm30{k7},xmm29,xmm28,{rz-sae}                        }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x59, 0x31                                     }, { vmulss xmm30{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x16, 0x07, 0x59, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmulss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x59, 0x72, 0x7f                               }, { vmulss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x59, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vmulss xmm30{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x59, 0x72, 0x80                               }, { vmulss xmm30{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x59, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vmulss xmm30{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x02, 0x7d, 0x48, 0x1e, 0xf5                                     }, { vpabsd zmm30,zmm29                                           }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x1e, 0xf5                                     }, { vpabsd zmm30{k7},zmm29                                       }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x1e, 0xf5                                     }, { vpabsd zmm30{k7}{z},zmm29                                    }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x1e, 0x31                                     }, { vpabsd zmm30,ZWORD [rcx]                                     }
testcase	{ 0x62, 0x22, 0x7d, 0x48, 0x1e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpabsd zmm30,ZWORD [rax+r14*8+0x123]                         }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x1e, 0x31                                     }, { vpabsd zmm30,DWORD [rcx]{1to16}                              }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x1e, 0x72, 0x7f                               }, { vpabsd zmm30,ZWORD [rdx+0x1fc0]                              }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x1e, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpabsd zmm30,ZWORD [rdx+0x2000]                              }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x1e, 0x72, 0x80                               }, { vpabsd zmm30,ZWORD [rdx-0x2000]                              }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x1e, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpabsd zmm30,ZWORD [rdx-0x2040]                              }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x1e, 0x72, 0x7f                               }, { vpabsd zmm30,DWORD [rdx+0x1fc]{1to16}                        }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x1e, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpabsd zmm30,DWORD [rdx+0x200]{1to16}                        }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x1e, 0x72, 0x80                               }, { vpabsd zmm30,DWORD [rdx-0x200]{1to16}                        }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x1e, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpabsd zmm30,DWORD [rdx-0x204]{1to16}                        }
testcase	{ 0x62, 0x02, 0xfd, 0x48, 0x1f, 0xf5                                     }, { vpabsq zmm30,zmm29                                           }
testcase	{ 0x62, 0x02, 0xfd, 0x4f, 0x1f, 0xf5                                     }, { vpabsq zmm30{k7},zmm29                                       }
testcase	{ 0x62, 0x02, 0xfd, 0xcf, 0x1f, 0xf5                                     }, { vpabsq zmm30{k7}{z},zmm29                                    }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x1f, 0x31                                     }, { vpabsq zmm30,ZWORD [rcx]                                     }
testcase	{ 0x62, 0x22, 0xfd, 0x48, 0x1f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpabsq zmm30,ZWORD [rax+r14*8+0x123]                         }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x1f, 0x31                                     }, { vpabsq zmm30,QWORD [rcx]{1to8}                               }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x1f, 0x72, 0x7f                               }, { vpabsq zmm30,ZWORD [rdx+0x1fc0]                              }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x1f, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpabsq zmm30,ZWORD [rdx+0x2000]                              }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x1f, 0x72, 0x80                               }, { vpabsq zmm30,ZWORD [rdx-0x2000]                              }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x1f, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpabsq zmm30,ZWORD [rdx-0x2040]                              }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x1f, 0x72, 0x7f                               }, { vpabsq zmm30,QWORD [rdx+0x3f8]{1to8}                         }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x1f, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpabsq zmm30,QWORD [rdx+0x400]{1to8}                         }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x1f, 0x72, 0x80                               }, { vpabsq zmm30,QWORD [rdx-0x400]{1to8}                         }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x1f, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpabsq zmm30,QWORD [rdx-0x408]{1to8}                         }
testcase	{ 0x62, 0x01, 0x15, 0x40, 0xfe, 0xf4                                     }, { vpaddd zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x15, 0x47, 0xfe, 0xf4                                     }, { vpaddd zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x15, 0xc7, 0xfe, 0xf4                                     }, { vpaddd zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xfe, 0x31                                     }, { vpaddd zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x15, 0x40, 0xfe, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpaddd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xfe, 0x31                                     }, { vpaddd zmm30,zmm29,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xfe, 0x72, 0x7f                               }, { vpaddd zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xfe, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpaddd zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xfe, 0x72, 0x80                               }, { vpaddd zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xfe, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpaddd zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xfe, 0x72, 0x7f                               }, { vpaddd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xfe, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpaddd zmm30,zmm29,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xfe, 0x72, 0x80                               }, { vpaddd zmm30,zmm29,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xfe, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpaddd zmm30,zmm29,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0xd4, 0xf4                                     }, { vpaddq zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0xd4, 0xf4                                     }, { vpaddq zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0xd4, 0xf4                                     }, { vpaddq zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xd4, 0x31                                     }, { vpaddq zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0xd4, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpaddq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xd4, 0x31                                     }, { vpaddq zmm30,zmm29,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xd4, 0x72, 0x7f                               }, { vpaddq zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xd4, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpaddq zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xd4, 0x72, 0x80                               }, { vpaddq zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xd4, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpaddq zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xd4, 0x72, 0x7f                               }, { vpaddq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xd4, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpaddq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xd4, 0x72, 0x80                               }, { vpaddq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xd4, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpaddq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x01, 0x15, 0x40, 0xdb, 0xf4                                     }, { vpandd zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x15, 0x47, 0xdb, 0xf4                                     }, { vpandd zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x15, 0xc7, 0xdb, 0xf4                                     }, { vpandd zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xdb, 0x31                                     }, { vpandd zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x15, 0x40, 0xdb, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpandd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xdb, 0x31                                     }, { vpandd zmm30,zmm29,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xdb, 0x72, 0x7f                               }, { vpandd zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xdb, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpandd zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xdb, 0x72, 0x80                               }, { vpandd zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xdb, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpandd zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xdb, 0x72, 0x7f                               }, { vpandd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xdb, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpandd zmm30,zmm29,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xdb, 0x72, 0x80                               }, { vpandd zmm30,zmm29,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xdb, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpandd zmm30,zmm29,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x01, 0x15, 0x40, 0xdf, 0xf4                                     }, { vpandnd zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x01, 0x15, 0x47, 0xdf, 0xf4                                     }, { vpandnd zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x01, 0x15, 0xc7, 0xdf, 0xf4                                     }, { vpandnd zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xdf, 0x31                                     }, { vpandnd zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x21, 0x15, 0x40, 0xdf, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpandnd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xdf, 0x31                                     }, { vpandnd zmm30,zmm29,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xdf, 0x72, 0x7f                               }, { vpandnd zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xdf, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpandnd zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xdf, 0x72, 0x80                               }, { vpandnd zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xdf, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpandnd zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xdf, 0x72, 0x7f                               }, { vpandnd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xdf, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpandnd zmm30,zmm29,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xdf, 0x72, 0x80                               }, { vpandnd zmm30,zmm29,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xdf, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpandnd zmm30,zmm29,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0xdf, 0xf4                                     }, { vpandnq zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0xdf, 0xf4                                     }, { vpandnq zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0xdf, 0xf4                                     }, { vpandnq zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xdf, 0x31                                     }, { vpandnq zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0xdf, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpandnq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xdf, 0x31                                     }, { vpandnq zmm30,zmm29,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xdf, 0x72, 0x7f                               }, { vpandnq zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xdf, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpandnq zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xdf, 0x72, 0x80                               }, { vpandnq zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xdf, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpandnq zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xdf, 0x72, 0x7f                               }, { vpandnq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xdf, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpandnq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xdf, 0x72, 0x80                               }, { vpandnq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xdf, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpandnq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0xdb, 0xf4                                     }, { vpandq zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0xdb, 0xf4                                     }, { vpandq zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0xdb, 0xf4                                     }, { vpandq zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xdb, 0x31                                     }, { vpandq zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0xdb, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpandq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xdb, 0x31                                     }, { vpandq zmm30,zmm29,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xdb, 0x72, 0x7f                               }, { vpandq zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xdb, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpandq zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xdb, 0x72, 0x80                               }, { vpandq zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xdb, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpandq zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xdb, 0x72, 0x7f                               }, { vpandq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xdb, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpandq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xdb, 0x72, 0x80                               }, { vpandq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xdb, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpandq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x64, 0xf4                                     }, { vpblendmd zmm30,zmm29,zmm28                                  }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x64, 0xf4                                     }, { vpblendmd zmm30{k7},zmm29,zmm28                              }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x64, 0xf4                                     }, { vpblendmd zmm30{k7}{z},zmm29,zmm28                           }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x64, 0x31                                     }, { vpblendmd zmm30,zmm29,ZWORD [rcx]                            }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x64, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpblendmd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x64, 0x31                                     }, { vpblendmd zmm30,zmm29,DWORD [rcx]{1to16}                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x64, 0x72, 0x7f                               }, { vpblendmd zmm30,zmm29,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x64, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpblendmd zmm30,zmm29,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x64, 0x72, 0x80                               }, { vpblendmd zmm30,zmm29,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x64, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpblendmd zmm30,zmm29,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x64, 0x72, 0x7f                               }, { vpblendmd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x64, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpblendmd zmm30,zmm29,DWORD [rdx+0x200]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x64, 0x72, 0x80                               }, { vpblendmd zmm30,zmm29,DWORD [rdx-0x200]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x64, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpblendmd zmm30,zmm29,DWORD [rdx-0x204]{1to16}               }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x58, 0x31                                     }, { vpbroadcastd zmm30,DWORD [rcx]                               }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x58, 0x31                                     }, { vpbroadcastd zmm30{k7},DWORD [rcx]                           }
testcase	{ 0x62, 0x62, 0x7d, 0xcf, 0x58, 0x31                                     }, { vpbroadcastd zmm30{k7}{z},DWORD [rcx]                        }
testcase	{ 0x62, 0x22, 0x7d, 0x48, 0x58, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpbroadcastd zmm30,DWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x58, 0x72, 0x7f                               }, { vpbroadcastd zmm30,DWORD [rdx+0x1fc]                         }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x58, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpbroadcastd zmm30,DWORD [rdx+0x200]                         }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x58, 0x72, 0x80                               }, { vpbroadcastd zmm30,DWORD [rdx-0x200]                         }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x58, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpbroadcastd zmm30,DWORD [rdx-0x204]                         }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x58, 0xf5                                     }, { vpbroadcastd zmm30{k7},xmm29                                 }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x58, 0xf5                                     }, { vpbroadcastd zmm30{k7}{z},xmm29                              }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x7c, 0xf0                                     }, { vpbroadcastd zmm30,eax                                       }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x7c, 0xf0                                     }, { vpbroadcastd zmm30{k7},eax                                   }
testcase	{ 0x62, 0x62, 0x7d, 0xcf, 0x7c, 0xf0                                     }, { vpbroadcastd zmm30{k7}{z},eax                                }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x7c, 0xf5                                     }, { vpbroadcastd zmm30,ebp                                       }
testcase	{ 0x62, 0x42, 0x7d, 0x48, 0x7c, 0xf5                                     }, { vpbroadcastd zmm30,r13d                                      }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x59, 0x31                                     }, { vpbroadcastq zmm30,QWORD [rcx]                               }
testcase	{ 0x62, 0x62, 0xfd, 0x4f, 0x59, 0x31                                     }, { vpbroadcastq zmm30{k7},QWORD [rcx]                           }
testcase	{ 0x62, 0x62, 0xfd, 0xcf, 0x59, 0x31                                     }, { vpbroadcastq zmm30{k7}{z},QWORD [rcx]                        }
testcase	{ 0x62, 0x22, 0xfd, 0x48, 0x59, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpbroadcastq zmm30,QWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x59, 0x72, 0x7f                               }, { vpbroadcastq zmm30,QWORD [rdx+0x3f8]                         }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x59, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpbroadcastq zmm30,QWORD [rdx+0x400]                         }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x59, 0x72, 0x80                               }, { vpbroadcastq zmm30,QWORD [rdx-0x400]                         }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x59, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpbroadcastq zmm30,QWORD [rdx-0x408]                         }
testcase	{ 0x62, 0x02, 0xfd, 0x4f, 0x59, 0xf5                                     }, { vpbroadcastq zmm30{k7},xmm29                                 }
testcase	{ 0x62, 0x02, 0xfd, 0xcf, 0x59, 0xf5                                     }, { vpbroadcastq zmm30{k7}{z},xmm29                              }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x7c, 0xf0                                     }, { vpbroadcastq zmm30,rax                                       }
testcase	{ 0x62, 0x62, 0xfd, 0x4f, 0x7c, 0xf0                                     }, { vpbroadcastq zmm30{k7},rax                                   }
testcase	{ 0x62, 0x62, 0xfd, 0xcf, 0x7c, 0xf0                                     }, { vpbroadcastq zmm30{k7}{z},rax                                }
testcase	{ 0x62, 0x42, 0xfd, 0x48, 0x7c, 0xf0                                     }, { vpbroadcastq zmm30,r8                                        }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1f, 0xed, 0xab                               }, { vpcmpd k5,zmm30,zmm29,0xab                                   }
testcase	{ 0x62, 0x93, 0x0d, 0x47, 0x1f, 0xed, 0xab                               }, { vpcmpd k5{k7},zmm30,zmm29,0xab                               }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1f, 0xed, 0x7b                               }, { vpcmpd k5,zmm30,zmm29,0x7b                                   }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x29, 0x7b                               }, { vpcmpd k5,zmm30,ZWORD [rcx],0x7b                             }
testcase	{ 0x62, 0xb3, 0x0d, 0x40, 0x1f, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpcmpd k5,zmm30,ZWORD [rax+r14*8+0x123],0x7b                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x29, 0x7b                               }, { vpcmpd k5,zmm30,DWORD [rcx]{1to16},0x7b                      }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x6a, 0x7f, 0x7b                         }, { vpcmpd k5,zmm30,ZWORD [rdx+0x1fc0],0x7b                      }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpcmpd k5,zmm30,ZWORD [rdx+0x2000],0x7b                      }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x6a, 0x80, 0x7b                         }, { vpcmpd k5,zmm30,ZWORD [rdx-0x2000],0x7b                      }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpcmpd k5,zmm30,ZWORD [rdx-0x2040],0x7b                      }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x6a, 0x7f, 0x7b                         }, { vpcmpd k5,zmm30,DWORD [rdx+0x1fc]{1to16},0x7b                }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vpcmpd k5,zmm30,DWORD [rdx+0x200]{1to16},0x7b                }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x6a, 0x80, 0x7b                         }, { vpcmpd k5,zmm30,DWORD [rdx-0x200]{1to16},0x7b                }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vpcmpd k5,zmm30,DWORD [rdx-0x204]{1to16},0x7b                }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1f, 0xed, 0x01                               }, { vpcmpltd k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x93, 0x0d, 0x47, 0x1f, 0xed, 0x01                               }, { vpcmpltd k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x29, 0x01                               }, { vpcmpltd k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb3, 0x0d, 0x40, 0x1f, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x01 }, { vpcmpltd k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x29, 0x01                               }, { vpcmpltd k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x6a, 0x7f, 0x01                         }, { vpcmpltd k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x01       }, { vpcmpltd k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x6a, 0x80, 0x01                         }, { vpcmpltd k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x01       }, { vpcmpltd k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x6a, 0x7f, 0x01                         }, { vpcmpltd k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x01       }, { vpcmpltd k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x6a, 0x80, 0x01                         }, { vpcmpltd k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x01       }, { vpcmpltd k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1f, 0xed, 0x02                               }, { vpcmpled k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x93, 0x0d, 0x47, 0x1f, 0xed, 0x02                               }, { vpcmpled k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x29, 0x02                               }, { vpcmpled k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb3, 0x0d, 0x40, 0x1f, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x02 }, { vpcmpled k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x29, 0x02                               }, { vpcmpled k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x6a, 0x7f, 0x02                         }, { vpcmpled k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x02       }, { vpcmpled k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x6a, 0x80, 0x02                         }, { vpcmpled k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x02       }, { vpcmpled k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x6a, 0x7f, 0x02                         }, { vpcmpled k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x02       }, { vpcmpled k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x6a, 0x80, 0x02                         }, { vpcmpled k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x02       }, { vpcmpled k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1f, 0xed, 0x04                               }, { vpcmpneqd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x93, 0x0d, 0x47, 0x1f, 0xed, 0x04                               }, { vpcmpneqd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x29, 0x04                               }, { vpcmpneqd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb3, 0x0d, 0x40, 0x1f, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x04 }, { vpcmpneqd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x29, 0x04                               }, { vpcmpneqd k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x6a, 0x7f, 0x04                         }, { vpcmpneqd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x04       }, { vpcmpneqd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x6a, 0x80, 0x04                         }, { vpcmpneqd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x04       }, { vpcmpneqd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x6a, 0x7f, 0x04                         }, { vpcmpneqd k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x04       }, { vpcmpneqd k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x6a, 0x80, 0x04                         }, { vpcmpneqd k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x04       }, { vpcmpneqd k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1f, 0xed, 0x05                               }, { vpcmpnltd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x93, 0x0d, 0x47, 0x1f, 0xed, 0x05                               }, { vpcmpnltd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x29, 0x05                               }, { vpcmpnltd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb3, 0x0d, 0x40, 0x1f, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x05 }, { vpcmpnltd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x29, 0x05                               }, { vpcmpnltd k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x6a, 0x7f, 0x05                         }, { vpcmpnltd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x05       }, { vpcmpnltd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x6a, 0x80, 0x05                         }, { vpcmpnltd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x05       }, { vpcmpnltd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x6a, 0x7f, 0x05                         }, { vpcmpnltd k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x05       }, { vpcmpnltd k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x6a, 0x80, 0x05                         }, { vpcmpnltd k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x05       }, { vpcmpnltd k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1f, 0xed, 0x06                               }, { vpcmpnled k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x93, 0x0d, 0x47, 0x1f, 0xed, 0x06                               }, { vpcmpnled k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x29, 0x06                               }, { vpcmpnled k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb3, 0x0d, 0x40, 0x1f, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x06 }, { vpcmpnled k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x29, 0x06                               }, { vpcmpnled k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x6a, 0x7f, 0x06                         }, { vpcmpnled k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x06       }, { vpcmpnled k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0x6a, 0x80, 0x06                         }, { vpcmpnled k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1f, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x06       }, { vpcmpnled k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x6a, 0x7f, 0x06                         }, { vpcmpnled k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x06       }, { vpcmpnled k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0x6a, 0x80, 0x06                         }, { vpcmpnled k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1f, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x06       }, { vpcmpnled k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x91, 0x0d, 0x40, 0x76, 0xed                                     }, { vpcmpeqd k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x0d, 0x47, 0x76, 0xed                                     }, { vpcmpeqd k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x76, 0x29                                     }, { vpcmpeqd k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x0d, 0x40, 0x76, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpcmpeqd k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x76, 0x29                                     }, { vpcmpeqd k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x76, 0x6a, 0x7f                               }, { vpcmpeqd k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x76, 0xaa, 0x00, 0x20, 0x00, 0x00             }, { vpcmpeqd k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x76, 0x6a, 0x80                               }, { vpcmpeqd k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x76, 0xaa, 0xc0, 0xdf, 0xff, 0xff             }, { vpcmpeqd k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x76, 0x6a, 0x7f                               }, { vpcmpeqd k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x76, 0xaa, 0x00, 0x02, 0x00, 0x00             }, { vpcmpeqd k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x76, 0x6a, 0x80                               }, { vpcmpeqd k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x76, 0xaa, 0xfc, 0xfd, 0xff, 0xff             }, { vpcmpeqd k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x92, 0x8d, 0x40, 0x29, 0xed                                     }, { vpcmpeqq k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x92, 0x8d, 0x47, 0x29, 0xed                                     }, { vpcmpeqq k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x29, 0x29                                     }, { vpcmpeqq k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb2, 0x8d, 0x40, 0x29, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpcmpeqq k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x29, 0x29                                     }, { vpcmpeqq k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x29, 0x6a, 0x7f                               }, { vpcmpeqq k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x29, 0xaa, 0x00, 0x20, 0x00, 0x00             }, { vpcmpeqq k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x29, 0x6a, 0x80                               }, { vpcmpeqq k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x29, 0xaa, 0xc0, 0xdf, 0xff, 0xff             }, { vpcmpeqq k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x29, 0x6a, 0x7f                               }, { vpcmpeqq k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x29, 0xaa, 0x00, 0x04, 0x00, 0x00             }, { vpcmpeqq k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x29, 0x6a, 0x80                               }, { vpcmpeqq k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x29, 0xaa, 0xf8, 0xfb, 0xff, 0xff             }, { vpcmpeqq k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x91, 0x0d, 0x40, 0x66, 0xed                                     }, { vpcmpgtd k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x91, 0x0d, 0x47, 0x66, 0xed                                     }, { vpcmpgtd k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x66, 0x29                                     }, { vpcmpgtd k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb1, 0x0d, 0x40, 0x66, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpcmpgtd k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x66, 0x29                                     }, { vpcmpgtd k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x66, 0x6a, 0x7f                               }, { vpcmpgtd k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x66, 0xaa, 0x00, 0x20, 0x00, 0x00             }, { vpcmpgtd k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x66, 0x6a, 0x80                               }, { vpcmpgtd k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x66, 0xaa, 0xc0, 0xdf, 0xff, 0xff             }, { vpcmpgtd k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x66, 0x6a, 0x7f                               }, { vpcmpgtd k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x66, 0xaa, 0x00, 0x02, 0x00, 0x00             }, { vpcmpgtd k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x66, 0x6a, 0x80                               }, { vpcmpgtd k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x66, 0xaa, 0xfc, 0xfd, 0xff, 0xff             }, { vpcmpgtd k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x92, 0x8d, 0x40, 0x37, 0xed                                     }, { vpcmpgtq k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x92, 0x8d, 0x47, 0x37, 0xed                                     }, { vpcmpgtq k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x37, 0x29                                     }, { vpcmpgtq k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb2, 0x8d, 0x40, 0x37, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpcmpgtq k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x37, 0x29                                     }, { vpcmpgtq k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x37, 0x6a, 0x7f                               }, { vpcmpgtq k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x37, 0xaa, 0x00, 0x20, 0x00, 0x00             }, { vpcmpgtq k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x37, 0x6a, 0x80                               }, { vpcmpgtq k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x37, 0xaa, 0xc0, 0xdf, 0xff, 0xff             }, { vpcmpgtq k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x37, 0x6a, 0x7f                               }, { vpcmpgtq k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x37, 0xaa, 0x00, 0x04, 0x00, 0x00             }, { vpcmpgtq k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x37, 0x6a, 0x80                               }, { vpcmpgtq k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x37, 0xaa, 0xf8, 0xfb, 0xff, 0xff             }, { vpcmpgtq k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1f, 0xed, 0xab                               }, { vpcmpq k5,zmm30,zmm29,0xab                                   }
testcase	{ 0x62, 0x93, 0x8d, 0x47, 0x1f, 0xed, 0xab                               }, { vpcmpq k5{k7},zmm30,zmm29,0xab                               }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1f, 0xed, 0x7b                               }, { vpcmpq k5,zmm30,zmm29,0x7b                                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x29, 0x7b                               }, { vpcmpq k5,zmm30,ZWORD [rcx],0x7b                             }
testcase	{ 0x62, 0xb3, 0x8d, 0x40, 0x1f, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpcmpq k5,zmm30,ZWORD [rax+r14*8+0x123],0x7b                 }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x29, 0x7b                               }, { vpcmpq k5,zmm30,QWORD [rcx]{1to8},0x7b                       }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x6a, 0x7f, 0x7b                         }, { vpcmpq k5,zmm30,ZWORD [rdx+0x1fc0],0x7b                      }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpcmpq k5,zmm30,ZWORD [rdx+0x2000],0x7b                      }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x6a, 0x80, 0x7b                         }, { vpcmpq k5,zmm30,ZWORD [rdx-0x2000],0x7b                      }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpcmpq k5,zmm30,ZWORD [rdx-0x2040],0x7b                      }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x6a, 0x7f, 0x7b                         }, { vpcmpq k5,zmm30,QWORD [rdx+0x3f8]{1to8},0x7b                 }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vpcmpq k5,zmm30,QWORD [rdx+0x400]{1to8},0x7b                 }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x6a, 0x80, 0x7b                         }, { vpcmpq k5,zmm30,QWORD [rdx-0x400]{1to8},0x7b                 }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vpcmpq k5,zmm30,QWORD [rdx-0x408]{1to8},0x7b                 }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1f, 0xed, 0x01                               }, { vpcmpltq k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x93, 0x8d, 0x47, 0x1f, 0xed, 0x01                               }, { vpcmpltq k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x29, 0x01                               }, { vpcmpltq k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb3, 0x8d, 0x40, 0x1f, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x01 }, { vpcmpltq k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x29, 0x01                               }, { vpcmpltq k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x6a, 0x7f, 0x01                         }, { vpcmpltq k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x01       }, { vpcmpltq k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x6a, 0x80, 0x01                         }, { vpcmpltq k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x01       }, { vpcmpltq k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x6a, 0x7f, 0x01                         }, { vpcmpltq k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x01       }, { vpcmpltq k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x6a, 0x80, 0x01                         }, { vpcmpltq k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x01       }, { vpcmpltq k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1f, 0xed, 0x02                               }, { vpcmpleq k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x93, 0x8d, 0x47, 0x1f, 0xed, 0x02                               }, { vpcmpleq k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x29, 0x02                               }, { vpcmpleq k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb3, 0x8d, 0x40, 0x1f, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x02 }, { vpcmpleq k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x29, 0x02                               }, { vpcmpleq k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x6a, 0x7f, 0x02                         }, { vpcmpleq k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x02       }, { vpcmpleq k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x6a, 0x80, 0x02                         }, { vpcmpleq k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x02       }, { vpcmpleq k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x6a, 0x7f, 0x02                         }, { vpcmpleq k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x02       }, { vpcmpleq k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x6a, 0x80, 0x02                         }, { vpcmpleq k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x02       }, { vpcmpleq k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1f, 0xed, 0x04                               }, { vpcmpneqq k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x93, 0x8d, 0x47, 0x1f, 0xed, 0x04                               }, { vpcmpneqq k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x29, 0x04                               }, { vpcmpneqq k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb3, 0x8d, 0x40, 0x1f, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x04 }, { vpcmpneqq k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x29, 0x04                               }, { vpcmpneqq k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x6a, 0x7f, 0x04                         }, { vpcmpneqq k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x04       }, { vpcmpneqq k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x6a, 0x80, 0x04                         }, { vpcmpneqq k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x04       }, { vpcmpneqq k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x6a, 0x7f, 0x04                         }, { vpcmpneqq k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x04       }, { vpcmpneqq k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x6a, 0x80, 0x04                         }, { vpcmpneqq k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x04       }, { vpcmpneqq k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1f, 0xed, 0x05                               }, { vpcmpnltq k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x93, 0x8d, 0x47, 0x1f, 0xed, 0x05                               }, { vpcmpnltq k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x29, 0x05                               }, { vpcmpnltq k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb3, 0x8d, 0x40, 0x1f, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x05 }, { vpcmpnltq k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x29, 0x05                               }, { vpcmpnltq k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x6a, 0x7f, 0x05                         }, { vpcmpnltq k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x05       }, { vpcmpnltq k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x6a, 0x80, 0x05                         }, { vpcmpnltq k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x05       }, { vpcmpnltq k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x6a, 0x7f, 0x05                         }, { vpcmpnltq k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x05       }, { vpcmpnltq k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x6a, 0x80, 0x05                         }, { vpcmpnltq k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x05       }, { vpcmpnltq k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1f, 0xed, 0x06                               }, { vpcmpnleq k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x93, 0x8d, 0x47, 0x1f, 0xed, 0x06                               }, { vpcmpnleq k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x29, 0x06                               }, { vpcmpnleq k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb3, 0x8d, 0x40, 0x1f, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x06 }, { vpcmpnleq k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x29, 0x06                               }, { vpcmpnleq k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x6a, 0x7f, 0x06                         }, { vpcmpnleq k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x06       }, { vpcmpnleq k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0x6a, 0x80, 0x06                         }, { vpcmpnleq k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1f, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x06       }, { vpcmpnleq k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x6a, 0x7f, 0x06                         }, { vpcmpnleq k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x06       }, { vpcmpnleq k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0x6a, 0x80, 0x06                         }, { vpcmpnleq k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1f, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x06       }, { vpcmpnleq k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1e, 0xed, 0xab                               }, { vpcmpud k5,zmm30,zmm29,0xab                                  }
testcase	{ 0x62, 0x93, 0x0d, 0x47, 0x1e, 0xed, 0xab                               }, { vpcmpud k5{k7},zmm30,zmm29,0xab                              }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1e, 0xed, 0x7b                               }, { vpcmpud k5,zmm30,zmm29,0x7b                                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x29, 0x7b                               }, { vpcmpud k5,zmm30,ZWORD [rcx],0x7b                            }
testcase	{ 0x62, 0xb3, 0x0d, 0x40, 0x1e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpcmpud k5,zmm30,ZWORD [rax+r14*8+0x123],0x7b                }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x29, 0x7b                               }, { vpcmpud k5,zmm30,DWORD [rcx]{1to16},0x7b                     }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x6a, 0x7f, 0x7b                         }, { vpcmpud k5,zmm30,ZWORD [rdx+0x1fc0],0x7b                     }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpcmpud k5,zmm30,ZWORD [rdx+0x2000],0x7b                     }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x6a, 0x80, 0x7b                         }, { vpcmpud k5,zmm30,ZWORD [rdx-0x2000],0x7b                     }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpcmpud k5,zmm30,ZWORD [rdx-0x2040],0x7b                     }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x6a, 0x7f, 0x7b                         }, { vpcmpud k5,zmm30,DWORD [rdx+0x1fc]{1to16},0x7b               }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vpcmpud k5,zmm30,DWORD [rdx+0x200]{1to16},0x7b               }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x6a, 0x80, 0x7b                         }, { vpcmpud k5,zmm30,DWORD [rdx-0x200]{1to16},0x7b               }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vpcmpud k5,zmm30,DWORD [rdx-0x204]{1to16},0x7b               }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1e, 0xed, 0x00                               }, { vpcmpequd k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x93, 0x0d, 0x47, 0x1e, 0xed, 0x00                               }, { vpcmpequd k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x29, 0x00                               }, { vpcmpequd k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb3, 0x0d, 0x40, 0x1e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x00 }, { vpcmpequd k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x29, 0x00                               }, { vpcmpequd k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x6a, 0x7f, 0x00                         }, { vpcmpequd k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x00       }, { vpcmpequd k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x6a, 0x80, 0x00                         }, { vpcmpequd k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x00       }, { vpcmpequd k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x6a, 0x7f, 0x00                         }, { vpcmpequd k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x00       }, { vpcmpequd k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x6a, 0x80, 0x00                         }, { vpcmpequd k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x00       }, { vpcmpequd k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1e, 0xed, 0x01                               }, { vpcmpltud k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x93, 0x0d, 0x47, 0x1e, 0xed, 0x01                               }, { vpcmpltud k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x29, 0x01                               }, { vpcmpltud k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb3, 0x0d, 0x40, 0x1e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x01 }, { vpcmpltud k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x29, 0x01                               }, { vpcmpltud k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x6a, 0x7f, 0x01                         }, { vpcmpltud k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x01       }, { vpcmpltud k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x6a, 0x80, 0x01                         }, { vpcmpltud k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x01       }, { vpcmpltud k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x6a, 0x7f, 0x01                         }, { vpcmpltud k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x01       }, { vpcmpltud k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x6a, 0x80, 0x01                         }, { vpcmpltud k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x01       }, { vpcmpltud k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1e, 0xed, 0x02                               }, { vpcmpleud k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x93, 0x0d, 0x47, 0x1e, 0xed, 0x02                               }, { vpcmpleud k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x29, 0x02                               }, { vpcmpleud k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb3, 0x0d, 0x40, 0x1e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x02 }, { vpcmpleud k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x29, 0x02                               }, { vpcmpleud k5,zmm30,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x6a, 0x7f, 0x02                         }, { vpcmpleud k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x02       }, { vpcmpleud k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x6a, 0x80, 0x02                         }, { vpcmpleud k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x02       }, { vpcmpleud k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x6a, 0x7f, 0x02                         }, { vpcmpleud k5,zmm30,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x02       }, { vpcmpleud k5,zmm30,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x6a, 0x80, 0x02                         }, { vpcmpleud k5,zmm30,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x02       }, { vpcmpleud k5,zmm30,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1e, 0xed, 0x04                               }, { vpcmpnequd k5,zmm30,zmm29                                    }
testcase	{ 0x62, 0x93, 0x0d, 0x47, 0x1e, 0xed, 0x04                               }, { vpcmpnequd k5{k7},zmm30,zmm29                                }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x29, 0x04                               }, { vpcmpnequd k5,zmm30,ZWORD [rcx]                              }
testcase	{ 0x62, 0xb3, 0x0d, 0x40, 0x1e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x04 }, { vpcmpnequd k5,zmm30,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x29, 0x04                               }, { vpcmpnequd k5,zmm30,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x6a, 0x7f, 0x04                         }, { vpcmpnequd k5,zmm30,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x04       }, { vpcmpnequd k5,zmm30,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x6a, 0x80, 0x04                         }, { vpcmpnequd k5,zmm30,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x04       }, { vpcmpnequd k5,zmm30,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x6a, 0x7f, 0x04                         }, { vpcmpnequd k5,zmm30,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x04       }, { vpcmpnequd k5,zmm30,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x6a, 0x80, 0x04                         }, { vpcmpnequd k5,zmm30,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x04       }, { vpcmpnequd k5,zmm30,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1e, 0xed, 0x05                               }, { vpcmpnltud k5,zmm30,zmm29                                    }
testcase	{ 0x62, 0x93, 0x0d, 0x47, 0x1e, 0xed, 0x05                               }, { vpcmpnltud k5{k7},zmm30,zmm29                                }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x29, 0x05                               }, { vpcmpnltud k5,zmm30,ZWORD [rcx]                              }
testcase	{ 0x62, 0xb3, 0x0d, 0x40, 0x1e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x05 }, { vpcmpnltud k5,zmm30,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x29, 0x05                               }, { vpcmpnltud k5,zmm30,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x6a, 0x7f, 0x05                         }, { vpcmpnltud k5,zmm30,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x05       }, { vpcmpnltud k5,zmm30,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x6a, 0x80, 0x05                         }, { vpcmpnltud k5,zmm30,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x05       }, { vpcmpnltud k5,zmm30,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x6a, 0x7f, 0x05                         }, { vpcmpnltud k5,zmm30,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x05       }, { vpcmpnltud k5,zmm30,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x6a, 0x80, 0x05                         }, { vpcmpnltud k5,zmm30,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x05       }, { vpcmpnltud k5,zmm30,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x93, 0x0d, 0x40, 0x1e, 0xed, 0x06                               }, { vpcmpnleud k5,zmm30,zmm29                                    }
testcase	{ 0x62, 0x93, 0x0d, 0x47, 0x1e, 0xed, 0x06                               }, { vpcmpnleud k5{k7},zmm30,zmm29                                }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x29, 0x06                               }, { vpcmpnleud k5,zmm30,ZWORD [rcx]                              }
testcase	{ 0x62, 0xb3, 0x0d, 0x40, 0x1e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x06 }, { vpcmpnleud k5,zmm30,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x29, 0x06                               }, { vpcmpnleud k5,zmm30,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x6a, 0x7f, 0x06                         }, { vpcmpnleud k5,zmm30,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x06       }, { vpcmpnleud k5,zmm30,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0x6a, 0x80, 0x06                         }, { vpcmpnleud k5,zmm30,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x40, 0x1e, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x06       }, { vpcmpnleud k5,zmm30,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x6a, 0x7f, 0x06                         }, { vpcmpnleud k5,zmm30,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0xaa, 0x00, 0x02, 0x00, 0x00, 0x06       }, { vpcmpnleud k5,zmm30,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0x6a, 0x80, 0x06                         }, { vpcmpnleud k5,zmm30,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0xf3, 0x0d, 0x50, 0x1e, 0xaa, 0xfc, 0xfd, 0xff, 0xff, 0x06       }, { vpcmpnleud k5,zmm30,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1e, 0xed, 0xab                               }, { vpcmpuq k5,zmm30,zmm29,0xab                                  }
testcase	{ 0x62, 0x93, 0x8d, 0x47, 0x1e, 0xed, 0xab                               }, { vpcmpuq k5{k7},zmm30,zmm29,0xab                              }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1e, 0xed, 0x7b                               }, { vpcmpuq k5,zmm30,zmm29,0x7b                                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x29, 0x7b                               }, { vpcmpuq k5,zmm30,ZWORD [rcx],0x7b                            }
testcase	{ 0x62, 0xb3, 0x8d, 0x40, 0x1e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpcmpuq k5,zmm30,ZWORD [rax+r14*8+0x123],0x7b                }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x29, 0x7b                               }, { vpcmpuq k5,zmm30,QWORD [rcx]{1to8},0x7b                      }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x6a, 0x7f, 0x7b                         }, { vpcmpuq k5,zmm30,ZWORD [rdx+0x1fc0],0x7b                     }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpcmpuq k5,zmm30,ZWORD [rdx+0x2000],0x7b                     }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x6a, 0x80, 0x7b                         }, { vpcmpuq k5,zmm30,ZWORD [rdx-0x2000],0x7b                     }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpcmpuq k5,zmm30,ZWORD [rdx-0x2040],0x7b                     }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x6a, 0x7f, 0x7b                         }, { vpcmpuq k5,zmm30,QWORD [rdx+0x3f8]{1to8},0x7b                }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vpcmpuq k5,zmm30,QWORD [rdx+0x400]{1to8},0x7b                }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x6a, 0x80, 0x7b                         }, { vpcmpuq k5,zmm30,QWORD [rdx-0x400]{1to8},0x7b                }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vpcmpuq k5,zmm30,QWORD [rdx-0x408]{1to8},0x7b                }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1e, 0xed, 0x00                               }, { vpcmpequq k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x93, 0x8d, 0x47, 0x1e, 0xed, 0x00                               }, { vpcmpequq k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x29, 0x00                               }, { vpcmpequq k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb3, 0x8d, 0x40, 0x1e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x00 }, { vpcmpequq k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x29, 0x00                               }, { vpcmpequq k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x6a, 0x7f, 0x00                         }, { vpcmpequq k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x00       }, { vpcmpequq k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x6a, 0x80, 0x00                         }, { vpcmpequq k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x00       }, { vpcmpequq k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x6a, 0x7f, 0x00                         }, { vpcmpequq k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x00       }, { vpcmpequq k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x6a, 0x80, 0x00                         }, { vpcmpequq k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x00       }, { vpcmpequq k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1e, 0xed, 0x01                               }, { vpcmpltuq k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x93, 0x8d, 0x47, 0x1e, 0xed, 0x01                               }, { vpcmpltuq k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x29, 0x01                               }, { vpcmpltuq k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb3, 0x8d, 0x40, 0x1e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x01 }, { vpcmpltuq k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x29, 0x01                               }, { vpcmpltuq k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x6a, 0x7f, 0x01                         }, { vpcmpltuq k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x01       }, { vpcmpltuq k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x6a, 0x80, 0x01                         }, { vpcmpltuq k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x01       }, { vpcmpltuq k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x6a, 0x7f, 0x01                         }, { vpcmpltuq k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x01       }, { vpcmpltuq k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x6a, 0x80, 0x01                         }, { vpcmpltuq k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x01       }, { vpcmpltuq k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1e, 0xed, 0x02                               }, { vpcmpleuq k5,zmm30,zmm29                                     }
testcase	{ 0x62, 0x93, 0x8d, 0x47, 0x1e, 0xed, 0x02                               }, { vpcmpleuq k5{k7},zmm30,zmm29                                 }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x29, 0x02                               }, { vpcmpleuq k5,zmm30,ZWORD [rcx]                               }
testcase	{ 0x62, 0xb3, 0x8d, 0x40, 0x1e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x02 }, { vpcmpleuq k5,zmm30,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x29, 0x02                               }, { vpcmpleuq k5,zmm30,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x6a, 0x7f, 0x02                         }, { vpcmpleuq k5,zmm30,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x02       }, { vpcmpleuq k5,zmm30,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x6a, 0x80, 0x02                         }, { vpcmpleuq k5,zmm30,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x02       }, { vpcmpleuq k5,zmm30,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x6a, 0x7f, 0x02                         }, { vpcmpleuq k5,zmm30,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x02       }, { vpcmpleuq k5,zmm30,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x6a, 0x80, 0x02                         }, { vpcmpleuq k5,zmm30,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x02       }, { vpcmpleuq k5,zmm30,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1e, 0xed, 0x04                               }, { vpcmpnequq k5,zmm30,zmm29                                    }
testcase	{ 0x62, 0x93, 0x8d, 0x47, 0x1e, 0xed, 0x04                               }, { vpcmpnequq k5{k7},zmm30,zmm29                                }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x29, 0x04                               }, { vpcmpnequq k5,zmm30,ZWORD [rcx]                              }
testcase	{ 0x62, 0xb3, 0x8d, 0x40, 0x1e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x04 }, { vpcmpnequq k5,zmm30,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x29, 0x04                               }, { vpcmpnequq k5,zmm30,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x6a, 0x7f, 0x04                         }, { vpcmpnequq k5,zmm30,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x04       }, { vpcmpnequq k5,zmm30,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x6a, 0x80, 0x04                         }, { vpcmpnequq k5,zmm30,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x04       }, { vpcmpnequq k5,zmm30,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x6a, 0x7f, 0x04                         }, { vpcmpnequq k5,zmm30,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x04       }, { vpcmpnequq k5,zmm30,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x6a, 0x80, 0x04                         }, { vpcmpnequq k5,zmm30,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x04       }, { vpcmpnequq k5,zmm30,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1e, 0xed, 0x05                               }, { vpcmpnltuq k5,zmm30,zmm29                                    }
testcase	{ 0x62, 0x93, 0x8d, 0x47, 0x1e, 0xed, 0x05                               }, { vpcmpnltuq k5{k7},zmm30,zmm29                                }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x29, 0x05                               }, { vpcmpnltuq k5,zmm30,ZWORD [rcx]                              }
testcase	{ 0x62, 0xb3, 0x8d, 0x40, 0x1e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x05 }, { vpcmpnltuq k5,zmm30,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x29, 0x05                               }, { vpcmpnltuq k5,zmm30,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x6a, 0x7f, 0x05                         }, { vpcmpnltuq k5,zmm30,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x05       }, { vpcmpnltuq k5,zmm30,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x6a, 0x80, 0x05                         }, { vpcmpnltuq k5,zmm30,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x05       }, { vpcmpnltuq k5,zmm30,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x6a, 0x7f, 0x05                         }, { vpcmpnltuq k5,zmm30,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x05       }, { vpcmpnltuq k5,zmm30,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x6a, 0x80, 0x05                         }, { vpcmpnltuq k5,zmm30,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x05       }, { vpcmpnltuq k5,zmm30,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x93, 0x8d, 0x40, 0x1e, 0xed, 0x06                               }, { vpcmpnleuq k5,zmm30,zmm29                                    }
testcase	{ 0x62, 0x93, 0x8d, 0x47, 0x1e, 0xed, 0x06                               }, { vpcmpnleuq k5{k7},zmm30,zmm29                                }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x29, 0x06                               }, { vpcmpnleuq k5,zmm30,ZWORD [rcx]                              }
testcase	{ 0x62, 0xb3, 0x8d, 0x40, 0x1e, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x06 }, { vpcmpnleuq k5,zmm30,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x29, 0x06                               }, { vpcmpnleuq k5,zmm30,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x6a, 0x7f, 0x06                         }, { vpcmpnleuq k5,zmm30,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0xaa, 0x00, 0x20, 0x00, 0x00, 0x06       }, { vpcmpnleuq k5,zmm30,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0x6a, 0x80, 0x06                         }, { vpcmpnleuq k5,zmm30,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0xf3, 0x8d, 0x40, 0x1e, 0xaa, 0xc0, 0xdf, 0xff, 0xff, 0x06       }, { vpcmpnleuq k5,zmm30,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x6a, 0x7f, 0x06                         }, { vpcmpnleuq k5,zmm30,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0xaa, 0x00, 0x04, 0x00, 0x00, 0x06       }, { vpcmpnleuq k5,zmm30,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0x6a, 0x80, 0x06                         }, { vpcmpnleuq k5,zmm30,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0xf3, 0x8d, 0x50, 0x1e, 0xaa, 0xf8, 0xfb, 0xff, 0xff, 0x06       }, { vpcmpnleuq k5,zmm30,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x64, 0xf4                                     }, { vpblendmq zmm30,zmm29,zmm28                                  }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x64, 0xf4                                     }, { vpblendmq zmm30{k7},zmm29,zmm28                              }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x64, 0xf4                                     }, { vpblendmq zmm30{k7}{z},zmm29,zmm28                           }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x64, 0x31                                     }, { vpblendmq zmm30,zmm29,ZWORD [rcx]                            }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x64, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpblendmq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x64, 0x31                                     }, { vpblendmq zmm30,zmm29,QWORD [rcx]{1to8}                      }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x64, 0x72, 0x7f                               }, { vpblendmq zmm30,zmm29,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x64, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpblendmq zmm30,zmm29,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x64, 0x72, 0x80                               }, { vpblendmq zmm30,zmm29,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x64, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpblendmq zmm30,zmm29,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x64, 0x72, 0x7f                               }, { vpblendmq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x64, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpblendmq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x64, 0x72, 0x80                               }, { vpblendmq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x64, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpblendmq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x8b, 0x31                                     }, { vpcompressd ZWORD [rcx],zmm30                                }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x8b, 0x31                                     }, { vpcompressd ZWORD [rcx]{k7},zmm30                            }
testcase	{ 0x62, 0x22, 0x7d, 0x48, 0x8b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpcompressd ZWORD [rax+r14*8+0x123],zmm30                    }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x8b, 0x72, 0x7f                               }, { vpcompressd ZWORD [rdx+0x1fc],zmm30                          }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x8b, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpcompressd ZWORD [rdx+0x200],zmm30                          }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x8b, 0x72, 0x80                               }, { vpcompressd ZWORD [rdx-0x200],zmm30                          }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x8b, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpcompressd ZWORD [rdx-0x204],zmm30                          }
testcase	{ 0x62, 0x02, 0x7d, 0x48, 0x8b, 0xee                                     }, { vpcompressd zmm30,zmm29                                      }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x8b, 0xee                                     }, { vpcompressd zmm30{k7},zmm29                                  }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x8b, 0xee                                     }, { vpcompressd zmm30{k7}{z},zmm29                               }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x36, 0xf4                                     }, { vpermd zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x36, 0xf4                                     }, { vpermd zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x36, 0xf4                                     }, { vpermd zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x36, 0x31                                     }, { vpermd zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x36, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpermd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x36, 0x31                                     }, { vpermd zmm30,zmm29,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x36, 0x72, 0x7f                               }, { vpermd zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x36, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpermd zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x36, 0x72, 0x80                               }, { vpermd zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x36, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpermd zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x36, 0x72, 0x7f                               }, { vpermd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x36, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpermd zmm30,zmm29,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x36, 0x72, 0x80                               }, { vpermd zmm30,zmm29,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x36, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpermd zmm30,zmm29,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x03, 0xfd, 0x48, 0x05, 0xf5, 0xab                               }, { vpermilpd zmm30,zmm29,0xab                                   }
testcase	{ 0x62, 0x03, 0xfd, 0x4f, 0x05, 0xf5, 0xab                               }, { vpermilpd zmm30{k7},zmm29,0xab                               }
testcase	{ 0x62, 0x03, 0xfd, 0xcf, 0x05, 0xf5, 0xab                               }, { vpermilpd zmm30{k7}{z},zmm29,0xab                            }
testcase	{ 0x62, 0x03, 0xfd, 0x48, 0x05, 0xf5, 0x7b                               }, { vpermilpd zmm30,zmm29,0x7b                                   }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x05, 0x31, 0x7b                               }, { vpermilpd zmm30,ZWORD [rcx],0x7b                             }
testcase	{ 0x62, 0x23, 0xfd, 0x48, 0x05, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpermilpd zmm30,ZWORD [rax+r14*8+0x123],0x7b                 }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x05, 0x31, 0x7b                               }, { vpermilpd zmm30,QWORD [rcx]{1to8},0x7b                       }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x05, 0x72, 0x7f, 0x7b                         }, { vpermilpd zmm30,ZWORD [rdx+0x1fc0],0x7b                      }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x05, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpermilpd zmm30,ZWORD [rdx+0x2000],0x7b                      }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x05, 0x72, 0x80, 0x7b                         }, { vpermilpd zmm30,ZWORD [rdx-0x2000],0x7b                      }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x05, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpermilpd zmm30,ZWORD [rdx-0x2040],0x7b                      }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x05, 0x72, 0x7f, 0x7b                         }, { vpermilpd zmm30,QWORD [rdx+0x3f8]{1to8},0x7b                 }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x05, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vpermilpd zmm30,QWORD [rdx+0x400]{1to8},0x7b                 }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x05, 0x72, 0x80, 0x7b                         }, { vpermilpd zmm30,QWORD [rdx-0x400]{1to8},0x7b                 }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x05, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vpermilpd zmm30,QWORD [rdx-0x408]{1to8},0x7b                 }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x0d, 0xf4                                     }, { vpermilpd zmm30,zmm29,zmm28                                  }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x0d, 0xf4                                     }, { vpermilpd zmm30{k7},zmm29,zmm28                              }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x0d, 0xf4                                     }, { vpermilpd zmm30{k7}{z},zmm29,zmm28                           }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x0d, 0x31                                     }, { vpermilpd zmm30,zmm29,ZWORD [rcx]                            }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x0d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpermilpd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x0d, 0x31                                     }, { vpermilpd zmm30,zmm29,QWORD [rcx]{1to8}                      }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x0d, 0x72, 0x7f                               }, { vpermilpd zmm30,zmm29,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x0d, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpermilpd zmm30,zmm29,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x0d, 0x72, 0x80                               }, { vpermilpd zmm30,zmm29,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x0d, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpermilpd zmm30,zmm29,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x0d, 0x72, 0x7f                               }, { vpermilpd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x0d, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpermilpd zmm30,zmm29,QWORD [rdx+0x400]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x0d, 0x72, 0x80                               }, { vpermilpd zmm30,zmm29,QWORD [rdx-0x400]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x0d, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpermilpd zmm30,zmm29,QWORD [rdx-0x408]{1to8}                }
testcase	{ 0x62, 0x03, 0x7d, 0x48, 0x04, 0xf5, 0xab                               }, { vpermilps zmm30,zmm29,0xab                                   }
testcase	{ 0x62, 0x03, 0x7d, 0x4f, 0x04, 0xf5, 0xab                               }, { vpermilps zmm30{k7},zmm29,0xab                               }
testcase	{ 0x62, 0x03, 0x7d, 0xcf, 0x04, 0xf5, 0xab                               }, { vpermilps zmm30{k7}{z},zmm29,0xab                            }
testcase	{ 0x62, 0x03, 0x7d, 0x48, 0x04, 0xf5, 0x7b                               }, { vpermilps zmm30,zmm29,0x7b                                   }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x04, 0x31, 0x7b                               }, { vpermilps zmm30,ZWORD [rcx],0x7b                             }
testcase	{ 0x62, 0x23, 0x7d, 0x48, 0x04, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpermilps zmm30,ZWORD [rax+r14*8+0x123],0x7b                 }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x04, 0x31, 0x7b                               }, { vpermilps zmm30,DWORD [rcx]{1to16},0x7b                      }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x04, 0x72, 0x7f, 0x7b                         }, { vpermilps zmm30,ZWORD [rdx+0x1fc0],0x7b                      }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x04, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpermilps zmm30,ZWORD [rdx+0x2000],0x7b                      }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x04, 0x72, 0x80, 0x7b                         }, { vpermilps zmm30,ZWORD [rdx-0x2000],0x7b                      }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x04, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpermilps zmm30,ZWORD [rdx-0x2040],0x7b                      }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x04, 0x72, 0x7f, 0x7b                         }, { vpermilps zmm30,DWORD [rdx+0x1fc]{1to16},0x7b                }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x04, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vpermilps zmm30,DWORD [rdx+0x200]{1to16},0x7b                }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x04, 0x72, 0x80, 0x7b                         }, { vpermilps zmm30,DWORD [rdx-0x200]{1to16},0x7b                }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x04, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vpermilps zmm30,DWORD [rdx-0x204]{1to16},0x7b                }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x0c, 0xf4                                     }, { vpermilps zmm30,zmm29,zmm28                                  }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x0c, 0xf4                                     }, { vpermilps zmm30{k7},zmm29,zmm28                              }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x0c, 0xf4                                     }, { vpermilps zmm30{k7}{z},zmm29,zmm28                           }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x0c, 0x31                                     }, { vpermilps zmm30,zmm29,ZWORD [rcx]                            }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x0c, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpermilps zmm30,zmm29,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x0c, 0x31                                     }, { vpermilps zmm30,zmm29,DWORD [rcx]{1to16}                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x0c, 0x72, 0x7f                               }, { vpermilps zmm30,zmm29,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x0c, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpermilps zmm30,zmm29,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x0c, 0x72, 0x80                               }, { vpermilps zmm30,zmm29,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x0c, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpermilps zmm30,zmm29,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x0c, 0x72, 0x7f                               }, { vpermilps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x0c, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpermilps zmm30,zmm29,DWORD [rdx+0x200]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x0c, 0x72, 0x80                               }, { vpermilps zmm30,zmm29,DWORD [rdx-0x200]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x0c, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpermilps zmm30,zmm29,DWORD [rdx-0x204]{1to16}               }
testcase	{ 0x62, 0x03, 0xfd, 0x48, 0x01, 0xf5, 0xab                               }, { vpermpd zmm30,zmm29,0xab                                     }
testcase	{ 0x62, 0x03, 0xfd, 0x4f, 0x01, 0xf5, 0xab                               }, { vpermpd zmm30{k7},zmm29,0xab                                 }
testcase	{ 0x62, 0x03, 0xfd, 0xcf, 0x01, 0xf5, 0xab                               }, { vpermpd zmm30{k7}{z},zmm29,0xab                              }
testcase	{ 0x62, 0x03, 0xfd, 0x48, 0x01, 0xf5, 0x7b                               }, { vpermpd zmm30,zmm29,0x7b                                     }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x01, 0x31, 0x7b                               }, { vpermpd zmm30,ZWORD [rcx],0x7b                               }
testcase	{ 0x62, 0x23, 0xfd, 0x48, 0x01, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpermpd zmm30,ZWORD [rax+r14*8+0x123],0x7b                   }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x01, 0x31, 0x7b                               }, { vpermpd zmm30,QWORD [rcx]{1to8},0x7b                         }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x01, 0x72, 0x7f, 0x7b                         }, { vpermpd zmm30,ZWORD [rdx+0x1fc0],0x7b                        }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x01, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpermpd zmm30,ZWORD [rdx+0x2000],0x7b                        }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x01, 0x72, 0x80, 0x7b                         }, { vpermpd zmm30,ZWORD [rdx-0x2000],0x7b                        }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x01, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpermpd zmm30,ZWORD [rdx-0x2040],0x7b                        }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x01, 0x72, 0x7f, 0x7b                         }, { vpermpd zmm30,QWORD [rdx+0x3f8]{1to8},0x7b                   }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x01, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vpermpd zmm30,QWORD [rdx+0x400]{1to8},0x7b                   }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x01, 0x72, 0x80, 0x7b                         }, { vpermpd zmm30,QWORD [rdx-0x400]{1to8},0x7b                   }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x01, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vpermpd zmm30,QWORD [rdx-0x408]{1to8},0x7b                   }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x16, 0xf4                                     }, { vpermps zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x16, 0xf4                                     }, { vpermps zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x16, 0xf4                                     }, { vpermps zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x16, 0x31                                     }, { vpermps zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x16, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpermps zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x16, 0x31                                     }, { vpermps zmm30,zmm29,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x16, 0x72, 0x7f                               }, { vpermps zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x16, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpermps zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x16, 0x72, 0x80                               }, { vpermps zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x16, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpermps zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x16, 0x72, 0x7f                               }, { vpermps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x16, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpermps zmm30,zmm29,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x16, 0x72, 0x80                               }, { vpermps zmm30,zmm29,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x16, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpermps zmm30,zmm29,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x03, 0xfd, 0x48, 0x00, 0xf5, 0xab                               }, { vpermq zmm30,zmm29,0xab                                      }
testcase	{ 0x62, 0x03, 0xfd, 0x4f, 0x00, 0xf5, 0xab                               }, { vpermq zmm30{k7},zmm29,0xab                                  }
testcase	{ 0x62, 0x03, 0xfd, 0xcf, 0x00, 0xf5, 0xab                               }, { vpermq zmm30{k7}{z},zmm29,0xab                               }
testcase	{ 0x62, 0x03, 0xfd, 0x48, 0x00, 0xf5, 0x7b                               }, { vpermq zmm30,zmm29,0x7b                                      }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x00, 0x31, 0x7b                               }, { vpermq zmm30,ZWORD [rcx],0x7b                                }
testcase	{ 0x62, 0x23, 0xfd, 0x48, 0x00, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpermq zmm30,ZWORD [rax+r14*8+0x123],0x7b                    }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x00, 0x31, 0x7b                               }, { vpermq zmm30,QWORD [rcx]{1to8},0x7b                          }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x00, 0x72, 0x7f, 0x7b                         }, { vpermq zmm30,ZWORD [rdx+0x1fc0],0x7b                         }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x00, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpermq zmm30,ZWORD [rdx+0x2000],0x7b                         }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x00, 0x72, 0x80, 0x7b                         }, { vpermq zmm30,ZWORD [rdx-0x2000],0x7b                         }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x00, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpermq zmm30,ZWORD [rdx-0x2040],0x7b                         }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x00, 0x72, 0x7f, 0x7b                         }, { vpermq zmm30,QWORD [rdx+0x3f8]{1to8},0x7b                    }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x00, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vpermq zmm30,QWORD [rdx+0x400]{1to8},0x7b                    }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x00, 0x72, 0x80, 0x7b                         }, { vpermq zmm30,QWORD [rdx-0x400]{1to8},0x7b                    }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x00, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vpermq zmm30,QWORD [rdx-0x408]{1to8},0x7b                    }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x89, 0x31                                     }, { vpexpandd zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x89, 0x31                                     }, { vpexpandd zmm30{k7},ZWORD [rcx]                              }
testcase	{ 0x62, 0x62, 0x7d, 0xcf, 0x89, 0x31                                     }, { vpexpandd zmm30{k7}{z},ZWORD [rcx]                           }
testcase	{ 0x62, 0x22, 0x7d, 0x48, 0x89, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpexpandd zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x89, 0x72, 0x7f                               }, { vpexpandd zmm30,ZWORD [rdx+0x1fc]                            }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x89, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpexpandd zmm30,ZWORD [rdx+0x200]                            }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x89, 0x72, 0x80                               }, { vpexpandd zmm30,ZWORD [rdx-0x200]                            }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x89, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpexpandd zmm30,ZWORD [rdx-0x204]                            }
testcase	{ 0x62, 0x02, 0x7d, 0x48, 0x89, 0xf5                                     }, { vpexpandd zmm30,zmm29                                        }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x89, 0xf5                                     }, { vpexpandd zmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x89, 0xf5                                     }, { vpexpandd zmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x89, 0x31                                     }, { vpexpandq zmm30,ZWORD [rcx]                                  }
testcase	{ 0x62, 0x62, 0xfd, 0x4f, 0x89, 0x31                                     }, { vpexpandq zmm30{k7},ZWORD [rcx]                              }
testcase	{ 0x62, 0x62, 0xfd, 0xcf, 0x89, 0x31                                     }, { vpexpandq zmm30{k7}{z},ZWORD [rcx]                           }
testcase	{ 0x62, 0x22, 0xfd, 0x48, 0x89, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpexpandq zmm30,ZWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x89, 0x72, 0x7f                               }, { vpexpandq zmm30,ZWORD [rdx+0x3f8]                            }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x89, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpexpandq zmm30,ZWORD [rdx+0x400]                            }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x89, 0x72, 0x80                               }, { vpexpandq zmm30,ZWORD [rdx-0x400]                            }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x89, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpexpandq zmm30,ZWORD [rdx-0x408]                            }
testcase	{ 0x62, 0x02, 0xfd, 0x48, 0x89, 0xf5                                     }, { vpexpandq zmm30,zmm29                                        }
testcase	{ 0x62, 0x02, 0xfd, 0x4f, 0x89, 0xf5                                     }, { vpexpandq zmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x02, 0xfd, 0xcf, 0x89, 0xf5                                     }, { vpexpandq zmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x02, 0x7d, 0x41, 0x90, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vpgatherdd zmm30{k1}, [r14+zmm31*8+0x7b]                     }
testcase	{ 0x62, 0x02, 0x7d, 0x41, 0x90, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vpgatherdd zmm30{k1}, [r14+zmm31*8+0x7b]                     }
testcase	{ 0x62, 0x02, 0x7d, 0x41, 0x90, 0x74, 0x39, 0x40                         }, { vpgatherdd zmm30{k1}, [r9+zmm31*1+0x100]                     }
testcase	{ 0x62, 0x22, 0x7d, 0x41, 0x90, 0xb4, 0xb9, 0x00, 0x04, 0x00, 0x00       }, { vpgatherdd zmm30{k1}, [rcx+zmm31*4+0x400]                    }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0x90, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vpgatherdq zmm30{k1}, [r14+ymm31*8+0x7b]                     }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0x90, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vpgatherdq zmm30{k1}, [r14+ymm31*8+0x7b]                     }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0x90, 0x74, 0x39, 0x20                         }, { vpgatherdq zmm30{k1}, [r9+ymm31*1+0x100]                     }
testcase	{ 0x62, 0x22, 0xfd, 0x41, 0x90, 0xb4, 0xb9, 0x00, 0x04, 0x00, 0x00       }, { vpgatherdq zmm30{k1}, [rcx+ymm31*4+0x400]                    }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0x91, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vpgatherqq zmm30{k1}, [r14+zmm31*8+0x7b]                     }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0x91, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vpgatherqq zmm30{k1}, [r14+zmm31*8+0x7b]                     }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0x91, 0x74, 0x39, 0x20                         }, { vpgatherqq zmm30{k1}, [r9+zmm31*1+0x100]                     }
testcase	{ 0x62, 0x22, 0xfd, 0x41, 0x91, 0xb4, 0xb9, 0x00, 0x04, 0x00, 0x00       }, { vpgatherqq zmm30{k1}, [rcx+zmm31*4+0x400]                    }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x3d, 0xf4                                     }, { vpmaxsd zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x3d, 0xf4                                     }, { vpmaxsd zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x3d, 0xf4                                     }, { vpmaxsd zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3d, 0x31                                     }, { vpmaxsd zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x3d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmaxsd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3d, 0x31                                     }, { vpmaxsd zmm30,zmm29,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3d, 0x72, 0x7f                               }, { vpmaxsd zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3d, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpmaxsd zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3d, 0x72, 0x80                               }, { vpmaxsd zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3d, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpmaxsd zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3d, 0x72, 0x7f                               }, { vpmaxsd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3d, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpmaxsd zmm30,zmm29,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3d, 0x72, 0x80                               }, { vpmaxsd zmm30,zmm29,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3d, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpmaxsd zmm30,zmm29,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x3d, 0xf4                                     }, { vpmaxsq zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x3d, 0xf4                                     }, { vpmaxsq zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x3d, 0xf4                                     }, { vpmaxsq zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3d, 0x31                                     }, { vpmaxsq zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x3d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmaxsq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3d, 0x31                                     }, { vpmaxsq zmm30,zmm29,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3d, 0x72, 0x7f                               }, { vpmaxsq zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3d, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpmaxsq zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3d, 0x72, 0x80                               }, { vpmaxsq zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3d, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpmaxsq zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3d, 0x72, 0x7f                               }, { vpmaxsq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3d, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpmaxsq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3d, 0x72, 0x80                               }, { vpmaxsq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3d, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpmaxsq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x3f, 0xf4                                     }, { vpmaxud zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x3f, 0xf4                                     }, { vpmaxud zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x3f, 0xf4                                     }, { vpmaxud zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3f, 0x31                                     }, { vpmaxud zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x3f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmaxud zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3f, 0x31                                     }, { vpmaxud zmm30,zmm29,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3f, 0x72, 0x7f                               }, { vpmaxud zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3f, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpmaxud zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3f, 0x72, 0x80                               }, { vpmaxud zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3f, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpmaxud zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3f, 0x72, 0x7f                               }, { vpmaxud zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3f, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpmaxud zmm30,zmm29,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3f, 0x72, 0x80                               }, { vpmaxud zmm30,zmm29,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3f, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpmaxud zmm30,zmm29,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x3f, 0xf4                                     }, { vpmaxuq zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x3f, 0xf4                                     }, { vpmaxuq zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x3f, 0xf4                                     }, { vpmaxuq zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3f, 0x31                                     }, { vpmaxuq zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x3f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmaxuq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3f, 0x31                                     }, { vpmaxuq zmm30,zmm29,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3f, 0x72, 0x7f                               }, { vpmaxuq zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3f, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpmaxuq zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3f, 0x72, 0x80                               }, { vpmaxuq zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3f, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpmaxuq zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3f, 0x72, 0x7f                               }, { vpmaxuq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3f, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpmaxuq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3f, 0x72, 0x80                               }, { vpmaxuq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3f, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpmaxuq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x39, 0xf4                                     }, { vpminsd zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x39, 0xf4                                     }, { vpminsd zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x39, 0xf4                                     }, { vpminsd zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x39, 0x31                                     }, { vpminsd zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x39, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpminsd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x39, 0x31                                     }, { vpminsd zmm30,zmm29,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x39, 0x72, 0x7f                               }, { vpminsd zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x39, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpminsd zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x39, 0x72, 0x80                               }, { vpminsd zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x39, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpminsd zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x39, 0x72, 0x7f                               }, { vpminsd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x39, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpminsd zmm30,zmm29,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x39, 0x72, 0x80                               }, { vpminsd zmm30,zmm29,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x39, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpminsd zmm30,zmm29,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x39, 0xf4                                     }, { vpminsq zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x39, 0xf4                                     }, { vpminsq zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x39, 0xf4                                     }, { vpminsq zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x39, 0x31                                     }, { vpminsq zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x39, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpminsq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x39, 0x31                                     }, { vpminsq zmm30,zmm29,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x39, 0x72, 0x7f                               }, { vpminsq zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x39, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpminsq zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x39, 0x72, 0x80                               }, { vpminsq zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x39, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpminsq zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x39, 0x72, 0x7f                               }, { vpminsq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x39, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpminsq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x39, 0x72, 0x80                               }, { vpminsq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x39, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpminsq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x3b, 0xf4                                     }, { vpminud zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x3b, 0xf4                                     }, { vpminud zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x3b, 0xf4                                     }, { vpminud zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3b, 0x31                                     }, { vpminud zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x3b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpminud zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3b, 0x31                                     }, { vpminud zmm30,zmm29,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3b, 0x72, 0x7f                               }, { vpminud zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3b, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpminud zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3b, 0x72, 0x80                               }, { vpminud zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x3b, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpminud zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3b, 0x72, 0x7f                               }, { vpminud zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3b, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpminud zmm30,zmm29,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3b, 0x72, 0x80                               }, { vpminud zmm30,zmm29,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x3b, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpminud zmm30,zmm29,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x3b, 0xf4                                     }, { vpminuq zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x3b, 0xf4                                     }, { vpminuq zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x3b, 0xf4                                     }, { vpminuq zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3b, 0x31                                     }, { vpminuq zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x3b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpminuq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3b, 0x31                                     }, { vpminuq zmm30,zmm29,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3b, 0x72, 0x7f                               }, { vpminuq zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3b, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpminuq zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3b, 0x72, 0x80                               }, { vpminuq zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x3b, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpminuq zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3b, 0x72, 0x7f                               }, { vpminuq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3b, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpminuq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3b, 0x72, 0x80                               }, { vpminuq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x3b, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpminuq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x21, 0xf5                                     }, { vpmovsxbd zmm30{k7},xmm29                                    }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x21, 0xf5                                     }, { vpmovsxbd zmm30{k7}{z},xmm29                                 }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x21, 0x31                                     }, { vpmovsxbd zmm30{k7},OWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x7d, 0x4f, 0x21, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmovsxbd zmm30{k7},OWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x21, 0x72, 0x7f                               }, { vpmovsxbd zmm30{k7},OWORD [rdx+0x7f0]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x21, 0xb2, 0x00, 0x08, 0x00, 0x00             }, { vpmovsxbd zmm30{k7},OWORD [rdx+0x800]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x21, 0x72, 0x80                               }, { vpmovsxbd zmm30{k7},OWORD [rdx-0x800]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x21, 0xb2, 0xf0, 0xf7, 0xff, 0xff             }, { vpmovsxbd zmm30{k7},OWORD [rdx-0x810]                        }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x22, 0xf5                                     }, { vpmovsxbq zmm30{k7},xmm29                                    }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x22, 0xf5                                     }, { vpmovsxbq zmm30{k7}{z},xmm29                                 }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x22, 0x31                                     }, { vpmovsxbq zmm30{k7},QWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x7d, 0x4f, 0x22, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmovsxbq zmm30{k7},QWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x22, 0x72, 0x7f                               }, { vpmovsxbq zmm30{k7},QWORD [rdx+0x3f8]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x22, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpmovsxbq zmm30{k7},QWORD [rdx+0x400]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x22, 0x72, 0x80                               }, { vpmovsxbq zmm30{k7},QWORD [rdx-0x400]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x22, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpmovsxbq zmm30{k7},QWORD [rdx-0x408]                        }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x25, 0xf5                                     }, { vpmovsxdq zmm30{k7},ymm29                                    }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x25, 0xf5                                     }, { vpmovsxdq zmm30{k7}{z},ymm29                                 }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x25, 0x31                                     }, { vpmovsxdq zmm30{k7},YWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x7d, 0x4f, 0x25, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmovsxdq zmm30{k7},YWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x25, 0x72, 0x7f                               }, { vpmovsxdq zmm30{k7},YWORD [rdx+0xfe0]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x25, 0xb2, 0x00, 0x10, 0x00, 0x00             }, { vpmovsxdq zmm30{k7},YWORD [rdx+0x1000]                       }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x25, 0x72, 0x80                               }, { vpmovsxdq zmm30{k7},YWORD [rdx-0x1000]                       }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x25, 0xb2, 0xe0, 0xef, 0xff, 0xff             }, { vpmovsxdq zmm30{k7},YWORD [rdx-0x1020]                       }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x23, 0xf5                                     }, { vpmovsxwd zmm30{k7},ymm29                                    }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x23, 0xf5                                     }, { vpmovsxwd zmm30{k7}{z},ymm29                                 }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x23, 0x31                                     }, { vpmovsxwd zmm30{k7},YWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x7d, 0x4f, 0x23, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmovsxwd zmm30{k7},YWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x23, 0x72, 0x7f                               }, { vpmovsxwd zmm30{k7},YWORD [rdx+0xfe0]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x23, 0xb2, 0x00, 0x10, 0x00, 0x00             }, { vpmovsxwd zmm30{k7},YWORD [rdx+0x1000]                       }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x23, 0x72, 0x80                               }, { vpmovsxwd zmm30{k7},YWORD [rdx-0x1000]                       }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x23, 0xb2, 0xe0, 0xef, 0xff, 0xff             }, { vpmovsxwd zmm30{k7},YWORD [rdx-0x1020]                       }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x24, 0xf5                                     }, { vpmovsxwq zmm30{k7},xmm29                                    }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x24, 0xf5                                     }, { vpmovsxwq zmm30{k7}{z},xmm29                                 }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x24, 0x31                                     }, { vpmovsxwq zmm30{k7},OWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x7d, 0x4f, 0x24, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmovsxwq zmm30{k7},OWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x24, 0x72, 0x7f                               }, { vpmovsxwq zmm30{k7},OWORD [rdx+0x7f0]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x24, 0xb2, 0x00, 0x08, 0x00, 0x00             }, { vpmovsxwq zmm30{k7},OWORD [rdx+0x800]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x24, 0x72, 0x80                               }, { vpmovsxwq zmm30{k7},OWORD [rdx-0x800]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x24, 0xb2, 0xf0, 0xf7, 0xff, 0xff             }, { vpmovsxwq zmm30{k7},OWORD [rdx-0x810]                        }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x31, 0xf5                                     }, { vpmovzxbd zmm30{k7},xmm29                                    }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x31, 0xf5                                     }, { vpmovzxbd zmm30{k7}{z},xmm29                                 }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x31, 0x31                                     }, { vpmovzxbd zmm30{k7},OWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x7d, 0x4f, 0x31, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmovzxbd zmm30{k7},OWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x31, 0x72, 0x7f                               }, { vpmovzxbd zmm30{k7},OWORD [rdx+0x7f0]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x31, 0xb2, 0x00, 0x08, 0x00, 0x00             }, { vpmovzxbd zmm30{k7},OWORD [rdx+0x800]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x31, 0x72, 0x80                               }, { vpmovzxbd zmm30{k7},OWORD [rdx-0x800]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x31, 0xb2, 0xf0, 0xf7, 0xff, 0xff             }, { vpmovzxbd zmm30{k7},OWORD [rdx-0x810]                        }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x32, 0xf5                                     }, { vpmovzxbq zmm30{k7},xmm29                                    }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x32, 0xf5                                     }, { vpmovzxbq zmm30{k7}{z},xmm29                                 }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x32, 0x31                                     }, { vpmovzxbq zmm30{k7},QWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x7d, 0x4f, 0x32, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmovzxbq zmm30{k7},QWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x32, 0x72, 0x7f                               }, { vpmovzxbq zmm30{k7},QWORD [rdx+0x3f8]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x32, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpmovzxbq zmm30{k7},QWORD [rdx+0x400]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x32, 0x72, 0x80                               }, { vpmovzxbq zmm30{k7},QWORD [rdx-0x400]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x32, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpmovzxbq zmm30{k7},QWORD [rdx-0x408]                        }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x35, 0xf5                                     }, { vpmovzxdq zmm30{k7},ymm29                                    }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x35, 0xf5                                     }, { vpmovzxdq zmm30{k7}{z},ymm29                                 }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x35, 0x31                                     }, { vpmovzxdq zmm30{k7},YWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x7d, 0x4f, 0x35, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmovzxdq zmm30{k7},YWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x35, 0x72, 0x7f                               }, { vpmovzxdq zmm30{k7},YWORD [rdx+0xfe0]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x35, 0xb2, 0x00, 0x10, 0x00, 0x00             }, { vpmovzxdq zmm30{k7},YWORD [rdx+0x1000]                       }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x35, 0x72, 0x80                               }, { vpmovzxdq zmm30{k7},YWORD [rdx-0x1000]                       }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x35, 0xb2, 0xe0, 0xef, 0xff, 0xff             }, { vpmovzxdq zmm30{k7},YWORD [rdx-0x1020]                       }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x33, 0xf5                                     }, { vpmovzxwd zmm30{k7},ymm29                                    }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x33, 0xf5                                     }, { vpmovzxwd zmm30{k7}{z},ymm29                                 }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x33, 0x31                                     }, { vpmovzxwd zmm30{k7},YWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x7d, 0x4f, 0x33, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmovzxwd zmm30{k7},YWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x33, 0x72, 0x7f                               }, { vpmovzxwd zmm30{k7},YWORD [rdx+0xfe0]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x33, 0xb2, 0x00, 0x10, 0x00, 0x00             }, { vpmovzxwd zmm30{k7},YWORD [rdx+0x1000]                       }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x33, 0x72, 0x80                               }, { vpmovzxwd zmm30{k7},YWORD [rdx-0x1000]                       }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x33, 0xb2, 0xe0, 0xef, 0xff, 0xff             }, { vpmovzxwd zmm30{k7},YWORD [rdx-0x1020]                       }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x34, 0xf5                                     }, { vpmovzxwq zmm30{k7},xmm29                                    }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x34, 0xf5                                     }, { vpmovzxwq zmm30{k7}{z},xmm29                                 }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x34, 0x31                                     }, { vpmovzxwq zmm30{k7},OWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x7d, 0x4f, 0x34, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmovzxwq zmm30{k7},OWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x34, 0x72, 0x7f                               }, { vpmovzxwq zmm30{k7},OWORD [rdx+0x7f0]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x34, 0xb2, 0x00, 0x08, 0x00, 0x00             }, { vpmovzxwq zmm30{k7},OWORD [rdx+0x800]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x34, 0x72, 0x80                               }, { vpmovzxwq zmm30{k7},OWORD [rdx-0x800]                        }
testcase	{ 0x62, 0x62, 0x7d, 0x4f, 0x34, 0xb2, 0xf0, 0xf7, 0xff, 0xff             }, { vpmovzxwq zmm30{k7},OWORD [rdx-0x810]                        }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x28, 0xf4                                     }, { vpmuldq zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x28, 0xf4                                     }, { vpmuldq zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x28, 0xf4                                     }, { vpmuldq zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x28, 0x31                                     }, { vpmuldq zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x28, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmuldq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x28, 0x31                                     }, { vpmuldq zmm30,zmm29,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x28, 0x72, 0x7f                               }, { vpmuldq zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x28, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpmuldq zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x28, 0x72, 0x80                               }, { vpmuldq zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x28, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpmuldq zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x28, 0x72, 0x7f                               }, { vpmuldq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x28, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpmuldq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x28, 0x72, 0x80                               }, { vpmuldq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x28, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpmuldq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x40, 0xf4                                     }, { vpmulld zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x40, 0xf4                                     }, { vpmulld zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x40, 0xf4                                     }, { vpmulld zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x40, 0x31                                     }, { vpmulld zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x40, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmulld zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x40, 0x31                                     }, { vpmulld zmm30,zmm29,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x40, 0x72, 0x7f                               }, { vpmulld zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x40, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpmulld zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x40, 0x72, 0x80                               }, { vpmulld zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x40, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpmulld zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x40, 0x72, 0x7f                               }, { vpmulld zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x40, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpmulld zmm30,zmm29,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x40, 0x72, 0x80                               }, { vpmulld zmm30,zmm29,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x40, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpmulld zmm30,zmm29,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0xf4, 0xf4                                     }, { vpmuludq zmm30,zmm29,zmm28                                   }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0xf4, 0xf4                                     }, { vpmuludq zmm30{k7},zmm29,zmm28                               }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0xf4, 0xf4                                     }, { vpmuludq zmm30{k7}{z},zmm29,zmm28                            }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xf4, 0x31                                     }, { vpmuludq zmm30,zmm29,ZWORD [rcx]                             }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0xf4, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpmuludq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xf4, 0x31                                     }, { vpmuludq zmm30,zmm29,QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xf4, 0x72, 0x7f                               }, { vpmuludq zmm30,zmm29,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xf4, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpmuludq zmm30,zmm29,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xf4, 0x72, 0x80                               }, { vpmuludq zmm30,zmm29,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xf4, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpmuludq zmm30,zmm29,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xf4, 0x72, 0x7f                               }, { vpmuludq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xf4, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpmuludq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xf4, 0x72, 0x80                               }, { vpmuludq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xf4, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpmuludq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x01, 0x15, 0x40, 0xeb, 0xf4                                     }, { vpord  zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x15, 0x47, 0xeb, 0xf4                                     }, { vpord  zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x15, 0xc7, 0xeb, 0xf4                                     }, { vpord  zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xeb, 0x31                                     }, { vpord  zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x15, 0x40, 0xeb, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpord  zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xeb, 0x31                                     }, { vpord  zmm30,zmm29,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xeb, 0x72, 0x7f                               }, { vpord  zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xeb, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpord  zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xeb, 0x72, 0x80                               }, { vpord  zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xeb, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpord  zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xeb, 0x72, 0x7f                               }, { vpord  zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xeb, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpord  zmm30,zmm29,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xeb, 0x72, 0x80                               }, { vpord  zmm30,zmm29,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xeb, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpord  zmm30,zmm29,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0xeb, 0xf4                                     }, { vporq  zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0xeb, 0xf4                                     }, { vporq  zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0xeb, 0xf4                                     }, { vporq  zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xeb, 0x31                                     }, { vporq  zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0xeb, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vporq  zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xeb, 0x31                                     }, { vporq  zmm30,zmm29,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xeb, 0x72, 0x7f                               }, { vporq  zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xeb, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vporq  zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xeb, 0x72, 0x80                               }, { vporq  zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xeb, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vporq  zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xeb, 0x72, 0x7f                               }, { vporq  zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xeb, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vporq  zmm30,zmm29,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xeb, 0x72, 0x80                               }, { vporq  zmm30,zmm29,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xeb, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vporq  zmm30,zmm29,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x02, 0x7d, 0x41, 0xa0, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vpscatterdd  [r14+zmm31*8+0x7b]{k1},zmm30                    }
testcase	{ 0x62, 0x02, 0x7d, 0x41, 0xa0, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vpscatterdd  [r14+zmm31*8+0x7b]{k1},zmm30                    }
testcase	{ 0x62, 0x02, 0x7d, 0x41, 0xa0, 0x74, 0x39, 0x40                         }, { vpscatterdd  [r9+zmm31*1+0x100]{k1},zmm30                    }
testcase	{ 0x62, 0x22, 0x7d, 0x41, 0xa0, 0xb4, 0xb9, 0x00, 0x04, 0x00, 0x00       }, { vpscatterdd  [rcx+zmm31*4+0x400]{k1},zmm30                   }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0xa0, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vpscatterdq  [r14+ymm31*8+0x7b]{k1},zmm30                    }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0xa0, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vpscatterdq  [r14+ymm31*8+0x7b]{k1},zmm30                    }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0xa0, 0x74, 0x39, 0x20                         }, { vpscatterdq  [r9+ymm31*1+0x100]{k1},zmm30                    }
testcase	{ 0x62, 0x22, 0xfd, 0x41, 0xa0, 0xb4, 0xb9, 0x00, 0x04, 0x00, 0x00       }, { vpscatterdq  [rcx+ymm31*4+0x400]{k1},zmm30                   }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0xa1, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vpscatterqq  [r14+zmm31*8+0x7b]{k1},zmm30                    }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0xa1, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vpscatterqq  [r14+zmm31*8+0x7b]{k1},zmm30                    }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0xa1, 0x74, 0x39, 0x20                         }, { vpscatterqq  [r9+zmm31*1+0x100]{k1},zmm30                    }
testcase	{ 0x62, 0x22, 0xfd, 0x41, 0xa1, 0xb4, 0xb9, 0x00, 0x04, 0x00, 0x00       }, { vpscatterqq  [rcx+zmm31*4+0x400]{k1},zmm30                   }
testcase	{ 0x62, 0x01, 0x7d, 0x48, 0x70, 0xf5, 0xab                               }, { vpshufd zmm30,zmm29,0xab                                     }
testcase	{ 0x62, 0x01, 0x7d, 0x4f, 0x70, 0xf5, 0xab                               }, { vpshufd zmm30{k7},zmm29,0xab                                 }
testcase	{ 0x62, 0x01, 0x7d, 0xcf, 0x70, 0xf5, 0xab                               }, { vpshufd zmm30{k7}{z},zmm29,0xab                              }
testcase	{ 0x62, 0x01, 0x7d, 0x48, 0x70, 0xf5, 0x7b                               }, { vpshufd zmm30,zmm29,0x7b                                     }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x70, 0x31, 0x7b                               }, { vpshufd zmm30,ZWORD [rcx],0x7b                               }
testcase	{ 0x62, 0x21, 0x7d, 0x48, 0x70, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpshufd zmm30,ZWORD [rax+r14*8+0x123],0x7b                   }
testcase	{ 0x62, 0x61, 0x7d, 0x58, 0x70, 0x31, 0x7b                               }, { vpshufd zmm30,DWORD [rcx]{1to16},0x7b                        }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x70, 0x72, 0x7f, 0x7b                         }, { vpshufd zmm30,ZWORD [rdx+0x1fc0],0x7b                        }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x70, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpshufd zmm30,ZWORD [rdx+0x2000],0x7b                        }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x70, 0x72, 0x80, 0x7b                         }, { vpshufd zmm30,ZWORD [rdx-0x2000],0x7b                        }
testcase	{ 0x62, 0x61, 0x7d, 0x48, 0x70, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpshufd zmm30,ZWORD [rdx-0x2040],0x7b                        }
testcase	{ 0x62, 0x61, 0x7d, 0x58, 0x70, 0x72, 0x7f, 0x7b                         }, { vpshufd zmm30,DWORD [rdx+0x1fc]{1to16},0x7b                  }
testcase	{ 0x62, 0x61, 0x7d, 0x58, 0x70, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vpshufd zmm30,DWORD [rdx+0x200]{1to16},0x7b                  }
testcase	{ 0x62, 0x61, 0x7d, 0x58, 0x70, 0x72, 0x80, 0x7b                         }, { vpshufd zmm30,DWORD [rdx-0x200]{1to16},0x7b                  }
testcase	{ 0x62, 0x61, 0x7d, 0x58, 0x70, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vpshufd zmm30,DWORD [rdx-0x204]{1to16},0x7b                  }
testcase	{ 0x62, 0x01, 0x15, 0x47, 0xf2, 0xf4                                     }, { vpslld zmm30{k7},zmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x15, 0xc7, 0xf2, 0xf4                                     }, { vpslld zmm30{k7}{z},zmm29,xmm28                              }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xf2, 0x31                                     }, { vpslld zmm30{k7},zmm29,OWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x15, 0x47, 0xf2, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpslld zmm30{k7},zmm29,OWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xf2, 0x72, 0x7f                               }, { vpslld zmm30{k7},zmm29,OWORD [rdx+0x7f0]                     }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xf2, 0xb2, 0x00, 0x08, 0x00, 0x00             }, { vpslld zmm30{k7},zmm29,OWORD [rdx+0x800]                     }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xf2, 0x72, 0x80                               }, { vpslld zmm30{k7},zmm29,OWORD [rdx-0x800]                     }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xf2, 0xb2, 0xf0, 0xf7, 0xff, 0xff             }, { vpslld zmm30{k7},zmm29,OWORD [rdx-0x810]                     }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0xf3, 0xf4                                     }, { vpsllq zmm30{k7},zmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0xf3, 0xf4                                     }, { vpsllq zmm30{k7}{z},zmm29,xmm28                              }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xf3, 0x31                                     }, { vpsllq zmm30{k7},zmm29,OWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x95, 0x47, 0xf3, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpsllq zmm30{k7},zmm29,OWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xf3, 0x72, 0x7f                               }, { vpsllq zmm30{k7},zmm29,OWORD [rdx+0x7f0]                     }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xf3, 0xb2, 0x00, 0x08, 0x00, 0x00             }, { vpsllq zmm30{k7},zmm29,OWORD [rdx+0x800]                     }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xf3, 0x72, 0x80                               }, { vpsllq zmm30{k7},zmm29,OWORD [rdx-0x800]                     }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xf3, 0xb2, 0xf0, 0xf7, 0xff, 0xff             }, { vpsllq zmm30{k7},zmm29,OWORD [rdx-0x810]                     }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x47, 0xf4                                     }, { vpsllvd zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x47, 0xf4                                     }, { vpsllvd zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x47, 0xf4                                     }, { vpsllvd zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x47, 0x31                                     }, { vpsllvd zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x47, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpsllvd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x47, 0x31                                     }, { vpsllvd zmm30,zmm29,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x47, 0x72, 0x7f                               }, { vpsllvd zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x47, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpsllvd zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x47, 0x72, 0x80                               }, { vpsllvd zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x47, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpsllvd zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x47, 0x72, 0x7f                               }, { vpsllvd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x47, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpsllvd zmm30,zmm29,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x47, 0x72, 0x80                               }, { vpsllvd zmm30,zmm29,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x47, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpsllvd zmm30,zmm29,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x47, 0xf4                                     }, { vpsllvq zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x47, 0xf4                                     }, { vpsllvq zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x47, 0xf4                                     }, { vpsllvq zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x47, 0x31                                     }, { vpsllvq zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x47, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpsllvq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x47, 0x31                                     }, { vpsllvq zmm30,zmm29,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x47, 0x72, 0x7f                               }, { vpsllvq zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x47, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpsllvq zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x47, 0x72, 0x80                               }, { vpsllvq zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x47, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpsllvq zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x47, 0x72, 0x7f                               }, { vpsllvq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x47, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpsllvq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x47, 0x72, 0x80                               }, { vpsllvq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x47, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpsllvq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x01, 0x15, 0x47, 0xe2, 0xf4                                     }, { vpsrad zmm30{k7},zmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x15, 0xc7, 0xe2, 0xf4                                     }, { vpsrad zmm30{k7}{z},zmm29,xmm28                              }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xe2, 0x31                                     }, { vpsrad zmm30{k7},zmm29,OWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x15, 0x47, 0xe2, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpsrad zmm30{k7},zmm29,OWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xe2, 0x72, 0x7f                               }, { vpsrad zmm30{k7},zmm29,OWORD [rdx+0x7f0]                     }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xe2, 0xb2, 0x00, 0x08, 0x00, 0x00             }, { vpsrad zmm30{k7},zmm29,OWORD [rdx+0x800]                     }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xe2, 0x72, 0x80                               }, { vpsrad zmm30{k7},zmm29,OWORD [rdx-0x800]                     }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xe2, 0xb2, 0xf0, 0xf7, 0xff, 0xff             }, { vpsrad zmm30{k7},zmm29,OWORD [rdx-0x810]                     }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0xe2, 0xf4                                     }, { vpsraq zmm30{k7},zmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0xe2, 0xf4                                     }, { vpsraq zmm30{k7}{z},zmm29,xmm28                              }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xe2, 0x31                                     }, { vpsraq zmm30{k7},zmm29,OWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x95, 0x47, 0xe2, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpsraq zmm30{k7},zmm29,OWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xe2, 0x72, 0x7f                               }, { vpsraq zmm30{k7},zmm29,OWORD [rdx+0x7f0]                     }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xe2, 0xb2, 0x00, 0x08, 0x00, 0x00             }, { vpsraq zmm30{k7},zmm29,OWORD [rdx+0x800]                     }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xe2, 0x72, 0x80                               }, { vpsraq zmm30{k7},zmm29,OWORD [rdx-0x800]                     }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xe2, 0xb2, 0xf0, 0xf7, 0xff, 0xff             }, { vpsraq zmm30{k7},zmm29,OWORD [rdx-0x810]                     }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x46, 0xf4                                     }, { vpsravd zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x46, 0xf4                                     }, { vpsravd zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x46, 0xf4                                     }, { vpsravd zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x46, 0x31                                     }, { vpsravd zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x46, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpsravd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x46, 0x31                                     }, { vpsravd zmm30,zmm29,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x46, 0x72, 0x7f                               }, { vpsravd zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x46, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpsravd zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x46, 0x72, 0x80                               }, { vpsravd zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x46, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpsravd zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x46, 0x72, 0x7f                               }, { vpsravd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x46, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpsravd zmm30,zmm29,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x46, 0x72, 0x80                               }, { vpsravd zmm30,zmm29,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x46, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpsravd zmm30,zmm29,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x46, 0xf4                                     }, { vpsravq zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x46, 0xf4                                     }, { vpsravq zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x46, 0xf4                                     }, { vpsravq zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x46, 0x31                                     }, { vpsravq zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x46, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpsravq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x46, 0x31                                     }, { vpsravq zmm30,zmm29,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x46, 0x72, 0x7f                               }, { vpsravq zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x46, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpsravq zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x46, 0x72, 0x80                               }, { vpsravq zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x46, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpsravq zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x46, 0x72, 0x7f                               }, { vpsravq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x46, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpsravq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x46, 0x72, 0x80                               }, { vpsravq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x46, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpsravq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x01, 0x15, 0x47, 0xd2, 0xf4                                     }, { vpsrld zmm30{k7},zmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x15, 0xc7, 0xd2, 0xf4                                     }, { vpsrld zmm30{k7}{z},zmm29,xmm28                              }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xd2, 0x31                                     }, { vpsrld zmm30{k7},zmm29,OWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x15, 0x47, 0xd2, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpsrld zmm30{k7},zmm29,OWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xd2, 0x72, 0x7f                               }, { vpsrld zmm30{k7},zmm29,OWORD [rdx+0x7f0]                     }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xd2, 0xb2, 0x00, 0x08, 0x00, 0x00             }, { vpsrld zmm30{k7},zmm29,OWORD [rdx+0x800]                     }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xd2, 0x72, 0x80                               }, { vpsrld zmm30{k7},zmm29,OWORD [rdx-0x800]                     }
testcase	{ 0x62, 0x61, 0x15, 0x47, 0xd2, 0xb2, 0xf0, 0xf7, 0xff, 0xff             }, { vpsrld zmm30{k7},zmm29,OWORD [rdx-0x810]                     }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0xd3, 0xf4                                     }, { vpsrlq zmm30{k7},zmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0xd3, 0xf4                                     }, { vpsrlq zmm30{k7}{z},zmm29,xmm28                              }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xd3, 0x31                                     }, { vpsrlq zmm30{k7},zmm29,OWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x95, 0x47, 0xd3, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpsrlq zmm30{k7},zmm29,OWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xd3, 0x72, 0x7f                               }, { vpsrlq zmm30{k7},zmm29,OWORD [rdx+0x7f0]                     }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xd3, 0xb2, 0x00, 0x08, 0x00, 0x00             }, { vpsrlq zmm30{k7},zmm29,OWORD [rdx+0x800]                     }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xd3, 0x72, 0x80                               }, { vpsrlq zmm30{k7},zmm29,OWORD [rdx-0x800]                     }
testcase	{ 0x62, 0x61, 0x95, 0x47, 0xd3, 0xb2, 0xf0, 0xf7, 0xff, 0xff             }, { vpsrlq zmm30{k7},zmm29,OWORD [rdx-0x810]                     }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x45, 0xf4                                     }, { vpsrlvd zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x45, 0xf4                                     }, { vpsrlvd zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x45, 0xf4                                     }, { vpsrlvd zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x45, 0x31                                     }, { vpsrlvd zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x45, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpsrlvd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x45, 0x31                                     }, { vpsrlvd zmm30,zmm29,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x45, 0x72, 0x7f                               }, { vpsrlvd zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x45, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpsrlvd zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x45, 0x72, 0x80                               }, { vpsrlvd zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x45, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpsrlvd zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x45, 0x72, 0x7f                               }, { vpsrlvd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x45, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpsrlvd zmm30,zmm29,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x45, 0x72, 0x80                               }, { vpsrlvd zmm30,zmm29,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x45, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpsrlvd zmm30,zmm29,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x45, 0xf4                                     }, { vpsrlvq zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x45, 0xf4                                     }, { vpsrlvq zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x45, 0xf4                                     }, { vpsrlvq zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x45, 0x31                                     }, { vpsrlvq zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x45, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpsrlvq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x45, 0x31                                     }, { vpsrlvq zmm30,zmm29,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x45, 0x72, 0x7f                               }, { vpsrlvq zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x45, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpsrlvq zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x45, 0x72, 0x80                               }, { vpsrlvq zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x45, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpsrlvq zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x45, 0x72, 0x7f                               }, { vpsrlvq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x45, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpsrlvq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x45, 0x72, 0x80                               }, { vpsrlvq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x45, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpsrlvq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x91, 0x0d, 0x40, 0x72, 0xd5, 0xab                               }, { vpsrld zmm30,zmm29,0xab                                      }
testcase	{ 0x62, 0x91, 0x0d, 0x47, 0x72, 0xd5, 0xab                               }, { vpsrld zmm30{k7},zmm29,0xab                                  }
testcase	{ 0x62, 0x91, 0x0d, 0xc7, 0x72, 0xd5, 0xab                               }, { vpsrld zmm30{k7}{z},zmm29,0xab                               }
testcase	{ 0x62, 0x91, 0x0d, 0x40, 0x72, 0xd5, 0x7b                               }, { vpsrld zmm30,zmm29,0x7b                                      }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x11, 0x7b                               }, { vpsrld zmm30,ZWORD [rcx],0x7b                                }
testcase	{ 0x62, 0xb1, 0x0d, 0x40, 0x72, 0x94, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpsrld zmm30,ZWORD [rax+r14*8+0x123],0x7b                    }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x11, 0x7b                               }, { vpsrld zmm30,DWORD [rcx]{1to16},0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x52, 0x7f, 0x7b                         }, { vpsrld zmm30,ZWORD [rdx+0x1fc0],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x92, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpsrld zmm30,ZWORD [rdx+0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x52, 0x80, 0x7b                         }, { vpsrld zmm30,ZWORD [rdx-0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x92, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpsrld zmm30,ZWORD [rdx-0x2040],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x52, 0x7f, 0x7b                         }, { vpsrld zmm30,DWORD [rdx+0x1fc]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x92, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vpsrld zmm30,DWORD [rdx+0x200]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x52, 0x80, 0x7b                         }, { vpsrld zmm30,DWORD [rdx-0x200]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x92, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vpsrld zmm30,DWORD [rdx-0x204]{1to16},0x7b                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0x73, 0xd5, 0xab                               }, { vpsrlq zmm30,zmm29,0xab                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0x73, 0xd5, 0xab                               }, { vpsrlq zmm30{k7},zmm29,0xab                                  }
testcase	{ 0x62, 0x91, 0x8d, 0xc7, 0x73, 0xd5, 0xab                               }, { vpsrlq zmm30{k7}{z},zmm29,0xab                               }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0x73, 0xd5, 0x7b                               }, { vpsrlq zmm30,zmm29,0x7b                                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x73, 0x11, 0x7b                               }, { vpsrlq zmm30,ZWORD [rcx],0x7b                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0x73, 0x94, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpsrlq zmm30,ZWORD [rax+r14*8+0x123],0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x73, 0x11, 0x7b                               }, { vpsrlq zmm30,QWORD [rcx]{1to8},0x7b                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x73, 0x52, 0x7f, 0x7b                         }, { vpsrlq zmm30,ZWORD [rdx+0x1fc0],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x73, 0x92, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpsrlq zmm30,ZWORD [rdx+0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x73, 0x52, 0x80, 0x7b                         }, { vpsrlq zmm30,ZWORD [rdx-0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x73, 0x92, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpsrlq zmm30,ZWORD [rdx-0x2040],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x73, 0x52, 0x7f, 0x7b                         }, { vpsrlq zmm30,QWORD [rdx+0x3f8]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x73, 0x92, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vpsrlq zmm30,QWORD [rdx+0x400]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x73, 0x52, 0x80, 0x7b                         }, { vpsrlq zmm30,QWORD [rdx-0x400]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x73, 0x92, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vpsrlq zmm30,QWORD [rdx-0x408]{1to8},0x7b                    }
testcase	{ 0x62, 0x01, 0x15, 0x40, 0xfa, 0xf4                                     }, { vpsubd zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x15, 0x47, 0xfa, 0xf4                                     }, { vpsubd zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x15, 0xc7, 0xfa, 0xf4                                     }, { vpsubd zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xfa, 0x31                                     }, { vpsubd zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x15, 0x40, 0xfa, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpsubd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xfa, 0x31                                     }, { vpsubd zmm30,zmm29,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xfa, 0x72, 0x7f                               }, { vpsubd zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xfa, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpsubd zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xfa, 0x72, 0x80                               }, { vpsubd zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xfa, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpsubd zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xfa, 0x72, 0x7f                               }, { vpsubd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xfa, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpsubd zmm30,zmm29,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xfa, 0x72, 0x80                               }, { vpsubd zmm30,zmm29,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xfa, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpsubd zmm30,zmm29,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0xfb, 0xf4                                     }, { vpsubq zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0xfb, 0xf4                                     }, { vpsubq zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0xfb, 0xf4                                     }, { vpsubq zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xfb, 0x31                                     }, { vpsubq zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0xfb, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpsubq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xfb, 0x31                                     }, { vpsubq zmm30,zmm29,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xfb, 0x72, 0x7f                               }, { vpsubq zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xfb, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpsubq zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xfb, 0x72, 0x80                               }, { vpsubq zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xfb, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpsubq zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xfb, 0x72, 0x7f                               }, { vpsubq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xfb, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpsubq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xfb, 0x72, 0x80                               }, { vpsubq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xfb, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpsubq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x92, 0x0d, 0x40, 0x27, 0xed                                     }, { vptestmd k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x92, 0x0d, 0x47, 0x27, 0xed                                     }, { vptestmd k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0xf2, 0x0d, 0x40, 0x27, 0x29                                     }, { vptestmd k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb2, 0x0d, 0x40, 0x27, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vptestmd k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf2, 0x0d, 0x50, 0x27, 0x29                                     }, { vptestmd k5,zmm30,DWORD [rcx]{1to16}                         }
testcase	{ 0x62, 0xf2, 0x0d, 0x40, 0x27, 0x6a, 0x7f                               }, { vptestmd k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf2, 0x0d, 0x40, 0x27, 0xaa, 0x00, 0x20, 0x00, 0x00             }, { vptestmd k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf2, 0x0d, 0x40, 0x27, 0x6a, 0x80                               }, { vptestmd k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf2, 0x0d, 0x40, 0x27, 0xaa, 0xc0, 0xdf, 0xff, 0xff             }, { vptestmd k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf2, 0x0d, 0x50, 0x27, 0x6a, 0x7f                               }, { vptestmd k5,zmm30,DWORD [rdx+0x1fc]{1to16}                   }
testcase	{ 0x62, 0xf2, 0x0d, 0x50, 0x27, 0xaa, 0x00, 0x02, 0x00, 0x00             }, { vptestmd k5,zmm30,DWORD [rdx+0x200]{1to16}                   }
testcase	{ 0x62, 0xf2, 0x0d, 0x50, 0x27, 0x6a, 0x80                               }, { vptestmd k5,zmm30,DWORD [rdx-0x200]{1to16}                   }
testcase	{ 0x62, 0xf2, 0x0d, 0x50, 0x27, 0xaa, 0xfc, 0xfd, 0xff, 0xff             }, { vptestmd k5,zmm30,DWORD [rdx-0x204]{1to16}                   }
testcase	{ 0x62, 0x92, 0x8d, 0x40, 0x27, 0xed                                     }, { vptestmq k5,zmm30,zmm29                                      }
testcase	{ 0x62, 0x92, 0x8d, 0x47, 0x27, 0xed                                     }, { vptestmq k5{k7},zmm30,zmm29                                  }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x27, 0x29                                     }, { vptestmq k5,zmm30,ZWORD [rcx]                                }
testcase	{ 0x62, 0xb2, 0x8d, 0x40, 0x27, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vptestmq k5,zmm30,ZWORD [rax+r14*8+0x123]                    }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x27, 0x29                                     }, { vptestmq k5,zmm30,QWORD [rcx]{1to8}                          }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x27, 0x6a, 0x7f                               }, { vptestmq k5,zmm30,ZWORD [rdx+0x1fc0]                         }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x27, 0xaa, 0x00, 0x20, 0x00, 0x00             }, { vptestmq k5,zmm30,ZWORD [rdx+0x2000]                         }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x27, 0x6a, 0x80                               }, { vptestmq k5,zmm30,ZWORD [rdx-0x2000]                         }
testcase	{ 0x62, 0xf2, 0x8d, 0x40, 0x27, 0xaa, 0xc0, 0xdf, 0xff, 0xff             }, { vptestmq k5,zmm30,ZWORD [rdx-0x2040]                         }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x27, 0x6a, 0x7f                               }, { vptestmq k5,zmm30,QWORD [rdx+0x3f8]{1to8}                    }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x27, 0xaa, 0x00, 0x04, 0x00, 0x00             }, { vptestmq k5,zmm30,QWORD [rdx+0x400]{1to8}                    }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x27, 0x6a, 0x80                               }, { vptestmq k5,zmm30,QWORD [rdx-0x400]{1to8}                    }
testcase	{ 0x62, 0xf2, 0x8d, 0x50, 0x27, 0xaa, 0xf8, 0xfb, 0xff, 0xff             }, { vptestmq k5,zmm30,QWORD [rdx-0x408]{1to8}                    }
testcase	{ 0x62, 0x01, 0x15, 0x40, 0x6a, 0xf4                                     }, { vpunpckhdq zmm30,zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x15, 0x47, 0x6a, 0xf4                                     }, { vpunpckhdq zmm30{k7},zmm29,zmm28                             }
testcase	{ 0x62, 0x01, 0x15, 0xc7, 0x6a, 0xf4                                     }, { vpunpckhdq zmm30{k7}{z},zmm29,zmm28                          }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0x6a, 0x31                                     }, { vpunpckhdq zmm30,zmm29,ZWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x15, 0x40, 0x6a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpunpckhdq zmm30,zmm29,ZWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0x6a, 0x31                                     }, { vpunpckhdq zmm30,zmm29,DWORD [rcx]{1to16}                    }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0x6a, 0x72, 0x7f                               }, { vpunpckhdq zmm30,zmm29,ZWORD [rdx+0x1fc0]                    }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0x6a, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpunpckhdq zmm30,zmm29,ZWORD [rdx+0x2000]                    }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0x6a, 0x72, 0x80                               }, { vpunpckhdq zmm30,zmm29,ZWORD [rdx-0x2000]                    }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0x6a, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpunpckhdq zmm30,zmm29,ZWORD [rdx-0x2040]                    }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0x6a, 0x72, 0x7f                               }, { vpunpckhdq zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}              }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0x6a, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpunpckhdq zmm30,zmm29,DWORD [rdx+0x200]{1to16}              }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0x6a, 0x72, 0x80                               }, { vpunpckhdq zmm30,zmm29,DWORD [rdx-0x200]{1to16}              }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0x6a, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpunpckhdq zmm30,zmm29,DWORD [rdx-0x204]{1to16}              }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0x6d, 0xf4                                     }, { vpunpckhqdq zmm30,zmm29,zmm28                                }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0x6d, 0xf4                                     }, { vpunpckhqdq zmm30{k7},zmm29,zmm28                            }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0x6d, 0xf4                                     }, { vpunpckhqdq zmm30{k7}{z},zmm29,zmm28                         }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x6d, 0x31                                     }, { vpunpckhqdq zmm30,zmm29,ZWORD [rcx]                          }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0x6d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpunpckhqdq zmm30,zmm29,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x6d, 0x31                                     }, { vpunpckhqdq zmm30,zmm29,QWORD [rcx]{1to8}                    }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x6d, 0x72, 0x7f                               }, { vpunpckhqdq zmm30,zmm29,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x6d, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpunpckhqdq zmm30,zmm29,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x6d, 0x72, 0x80                               }, { vpunpckhqdq zmm30,zmm29,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x6d, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpunpckhqdq zmm30,zmm29,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x6d, 0x72, 0x7f                               }, { vpunpckhqdq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}              }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x6d, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpunpckhqdq zmm30,zmm29,QWORD [rdx+0x400]{1to8}              }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x6d, 0x72, 0x80                               }, { vpunpckhqdq zmm30,zmm29,QWORD [rdx-0x400]{1to8}              }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x6d, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpunpckhqdq zmm30,zmm29,QWORD [rdx-0x408]{1to8}              }
testcase	{ 0x62, 0x01, 0x15, 0x40, 0x62, 0xf4                                     }, { vpunpckldq zmm30,zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x15, 0x47, 0x62, 0xf4                                     }, { vpunpckldq zmm30{k7},zmm29,zmm28                             }
testcase	{ 0x62, 0x01, 0x15, 0xc7, 0x62, 0xf4                                     }, { vpunpckldq zmm30{k7}{z},zmm29,zmm28                          }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0x62, 0x31                                     }, { vpunpckldq zmm30,zmm29,ZWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x15, 0x40, 0x62, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpunpckldq zmm30,zmm29,ZWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0x62, 0x31                                     }, { vpunpckldq zmm30,zmm29,DWORD [rcx]{1to16}                    }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0x62, 0x72, 0x7f                               }, { vpunpckldq zmm30,zmm29,ZWORD [rdx+0x1fc0]                    }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0x62, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpunpckldq zmm30,zmm29,ZWORD [rdx+0x2000]                    }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0x62, 0x72, 0x80                               }, { vpunpckldq zmm30,zmm29,ZWORD [rdx-0x2000]                    }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0x62, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpunpckldq zmm30,zmm29,ZWORD [rdx-0x2040]                    }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0x62, 0x72, 0x7f                               }, { vpunpckldq zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}              }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0x62, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpunpckldq zmm30,zmm29,DWORD [rdx+0x200]{1to16}              }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0x62, 0x72, 0x80                               }, { vpunpckldq zmm30,zmm29,DWORD [rdx-0x200]{1to16}              }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0x62, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpunpckldq zmm30,zmm29,DWORD [rdx-0x204]{1to16}              }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0x6c, 0xf4                                     }, { vpunpcklqdq zmm30,zmm29,zmm28                                }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0x6c, 0xf4                                     }, { vpunpcklqdq zmm30{k7},zmm29,zmm28                            }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0x6c, 0xf4                                     }, { vpunpcklqdq zmm30{k7}{z},zmm29,zmm28                         }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x6c, 0x31                                     }, { vpunpcklqdq zmm30,zmm29,ZWORD [rcx]                          }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0x6c, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpunpcklqdq zmm30,zmm29,ZWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x6c, 0x31                                     }, { vpunpcklqdq zmm30,zmm29,QWORD [rcx]{1to8}                    }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x6c, 0x72, 0x7f                               }, { vpunpcklqdq zmm30,zmm29,ZWORD [rdx+0x1fc0]                   }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x6c, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpunpcklqdq zmm30,zmm29,ZWORD [rdx+0x2000]                   }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x6c, 0x72, 0x80                               }, { vpunpcklqdq zmm30,zmm29,ZWORD [rdx-0x2000]                   }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x6c, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpunpcklqdq zmm30,zmm29,ZWORD [rdx-0x2040]                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x6c, 0x72, 0x7f                               }, { vpunpcklqdq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}              }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x6c, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpunpcklqdq zmm30,zmm29,QWORD [rdx+0x400]{1to8}              }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x6c, 0x72, 0x80                               }, { vpunpcklqdq zmm30,zmm29,QWORD [rdx-0x400]{1to8}              }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x6c, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpunpcklqdq zmm30,zmm29,QWORD [rdx-0x408]{1to8}              }
testcase	{ 0x62, 0x01, 0x15, 0x40, 0xef, 0xf4                                     }, { vpxord zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x15, 0x47, 0xef, 0xf4                                     }, { vpxord zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x15, 0xc7, 0xef, 0xf4                                     }, { vpxord zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xef, 0x31                                     }, { vpxord zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x15, 0x40, 0xef, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpxord zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xef, 0x31                                     }, { vpxord zmm30,zmm29,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xef, 0x72, 0x7f                               }, { vpxord zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xef, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpxord zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xef, 0x72, 0x80                               }, { vpxord zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x15, 0x40, 0xef, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpxord zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xef, 0x72, 0x7f                               }, { vpxord zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xef, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpxord zmm30,zmm29,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xef, 0x72, 0x80                               }, { vpxord zmm30,zmm29,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x15, 0x50, 0xef, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpxord zmm30,zmm29,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0xef, 0xf4                                     }, { vpxorq zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0xef, 0xf4                                     }, { vpxorq zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0xef, 0xf4                                     }, { vpxorq zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xef, 0x31                                     }, { vpxorq zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0xef, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpxorq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xef, 0x31                                     }, { vpxorq zmm30,zmm29,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xef, 0x72, 0x7f                               }, { vpxorq zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xef, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpxorq zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xef, 0x72, 0x80                               }, { vpxorq zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xef, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpxorq zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xef, 0x72, 0x7f                               }, { vpxorq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xef, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpxorq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xef, 0x72, 0x80                               }, { vpxorq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xef, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpxorq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x02, 0xfd, 0x48, 0x4c, 0xf5                                     }, { vrcp14pd zmm30,zmm29                                         }
testcase	{ 0x62, 0x02, 0xfd, 0x4f, 0x4c, 0xf5                                     }, { vrcp14pd zmm30{k7},zmm29                                     }
testcase	{ 0x62, 0x02, 0xfd, 0xcf, 0x4c, 0xf5                                     }, { vrcp14pd zmm30{k7}{z},zmm29                                  }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x4c, 0x31                                     }, { vrcp14pd zmm30,ZWORD [rcx]                                   }
testcase	{ 0x62, 0x22, 0xfd, 0x48, 0x4c, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vrcp14pd zmm30,ZWORD [rax+r14*8+0x123]                       }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x4c, 0x31                                     }, { vrcp14pd zmm30,QWORD [rcx]{1to8}                             }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x4c, 0x72, 0x7f                               }, { vrcp14pd zmm30,ZWORD [rdx+0x1fc0]                            }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x4c, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vrcp14pd zmm30,ZWORD [rdx+0x2000]                            }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x4c, 0x72, 0x80                               }, { vrcp14pd zmm30,ZWORD [rdx-0x2000]                            }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x4c, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vrcp14pd zmm30,ZWORD [rdx-0x2040]                            }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x4c, 0x72, 0x7f                               }, { vrcp14pd zmm30,QWORD [rdx+0x3f8]{1to8}                       }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x4c, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vrcp14pd zmm30,QWORD [rdx+0x400]{1to8}                       }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x4c, 0x72, 0x80                               }, { vrcp14pd zmm30,QWORD [rdx-0x400]{1to8}                       }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x4c, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vrcp14pd zmm30,QWORD [rdx-0x408]{1to8}                       }
testcase	{ 0x62, 0x02, 0x7d, 0x48, 0x4c, 0xf5                                     }, { vrcp14ps zmm30,zmm29                                         }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x4c, 0xf5                                     }, { vrcp14ps zmm30{k7},zmm29                                     }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x4c, 0xf5                                     }, { vrcp14ps zmm30{k7}{z},zmm29                                  }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x4c, 0x31                                     }, { vrcp14ps zmm30,ZWORD [rcx]                                   }
testcase	{ 0x62, 0x22, 0x7d, 0x48, 0x4c, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vrcp14ps zmm30,ZWORD [rax+r14*8+0x123]                       }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x4c, 0x31                                     }, { vrcp14ps zmm30,DWORD [rcx]{1to16}                            }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x4c, 0x72, 0x7f                               }, { vrcp14ps zmm30,ZWORD [rdx+0x1fc0]                            }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x4c, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vrcp14ps zmm30,ZWORD [rdx+0x2000]                            }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x4c, 0x72, 0x80                               }, { vrcp14ps zmm30,ZWORD [rdx-0x2000]                            }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x4c, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vrcp14ps zmm30,ZWORD [rdx-0x2040]                            }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x4c, 0x72, 0x7f                               }, { vrcp14ps zmm30,DWORD [rdx+0x1fc]{1to16}                      }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x4c, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vrcp14ps zmm30,DWORD [rdx+0x200]{1to16}                      }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x4c, 0x72, 0x80                               }, { vrcp14ps zmm30,DWORD [rdx-0x200]{1to16}                      }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x4c, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vrcp14ps zmm30,DWORD [rdx-0x204]{1to16}                      }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0x4d, 0xf4                                     }, { vrcp14sd xmm30{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0x4d, 0xf4                                     }, { vrcp14sd xmm30{k7}{z},xmm29,xmm28                            }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x4d, 0x31                                     }, { vrcp14sd xmm30{k7},xmm29,QWORD [rcx]                         }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0x4d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vrcp14sd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x4d, 0x72, 0x7f                               }, { vrcp14sd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                   }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x4d, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vrcp14sd xmm30{k7},xmm29,QWORD [rdx+0x400]                   }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x4d, 0x72, 0x80                               }, { vrcp14sd xmm30{k7},xmm29,QWORD [rdx-0x400]                   }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x4d, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vrcp14sd xmm30{k7},xmm29,QWORD [rdx-0x408]                   }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0x4d, 0xf4                                     }, { vrcp14ss xmm30{k7},xmm29,xmm28                               }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0x4d, 0xf4                                     }, { vrcp14ss xmm30{k7}{z},xmm29,xmm28                            }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x4d, 0x31                                     }, { vrcp14ss xmm30{k7},xmm29,DWORD [rcx]                         }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0x4d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vrcp14ss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]             }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x4d, 0x72, 0x7f                               }, { vrcp14ss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                   }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x4d, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vrcp14ss xmm30{k7},xmm29,DWORD [rdx+0x200]                   }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x4d, 0x72, 0x80                               }, { vrcp14ss xmm30{k7},xmm29,DWORD [rdx-0x200]                   }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x4d, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vrcp14ss xmm30{k7},xmm29,DWORD [rdx-0x204]                   }
testcase	{ 0x62, 0x02, 0xfd, 0x48, 0x4e, 0xf5                                     }, { vrsqrt14pd zmm30,zmm29                                       }
testcase	{ 0x62, 0x02, 0xfd, 0x4f, 0x4e, 0xf5                                     }, { vrsqrt14pd zmm30{k7},zmm29                                   }
testcase	{ 0x62, 0x02, 0xfd, 0xcf, 0x4e, 0xf5                                     }, { vrsqrt14pd zmm30{k7}{z},zmm29                                }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x4e, 0x31                                     }, { vrsqrt14pd zmm30,ZWORD [rcx]                                 }
testcase	{ 0x62, 0x22, 0xfd, 0x48, 0x4e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vrsqrt14pd zmm30,ZWORD [rax+r14*8+0x123]                     }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x4e, 0x31                                     }, { vrsqrt14pd zmm30,QWORD [rcx]{1to8}                           }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x4e, 0x72, 0x7f                               }, { vrsqrt14pd zmm30,ZWORD [rdx+0x1fc0]                          }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x4e, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vrsqrt14pd zmm30,ZWORD [rdx+0x2000]                          }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x4e, 0x72, 0x80                               }, { vrsqrt14pd zmm30,ZWORD [rdx-0x2000]                          }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x4e, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vrsqrt14pd zmm30,ZWORD [rdx-0x2040]                          }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x4e, 0x72, 0x7f                               }, { vrsqrt14pd zmm30,QWORD [rdx+0x3f8]{1to8}                     }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x4e, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vrsqrt14pd zmm30,QWORD [rdx+0x400]{1to8}                     }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x4e, 0x72, 0x80                               }, { vrsqrt14pd zmm30,QWORD [rdx-0x400]{1to8}                     }
testcase	{ 0x62, 0x62, 0xfd, 0x58, 0x4e, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vrsqrt14pd zmm30,QWORD [rdx-0x408]{1to8}                     }
testcase	{ 0x62, 0x02, 0x7d, 0x48, 0x4e, 0xf5                                     }, { vrsqrt14ps zmm30,zmm29                                       }
testcase	{ 0x62, 0x02, 0x7d, 0x4f, 0x4e, 0xf5                                     }, { vrsqrt14ps zmm30{k7},zmm29                                   }
testcase	{ 0x62, 0x02, 0x7d, 0xcf, 0x4e, 0xf5                                     }, { vrsqrt14ps zmm30{k7}{z},zmm29                                }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x4e, 0x31                                     }, { vrsqrt14ps zmm30,ZWORD [rcx]                                 }
testcase	{ 0x62, 0x22, 0x7d, 0x48, 0x4e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vrsqrt14ps zmm30,ZWORD [rax+r14*8+0x123]                     }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x4e, 0x31                                     }, { vrsqrt14ps zmm30,DWORD [rcx]{1to16}                          }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x4e, 0x72, 0x7f                               }, { vrsqrt14ps zmm30,ZWORD [rdx+0x1fc0]                          }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x4e, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vrsqrt14ps zmm30,ZWORD [rdx+0x2000]                          }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x4e, 0x72, 0x80                               }, { vrsqrt14ps zmm30,ZWORD [rdx-0x2000]                          }
testcase	{ 0x62, 0x62, 0x7d, 0x48, 0x4e, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vrsqrt14ps zmm30,ZWORD [rdx-0x2040]                          }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x4e, 0x72, 0x7f                               }, { vrsqrt14ps zmm30,DWORD [rdx+0x1fc]{1to16}                    }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x4e, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vrsqrt14ps zmm30,DWORD [rdx+0x200]{1to16}                    }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x4e, 0x72, 0x80                               }, { vrsqrt14ps zmm30,DWORD [rdx-0x200]{1to16}                    }
testcase	{ 0x62, 0x62, 0x7d, 0x58, 0x4e, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vrsqrt14ps zmm30,DWORD [rdx-0x204]{1to16}                    }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0x4f, 0xf4                                     }, { vrsqrt14sd xmm30{k7},xmm29,xmm28                             }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0x4f, 0xf4                                     }, { vrsqrt14sd xmm30{k7}{z},xmm29,xmm28                          }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x4f, 0x31                                     }, { vrsqrt14sd xmm30{k7},xmm29,QWORD [rcx]                       }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0x4f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vrsqrt14sd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x4f, 0x72, 0x7f                               }, { vrsqrt14sd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                 }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x4f, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vrsqrt14sd xmm30{k7},xmm29,QWORD [rdx+0x400]                 }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x4f, 0x72, 0x80                               }, { vrsqrt14sd xmm30{k7},xmm29,QWORD [rdx-0x400]                 }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x4f, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vrsqrt14sd xmm30{k7},xmm29,QWORD [rdx-0x408]                 }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0x4f, 0xf4                                     }, { vrsqrt14ss xmm30{k7},xmm29,xmm28                             }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0x4f, 0xf4                                     }, { vrsqrt14ss xmm30{k7}{z},xmm29,xmm28                          }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x4f, 0x31                                     }, { vrsqrt14ss xmm30{k7},xmm29,DWORD [rcx]                       }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0x4f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vrsqrt14ss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]           }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x4f, 0x72, 0x7f                               }, { vrsqrt14ss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                 }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x4f, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vrsqrt14ss xmm30{k7},xmm29,DWORD [rdx+0x200]                 }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x4f, 0x72, 0x80                               }, { vrsqrt14ss xmm30{k7},xmm29,DWORD [rdx-0x200]                 }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x4f, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vrsqrt14ss xmm30{k7},xmm29,DWORD [rdx-0x204]                 }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0xa2, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vscatterdpd  [r14+ymm31*8+0x7b]{k1},zmm30                    }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0xa2, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vscatterdpd  [r14+ymm31*8+0x7b]{k1},zmm30                    }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0xa2, 0x74, 0x39, 0x20                         }, { vscatterdpd  [r9+ymm31*1+0x100]{k1},zmm30                    }
testcase	{ 0x62, 0x22, 0xfd, 0x41, 0xa2, 0xb4, 0xb9, 0x00, 0x04, 0x00, 0x00       }, { vscatterdpd  [rcx+ymm31*4+0x400]{k1},zmm30                   }
testcase	{ 0x62, 0x02, 0x7d, 0x41, 0xa2, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vscatterdps  [r14+zmm31*8+0x7b]{k1},zmm30                    }
testcase	{ 0x62, 0x02, 0x7d, 0x41, 0xa2, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vscatterdps  [r14+zmm31*8+0x7b]{k1},zmm30                    }
testcase	{ 0x62, 0x02, 0x7d, 0x41, 0xa2, 0x74, 0x39, 0x40                         }, { vscatterdps  [r9+zmm31*1+0x100]{k1},zmm30                    }
testcase	{ 0x62, 0x22, 0x7d, 0x41, 0xa2, 0xb4, 0xb9, 0x00, 0x04, 0x00, 0x00       }, { vscatterdps  [rcx+zmm31*4+0x400]{k1},zmm30                   }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0xa3, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vscatterqpd  [r14+zmm31*8+0x7b]{k1},zmm30                    }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0xa3, 0xb4, 0xfe, 0x7b, 0x00, 0x00, 0x00       }, { vscatterqpd  [r14+zmm31*8+0x7b]{k1},zmm30                    }
testcase	{ 0x62, 0x02, 0xfd, 0x41, 0xa3, 0x74, 0x39, 0x20                         }, { vscatterqpd  [r9+zmm31*1+0x100]{k1},zmm30                    }
testcase	{ 0x62, 0x22, 0xfd, 0x41, 0xa3, 0xb4, 0xb9, 0x00, 0x04, 0x00, 0x00       }, { vscatterqpd  [rcx+zmm31*4+0x400]{k1},zmm30                   }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0xc6, 0xf4, 0xab                               }, { vshufpd zmm30,zmm29,zmm28,0xab                               }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0xc6, 0xf4, 0xab                               }, { vshufpd zmm30{k7},zmm29,zmm28,0xab                           }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0xc6, 0xf4, 0xab                               }, { vshufpd zmm30{k7}{z},zmm29,zmm28,0xab                        }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0xc6, 0xf4, 0x7b                               }, { vshufpd zmm30,zmm29,zmm28,0x7b                               }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xc6, 0x31, 0x7b                               }, { vshufpd zmm30,zmm29,ZWORD [rcx],0x7b                         }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0xc6, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vshufpd zmm30,zmm29,ZWORD [rax+r14*8+0x123],0x7b             }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xc6, 0x31, 0x7b                               }, { vshufpd zmm30,zmm29,QWORD [rcx]{1to8},0x7b                   }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xc6, 0x72, 0x7f, 0x7b                         }, { vshufpd zmm30,zmm29,ZWORD [rdx+0x1fc0],0x7b                  }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xc6, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vshufpd zmm30,zmm29,ZWORD [rdx+0x2000],0x7b                  }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xc6, 0x72, 0x80, 0x7b                         }, { vshufpd zmm30,zmm29,ZWORD [rdx-0x2000],0x7b                  }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0xc6, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vshufpd zmm30,zmm29,ZWORD [rdx-0x2040],0x7b                  }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xc6, 0x72, 0x7f, 0x7b                         }, { vshufpd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8},0x7b             }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xc6, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vshufpd zmm30,zmm29,QWORD [rdx+0x400]{1to8},0x7b             }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xc6, 0x72, 0x80, 0x7b                         }, { vshufpd zmm30,zmm29,QWORD [rdx-0x400]{1to8},0x7b             }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0xc6, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vshufpd zmm30,zmm29,QWORD [rdx-0x408]{1to8},0x7b             }
testcase	{ 0x62, 0x01, 0x14, 0x40, 0xc6, 0xf4, 0xab                               }, { vshufps zmm30,zmm29,zmm28,0xab                               }
testcase	{ 0x62, 0x01, 0x14, 0x47, 0xc6, 0xf4, 0xab                               }, { vshufps zmm30{k7},zmm29,zmm28,0xab                           }
testcase	{ 0x62, 0x01, 0x14, 0xc7, 0xc6, 0xf4, 0xab                               }, { vshufps zmm30{k7}{z},zmm29,zmm28,0xab                        }
testcase	{ 0x62, 0x01, 0x14, 0x40, 0xc6, 0xf4, 0x7b                               }, { vshufps zmm30,zmm29,zmm28,0x7b                               }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0xc6, 0x31, 0x7b                               }, { vshufps zmm30,zmm29,ZWORD [rcx],0x7b                         }
testcase	{ 0x62, 0x21, 0x14, 0x40, 0xc6, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vshufps zmm30,zmm29,ZWORD [rax+r14*8+0x123],0x7b             }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0xc6, 0x31, 0x7b                               }, { vshufps zmm30,zmm29,DWORD [rcx]{1to16},0x7b                  }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0xc6, 0x72, 0x7f, 0x7b                         }, { vshufps zmm30,zmm29,ZWORD [rdx+0x1fc0],0x7b                  }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0xc6, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vshufps zmm30,zmm29,ZWORD [rdx+0x2000],0x7b                  }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0xc6, 0x72, 0x80, 0x7b                         }, { vshufps zmm30,zmm29,ZWORD [rdx-0x2000],0x7b                  }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0xc6, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vshufps zmm30,zmm29,ZWORD [rdx-0x2040],0x7b                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0xc6, 0x72, 0x7f, 0x7b                         }, { vshufps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16},0x7b            }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0xc6, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vshufps zmm30,zmm29,DWORD [rdx+0x200]{1to16},0x7b            }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0xc6, 0x72, 0x80, 0x7b                         }, { vshufps zmm30,zmm29,DWORD [rdx-0x200]{1to16},0x7b            }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0xc6, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vshufps zmm30,zmm29,DWORD [rdx-0x204]{1to16},0x7b            }
testcase	{ 0x62, 0x01, 0xfd, 0x48, 0x51, 0xf5                                     }, { vsqrtpd zmm30,zmm29                                          }
testcase	{ 0x62, 0x01, 0xfd, 0x4f, 0x51, 0xf5                                     }, { vsqrtpd zmm30{k7},zmm29                                      }
testcase	{ 0x62, 0x01, 0xfd, 0xcf, 0x51, 0xf5                                     }, { vsqrtpd zmm30{k7}{z},zmm29                                   }
testcase	{ 0x62, 0x01, 0xfd, 0x18, 0x51, 0xf5                                     }, { vsqrtpd zmm30,zmm29,{rn-sae}                                 }
testcase	{ 0x62, 0x01, 0xfd, 0x58, 0x51, 0xf5                                     }, { vsqrtpd zmm30,zmm29,{ru-sae}                                 }
testcase	{ 0x62, 0x01, 0xfd, 0x38, 0x51, 0xf5                                     }, { vsqrtpd zmm30,zmm29,{rd-sae}                                 }
testcase	{ 0x62, 0x01, 0xfd, 0x78, 0x51, 0xf5                                     }, { vsqrtpd zmm30,zmm29,{rz-sae}                                 }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x51, 0x31                                     }, { vsqrtpd zmm30,ZWORD [rcx]                                    }
testcase	{ 0x62, 0x21, 0xfd, 0x48, 0x51, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vsqrtpd zmm30,ZWORD [rax+r14*8+0x123]                        }
testcase	{ 0x62, 0x61, 0xfd, 0x58, 0x51, 0x31                                     }, { vsqrtpd zmm30,QWORD [rcx]{1to8}                              }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x51, 0x72, 0x7f                               }, { vsqrtpd zmm30,ZWORD [rdx+0x1fc0]                             }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x51, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vsqrtpd zmm30,ZWORD [rdx+0x2000]                             }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x51, 0x72, 0x80                               }, { vsqrtpd zmm30,ZWORD [rdx-0x2000]                             }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x51, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vsqrtpd zmm30,ZWORD [rdx-0x2040]                             }
testcase	{ 0x62, 0x61, 0xfd, 0x58, 0x51, 0x72, 0x7f                               }, { vsqrtpd zmm30,QWORD [rdx+0x3f8]{1to8}                        }
testcase	{ 0x62, 0x61, 0xfd, 0x58, 0x51, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vsqrtpd zmm30,QWORD [rdx+0x400]{1to8}                        }
testcase	{ 0x62, 0x61, 0xfd, 0x58, 0x51, 0x72, 0x80                               }, { vsqrtpd zmm30,QWORD [rdx-0x400]{1to8}                        }
testcase	{ 0x62, 0x61, 0xfd, 0x58, 0x51, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vsqrtpd zmm30,QWORD [rdx-0x408]{1to8}                        }
testcase	{ 0x62, 0x01, 0x7c, 0x48, 0x51, 0xf5                                     }, { vsqrtps zmm30,zmm29                                          }
testcase	{ 0x62, 0x01, 0x7c, 0x4f, 0x51, 0xf5                                     }, { vsqrtps zmm30{k7},zmm29                                      }
testcase	{ 0x62, 0x01, 0x7c, 0xcf, 0x51, 0xf5                                     }, { vsqrtps zmm30{k7}{z},zmm29                                   }
testcase	{ 0x62, 0x01, 0x7c, 0x18, 0x51, 0xf5                                     }, { vsqrtps zmm30,zmm29,{rn-sae}                                 }
testcase	{ 0x62, 0x01, 0x7c, 0x58, 0x51, 0xf5                                     }, { vsqrtps zmm30,zmm29,{ru-sae}                                 }
testcase	{ 0x62, 0x01, 0x7c, 0x38, 0x51, 0xf5                                     }, { vsqrtps zmm30,zmm29,{rd-sae}                                 }
testcase	{ 0x62, 0x01, 0x7c, 0x78, 0x51, 0xf5                                     }, { vsqrtps zmm30,zmm29,{rz-sae}                                 }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x51, 0x31                                     }, { vsqrtps zmm30,ZWORD [rcx]                                    }
testcase	{ 0x62, 0x21, 0x7c, 0x48, 0x51, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vsqrtps zmm30,ZWORD [rax+r14*8+0x123]                        }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x51, 0x31                                     }, { vsqrtps zmm30,DWORD [rcx]{1to16}                             }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x51, 0x72, 0x7f                               }, { vsqrtps zmm30,ZWORD [rdx+0x1fc0]                             }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x51, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vsqrtps zmm30,ZWORD [rdx+0x2000]                             }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x51, 0x72, 0x80                               }, { vsqrtps zmm30,ZWORD [rdx-0x2000]                             }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x51, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vsqrtps zmm30,ZWORD [rdx-0x2040]                             }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x51, 0x72, 0x7f                               }, { vsqrtps zmm30,DWORD [rdx+0x1fc]{1to16}                       }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x51, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vsqrtps zmm30,DWORD [rdx+0x200]{1to16}                       }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x51, 0x72, 0x80                               }, { vsqrtps zmm30,DWORD [rdx-0x200]{1to16}                       }
testcase	{ 0x62, 0x61, 0x7c, 0x58, 0x51, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vsqrtps zmm30,DWORD [rdx-0x204]{1to16}                       }
testcase	{ 0x62, 0x01, 0x97, 0x07, 0x51, 0xf4                                     }, { vsqrtsd xmm30{k7},xmm29,xmm28                                }
testcase	{ 0x62, 0x01, 0x97, 0x87, 0x51, 0xf4                                     }, { vsqrtsd xmm30{k7}{z},xmm29,xmm28                             }
testcase	{ 0x62, 0x01, 0x97, 0x17, 0x51, 0xf4                                     }, { vsqrtsd xmm30{k7},xmm29,xmm28,{rn-sae}                       }
testcase	{ 0x62, 0x01, 0x97, 0x57, 0x51, 0xf4                                     }, { vsqrtsd xmm30{k7},xmm29,xmm28,{ru-sae}                       }
testcase	{ 0x62, 0x01, 0x97, 0x37, 0x51, 0xf4                                     }, { vsqrtsd xmm30{k7},xmm29,xmm28,{rd-sae}                       }
testcase	{ 0x62, 0x01, 0x97, 0x77, 0x51, 0xf4                                     }, { vsqrtsd xmm30{k7},xmm29,xmm28,{rz-sae}                       }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x51, 0x31                                     }, { vsqrtsd xmm30{k7},xmm29,QWORD [rcx]                          }
testcase	{ 0x62, 0x21, 0x97, 0x07, 0x51, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vsqrtsd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x51, 0x72, 0x7f                               }, { vsqrtsd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                    }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x51, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vsqrtsd xmm30{k7},xmm29,QWORD [rdx+0x400]                    }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x51, 0x72, 0x80                               }, { vsqrtsd xmm30{k7},xmm29,QWORD [rdx-0x400]                    }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x51, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vsqrtsd xmm30{k7},xmm29,QWORD [rdx-0x408]                    }
testcase	{ 0x62, 0x01, 0x16, 0x07, 0x51, 0xf4                                     }, { vsqrtss xmm30{k7},xmm29,xmm28                                }
testcase	{ 0x62, 0x01, 0x16, 0x87, 0x51, 0xf4                                     }, { vsqrtss xmm30{k7}{z},xmm29,xmm28                             }
testcase	{ 0x62, 0x01, 0x16, 0x17, 0x51, 0xf4                                     }, { vsqrtss xmm30{k7},xmm29,xmm28,{rn-sae}                       }
testcase	{ 0x62, 0x01, 0x16, 0x57, 0x51, 0xf4                                     }, { vsqrtss xmm30{k7},xmm29,xmm28,{ru-sae}                       }
testcase	{ 0x62, 0x01, 0x16, 0x37, 0x51, 0xf4                                     }, { vsqrtss xmm30{k7},xmm29,xmm28,{rd-sae}                       }
testcase	{ 0x62, 0x01, 0x16, 0x77, 0x51, 0xf4                                     }, { vsqrtss xmm30{k7},xmm29,xmm28,{rz-sae}                       }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x51, 0x31                                     }, { vsqrtss xmm30{k7},xmm29,DWORD [rcx]                          }
testcase	{ 0x62, 0x21, 0x16, 0x07, 0x51, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vsqrtss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]              }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x51, 0x72, 0x7f                               }, { vsqrtss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                    }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x51, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vsqrtss xmm30{k7},xmm29,DWORD [rdx+0x200]                    }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x51, 0x72, 0x80                               }, { vsqrtss xmm30{k7},xmm29,DWORD [rdx-0x200]                    }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x51, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vsqrtss xmm30{k7},xmm29,DWORD [rdx-0x204]                    }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0x5c, 0xf4                                     }, { vsubpd zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0x5c, 0xf4                                     }, { vsubpd zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0x5c, 0xf4                                     }, { vsubpd zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x95, 0x10, 0x5c, 0xf4                                     }, { vsubpd zmm30,zmm29,zmm28,{rn-sae}                            }
testcase	{ 0x62, 0x01, 0x95, 0x50, 0x5c, 0xf4                                     }, { vsubpd zmm30,zmm29,zmm28,{ru-sae}                            }
testcase	{ 0x62, 0x01, 0x95, 0x30, 0x5c, 0xf4                                     }, { vsubpd zmm30,zmm29,zmm28,{rd-sae}                            }
testcase	{ 0x62, 0x01, 0x95, 0x70, 0x5c, 0xf4                                     }, { vsubpd zmm30,zmm29,zmm28,{rz-sae}                            }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5c, 0x31                                     }, { vsubpd zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0x5c, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vsubpd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5c, 0x31                                     }, { vsubpd zmm30,zmm29,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5c, 0x72, 0x7f                               }, { vsubpd zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5c, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vsubpd zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5c, 0x72, 0x80                               }, { vsubpd zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x5c, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vsubpd zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5c, 0x72, 0x7f                               }, { vsubpd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5c, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vsubpd zmm30,zmm29,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5c, 0x72, 0x80                               }, { vsubpd zmm30,zmm29,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x5c, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vsubpd zmm30,zmm29,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x01, 0x14, 0x40, 0x5c, 0xf4                                     }, { vsubps zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x01, 0x14, 0x47, 0x5c, 0xf4                                     }, { vsubps zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x01, 0x14, 0xc7, 0x5c, 0xf4                                     }, { vsubps zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x14, 0x10, 0x5c, 0xf4                                     }, { vsubps zmm30,zmm29,zmm28,{rn-sae}                            }
testcase	{ 0x62, 0x01, 0x14, 0x50, 0x5c, 0xf4                                     }, { vsubps zmm30,zmm29,zmm28,{ru-sae}                            }
testcase	{ 0x62, 0x01, 0x14, 0x30, 0x5c, 0xf4                                     }, { vsubps zmm30,zmm29,zmm28,{rd-sae}                            }
testcase	{ 0x62, 0x01, 0x14, 0x70, 0x5c, 0xf4                                     }, { vsubps zmm30,zmm29,zmm28,{rz-sae}                            }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5c, 0x31                                     }, { vsubps zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x21, 0x14, 0x40, 0x5c, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vsubps zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5c, 0x31                                     }, { vsubps zmm30,zmm29,DWORD [rcx]{1to16}                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5c, 0x72, 0x7f                               }, { vsubps zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5c, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vsubps zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5c, 0x72, 0x80                               }, { vsubps zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x5c, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vsubps zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5c, 0x72, 0x7f                               }, { vsubps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5c, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vsubps zmm30,zmm29,DWORD [rdx+0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5c, 0x72, 0x80                               }, { vsubps zmm30,zmm29,DWORD [rdx-0x200]{1to16}                  }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x5c, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vsubps zmm30,zmm29,DWORD [rdx-0x204]{1to16}                  }
testcase	{ 0x62, 0x01, 0x97, 0x07, 0x5c, 0xf4                                     }, { vsubsd xmm30{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x97, 0x87, 0x5c, 0xf4                                     }, { vsubsd xmm30{k7}{z},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x97, 0x17, 0x5c, 0xf4                                     }, { vsubsd xmm30{k7},xmm29,xmm28,{rn-sae}                        }
testcase	{ 0x62, 0x01, 0x97, 0x57, 0x5c, 0xf4                                     }, { vsubsd xmm30{k7},xmm29,xmm28,{ru-sae}                        }
testcase	{ 0x62, 0x01, 0x97, 0x37, 0x5c, 0xf4                                     }, { vsubsd xmm30{k7},xmm29,xmm28,{rd-sae}                        }
testcase	{ 0x62, 0x01, 0x97, 0x77, 0x5c, 0xf4                                     }, { vsubsd xmm30{k7},xmm29,xmm28,{rz-sae}                        }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5c, 0x31                                     }, { vsubsd xmm30{k7},xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x97, 0x07, 0x5c, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vsubsd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5c, 0x72, 0x7f                               }, { vsubsd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5c, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vsubsd xmm30{k7},xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5c, 0x72, 0x80                               }, { vsubsd xmm30{k7},xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0x61, 0x97, 0x07, 0x5c, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vsubsd xmm30{k7},xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x01, 0x16, 0x07, 0x5c, 0xf4                                     }, { vsubss xmm30{k7},xmm29,xmm28                                 }
testcase	{ 0x62, 0x01, 0x16, 0x87, 0x5c, 0xf4                                     }, { vsubss xmm30{k7}{z},xmm29,xmm28                              }
testcase	{ 0x62, 0x01, 0x16, 0x17, 0x5c, 0xf4                                     }, { vsubss xmm30{k7},xmm29,xmm28,{rn-sae}                        }
testcase	{ 0x62, 0x01, 0x16, 0x57, 0x5c, 0xf4                                     }, { vsubss xmm30{k7},xmm29,xmm28,{ru-sae}                        }
testcase	{ 0x62, 0x01, 0x16, 0x37, 0x5c, 0xf4                                     }, { vsubss xmm30{k7},xmm29,xmm28,{rd-sae}                        }
testcase	{ 0x62, 0x01, 0x16, 0x77, 0x5c, 0xf4                                     }, { vsubss xmm30{k7},xmm29,xmm28,{rz-sae}                        }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5c, 0x31                                     }, { vsubss xmm30{k7},xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x16, 0x07, 0x5c, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vsubss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5c, 0x72, 0x7f                               }, { vsubss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5c, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vsubss xmm30{k7},xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5c, 0x72, 0x80                               }, { vsubss xmm30{k7},xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0x61, 0x16, 0x07, 0x5c, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vsubss xmm30{k7},xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x01, 0xfd, 0x08, 0x2e, 0xf5                                     }, { vucomisd xmm30,xmm29                                         }
testcase	{ 0x62, 0x01, 0xfd, 0x18, 0x2e, 0xf5                                     }, { vucomisd xmm30,xmm29,{sae}                                   }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x2e, 0x31                                     }, { vucomisd xmm30,QWORD [rcx]                                   }
testcase	{ 0x62, 0x21, 0xfd, 0x08, 0x2e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vucomisd xmm30,QWORD [rax+r14*8+0x123]                       }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x2e, 0x72, 0x7f                               }, { vucomisd xmm30,QWORD [rdx+0x3f8]                             }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x2e, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vucomisd xmm30,QWORD [rdx+0x400]                             }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x2e, 0x72, 0x80                               }, { vucomisd xmm30,QWORD [rdx-0x400]                             }
testcase	{ 0x62, 0x61, 0xfd, 0x08, 0x2e, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vucomisd xmm30,QWORD [rdx-0x408]                             }
testcase	{ 0x62, 0x01, 0x7c, 0x08, 0x2e, 0xf5                                     }, { vucomiss xmm30,xmm29                                         }
testcase	{ 0x62, 0x01, 0x7c, 0x18, 0x2e, 0xf5                                     }, { vucomiss xmm30,xmm29,{sae}                                   }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x2e, 0x31                                     }, { vucomiss xmm30,DWORD [rcx]                                   }
testcase	{ 0x62, 0x21, 0x7c, 0x08, 0x2e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vucomiss xmm30,DWORD [rax+r14*8+0x123]                       }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x2e, 0x72, 0x7f                               }, { vucomiss xmm30,DWORD [rdx+0x1fc]                             }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x2e, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vucomiss xmm30,DWORD [rdx+0x200]                             }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x2e, 0x72, 0x80                               }, { vucomiss xmm30,DWORD [rdx-0x200]                             }
testcase	{ 0x62, 0x61, 0x7c, 0x08, 0x2e, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vucomiss xmm30,DWORD [rdx-0x204]                             }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0x15, 0xf4                                     }, { vunpckhpd zmm30,zmm29,zmm28                                  }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0x15, 0xf4                                     }, { vunpckhpd zmm30{k7},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0x15, 0xf4                                     }, { vunpckhpd zmm30{k7}{z},zmm29,zmm28                           }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x15, 0x31                                     }, { vunpckhpd zmm30,zmm29,ZWORD [rcx]                            }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0x15, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vunpckhpd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x15, 0x31                                     }, { vunpckhpd zmm30,zmm29,QWORD [rcx]{1to8}                      }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x15, 0x72, 0x7f                               }, { vunpckhpd zmm30,zmm29,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x15, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vunpckhpd zmm30,zmm29,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x15, 0x72, 0x80                               }, { vunpckhpd zmm30,zmm29,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x15, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vunpckhpd zmm30,zmm29,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x15, 0x72, 0x7f                               }, { vunpckhpd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x15, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vunpckhpd zmm30,zmm29,QWORD [rdx+0x400]{1to8}                }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x15, 0x72, 0x80                               }, { vunpckhpd zmm30,zmm29,QWORD [rdx-0x400]{1to8}                }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x15, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vunpckhpd zmm30,zmm29,QWORD [rdx-0x408]{1to8}                }
testcase	{ 0x62, 0x01, 0x14, 0x40, 0x15, 0xf4                                     }, { vunpckhps zmm30,zmm29,zmm28                                  }
testcase	{ 0x62, 0x01, 0x14, 0x47, 0x15, 0xf4                                     }, { vunpckhps zmm30{k7},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x14, 0xc7, 0x15, 0xf4                                     }, { vunpckhps zmm30{k7}{z},zmm29,zmm28                           }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x15, 0x31                                     }, { vunpckhps zmm30,zmm29,ZWORD [rcx]                            }
testcase	{ 0x62, 0x21, 0x14, 0x40, 0x15, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vunpckhps zmm30,zmm29,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x15, 0x31                                     }, { vunpckhps zmm30,zmm29,DWORD [rcx]{1to16}                     }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x15, 0x72, 0x7f                               }, { vunpckhps zmm30,zmm29,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x15, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vunpckhps zmm30,zmm29,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x15, 0x72, 0x80                               }, { vunpckhps zmm30,zmm29,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x15, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vunpckhps zmm30,zmm29,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x15, 0x72, 0x7f                               }, { vunpckhps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}               }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x15, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vunpckhps zmm30,zmm29,DWORD [rdx+0x200]{1to16}               }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x15, 0x72, 0x80                               }, { vunpckhps zmm30,zmm29,DWORD [rdx-0x200]{1to16}               }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x15, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vunpckhps zmm30,zmm29,DWORD [rdx-0x204]{1to16}               }
testcase	{ 0x62, 0x01, 0x95, 0x40, 0x14, 0xf4                                     }, { vunpcklpd zmm30,zmm29,zmm28                                  }
testcase	{ 0x62, 0x01, 0x95, 0x47, 0x14, 0xf4                                     }, { vunpcklpd zmm30{k7},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x95, 0xc7, 0x14, 0xf4                                     }, { vunpcklpd zmm30{k7}{z},zmm29,zmm28                           }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x14, 0x31                                     }, { vunpcklpd zmm30,zmm29,ZWORD [rcx]                            }
testcase	{ 0x62, 0x21, 0x95, 0x40, 0x14, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vunpcklpd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x14, 0x31                                     }, { vunpcklpd zmm30,zmm29,QWORD [rcx]{1to8}                      }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x14, 0x72, 0x7f                               }, { vunpcklpd zmm30,zmm29,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x14, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vunpcklpd zmm30,zmm29,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x14, 0x72, 0x80                               }, { vunpcklpd zmm30,zmm29,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0x61, 0x95, 0x40, 0x14, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vunpcklpd zmm30,zmm29,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x14, 0x72, 0x7f                               }, { vunpcklpd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x14, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vunpcklpd zmm30,zmm29,QWORD [rdx+0x400]{1to8}                }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x14, 0x72, 0x80                               }, { vunpcklpd zmm30,zmm29,QWORD [rdx-0x400]{1to8}                }
testcase	{ 0x62, 0x61, 0x95, 0x50, 0x14, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vunpcklpd zmm30,zmm29,QWORD [rdx-0x408]{1to8}                }
testcase	{ 0x62, 0x01, 0x14, 0x40, 0x14, 0xf4                                     }, { vunpcklps zmm30,zmm29,zmm28                                  }
testcase	{ 0x62, 0x01, 0x14, 0x47, 0x14, 0xf4                                     }, { vunpcklps zmm30{k7},zmm29,zmm28                              }
testcase	{ 0x62, 0x01, 0x14, 0xc7, 0x14, 0xf4                                     }, { vunpcklps zmm30{k7}{z},zmm29,zmm28                           }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x14, 0x31                                     }, { vunpcklps zmm30,zmm29,ZWORD [rcx]                            }
testcase	{ 0x62, 0x21, 0x14, 0x40, 0x14, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vunpcklps zmm30,zmm29,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x14, 0x31                                     }, { vunpcklps zmm30,zmm29,DWORD [rcx]{1to16}                     }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x14, 0x72, 0x7f                               }, { vunpcklps zmm30,zmm29,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x14, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vunpcklps zmm30,zmm29,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x14, 0x72, 0x80                               }, { vunpcklps zmm30,zmm29,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0x61, 0x14, 0x40, 0x14, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vunpcklps zmm30,zmm29,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x14, 0x72, 0x7f                               }, { vunpcklps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}               }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x14, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vunpcklps zmm30,zmm29,DWORD [rdx+0x200]{1to16}               }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x14, 0x72, 0x80                               }, { vunpcklps zmm30,zmm29,DWORD [rdx-0x200]{1to16}               }
testcase	{ 0x62, 0x61, 0x14, 0x50, 0x14, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vunpcklps zmm30,zmm29,DWORD [rdx-0x204]{1to16}               }
testcase	{ 0x62, 0x03, 0x15, 0x40, 0x25, 0xf4, 0xab                               }, { vpternlogd zmm30,zmm29,zmm28,0xab                            }
testcase	{ 0x62, 0x03, 0x15, 0x47, 0x25, 0xf4, 0xab                               }, { vpternlogd zmm30{k7},zmm29,zmm28,0xab                        }
testcase	{ 0x62, 0x03, 0x15, 0xc7, 0x25, 0xf4, 0xab                               }, { vpternlogd zmm30{k7}{z},zmm29,zmm28,0xab                     }
testcase	{ 0x62, 0x03, 0x15, 0x40, 0x25, 0xf4, 0x7b                               }, { vpternlogd zmm30,zmm29,zmm28,0x7b                            }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x25, 0x31, 0x7b                               }, { vpternlogd zmm30,zmm29,ZWORD [rcx],0x7b                      }
testcase	{ 0x62, 0x23, 0x15, 0x40, 0x25, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpternlogd zmm30,zmm29,ZWORD [rax+r14*8+0x123],0x7b          }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x25, 0x31, 0x7b                               }, { vpternlogd zmm30,zmm29,DWORD [rcx]{1to16},0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x25, 0x72, 0x7f, 0x7b                         }, { vpternlogd zmm30,zmm29,ZWORD [rdx+0x1fc0],0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x25, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpternlogd zmm30,zmm29,ZWORD [rdx+0x2000],0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x25, 0x72, 0x80, 0x7b                         }, { vpternlogd zmm30,zmm29,ZWORD [rdx-0x2000],0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x25, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpternlogd zmm30,zmm29,ZWORD [rdx-0x2040],0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x25, 0x72, 0x7f, 0x7b                         }, { vpternlogd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16},0x7b         }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x25, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vpternlogd zmm30,zmm29,DWORD [rdx+0x200]{1to16},0x7b         }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x25, 0x72, 0x80, 0x7b                         }, { vpternlogd zmm30,zmm29,DWORD [rdx-0x200]{1to16},0x7b         }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x25, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vpternlogd zmm30,zmm29,DWORD [rdx-0x204]{1to16},0x7b         }
testcase	{ 0x62, 0x03, 0x95, 0x40, 0x25, 0xf4, 0xab                               }, { vpternlogq zmm30,zmm29,zmm28,0xab                            }
testcase	{ 0x62, 0x03, 0x95, 0x47, 0x25, 0xf4, 0xab                               }, { vpternlogq zmm30{k7},zmm29,zmm28,0xab                        }
testcase	{ 0x62, 0x03, 0x95, 0xc7, 0x25, 0xf4, 0xab                               }, { vpternlogq zmm30{k7}{z},zmm29,zmm28,0xab                     }
testcase	{ 0x62, 0x03, 0x95, 0x40, 0x25, 0xf4, 0x7b                               }, { vpternlogq zmm30,zmm29,zmm28,0x7b                            }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x25, 0x31, 0x7b                               }, { vpternlogq zmm30,zmm29,ZWORD [rcx],0x7b                      }
testcase	{ 0x62, 0x23, 0x95, 0x40, 0x25, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpternlogq zmm30,zmm29,ZWORD [rax+r14*8+0x123],0x7b          }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x25, 0x31, 0x7b                               }, { vpternlogq zmm30,zmm29,QWORD [rcx]{1to8},0x7b                }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x25, 0x72, 0x7f, 0x7b                         }, { vpternlogq zmm30,zmm29,ZWORD [rdx+0x1fc0],0x7b               }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x25, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpternlogq zmm30,zmm29,ZWORD [rdx+0x2000],0x7b               }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x25, 0x72, 0x80, 0x7b                         }, { vpternlogq zmm30,zmm29,ZWORD [rdx-0x2000],0x7b               }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x25, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpternlogq zmm30,zmm29,ZWORD [rdx-0x2040],0x7b               }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x25, 0x72, 0x7f, 0x7b                         }, { vpternlogq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8},0x7b          }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x25, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vpternlogq zmm30,zmm29,QWORD [rdx+0x400]{1to8},0x7b          }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x25, 0x72, 0x80, 0x7b                         }, { vpternlogq zmm30,zmm29,QWORD [rdx-0x400]{1to8},0x7b          }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x25, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vpternlogq zmm30,zmm29,QWORD [rdx-0x408]{1to8},0x7b          }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x32, 0xee                                     }, { vpmovqb xmm30{k7},zmm29                                      }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x32, 0xee                                     }, { vpmovqb xmm30{k7}{z},zmm29                                   }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x22, 0xee                                     }, { vpmovsqb xmm30{k7},zmm29                                     }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x22, 0xee                                     }, { vpmovsqb xmm30{k7}{z},zmm29                                  }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x12, 0xee                                     }, { vpmovusqb xmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x12, 0xee                                     }, { vpmovusqb xmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x34, 0xee                                     }, { vpmovqw xmm30{k7},zmm29                                      }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x34, 0xee                                     }, { vpmovqw xmm30{k7}{z},zmm29                                   }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x24, 0xee                                     }, { vpmovsqw xmm30{k7},zmm29                                     }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x24, 0xee                                     }, { vpmovsqw xmm30{k7}{z},zmm29                                  }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x14, 0xee                                     }, { vpmovusqw xmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x14, 0xee                                     }, { vpmovusqw xmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x35, 0xee                                     }, { vpmovqd ymm30{k7},zmm29                                      }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x35, 0xee                                     }, { vpmovqd ymm30{k7}{z},zmm29                                   }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x25, 0xee                                     }, { vpmovsqd ymm30{k7},zmm29                                     }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x25, 0xee                                     }, { vpmovsqd ymm30{k7}{z},zmm29                                  }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x15, 0xee                                     }, { vpmovusqd ymm30{k7},zmm29                                    }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x15, 0xee                                     }, { vpmovusqd ymm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x31, 0xee                                     }, { vpmovdb xmm30{k7},zmm29                                      }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x31, 0xee                                     }, { vpmovdb xmm30{k7}{z},zmm29                                   }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x21, 0xee                                     }, { vpmovsdb xmm30{k7},zmm29                                     }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x21, 0xee                                     }, { vpmovsdb xmm30{k7}{z},zmm29                                  }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x11, 0xee                                     }, { vpmovusdb xmm30{k7},zmm29                                    }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x11, 0xee                                     }, { vpmovusdb xmm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x33, 0xee                                     }, { vpmovdw ymm30{k7},zmm29                                      }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x33, 0xee                                     }, { vpmovdw ymm30{k7}{z},zmm29                                   }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x23, 0xee                                     }, { vpmovsdw ymm30{k7},zmm29                                     }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x23, 0xee                                     }, { vpmovsdw ymm30{k7}{z},zmm29                                  }
testcase	{ 0x62, 0x02, 0x7e, 0x4f, 0x13, 0xee                                     }, { vpmovusdw ymm30{k7},zmm29                                    }
testcase	{ 0x62, 0x02, 0x7e, 0xcf, 0x13, 0xee                                     }, { vpmovusdw ymm30{k7}{z},zmm29                                 }
testcase	{ 0x62, 0x03, 0x15, 0x40, 0x23, 0xf4, 0xab                               }, { vshuff32x4 zmm30,zmm29,zmm28,0xab                            }
testcase	{ 0x62, 0x03, 0x15, 0x47, 0x23, 0xf4, 0xab                               }, { vshuff32x4 zmm30{k7},zmm29,zmm28,0xab                        }
testcase	{ 0x62, 0x03, 0x15, 0xc7, 0x23, 0xf4, 0xab                               }, { vshuff32x4 zmm30{k7}{z},zmm29,zmm28,0xab                     }
testcase	{ 0x62, 0x03, 0x15, 0x40, 0x23, 0xf4, 0x7b                               }, { vshuff32x4 zmm30,zmm29,zmm28,0x7b                            }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x23, 0x31, 0x7b                               }, { vshuff32x4 zmm30,zmm29,ZWORD [rcx],0x7b                      }
testcase	{ 0x62, 0x23, 0x15, 0x40, 0x23, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vshuff32x4 zmm30,zmm29,ZWORD [rax+r14*8+0x123],0x7b          }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x23, 0x31, 0x7b                               }, { vshuff32x4 zmm30,zmm29,DWORD [rcx]{1to16},0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x23, 0x72, 0x7f, 0x7b                         }, { vshuff32x4 zmm30,zmm29,ZWORD [rdx+0x1fc0],0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x23, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vshuff32x4 zmm30,zmm29,ZWORD [rdx+0x2000],0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x23, 0x72, 0x80, 0x7b                         }, { vshuff32x4 zmm30,zmm29,ZWORD [rdx-0x2000],0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x23, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vshuff32x4 zmm30,zmm29,ZWORD [rdx-0x2040],0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x23, 0x72, 0x7f, 0x7b                         }, { vshuff32x4 zmm30,zmm29,DWORD [rdx+0x1fc]{1to16},0x7b         }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x23, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vshuff32x4 zmm30,zmm29,DWORD [rdx+0x200]{1to16},0x7b         }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x23, 0x72, 0x80, 0x7b                         }, { vshuff32x4 zmm30,zmm29,DWORD [rdx-0x200]{1to16},0x7b         }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x23, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vshuff32x4 zmm30,zmm29,DWORD [rdx-0x204]{1to16},0x7b         }
testcase	{ 0x62, 0x03, 0x95, 0x40, 0x23, 0xf4, 0xab                               }, { vshuff64x2 zmm30,zmm29,zmm28,0xab                            }
testcase	{ 0x62, 0x03, 0x95, 0x47, 0x23, 0xf4, 0xab                               }, { vshuff64x2 zmm30{k7},zmm29,zmm28,0xab                        }
testcase	{ 0x62, 0x03, 0x95, 0xc7, 0x23, 0xf4, 0xab                               }, { vshuff64x2 zmm30{k7}{z},zmm29,zmm28,0xab                     }
testcase	{ 0x62, 0x03, 0x95, 0x40, 0x23, 0xf4, 0x7b                               }, { vshuff64x2 zmm30,zmm29,zmm28,0x7b                            }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x23, 0x31, 0x7b                               }, { vshuff64x2 zmm30,zmm29,ZWORD [rcx],0x7b                      }
testcase	{ 0x62, 0x23, 0x95, 0x40, 0x23, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vshuff64x2 zmm30,zmm29,ZWORD [rax+r14*8+0x123],0x7b          }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x23, 0x31, 0x7b                               }, { vshuff64x2 zmm30,zmm29,QWORD [rcx]{1to8},0x7b                }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x23, 0x72, 0x7f, 0x7b                         }, { vshuff64x2 zmm30,zmm29,ZWORD [rdx+0x1fc0],0x7b               }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x23, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vshuff64x2 zmm30,zmm29,ZWORD [rdx+0x2000],0x7b               }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x23, 0x72, 0x80, 0x7b                         }, { vshuff64x2 zmm30,zmm29,ZWORD [rdx-0x2000],0x7b               }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x23, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vshuff64x2 zmm30,zmm29,ZWORD [rdx-0x2040],0x7b               }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x23, 0x72, 0x7f, 0x7b                         }, { vshuff64x2 zmm30,zmm29,QWORD [rdx+0x3f8]{1to8},0x7b          }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x23, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vshuff64x2 zmm30,zmm29,QWORD [rdx+0x400]{1to8},0x7b          }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x23, 0x72, 0x80, 0x7b                         }, { vshuff64x2 zmm30,zmm29,QWORD [rdx-0x400]{1to8},0x7b          }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x23, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vshuff64x2 zmm30,zmm29,QWORD [rdx-0x408]{1to8},0x7b          }
testcase	{ 0x62, 0x03, 0x15, 0x40, 0x43, 0xf4, 0xab                               }, { vshufi32x4 zmm30,zmm29,zmm28,0xab                            }
testcase	{ 0x62, 0x03, 0x15, 0x47, 0x43, 0xf4, 0xab                               }, { vshufi32x4 zmm30{k7},zmm29,zmm28,0xab                        }
testcase	{ 0x62, 0x03, 0x15, 0xc7, 0x43, 0xf4, 0xab                               }, { vshufi32x4 zmm30{k7}{z},zmm29,zmm28,0xab                     }
testcase	{ 0x62, 0x03, 0x15, 0x40, 0x43, 0xf4, 0x7b                               }, { vshufi32x4 zmm30,zmm29,zmm28,0x7b                            }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x43, 0x31, 0x7b                               }, { vshufi32x4 zmm30,zmm29,ZWORD [rcx],0x7b                      }
testcase	{ 0x62, 0x23, 0x15, 0x40, 0x43, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vshufi32x4 zmm30,zmm29,ZWORD [rax+r14*8+0x123],0x7b          }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x43, 0x31, 0x7b                               }, { vshufi32x4 zmm30,zmm29,DWORD [rcx]{1to16},0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x43, 0x72, 0x7f, 0x7b                         }, { vshufi32x4 zmm30,zmm29,ZWORD [rdx+0x1fc0],0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x43, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vshufi32x4 zmm30,zmm29,ZWORD [rdx+0x2000],0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x43, 0x72, 0x80, 0x7b                         }, { vshufi32x4 zmm30,zmm29,ZWORD [rdx-0x2000],0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x43, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vshufi32x4 zmm30,zmm29,ZWORD [rdx-0x2040],0x7b               }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x43, 0x72, 0x7f, 0x7b                         }, { vshufi32x4 zmm30,zmm29,DWORD [rdx+0x1fc]{1to16},0x7b         }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x43, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vshufi32x4 zmm30,zmm29,DWORD [rdx+0x200]{1to16},0x7b         }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x43, 0x72, 0x80, 0x7b                         }, { vshufi32x4 zmm30,zmm29,DWORD [rdx-0x200]{1to16},0x7b         }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x43, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vshufi32x4 zmm30,zmm29,DWORD [rdx-0x204]{1to16},0x7b         }
testcase	{ 0x62, 0x03, 0x95, 0x40, 0x43, 0xf4, 0xab                               }, { vshufi64x2 zmm30,zmm29,zmm28,0xab                            }
testcase	{ 0x62, 0x03, 0x95, 0x47, 0x43, 0xf4, 0xab                               }, { vshufi64x2 zmm30{k7},zmm29,zmm28,0xab                        }
testcase	{ 0x62, 0x03, 0x95, 0xc7, 0x43, 0xf4, 0xab                               }, { vshufi64x2 zmm30{k7}{z},zmm29,zmm28,0xab                     }
testcase	{ 0x62, 0x03, 0x95, 0x40, 0x43, 0xf4, 0x7b                               }, { vshufi64x2 zmm30,zmm29,zmm28,0x7b                            }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x43, 0x31, 0x7b                               }, { vshufi64x2 zmm30,zmm29,ZWORD [rcx],0x7b                      }
testcase	{ 0x62, 0x23, 0x95, 0x40, 0x43, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vshufi64x2 zmm30,zmm29,ZWORD [rax+r14*8+0x123],0x7b          }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x43, 0x31, 0x7b                               }, { vshufi64x2 zmm30,zmm29,QWORD [rcx]{1to8},0x7b                }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x43, 0x72, 0x7f, 0x7b                         }, { vshufi64x2 zmm30,zmm29,ZWORD [rdx+0x1fc0],0x7b               }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x43, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vshufi64x2 zmm30,zmm29,ZWORD [rdx+0x2000],0x7b               }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x43, 0x72, 0x80, 0x7b                         }, { vshufi64x2 zmm30,zmm29,ZWORD [rdx-0x2000],0x7b               }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x43, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vshufi64x2 zmm30,zmm29,ZWORD [rdx-0x2040],0x7b               }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x43, 0x72, 0x7f, 0x7b                         }, { vshufi64x2 zmm30,zmm29,QWORD [rdx+0x3f8]{1to8},0x7b          }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x43, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vshufi64x2 zmm30,zmm29,QWORD [rdx+0x400]{1to8},0x7b          }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x43, 0x72, 0x80, 0x7b                         }, { vshufi64x2 zmm30,zmm29,QWORD [rdx-0x400]{1to8},0x7b          }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x43, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vshufi64x2 zmm30,zmm29,QWORD [rdx-0x408]{1to8},0x7b          }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x36, 0xf4                                     }, { vpermq zmm30,zmm29,zmm28                                     }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x36, 0xf4                                     }, { vpermq zmm30{k7},zmm29,zmm28                                 }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x36, 0xf4                                     }, { vpermq zmm30{k7}{z},zmm29,zmm28                              }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x36, 0x31                                     }, { vpermq zmm30,zmm29,ZWORD [rcx]                               }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x36, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpermq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                   }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x36, 0x31                                     }, { vpermq zmm30,zmm29,QWORD [rcx]{1to8}                         }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x36, 0x72, 0x7f                               }, { vpermq zmm30,zmm29,ZWORD [rdx+0x1fc0]                        }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x36, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpermq zmm30,zmm29,ZWORD [rdx+0x2000]                        }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x36, 0x72, 0x80                               }, { vpermq zmm30,zmm29,ZWORD [rdx-0x2000]                        }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x36, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpermq zmm30,zmm29,ZWORD [rdx-0x2040]                        }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x36, 0x72, 0x7f                               }, { vpermq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                   }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x36, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpermq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                   }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x36, 0x72, 0x80                               }, { vpermq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                   }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x36, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpermq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                   }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x16, 0xf4                                     }, { vpermpd zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x16, 0xf4                                     }, { vpermpd zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x16, 0xf4                                     }, { vpermpd zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x16, 0x31                                     }, { vpermpd zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x16, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpermpd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x16, 0x31                                     }, { vpermpd zmm30,zmm29,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x16, 0x72, 0x7f                               }, { vpermpd zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x16, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpermpd zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x16, 0x72, 0x80                               }, { vpermpd zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x16, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpermpd zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x16, 0x72, 0x7f                               }, { vpermpd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x16, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpermpd zmm30,zmm29,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x16, 0x72, 0x80                               }, { vpermpd zmm30,zmm29,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x16, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpermpd zmm30,zmm29,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x7e, 0xf4                                     }, { vpermt2d zmm30,zmm29,zmm28                                   }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x7e, 0xf4                                     }, { vpermt2d zmm30{k7},zmm29,zmm28                               }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x7e, 0xf4                                     }, { vpermt2d zmm30{k7}{z},zmm29,zmm28                            }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x7e, 0x31                                     }, { vpermt2d zmm30,zmm29,ZWORD [rcx]                             }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x7e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpermt2d zmm30,zmm29,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x7e, 0x31                                     }, { vpermt2d zmm30,zmm29,DWORD [rcx]{1to16}                      }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x7e, 0x72, 0x7f                               }, { vpermt2d zmm30,zmm29,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x7e, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpermt2d zmm30,zmm29,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x7e, 0x72, 0x80                               }, { vpermt2d zmm30,zmm29,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x7e, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpermt2d zmm30,zmm29,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x7e, 0x72, 0x7f                               }, { vpermt2d zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x7e, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpermt2d zmm30,zmm29,DWORD [rdx+0x200]{1to16}                }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x7e, 0x72, 0x80                               }, { vpermt2d zmm30,zmm29,DWORD [rdx-0x200]{1to16}                }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x7e, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpermt2d zmm30,zmm29,DWORD [rdx-0x204]{1to16}                }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x7e, 0xf4                                     }, { vpermt2q zmm30,zmm29,zmm28                                   }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x7e, 0xf4                                     }, { vpermt2q zmm30{k7},zmm29,zmm28                               }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x7e, 0xf4                                     }, { vpermt2q zmm30{k7}{z},zmm29,zmm28                            }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x7e, 0x31                                     }, { vpermt2q zmm30,zmm29,ZWORD [rcx]                             }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x7e, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpermt2q zmm30,zmm29,ZWORD [rax+r14*8+0x123]                 }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x7e, 0x31                                     }, { vpermt2q zmm30,zmm29,QWORD [rcx]{1to8}                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x7e, 0x72, 0x7f                               }, { vpermt2q zmm30,zmm29,ZWORD [rdx+0x1fc0]                      }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x7e, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpermt2q zmm30,zmm29,ZWORD [rdx+0x2000]                      }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x7e, 0x72, 0x80                               }, { vpermt2q zmm30,zmm29,ZWORD [rdx-0x2000]                      }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x7e, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpermt2q zmm30,zmm29,ZWORD [rdx-0x2040]                      }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x7e, 0x72, 0x7f                               }, { vpermt2q zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                 }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x7e, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpermt2q zmm30,zmm29,QWORD [rdx+0x400]{1to8}                 }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x7e, 0x72, 0x80                               }, { vpermt2q zmm30,zmm29,QWORD [rdx-0x400]{1to8}                 }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x7e, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpermt2q zmm30,zmm29,QWORD [rdx-0x408]{1to8}                 }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x7f, 0xf4                                     }, { vpermt2ps zmm30,zmm29,zmm28                                  }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x7f, 0xf4                                     }, { vpermt2ps zmm30{k7},zmm29,zmm28                              }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x7f, 0xf4                                     }, { vpermt2ps zmm30{k7}{z},zmm29,zmm28                           }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x7f, 0x31                                     }, { vpermt2ps zmm30,zmm29,ZWORD [rcx]                            }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x7f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpermt2ps zmm30,zmm29,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x7f, 0x31                                     }, { vpermt2ps zmm30,zmm29,DWORD [rcx]{1to16}                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x7f, 0x72, 0x7f                               }, { vpermt2ps zmm30,zmm29,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x7f, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpermt2ps zmm30,zmm29,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x7f, 0x72, 0x80                               }, { vpermt2ps zmm30,zmm29,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x7f, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpermt2ps zmm30,zmm29,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x7f, 0x72, 0x7f                               }, { vpermt2ps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x7f, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vpermt2ps zmm30,zmm29,DWORD [rdx+0x200]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x7f, 0x72, 0x80                               }, { vpermt2ps zmm30,zmm29,DWORD [rdx-0x200]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x7f, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vpermt2ps zmm30,zmm29,DWORD [rdx-0x204]{1to16}               }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x7f, 0xf4                                     }, { vpermt2pd zmm30,zmm29,zmm28                                  }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x7f, 0xf4                                     }, { vpermt2pd zmm30{k7},zmm29,zmm28                              }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x7f, 0xf4                                     }, { vpermt2pd zmm30{k7}{z},zmm29,zmm28                           }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x7f, 0x31                                     }, { vpermt2pd zmm30,zmm29,ZWORD [rcx]                            }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x7f, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpermt2pd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x7f, 0x31                                     }, { vpermt2pd zmm30,zmm29,QWORD [rcx]{1to8}                      }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x7f, 0x72, 0x7f                               }, { vpermt2pd zmm30,zmm29,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x7f, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vpermt2pd zmm30,zmm29,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x7f, 0x72, 0x80                               }, { vpermt2pd zmm30,zmm29,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x7f, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vpermt2pd zmm30,zmm29,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x7f, 0x72, 0x7f                               }, { vpermt2pd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x7f, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpermt2pd zmm30,zmm29,QWORD [rdx+0x400]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x7f, 0x72, 0x80                               }, { vpermt2pd zmm30,zmm29,QWORD [rdx-0x400]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x7f, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpermt2pd zmm30,zmm29,QWORD [rdx-0x408]{1to8}                }
testcase	{ 0x62, 0x03, 0x95, 0x40, 0x03, 0xf4, 0xab                               }, { valignq zmm30,zmm29,zmm28,0xab                               }
testcase	{ 0x62, 0x03, 0x95, 0x47, 0x03, 0xf4, 0xab                               }, { valignq zmm30{k7},zmm29,zmm28,0xab                           }
testcase	{ 0x62, 0x03, 0x95, 0xc7, 0x03, 0xf4, 0xab                               }, { valignq zmm30{k7}{z},zmm29,zmm28,0xab                        }
testcase	{ 0x62, 0x03, 0x95, 0x40, 0x03, 0xf4, 0x7b                               }, { valignq zmm30,zmm29,zmm28,0x7b                               }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x03, 0x31, 0x7b                               }, { valignq zmm30,zmm29,ZWORD [rcx],0x7b                         }
testcase	{ 0x62, 0x23, 0x95, 0x40, 0x03, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { valignq zmm30,zmm29,ZWORD [rax+r14*8+0x123],0x7b             }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x03, 0x31, 0x7b                               }, { valignq zmm30,zmm29,QWORD [rcx]{1to8},0x7b                   }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x03, 0x72, 0x7f, 0x7b                         }, { valignq zmm30,zmm29,ZWORD [rdx+0x1fc0],0x7b                  }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x03, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { valignq zmm30,zmm29,ZWORD [rdx+0x2000],0x7b                  }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x03, 0x72, 0x80, 0x7b                         }, { valignq zmm30,zmm29,ZWORD [rdx-0x2000],0x7b                  }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x03, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { valignq zmm30,zmm29,ZWORD [rdx-0x2040],0x7b                  }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x03, 0x72, 0x7f, 0x7b                         }, { valignq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8},0x7b             }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x03, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { valignq zmm30,zmm29,QWORD [rdx+0x400]{1to8},0x7b             }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x03, 0x72, 0x80, 0x7b                         }, { valignq zmm30,zmm29,QWORD [rdx-0x400]{1to8},0x7b             }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x03, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { valignq zmm30,zmm29,QWORD [rdx-0x408]{1to8},0x7b             }
testcase	{ 0x62, 0x91, 0x7f, 0x08, 0x79, 0xc6                                     }, { vcvtsd2usi eax,xmm30                                         }
testcase	{ 0x62, 0x91, 0x7f, 0x18, 0x79, 0xc6                                     }, { vcvtsd2usi eax,xmm30,{rn-sae}                                }
testcase	{ 0x62, 0x91, 0x7f, 0x58, 0x79, 0xc6                                     }, { vcvtsd2usi eax,xmm30,{ru-sae}                                }
testcase	{ 0x62, 0x91, 0x7f, 0x38, 0x79, 0xc6                                     }, { vcvtsd2usi eax,xmm30,{rd-sae}                                }
testcase	{ 0x62, 0x91, 0x7f, 0x78, 0x79, 0xc6                                     }, { vcvtsd2usi eax,xmm30,{rz-sae}                                }
testcase	{ 0x62, 0xf1, 0x7f, 0x08, 0x79, 0x01                                     }, { vcvtsd2usi eax,QWORD [rcx]                                   }
testcase	{ 0x62, 0xb1, 0x7f, 0x08, 0x79, 0x84, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtsd2usi eax,QWORD [rax+r14*8+0x123]                       }
testcase	{ 0x62, 0xf1, 0x7f, 0x08, 0x79, 0x42, 0x7f                               }, { vcvtsd2usi eax,QWORD [rdx+0x3f8]                             }
testcase	{ 0x62, 0xf1, 0x7f, 0x08, 0x79, 0x82, 0x00, 0x04, 0x00, 0x00             }, { vcvtsd2usi eax,QWORD [rdx+0x400]                             }
testcase	{ 0x62, 0xf1, 0x7f, 0x08, 0x79, 0x42, 0x80                               }, { vcvtsd2usi eax,QWORD [rdx-0x400]                             }
testcase	{ 0x62, 0xf1, 0x7f, 0x08, 0x79, 0x82, 0xf8, 0xfb, 0xff, 0xff             }, { vcvtsd2usi eax,QWORD [rdx-0x408]                             }
testcase	{ 0x62, 0x91, 0x7f, 0x08, 0x79, 0xee                                     }, { vcvtsd2usi ebp,xmm30                                         }
testcase	{ 0x62, 0x91, 0x7f, 0x18, 0x79, 0xee                                     }, { vcvtsd2usi ebp,xmm30,{rn-sae}                                }
testcase	{ 0x62, 0x91, 0x7f, 0x58, 0x79, 0xee                                     }, { vcvtsd2usi ebp,xmm30,{ru-sae}                                }
testcase	{ 0x62, 0x91, 0x7f, 0x38, 0x79, 0xee                                     }, { vcvtsd2usi ebp,xmm30,{rd-sae}                                }
testcase	{ 0x62, 0x91, 0x7f, 0x78, 0x79, 0xee                                     }, { vcvtsd2usi ebp,xmm30,{rz-sae}                                }
testcase	{ 0x62, 0xf1, 0x7f, 0x08, 0x79, 0x29                                     }, { vcvtsd2usi ebp,QWORD [rcx]                                   }
testcase	{ 0x62, 0xb1, 0x7f, 0x08, 0x79, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtsd2usi ebp,QWORD [rax+r14*8+0x123]                       }
testcase	{ 0x62, 0xf1, 0x7f, 0x08, 0x79, 0x6a, 0x7f                               }, { vcvtsd2usi ebp,QWORD [rdx+0x3f8]                             }
testcase	{ 0x62, 0xf1, 0x7f, 0x08, 0x79, 0xaa, 0x00, 0x04, 0x00, 0x00             }, { vcvtsd2usi ebp,QWORD [rdx+0x400]                             }
testcase	{ 0x62, 0xf1, 0x7f, 0x08, 0x79, 0x6a, 0x80                               }, { vcvtsd2usi ebp,QWORD [rdx-0x400]                             }
testcase	{ 0x62, 0xf1, 0x7f, 0x08, 0x79, 0xaa, 0xf8, 0xfb, 0xff, 0xff             }, { vcvtsd2usi ebp,QWORD [rdx-0x408]                             }
testcase	{ 0x62, 0x11, 0x7f, 0x08, 0x79, 0xee                                     }, { vcvtsd2usi r13d,xmm30                                        }
testcase	{ 0x62, 0x11, 0x7f, 0x18, 0x79, 0xee                                     }, { vcvtsd2usi r13d,xmm30,{rn-sae}                               }
testcase	{ 0x62, 0x11, 0x7f, 0x58, 0x79, 0xee                                     }, { vcvtsd2usi r13d,xmm30,{ru-sae}                               }
testcase	{ 0x62, 0x11, 0x7f, 0x38, 0x79, 0xee                                     }, { vcvtsd2usi r13d,xmm30,{rd-sae}                               }
testcase	{ 0x62, 0x11, 0x7f, 0x78, 0x79, 0xee                                     }, { vcvtsd2usi r13d,xmm30,{rz-sae}                               }
testcase	{ 0x62, 0x71, 0x7f, 0x08, 0x79, 0x29                                     }, { vcvtsd2usi r13d,QWORD [rcx]                                  }
testcase	{ 0x62, 0x31, 0x7f, 0x08, 0x79, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtsd2usi r13d,QWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x71, 0x7f, 0x08, 0x79, 0x6a, 0x7f                               }, { vcvtsd2usi r13d,QWORD [rdx+0x3f8]                            }
testcase	{ 0x62, 0x71, 0x7f, 0x08, 0x79, 0xaa, 0x00, 0x04, 0x00, 0x00             }, { vcvtsd2usi r13d,QWORD [rdx+0x400]                            }
testcase	{ 0x62, 0x71, 0x7f, 0x08, 0x79, 0x6a, 0x80                               }, { vcvtsd2usi r13d,QWORD [rdx-0x400]                            }
testcase	{ 0x62, 0x71, 0x7f, 0x08, 0x79, 0xaa, 0xf8, 0xfb, 0xff, 0xff             }, { vcvtsd2usi r13d,QWORD [rdx-0x408]                            }
testcase	{ 0x62, 0x91, 0xff, 0x08, 0x79, 0xc6                                     }, { vcvtsd2usi rax,xmm30                                         }
testcase	{ 0x62, 0x91, 0xff, 0x18, 0x79, 0xc6                                     }, { vcvtsd2usi rax,xmm30,{rn-sae}                                }
testcase	{ 0x62, 0x91, 0xff, 0x58, 0x79, 0xc6                                     }, { vcvtsd2usi rax,xmm30,{ru-sae}                                }
testcase	{ 0x62, 0x91, 0xff, 0x38, 0x79, 0xc6                                     }, { vcvtsd2usi rax,xmm30,{rd-sae}                                }
testcase	{ 0x62, 0x91, 0xff, 0x78, 0x79, 0xc6                                     }, { vcvtsd2usi rax,xmm30,{rz-sae}                                }
testcase	{ 0x62, 0xf1, 0xff, 0x08, 0x79, 0x01                                     }, { vcvtsd2usi rax,QWORD [rcx]                                   }
testcase	{ 0x62, 0xb1, 0xff, 0x08, 0x79, 0x84, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtsd2usi rax,QWORD [rax+r14*8+0x123]                       }
testcase	{ 0x62, 0xf1, 0xff, 0x08, 0x79, 0x42, 0x7f                               }, { vcvtsd2usi rax,QWORD [rdx+0x3f8]                             }
testcase	{ 0x62, 0xf1, 0xff, 0x08, 0x79, 0x82, 0x00, 0x04, 0x00, 0x00             }, { vcvtsd2usi rax,QWORD [rdx+0x400]                             }
testcase	{ 0x62, 0xf1, 0xff, 0x08, 0x79, 0x42, 0x80                               }, { vcvtsd2usi rax,QWORD [rdx-0x400]                             }
testcase	{ 0x62, 0xf1, 0xff, 0x08, 0x79, 0x82, 0xf8, 0xfb, 0xff, 0xff             }, { vcvtsd2usi rax,QWORD [rdx-0x408]                             }
testcase	{ 0x62, 0x11, 0xff, 0x08, 0x79, 0xc6                                     }, { vcvtsd2usi r8,xmm30                                          }
testcase	{ 0x62, 0x11, 0xff, 0x18, 0x79, 0xc6                                     }, { vcvtsd2usi r8,xmm30,{rn-sae}                                 }
testcase	{ 0x62, 0x11, 0xff, 0x58, 0x79, 0xc6                                     }, { vcvtsd2usi r8,xmm30,{ru-sae}                                 }
testcase	{ 0x62, 0x11, 0xff, 0x38, 0x79, 0xc6                                     }, { vcvtsd2usi r8,xmm30,{rd-sae}                                 }
testcase	{ 0x62, 0x11, 0xff, 0x78, 0x79, 0xc6                                     }, { vcvtsd2usi r8,xmm30,{rz-sae}                                 }
testcase	{ 0x62, 0x71, 0xff, 0x08, 0x79, 0x01                                     }, { vcvtsd2usi r8,QWORD [rcx]                                    }
testcase	{ 0x62, 0x31, 0xff, 0x08, 0x79, 0x84, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtsd2usi r8,QWORD [rax+r14*8+0x123]                        }
testcase	{ 0x62, 0x71, 0xff, 0x08, 0x79, 0x42, 0x7f                               }, { vcvtsd2usi r8,QWORD [rdx+0x3f8]                              }
testcase	{ 0x62, 0x71, 0xff, 0x08, 0x79, 0x82, 0x00, 0x04, 0x00, 0x00             }, { vcvtsd2usi r8,QWORD [rdx+0x400]                              }
testcase	{ 0x62, 0x71, 0xff, 0x08, 0x79, 0x42, 0x80                               }, { vcvtsd2usi r8,QWORD [rdx-0x400]                              }
testcase	{ 0x62, 0x71, 0xff, 0x08, 0x79, 0x82, 0xf8, 0xfb, 0xff, 0xff             }, { vcvtsd2usi r8,QWORD [rdx-0x408]                              }
testcase	{ 0x62, 0x91, 0x7e, 0x08, 0x79, 0xc6                                     }, { vcvtss2usi eax,xmm30                                         }
testcase	{ 0x62, 0x91, 0x7e, 0x18, 0x79, 0xc6                                     }, { vcvtss2usi eax,xmm30,{rn-sae}                                }
testcase	{ 0x62, 0x91, 0x7e, 0x58, 0x79, 0xc6                                     }, { vcvtss2usi eax,xmm30,{ru-sae}                                }
testcase	{ 0x62, 0x91, 0x7e, 0x38, 0x79, 0xc6                                     }, { vcvtss2usi eax,xmm30,{rd-sae}                                }
testcase	{ 0x62, 0x91, 0x7e, 0x78, 0x79, 0xc6                                     }, { vcvtss2usi eax,xmm30,{rz-sae}                                }
testcase	{ 0x62, 0xf1, 0x7e, 0x08, 0x79, 0x01                                     }, { vcvtss2usi eax,DWORD [rcx]                                   }
testcase	{ 0x62, 0xb1, 0x7e, 0x08, 0x79, 0x84, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtss2usi eax,DWORD [rax+r14*8+0x123]                       }
testcase	{ 0x62, 0xf1, 0x7e, 0x08, 0x79, 0x42, 0x7f                               }, { vcvtss2usi eax,DWORD [rdx+0x1fc]                             }
testcase	{ 0x62, 0xf1, 0x7e, 0x08, 0x79, 0x82, 0x00, 0x02, 0x00, 0x00             }, { vcvtss2usi eax,DWORD [rdx+0x200]                             }
testcase	{ 0x62, 0xf1, 0x7e, 0x08, 0x79, 0x42, 0x80                               }, { vcvtss2usi eax,DWORD [rdx-0x200]                             }
testcase	{ 0x62, 0xf1, 0x7e, 0x08, 0x79, 0x82, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtss2usi eax,DWORD [rdx-0x204]                             }
testcase	{ 0x62, 0x91, 0x7e, 0x08, 0x79, 0xee                                     }, { vcvtss2usi ebp,xmm30                                         }
testcase	{ 0x62, 0x91, 0x7e, 0x18, 0x79, 0xee                                     }, { vcvtss2usi ebp,xmm30,{rn-sae}                                }
testcase	{ 0x62, 0x91, 0x7e, 0x58, 0x79, 0xee                                     }, { vcvtss2usi ebp,xmm30,{ru-sae}                                }
testcase	{ 0x62, 0x91, 0x7e, 0x38, 0x79, 0xee                                     }, { vcvtss2usi ebp,xmm30,{rd-sae}                                }
testcase	{ 0x62, 0x91, 0x7e, 0x78, 0x79, 0xee                                     }, { vcvtss2usi ebp,xmm30,{rz-sae}                                }
testcase	{ 0x62, 0xf1, 0x7e, 0x08, 0x79, 0x29                                     }, { vcvtss2usi ebp,DWORD [rcx]                                   }
testcase	{ 0x62, 0xb1, 0x7e, 0x08, 0x79, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtss2usi ebp,DWORD [rax+r14*8+0x123]                       }
testcase	{ 0x62, 0xf1, 0x7e, 0x08, 0x79, 0x6a, 0x7f                               }, { vcvtss2usi ebp,DWORD [rdx+0x1fc]                             }
testcase	{ 0x62, 0xf1, 0x7e, 0x08, 0x79, 0xaa, 0x00, 0x02, 0x00, 0x00             }, { vcvtss2usi ebp,DWORD [rdx+0x200]                             }
testcase	{ 0x62, 0xf1, 0x7e, 0x08, 0x79, 0x6a, 0x80                               }, { vcvtss2usi ebp,DWORD [rdx-0x200]                             }
testcase	{ 0x62, 0xf1, 0x7e, 0x08, 0x79, 0xaa, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtss2usi ebp,DWORD [rdx-0x204]                             }
testcase	{ 0x62, 0x11, 0x7e, 0x08, 0x79, 0xee                                     }, { vcvtss2usi r13d,xmm30                                        }
testcase	{ 0x62, 0x11, 0x7e, 0x18, 0x79, 0xee                                     }, { vcvtss2usi r13d,xmm30,{rn-sae}                               }
testcase	{ 0x62, 0x11, 0x7e, 0x58, 0x79, 0xee                                     }, { vcvtss2usi r13d,xmm30,{ru-sae}                               }
testcase	{ 0x62, 0x11, 0x7e, 0x38, 0x79, 0xee                                     }, { vcvtss2usi r13d,xmm30,{rd-sae}                               }
testcase	{ 0x62, 0x11, 0x7e, 0x78, 0x79, 0xee                                     }, { vcvtss2usi r13d,xmm30,{rz-sae}                               }
testcase	{ 0x62, 0x71, 0x7e, 0x08, 0x79, 0x29                                     }, { vcvtss2usi r13d,DWORD [rcx]                                  }
testcase	{ 0x62, 0x31, 0x7e, 0x08, 0x79, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtss2usi r13d,DWORD [rax+r14*8+0x123]                      }
testcase	{ 0x62, 0x71, 0x7e, 0x08, 0x79, 0x6a, 0x7f                               }, { vcvtss2usi r13d,DWORD [rdx+0x1fc]                            }
testcase	{ 0x62, 0x71, 0x7e, 0x08, 0x79, 0xaa, 0x00, 0x02, 0x00, 0x00             }, { vcvtss2usi r13d,DWORD [rdx+0x200]                            }
testcase	{ 0x62, 0x71, 0x7e, 0x08, 0x79, 0x6a, 0x80                               }, { vcvtss2usi r13d,DWORD [rdx-0x200]                            }
testcase	{ 0x62, 0x71, 0x7e, 0x08, 0x79, 0xaa, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtss2usi r13d,DWORD [rdx-0x204]                            }
testcase	{ 0x62, 0x91, 0xfe, 0x08, 0x79, 0xc6                                     }, { vcvtss2usi rax,xmm30                                         }
testcase	{ 0x62, 0x91, 0xfe, 0x18, 0x79, 0xc6                                     }, { vcvtss2usi rax,xmm30,{rn-sae}                                }
testcase	{ 0x62, 0x91, 0xfe, 0x58, 0x79, 0xc6                                     }, { vcvtss2usi rax,xmm30,{ru-sae}                                }
testcase	{ 0x62, 0x91, 0xfe, 0x38, 0x79, 0xc6                                     }, { vcvtss2usi rax,xmm30,{rd-sae}                                }
testcase	{ 0x62, 0x91, 0xfe, 0x78, 0x79, 0xc6                                     }, { vcvtss2usi rax,xmm30,{rz-sae}                                }
testcase	{ 0x62, 0xf1, 0xfe, 0x08, 0x79, 0x01                                     }, { vcvtss2usi rax,DWORD [rcx]                                   }
testcase	{ 0x62, 0xb1, 0xfe, 0x08, 0x79, 0x84, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtss2usi rax,DWORD [rax+r14*8+0x123]                       }
testcase	{ 0x62, 0xf1, 0xfe, 0x08, 0x79, 0x42, 0x7f                               }, { vcvtss2usi rax,DWORD [rdx+0x1fc]                             }
testcase	{ 0x62, 0xf1, 0xfe, 0x08, 0x79, 0x82, 0x00, 0x02, 0x00, 0x00             }, { vcvtss2usi rax,DWORD [rdx+0x200]                             }
testcase	{ 0x62, 0xf1, 0xfe, 0x08, 0x79, 0x42, 0x80                               }, { vcvtss2usi rax,DWORD [rdx-0x200]                             }
testcase	{ 0x62, 0xf1, 0xfe, 0x08, 0x79, 0x82, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtss2usi rax,DWORD [rdx-0x204]                             }
testcase	{ 0x62, 0x11, 0xfe, 0x08, 0x79, 0xc6                                     }, { vcvtss2usi r8,xmm30                                          }
testcase	{ 0x62, 0x11, 0xfe, 0x18, 0x79, 0xc6                                     }, { vcvtss2usi r8,xmm30,{rn-sae}                                 }
testcase	{ 0x62, 0x11, 0xfe, 0x58, 0x79, 0xc6                                     }, { vcvtss2usi r8,xmm30,{ru-sae}                                 }
testcase	{ 0x62, 0x11, 0xfe, 0x38, 0x79, 0xc6                                     }, { vcvtss2usi r8,xmm30,{rd-sae}                                 }
testcase	{ 0x62, 0x11, 0xfe, 0x78, 0x79, 0xc6                                     }, { vcvtss2usi r8,xmm30,{rz-sae}                                 }
testcase	{ 0x62, 0x71, 0xfe, 0x08, 0x79, 0x01                                     }, { vcvtss2usi r8,DWORD [rcx]                                    }
testcase	{ 0x62, 0x31, 0xfe, 0x08, 0x79, 0x84, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtss2usi r8,DWORD [rax+r14*8+0x123]                        }
testcase	{ 0x62, 0x71, 0xfe, 0x08, 0x79, 0x42, 0x7f                               }, { vcvtss2usi r8,DWORD [rdx+0x1fc]                              }
testcase	{ 0x62, 0x71, 0xfe, 0x08, 0x79, 0x82, 0x00, 0x02, 0x00, 0x00             }, { vcvtss2usi r8,DWORD [rdx+0x200]                              }
testcase	{ 0x62, 0x71, 0xfe, 0x08, 0x79, 0x42, 0x80                               }, { vcvtss2usi r8,DWORD [rdx-0x200]                              }
testcase	{ 0x62, 0x71, 0xfe, 0x08, 0x79, 0x82, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtss2usi r8,DWORD [rdx-0x204]                              }
testcase	{ 0x62, 0x61, 0x17, 0x00, 0x7b, 0xf0                                     }, { vcvtusi2sd xmm30,xmm29,eax                                   }
testcase	{ 0x62, 0x61, 0x17, 0x00, 0x7b, 0xf5                                     }, { vcvtusi2sd xmm30,xmm29,ebp                                   }
testcase	{ 0x62, 0x41, 0x17, 0x00, 0x7b, 0xf5                                     }, { vcvtusi2sd xmm30,xmm29,r13d                                  }
testcase	{ 0x62, 0x61, 0x17, 0x00, 0x7b, 0x31                                     }, { vcvtusi2sd xmm30,xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x17, 0x00, 0x7b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtusi2sd xmm30,xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x17, 0x00, 0x7b, 0x72, 0x7f                               }, { vcvtusi2sd xmm30,xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0x61, 0x17, 0x00, 0x7b, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcvtusi2sd xmm30,xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0x61, 0x17, 0x00, 0x7b, 0x72, 0x80                               }, { vcvtusi2sd xmm30,xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0x61, 0x17, 0x00, 0x7b, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtusi2sd xmm30,xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x61, 0x97, 0x00, 0x7b, 0xf0                                     }, { vcvtusi2sd xmm30,xmm29,rax                                   }
testcase	{ 0x62, 0x61, 0x97, 0x10, 0x7b, 0xf0                                     }, { vcvtusi2sd xmm30,xmm29,{rn-sae},rax                          }
testcase	{ 0x62, 0x61, 0x97, 0x50, 0x7b, 0xf0                                     }, { vcvtusi2sd xmm30,xmm29,{ru-sae},rax                          }
testcase	{ 0x62, 0x61, 0x97, 0x30, 0x7b, 0xf0                                     }, { vcvtusi2sd xmm30,xmm29,{rd-sae},rax                          }
testcase	{ 0x62, 0x61, 0x97, 0x70, 0x7b, 0xf0                                     }, { vcvtusi2sd xmm30,xmm29,{rz-sae},rax                          }
testcase	{ 0x62, 0x41, 0x97, 0x00, 0x7b, 0xf0                                     }, { vcvtusi2sd xmm30,xmm29,r8                                    }
testcase	{ 0x62, 0x41, 0x97, 0x10, 0x7b, 0xf0                                     }, { vcvtusi2sd xmm30,xmm29,{rn-sae},r8                           }
testcase	{ 0x62, 0x41, 0x97, 0x50, 0x7b, 0xf0                                     }, { vcvtusi2sd xmm30,xmm29,{ru-sae},r8                           }
testcase	{ 0x62, 0x41, 0x97, 0x30, 0x7b, 0xf0                                     }, { vcvtusi2sd xmm30,xmm29,{rd-sae},r8                           }
testcase	{ 0x62, 0x41, 0x97, 0x70, 0x7b, 0xf0                                     }, { vcvtusi2sd xmm30,xmm29,{rz-sae},r8                           }
testcase	{ 0x62, 0x61, 0x97, 0x00, 0x7b, 0x31                                     }, { vcvtusi2sd xmm30,xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x97, 0x00, 0x7b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtusi2sd xmm30,xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x97, 0x00, 0x7b, 0x72, 0x7f                               }, { vcvtusi2sd xmm30,xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0x61, 0x97, 0x00, 0x7b, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vcvtusi2sd xmm30,xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0x61, 0x97, 0x00, 0x7b, 0x72, 0x80                               }, { vcvtusi2sd xmm30,xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0x61, 0x97, 0x00, 0x7b, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vcvtusi2sd xmm30,xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x61, 0x16, 0x00, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,eax                                   }
testcase	{ 0x62, 0x61, 0x16, 0x10, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,{rn-sae},eax                          }
testcase	{ 0x62, 0x61, 0x16, 0x50, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,{ru-sae},eax                          }
testcase	{ 0x62, 0x61, 0x16, 0x30, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,{rd-sae},eax                          }
testcase	{ 0x62, 0x61, 0x16, 0x70, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,{rz-sae},eax                          }
testcase	{ 0x62, 0x61, 0x16, 0x00, 0x7b, 0xf5                                     }, { vcvtusi2ss xmm30,xmm29,ebp                                   }
testcase	{ 0x62, 0x61, 0x16, 0x10, 0x7b, 0xf5                                     }, { vcvtusi2ss xmm30,xmm29,{rn-sae},ebp                          }
testcase	{ 0x62, 0x61, 0x16, 0x50, 0x7b, 0xf5                                     }, { vcvtusi2ss xmm30,xmm29,{ru-sae},ebp                          }
testcase	{ 0x62, 0x61, 0x16, 0x30, 0x7b, 0xf5                                     }, { vcvtusi2ss xmm30,xmm29,{rd-sae},ebp                          }
testcase	{ 0x62, 0x61, 0x16, 0x70, 0x7b, 0xf5                                     }, { vcvtusi2ss xmm30,xmm29,{rz-sae},ebp                          }
testcase	{ 0x62, 0x41, 0x16, 0x00, 0x7b, 0xf5                                     }, { vcvtusi2ss xmm30,xmm29,r13d                                  }
testcase	{ 0x62, 0x41, 0x16, 0x10, 0x7b, 0xf5                                     }, { vcvtusi2ss xmm30,xmm29,{rn-sae},r13d                         }
testcase	{ 0x62, 0x41, 0x16, 0x50, 0x7b, 0xf5                                     }, { vcvtusi2ss xmm30,xmm29,{ru-sae},r13d                         }
testcase	{ 0x62, 0x41, 0x16, 0x30, 0x7b, 0xf5                                     }, { vcvtusi2ss xmm30,xmm29,{rd-sae},r13d                         }
testcase	{ 0x62, 0x41, 0x16, 0x70, 0x7b, 0xf5                                     }, { vcvtusi2ss xmm30,xmm29,{rz-sae},r13d                         }
testcase	{ 0x62, 0x61, 0x16, 0x00, 0x7b, 0x31                                     }, { vcvtusi2ss xmm30,xmm29,DWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x16, 0x00, 0x7b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtusi2ss xmm30,xmm29,DWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x16, 0x00, 0x7b, 0x72, 0x7f                               }, { vcvtusi2ss xmm30,xmm29,DWORD [rdx+0x1fc]                     }
testcase	{ 0x62, 0x61, 0x16, 0x00, 0x7b, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vcvtusi2ss xmm30,xmm29,DWORD [rdx+0x200]                     }
testcase	{ 0x62, 0x61, 0x16, 0x00, 0x7b, 0x72, 0x80                               }, { vcvtusi2ss xmm30,xmm29,DWORD [rdx-0x200]                     }
testcase	{ 0x62, 0x61, 0x16, 0x00, 0x7b, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vcvtusi2ss xmm30,xmm29,DWORD [rdx-0x204]                     }
testcase	{ 0x62, 0x61, 0x96, 0x00, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,rax                                   }
testcase	{ 0x62, 0x61, 0x96, 0x10, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,{rn-sae},rax                          }
testcase	{ 0x62, 0x61, 0x96, 0x50, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,{ru-sae},rax                          }
testcase	{ 0x62, 0x61, 0x96, 0x30, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,{rd-sae},rax                          }
testcase	{ 0x62, 0x61, 0x96, 0x70, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,{rz-sae},rax                          }
testcase	{ 0x62, 0x41, 0x96, 0x00, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,r8                                    }
testcase	{ 0x62, 0x41, 0x96, 0x10, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,{rn-sae},r8                           }
testcase	{ 0x62, 0x41, 0x96, 0x50, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,{ru-sae},r8                           }
testcase	{ 0x62, 0x41, 0x96, 0x30, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,{rd-sae},r8                           }
testcase	{ 0x62, 0x41, 0x96, 0x70, 0x7b, 0xf0                                     }, { vcvtusi2ss xmm30,xmm29,{rz-sae},r8                           }
testcase	{ 0x62, 0x61, 0x96, 0x00, 0x7b, 0x31                                     }, { vcvtusi2ss xmm30,xmm29,QWORD [rcx]                           }
testcase	{ 0x62, 0x21, 0x96, 0x00, 0x7b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vcvtusi2ss xmm30,xmm29,QWORD [rax+r14*8+0x123]               }
testcase	{ 0x62, 0x61, 0x96, 0x00, 0x7b, 0x72, 0x7f                               }, { vcvtusi2ss xmm30,xmm29,QWORD [rdx+0x3f8]                     }
testcase	{ 0x62, 0x61, 0x96, 0x00, 0x7b, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vcvtusi2ss xmm30,xmm29,QWORD [rdx+0x400]                     }
testcase	{ 0x62, 0x61, 0x96, 0x00, 0x7b, 0x72, 0x80                               }, { vcvtusi2ss xmm30,xmm29,QWORD [rdx-0x400]                     }
testcase	{ 0x62, 0x61, 0x96, 0x00, 0x7b, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vcvtusi2ss xmm30,xmm29,QWORD [rdx-0x408]                     }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x2c, 0xf4                                     }, { vscalefpd zmm30,zmm29,zmm28                                  }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x2c, 0xf4                                     }, { vscalefpd zmm30{k7},zmm29,zmm28                              }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x2c, 0xf4                                     }, { vscalefpd zmm30{k7}{z},zmm29,zmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0x10, 0x2c, 0xf4                                     }, { vscalefpd zmm30,zmm29,zmm28,{rn-sae}                         }
testcase	{ 0x62, 0x02, 0x95, 0x50, 0x2c, 0xf4                                     }, { vscalefpd zmm30,zmm29,zmm28,{ru-sae}                         }
testcase	{ 0x62, 0x02, 0x95, 0x30, 0x2c, 0xf4                                     }, { vscalefpd zmm30,zmm29,zmm28,{rd-sae}                         }
testcase	{ 0x62, 0x02, 0x95, 0x70, 0x2c, 0xf4                                     }, { vscalefpd zmm30,zmm29,zmm28,{rz-sae}                         }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x2c, 0x31                                     }, { vscalefpd zmm30,zmm29,ZWORD [rcx]                            }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x2c, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vscalefpd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x2c, 0x31                                     }, { vscalefpd zmm30,zmm29,QWORD [rcx]{1to8}                      }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x2c, 0x72, 0x7f                               }, { vscalefpd zmm30,zmm29,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x2c, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vscalefpd zmm30,zmm29,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x2c, 0x72, 0x80                               }, { vscalefpd zmm30,zmm29,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x2c, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vscalefpd zmm30,zmm29,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x2c, 0x72, 0x7f                               }, { vscalefpd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x2c, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vscalefpd zmm30,zmm29,QWORD [rdx+0x400]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x2c, 0x72, 0x80                               }, { vscalefpd zmm30,zmm29,QWORD [rdx-0x400]{1to8}                }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x2c, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vscalefpd zmm30,zmm29,QWORD [rdx-0x408]{1to8}                }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x2c, 0xf4                                     }, { vscalefps zmm30,zmm29,zmm28                                  }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x2c, 0xf4                                     }, { vscalefps zmm30{k7},zmm29,zmm28                              }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x2c, 0xf4                                     }, { vscalefps zmm30{k7}{z},zmm29,zmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0x10, 0x2c, 0xf4                                     }, { vscalefps zmm30,zmm29,zmm28,{rn-sae}                         }
testcase	{ 0x62, 0x02, 0x15, 0x50, 0x2c, 0xf4                                     }, { vscalefps zmm30,zmm29,zmm28,{ru-sae}                         }
testcase	{ 0x62, 0x02, 0x15, 0x30, 0x2c, 0xf4                                     }, { vscalefps zmm30,zmm29,zmm28,{rd-sae}                         }
testcase	{ 0x62, 0x02, 0x15, 0x70, 0x2c, 0xf4                                     }, { vscalefps zmm30,zmm29,zmm28,{rz-sae}                         }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x2c, 0x31                                     }, { vscalefps zmm30,zmm29,ZWORD [rcx]                            }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x2c, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vscalefps zmm30,zmm29,ZWORD [rax+r14*8+0x123]                }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x2c, 0x31                                     }, { vscalefps zmm30,zmm29,DWORD [rcx]{1to16}                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x2c, 0x72, 0x7f                               }, { vscalefps zmm30,zmm29,ZWORD [rdx+0x1fc0]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x2c, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vscalefps zmm30,zmm29,ZWORD [rdx+0x2000]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x2c, 0x72, 0x80                               }, { vscalefps zmm30,zmm29,ZWORD [rdx-0x2000]                     }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x2c, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vscalefps zmm30,zmm29,ZWORD [rdx-0x2040]                     }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x2c, 0x72, 0x7f                               }, { vscalefps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x2c, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vscalefps zmm30,zmm29,DWORD [rdx+0x200]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x2c, 0x72, 0x80                               }, { vscalefps zmm30,zmm29,DWORD [rdx-0x200]{1to16}               }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x2c, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vscalefps zmm30,zmm29,DWORD [rdx-0x204]{1to16}               }
testcase	{ 0x62, 0x02, 0x95, 0x07, 0x2d, 0xf4                                     }, { vscalefsd xmm30{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x02, 0x95, 0x87, 0x2d, 0xf4                                     }, { vscalefsd xmm30{k7}{z},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x95, 0x17, 0x2d, 0xf4                                     }, { vscalefsd xmm30{k7},xmm29,xmm28,{rn-sae}                     }
testcase	{ 0x62, 0x02, 0x95, 0x57, 0x2d, 0xf4                                     }, { vscalefsd xmm30{k7},xmm29,xmm28,{ru-sae}                     }
testcase	{ 0x62, 0x02, 0x95, 0x37, 0x2d, 0xf4                                     }, { vscalefsd xmm30{k7},xmm29,xmm28,{rd-sae}                     }
testcase	{ 0x62, 0x02, 0x95, 0x77, 0x2d, 0xf4                                     }, { vscalefsd xmm30{k7},xmm29,xmm28,{rz-sae}                     }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x2d, 0x31                                     }, { vscalefsd xmm30{k7},xmm29,QWORD [rcx]                        }
testcase	{ 0x62, 0x22, 0x95, 0x07, 0x2d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vscalefsd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x2d, 0x72, 0x7f                               }, { vscalefsd xmm30{k7},xmm29,QWORD [rdx+0x3f8]                  }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x2d, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vscalefsd xmm30{k7},xmm29,QWORD [rdx+0x400]                  }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x2d, 0x72, 0x80                               }, { vscalefsd xmm30{k7},xmm29,QWORD [rdx-0x400]                  }
testcase	{ 0x62, 0x62, 0x95, 0x07, 0x2d, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vscalefsd xmm30{k7},xmm29,QWORD [rdx-0x408]                  }
testcase	{ 0x62, 0x02, 0x15, 0x07, 0x2d, 0xf4                                     }, { vscalefss xmm30{k7},xmm29,xmm28                              }
testcase	{ 0x62, 0x02, 0x15, 0x87, 0x2d, 0xf4                                     }, { vscalefss xmm30{k7}{z},xmm29,xmm28                           }
testcase	{ 0x62, 0x02, 0x15, 0x17, 0x2d, 0xf4                                     }, { vscalefss xmm30{k7},xmm29,xmm28,{rn-sae}                     }
testcase	{ 0x62, 0x02, 0x15, 0x57, 0x2d, 0xf4                                     }, { vscalefss xmm30{k7},xmm29,xmm28,{ru-sae}                     }
testcase	{ 0x62, 0x02, 0x15, 0x37, 0x2d, 0xf4                                     }, { vscalefss xmm30{k7},xmm29,xmm28,{rd-sae}                     }
testcase	{ 0x62, 0x02, 0x15, 0x77, 0x2d, 0xf4                                     }, { vscalefss xmm30{k7},xmm29,xmm28,{rz-sae}                     }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x2d, 0x31                                     }, { vscalefss xmm30{k7},xmm29,DWORD [rcx]                        }
testcase	{ 0x62, 0x22, 0x15, 0x07, 0x2d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vscalefss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123]            }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x2d, 0x72, 0x7f                               }, { vscalefss xmm30{k7},xmm29,DWORD [rdx+0x1fc]                  }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x2d, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vscalefss xmm30{k7},xmm29,DWORD [rdx+0x200]                  }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x2d, 0x72, 0x80                               }, { vscalefss xmm30{k7},xmm29,DWORD [rdx-0x200]                  }
testcase	{ 0x62, 0x62, 0x15, 0x07, 0x2d, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vscalefss xmm30{k7},xmm29,DWORD [rdx-0x204]                  }
testcase	{ 0x62, 0x03, 0x15, 0x40, 0x54, 0xf4, 0xab                               }, { vfixupimmps zmm30,zmm29,zmm28,0xab                           }
testcase	{ 0x62, 0x03, 0x15, 0x47, 0x54, 0xf4, 0xab                               }, { vfixupimmps zmm30{k7},zmm29,zmm28,0xab                       }
testcase	{ 0x62, 0x03, 0x15, 0xc7, 0x54, 0xf4, 0xab                               }, { vfixupimmps zmm30{k7}{z},zmm29,zmm28,0xab                    }
testcase	{ 0x62, 0x03, 0x15, 0x10, 0x54, 0xf4, 0xab                               }, { vfixupimmps zmm30,zmm29,zmm28,{sae},0xab                     }
testcase	{ 0x62, 0x03, 0x15, 0x40, 0x54, 0xf4, 0x7b                               }, { vfixupimmps zmm30,zmm29,zmm28,0x7b                           }
testcase	{ 0x62, 0x03, 0x15, 0x10, 0x54, 0xf4, 0x7b                               }, { vfixupimmps zmm30,zmm29,zmm28,{sae},0x7b                     }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x54, 0x31, 0x7b                               }, { vfixupimmps zmm30,zmm29,ZWORD [rcx],0x7b                     }
testcase	{ 0x62, 0x23, 0x15, 0x40, 0x54, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vfixupimmps zmm30,zmm29,ZWORD [rax+r14*8+0x123],0x7b         }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x54, 0x31, 0x7b                               }, { vfixupimmps zmm30,zmm29,DWORD [rcx]{1to16},0x7b              }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x54, 0x72, 0x7f, 0x7b                         }, { vfixupimmps zmm30,zmm29,ZWORD [rdx+0x1fc0],0x7b              }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x54, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vfixupimmps zmm30,zmm29,ZWORD [rdx+0x2000],0x7b              }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x54, 0x72, 0x80, 0x7b                         }, { vfixupimmps zmm30,zmm29,ZWORD [rdx-0x2000],0x7b              }
testcase	{ 0x62, 0x63, 0x15, 0x40, 0x54, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vfixupimmps zmm30,zmm29,ZWORD [rdx-0x2040],0x7b              }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x54, 0x72, 0x7f, 0x7b                         }, { vfixupimmps zmm30,zmm29,DWORD [rdx+0x1fc]{1to16},0x7b        }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x54, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vfixupimmps zmm30,zmm29,DWORD [rdx+0x200]{1to16},0x7b        }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x54, 0x72, 0x80, 0x7b                         }, { vfixupimmps zmm30,zmm29,DWORD [rdx-0x200]{1to16},0x7b        }
testcase	{ 0x62, 0x63, 0x15, 0x50, 0x54, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vfixupimmps zmm30,zmm29,DWORD [rdx-0x204]{1to16},0x7b        }
testcase	{ 0x62, 0x03, 0x95, 0x40, 0x54, 0xf4, 0xab                               }, { vfixupimmpd zmm30,zmm29,zmm28,0xab                           }
testcase	{ 0x62, 0x03, 0x95, 0x47, 0x54, 0xf4, 0xab                               }, { vfixupimmpd zmm30{k7},zmm29,zmm28,0xab                       }
testcase	{ 0x62, 0x03, 0x95, 0xc7, 0x54, 0xf4, 0xab                               }, { vfixupimmpd zmm30{k7}{z},zmm29,zmm28,0xab                    }
testcase	{ 0x62, 0x03, 0x95, 0x10, 0x54, 0xf4, 0xab                               }, { vfixupimmpd zmm30,zmm29,zmm28,{sae},0xab                     }
testcase	{ 0x62, 0x03, 0x95, 0x40, 0x54, 0xf4, 0x7b                               }, { vfixupimmpd zmm30,zmm29,zmm28,0x7b                           }
testcase	{ 0x62, 0x03, 0x95, 0x10, 0x54, 0xf4, 0x7b                               }, { vfixupimmpd zmm30,zmm29,zmm28,{sae},0x7b                     }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x54, 0x31, 0x7b                               }, { vfixupimmpd zmm30,zmm29,ZWORD [rcx],0x7b                     }
testcase	{ 0x62, 0x23, 0x95, 0x40, 0x54, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vfixupimmpd zmm30,zmm29,ZWORD [rax+r14*8+0x123],0x7b         }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x54, 0x31, 0x7b                               }, { vfixupimmpd zmm30,zmm29,QWORD [rcx]{1to8},0x7b               }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x54, 0x72, 0x7f, 0x7b                         }, { vfixupimmpd zmm30,zmm29,ZWORD [rdx+0x1fc0],0x7b              }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x54, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vfixupimmpd zmm30,zmm29,ZWORD [rdx+0x2000],0x7b              }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x54, 0x72, 0x80, 0x7b                         }, { vfixupimmpd zmm30,zmm29,ZWORD [rdx-0x2000],0x7b              }
testcase	{ 0x62, 0x63, 0x95, 0x40, 0x54, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vfixupimmpd zmm30,zmm29,ZWORD [rdx-0x2040],0x7b              }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x54, 0x72, 0x7f, 0x7b                         }, { vfixupimmpd zmm30,zmm29,QWORD [rdx+0x3f8]{1to8},0x7b         }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x54, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vfixupimmpd zmm30,zmm29,QWORD [rdx+0x400]{1to8},0x7b         }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x54, 0x72, 0x80, 0x7b                         }, { vfixupimmpd zmm30,zmm29,QWORD [rdx-0x400]{1to8},0x7b         }
testcase	{ 0x62, 0x63, 0x95, 0x50, 0x54, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vfixupimmpd zmm30,zmm29,QWORD [rdx-0x408]{1to8},0x7b         }
testcase	{ 0x62, 0x03, 0x15, 0x07, 0x55, 0xf4, 0xab                               }, { vfixupimmss xmm30{k7},xmm29,xmm28,0xab                       }
testcase	{ 0x62, 0x03, 0x15, 0x87, 0x55, 0xf4, 0xab                               }, { vfixupimmss xmm30{k7}{z},xmm29,xmm28,0xab                    }
testcase	{ 0x62, 0x03, 0x15, 0x17, 0x55, 0xf4, 0xab                               }, { vfixupimmss xmm30{k7},xmm29,xmm28,{sae},0xab                 }
testcase	{ 0x62, 0x03, 0x15, 0x07, 0x55, 0xf4, 0x7b                               }, { vfixupimmss xmm30{k7},xmm29,xmm28,0x7b                       }
testcase	{ 0x62, 0x03, 0x15, 0x17, 0x55, 0xf4, 0x7b                               }, { vfixupimmss xmm30{k7},xmm29,xmm28,{sae},0x7b                 }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x55, 0x31, 0x7b                               }, { vfixupimmss xmm30{k7},xmm29,DWORD [rcx],0x7b                 }
testcase	{ 0x62, 0x23, 0x15, 0x07, 0x55, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vfixupimmss xmm30{k7},xmm29,DWORD [rax+r14*8+0x123],0x7b     }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x55, 0x72, 0x7f, 0x7b                         }, { vfixupimmss xmm30{k7},xmm29,DWORD [rdx+0x1fc],0x7b           }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x55, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vfixupimmss xmm30{k7},xmm29,DWORD [rdx+0x200],0x7b           }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x55, 0x72, 0x80, 0x7b                         }, { vfixupimmss xmm30{k7},xmm29,DWORD [rdx-0x200],0x7b           }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x55, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vfixupimmss xmm30{k7},xmm29,DWORD [rdx-0x204],0x7b           }
testcase	{ 0x62, 0x03, 0x95, 0x07, 0x55, 0xf4, 0xab                               }, { vfixupimmsd xmm30{k7},xmm29,xmm28,0xab                       }
testcase	{ 0x62, 0x03, 0x95, 0x87, 0x55, 0xf4, 0xab                               }, { vfixupimmsd xmm30{k7}{z},xmm29,xmm28,0xab                    }
testcase	{ 0x62, 0x03, 0x95, 0x17, 0x55, 0xf4, 0xab                               }, { vfixupimmsd xmm30{k7},xmm29,xmm28,{sae},0xab                 }
testcase	{ 0x62, 0x03, 0x95, 0x07, 0x55, 0xf4, 0x7b                               }, { vfixupimmsd xmm30{k7},xmm29,xmm28,0x7b                       }
testcase	{ 0x62, 0x03, 0x95, 0x17, 0x55, 0xf4, 0x7b                               }, { vfixupimmsd xmm30{k7},xmm29,xmm28,{sae},0x7b                 }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x55, 0x31, 0x7b                               }, { vfixupimmsd xmm30{k7},xmm29,QWORD [rcx],0x7b                 }
testcase	{ 0x62, 0x23, 0x95, 0x07, 0x55, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vfixupimmsd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123],0x7b     }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x55, 0x72, 0x7f, 0x7b                         }, { vfixupimmsd xmm30{k7},xmm29,QWORD [rdx+0x3f8],0x7b           }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x55, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vfixupimmsd xmm30{k7},xmm29,QWORD [rdx+0x400],0x7b           }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x55, 0x72, 0x80, 0x7b                         }, { vfixupimmsd xmm30{k7},xmm29,QWORD [rdx-0x400],0x7b           }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x55, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vfixupimmsd xmm30{k7},xmm29,QWORD [rdx-0x408],0x7b           }
testcase	{ 0x62, 0x91, 0x0d, 0x40, 0x72, 0xf5, 0xab                               }, { vpslld zmm30,zmm29,0xab                                      }
testcase	{ 0x62, 0x91, 0x0d, 0x47, 0x72, 0xf5, 0xab                               }, { vpslld zmm30{k7},zmm29,0xab                                  }
testcase	{ 0x62, 0x91, 0x0d, 0xc7, 0x72, 0xf5, 0xab                               }, { vpslld zmm30{k7}{z},zmm29,0xab                               }
testcase	{ 0x62, 0x91, 0x0d, 0x40, 0x72, 0xf5, 0x7b                               }, { vpslld zmm30,zmm29,0x7b                                      }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x31, 0x7b                               }, { vpslld zmm30,ZWORD [rcx],0x7b                                }
testcase	{ 0x62, 0xb1, 0x0d, 0x40, 0x72, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpslld zmm30,ZWORD [rax+r14*8+0x123],0x7b                    }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x31, 0x7b                               }, { vpslld zmm30,DWORD [rcx]{1to16},0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x72, 0x7f, 0x7b                         }, { vpslld zmm30,ZWORD [rdx+0x1fc0],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpslld zmm30,ZWORD [rdx+0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x72, 0x80, 0x7b                         }, { vpslld zmm30,ZWORD [rdx-0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpslld zmm30,ZWORD [rdx-0x2040],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x72, 0x7f, 0x7b                         }, { vpslld zmm30,DWORD [rdx+0x1fc]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vpslld zmm30,DWORD [rdx+0x200]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x72, 0x80, 0x7b                         }, { vpslld zmm30,DWORD [rdx-0x200]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vpslld zmm30,DWORD [rdx-0x204]{1to16},0x7b                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0x73, 0xf5, 0xab                               }, { vpsllq zmm30,zmm29,0xab                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0x73, 0xf5, 0xab                               }, { vpsllq zmm30{k7},zmm29,0xab                                  }
testcase	{ 0x62, 0x91, 0x8d, 0xc7, 0x73, 0xf5, 0xab                               }, { vpsllq zmm30{k7}{z},zmm29,0xab                               }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0x73, 0xf5, 0x7b                               }, { vpsllq zmm30,zmm29,0x7b                                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x73, 0x31, 0x7b                               }, { vpsllq zmm30,ZWORD [rcx],0x7b                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0x73, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpsllq zmm30,ZWORD [rax+r14*8+0x123],0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x73, 0x31, 0x7b                               }, { vpsllq zmm30,QWORD [rcx]{1to8},0x7b                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x73, 0x72, 0x7f, 0x7b                         }, { vpsllq zmm30,ZWORD [rdx+0x1fc0],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x73, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpsllq zmm30,ZWORD [rdx+0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x73, 0x72, 0x80, 0x7b                         }, { vpsllq zmm30,ZWORD [rdx-0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x73, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpsllq zmm30,ZWORD [rdx-0x2040],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x73, 0x72, 0x7f, 0x7b                         }, { vpsllq zmm30,QWORD [rdx+0x3f8]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x73, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vpsllq zmm30,QWORD [rdx+0x400]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x73, 0x72, 0x80, 0x7b                         }, { vpsllq zmm30,QWORD [rdx-0x400]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x73, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vpsllq zmm30,QWORD [rdx-0x408]{1to8},0x7b                    }
testcase	{ 0x62, 0x91, 0x0d, 0x40, 0x72, 0xe5, 0xab                               }, { vpsrad zmm30,zmm29,0xab                                      }
testcase	{ 0x62, 0x91, 0x0d, 0x47, 0x72, 0xe5, 0xab                               }, { vpsrad zmm30{k7},zmm29,0xab                                  }
testcase	{ 0x62, 0x91, 0x0d, 0xc7, 0x72, 0xe5, 0xab                               }, { vpsrad zmm30{k7}{z},zmm29,0xab                               }
testcase	{ 0x62, 0x91, 0x0d, 0x40, 0x72, 0xe5, 0x7b                               }, { vpsrad zmm30,zmm29,0x7b                                      }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x21, 0x7b                               }, { vpsrad zmm30,ZWORD [rcx],0x7b                                }
testcase	{ 0x62, 0xb1, 0x0d, 0x40, 0x72, 0xa4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpsrad zmm30,ZWORD [rax+r14*8+0x123],0x7b                    }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x21, 0x7b                               }, { vpsrad zmm30,DWORD [rcx]{1to16},0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x62, 0x7f, 0x7b                         }, { vpsrad zmm30,ZWORD [rdx+0x1fc0],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0xa2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpsrad zmm30,ZWORD [rdx+0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x62, 0x80, 0x7b                         }, { vpsrad zmm30,ZWORD [rdx-0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0xa2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpsrad zmm30,ZWORD [rdx-0x2040],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x62, 0x7f, 0x7b                         }, { vpsrad zmm30,DWORD [rdx+0x1fc]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0xa2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vpsrad zmm30,DWORD [rdx+0x200]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x62, 0x80, 0x7b                         }, { vpsrad zmm30,DWORD [rdx-0x200]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0xa2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vpsrad zmm30,DWORD [rdx-0x204]{1to16},0x7b                   }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0x72, 0xe5, 0xab                               }, { vpsraq zmm30,zmm29,0xab                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0x72, 0xe5, 0xab                               }, { vpsraq zmm30{k7},zmm29,0xab                                  }
testcase	{ 0x62, 0x91, 0x8d, 0xc7, 0x72, 0xe5, 0xab                               }, { vpsraq zmm30{k7}{z},zmm29,0xab                               }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0x72, 0xe5, 0x7b                               }, { vpsraq zmm30,zmm29,0x7b                                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0x21, 0x7b                               }, { vpsraq zmm30,ZWORD [rcx],0x7b                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0x72, 0xa4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vpsraq zmm30,ZWORD [rax+r14*8+0x123],0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0x21, 0x7b                               }, { vpsraq zmm30,QWORD [rcx]{1to8},0x7b                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0x62, 0x7f, 0x7b                         }, { vpsraq zmm30,ZWORD [rdx+0x1fc0],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0xa2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vpsraq zmm30,ZWORD [rdx+0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0x62, 0x80, 0x7b                         }, { vpsraq zmm30,ZWORD [rdx-0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0xa2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vpsraq zmm30,ZWORD [rdx-0x2040],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0x62, 0x7f, 0x7b                         }, { vpsraq zmm30,QWORD [rdx+0x3f8]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0xa2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vpsraq zmm30,QWORD [rdx+0x400]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0x62, 0x80, 0x7b                         }, { vpsraq zmm30,QWORD [rdx-0x400]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0xa2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vpsraq zmm30,QWORD [rdx-0x408]{1to8},0x7b                    }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x15, 0xf4                                     }, { vprolvd zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x15, 0xf4                                     }, { vprolvd zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x15, 0xf4                                     }, { vprolvd zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x15, 0x31                                     }, { vprolvd zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x15, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vprolvd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x15, 0x31                                     }, { vprolvd zmm30,zmm29,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x15, 0x72, 0x7f                               }, { vprolvd zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x15, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vprolvd zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x15, 0x72, 0x80                               }, { vprolvd zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x15, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vprolvd zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x15, 0x72, 0x7f                               }, { vprolvd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x15, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vprolvd zmm30,zmm29,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x15, 0x72, 0x80                               }, { vprolvd zmm30,zmm29,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x15, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vprolvd zmm30,zmm29,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x91, 0x0d, 0x40, 0x72, 0xcd, 0xab                               }, { vprold zmm30,zmm29,0xab                                      }
testcase	{ 0x62, 0x91, 0x0d, 0x47, 0x72, 0xcd, 0xab                               }, { vprold zmm30{k7},zmm29,0xab                                  }
testcase	{ 0x62, 0x91, 0x0d, 0xc7, 0x72, 0xcd, 0xab                               }, { vprold zmm30{k7}{z},zmm29,0xab                               }
testcase	{ 0x62, 0x91, 0x0d, 0x40, 0x72, 0xcd, 0x7b                               }, { vprold zmm30,zmm29,0x7b                                      }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x09, 0x7b                               }, { vprold zmm30,ZWORD [rcx],0x7b                                }
testcase	{ 0x62, 0xb1, 0x0d, 0x40, 0x72, 0x8c, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vprold zmm30,ZWORD [rax+r14*8+0x123],0x7b                    }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x09, 0x7b                               }, { vprold zmm30,DWORD [rcx]{1to16},0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x4a, 0x7f, 0x7b                         }, { vprold zmm30,ZWORD [rdx+0x1fc0],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x8a, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vprold zmm30,ZWORD [rdx+0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x4a, 0x80, 0x7b                         }, { vprold zmm30,ZWORD [rdx-0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x8a, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vprold zmm30,ZWORD [rdx-0x2040],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x4a, 0x7f, 0x7b                         }, { vprold zmm30,DWORD [rdx+0x1fc]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x8a, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vprold zmm30,DWORD [rdx+0x200]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x4a, 0x80, 0x7b                         }, { vprold zmm30,DWORD [rdx-0x200]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x8a, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vprold zmm30,DWORD [rdx-0x204]{1to16},0x7b                   }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x15, 0xf4                                     }, { vprolvq zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x15, 0xf4                                     }, { vprolvq zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x15, 0xf4                                     }, { vprolvq zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x15, 0x31                                     }, { vprolvq zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x15, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vprolvq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x15, 0x31                                     }, { vprolvq zmm30,zmm29,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x15, 0x72, 0x7f                               }, { vprolvq zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x15, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vprolvq zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x15, 0x72, 0x80                               }, { vprolvq zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x15, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vprolvq zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x15, 0x72, 0x7f                               }, { vprolvq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x15, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vprolvq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x15, 0x72, 0x80                               }, { vprolvq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x15, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vprolvq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0x72, 0xcd, 0xab                               }, { vprolq zmm30,zmm29,0xab                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0x72, 0xcd, 0xab                               }, { vprolq zmm30{k7},zmm29,0xab                                  }
testcase	{ 0x62, 0x91, 0x8d, 0xc7, 0x72, 0xcd, 0xab                               }, { vprolq zmm30{k7}{z},zmm29,0xab                               }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0x72, 0xcd, 0x7b                               }, { vprolq zmm30,zmm29,0x7b                                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0x09, 0x7b                               }, { vprolq zmm30,ZWORD [rcx],0x7b                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0x72, 0x8c, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vprolq zmm30,ZWORD [rax+r14*8+0x123],0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0x09, 0x7b                               }, { vprolq zmm30,QWORD [rcx]{1to8},0x7b                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0x4a, 0x7f, 0x7b                         }, { vprolq zmm30,ZWORD [rdx+0x1fc0],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0x8a, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vprolq zmm30,ZWORD [rdx+0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0x4a, 0x80, 0x7b                         }, { vprolq zmm30,ZWORD [rdx-0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0x8a, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vprolq zmm30,ZWORD [rdx-0x2040],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0x4a, 0x7f, 0x7b                         }, { vprolq zmm30,QWORD [rdx+0x3f8]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0x8a, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vprolq zmm30,QWORD [rdx+0x400]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0x4a, 0x80, 0x7b                         }, { vprolq zmm30,QWORD [rdx-0x400]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0x8a, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vprolq zmm30,QWORD [rdx-0x408]{1to8},0x7b                    }
testcase	{ 0x62, 0x02, 0x15, 0x40, 0x14, 0xf4                                     }, { vprorvd zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x15, 0x47, 0x14, 0xf4                                     }, { vprorvd zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x15, 0xc7, 0x14, 0xf4                                     }, { vprorvd zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x14, 0x31                                     }, { vprorvd zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x15, 0x40, 0x14, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vprorvd zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x14, 0x31                                     }, { vprorvd zmm30,zmm29,DWORD [rcx]{1to16}                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x14, 0x72, 0x7f                               }, { vprorvd zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x14, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vprorvd zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x14, 0x72, 0x80                               }, { vprorvd zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x15, 0x40, 0x14, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vprorvd zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x14, 0x72, 0x7f                               }, { vprorvd zmm30,zmm29,DWORD [rdx+0x1fc]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x14, 0xb2, 0x00, 0x02, 0x00, 0x00             }, { vprorvd zmm30,zmm29,DWORD [rdx+0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x14, 0x72, 0x80                               }, { vprorvd zmm30,zmm29,DWORD [rdx-0x200]{1to16}                 }
testcase	{ 0x62, 0x62, 0x15, 0x50, 0x14, 0xb2, 0xfc, 0xfd, 0xff, 0xff             }, { vprorvd zmm30,zmm29,DWORD [rdx-0x204]{1to16}                 }
testcase	{ 0x62, 0x91, 0x0d, 0x40, 0x72, 0xc5, 0xab                               }, { vprord zmm30,zmm29,0xab                                      }
testcase	{ 0x62, 0x91, 0x0d, 0x47, 0x72, 0xc5, 0xab                               }, { vprord zmm30{k7},zmm29,0xab                                  }
testcase	{ 0x62, 0x91, 0x0d, 0xc7, 0x72, 0xc5, 0xab                               }, { vprord zmm30{k7}{z},zmm29,0xab                               }
testcase	{ 0x62, 0x91, 0x0d, 0x40, 0x72, 0xc5, 0x7b                               }, { vprord zmm30,zmm29,0x7b                                      }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x01, 0x7b                               }, { vprord zmm30,ZWORD [rcx],0x7b                                }
testcase	{ 0x62, 0xb1, 0x0d, 0x40, 0x72, 0x84, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vprord zmm30,ZWORD [rax+r14*8+0x123],0x7b                    }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x01, 0x7b                               }, { vprord zmm30,DWORD [rcx]{1to16},0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x42, 0x7f, 0x7b                         }, { vprord zmm30,ZWORD [rdx+0x1fc0],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x82, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vprord zmm30,ZWORD [rdx+0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x42, 0x80, 0x7b                         }, { vprord zmm30,ZWORD [rdx-0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x40, 0x72, 0x82, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vprord zmm30,ZWORD [rdx-0x2040],0x7b                         }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x42, 0x7f, 0x7b                         }, { vprord zmm30,DWORD [rdx+0x1fc]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x82, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vprord zmm30,DWORD [rdx+0x200]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x42, 0x80, 0x7b                         }, { vprord zmm30,DWORD [rdx-0x200]{1to16},0x7b                   }
testcase	{ 0x62, 0xf1, 0x0d, 0x50, 0x72, 0x82, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vprord zmm30,DWORD [rdx-0x204]{1to16},0x7b                   }
testcase	{ 0x62, 0x02, 0x95, 0x40, 0x14, 0xf4                                     }, { vprorvq zmm30,zmm29,zmm28                                    }
testcase	{ 0x62, 0x02, 0x95, 0x47, 0x14, 0xf4                                     }, { vprorvq zmm30{k7},zmm29,zmm28                                }
testcase	{ 0x62, 0x02, 0x95, 0xc7, 0x14, 0xf4                                     }, { vprorvq zmm30{k7}{z},zmm29,zmm28                             }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x14, 0x31                                     }, { vprorvq zmm30,zmm29,ZWORD [rcx]                              }
testcase	{ 0x62, 0x22, 0x95, 0x40, 0x14, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vprorvq zmm30,zmm29,ZWORD [rax+r14*8+0x123]                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x14, 0x31                                     }, { vprorvq zmm30,zmm29,QWORD [rcx]{1to8}                        }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x14, 0x72, 0x7f                               }, { vprorvq zmm30,zmm29,ZWORD [rdx+0x1fc0]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x14, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vprorvq zmm30,zmm29,ZWORD [rdx+0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x14, 0x72, 0x80                               }, { vprorvq zmm30,zmm29,ZWORD [rdx-0x2000]                       }
testcase	{ 0x62, 0x62, 0x95, 0x40, 0x14, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vprorvq zmm30,zmm29,ZWORD [rdx-0x2040]                       }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x14, 0x72, 0x7f                               }, { vprorvq zmm30,zmm29,QWORD [rdx+0x3f8]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x14, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vprorvq zmm30,zmm29,QWORD [rdx+0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x14, 0x72, 0x80                               }, { vprorvq zmm30,zmm29,QWORD [rdx-0x400]{1to8}                  }
testcase	{ 0x62, 0x62, 0x95, 0x50, 0x14, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vprorvq zmm30,zmm29,QWORD [rdx-0x408]{1to8}                  }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0x72, 0xc5, 0xab                               }, { vprorq zmm30,zmm29,0xab                                      }
testcase	{ 0x62, 0x91, 0x8d, 0x47, 0x72, 0xc5, 0xab                               }, { vprorq zmm30{k7},zmm29,0xab                                  }
testcase	{ 0x62, 0x91, 0x8d, 0xc7, 0x72, 0xc5, 0xab                               }, { vprorq zmm30{k7}{z},zmm29,0xab                               }
testcase	{ 0x62, 0x91, 0x8d, 0x40, 0x72, 0xc5, 0x7b                               }, { vprorq zmm30,zmm29,0x7b                                      }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0x01, 0x7b                               }, { vprorq zmm30,ZWORD [rcx],0x7b                                }
testcase	{ 0x62, 0xb1, 0x8d, 0x40, 0x72, 0x84, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vprorq zmm30,ZWORD [rax+r14*8+0x123],0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0x01, 0x7b                               }, { vprorq zmm30,QWORD [rcx]{1to8},0x7b                          }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0x42, 0x7f, 0x7b                         }, { vprorq zmm30,ZWORD [rdx+0x1fc0],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0x82, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vprorq zmm30,ZWORD [rdx+0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0x42, 0x80, 0x7b                         }, { vprorq zmm30,ZWORD [rdx-0x2000],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x40, 0x72, 0x82, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vprorq zmm30,ZWORD [rdx-0x2040],0x7b                         }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0x42, 0x7f, 0x7b                         }, { vprorq zmm30,QWORD [rdx+0x3f8]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0x82, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vprorq zmm30,QWORD [rdx+0x400]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0x42, 0x80, 0x7b                         }, { vprorq zmm30,QWORD [rdx-0x400]{1to8},0x7b                    }
testcase	{ 0x62, 0xf1, 0x8d, 0x50, 0x72, 0x82, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vprorq zmm30,QWORD [rdx-0x408]{1to8},0x7b                    }
testcase	{ 0x62, 0x03, 0xfd, 0x48, 0x09, 0xf5, 0xab                               }, { vrndscalepd zmm30,zmm29,0xab                                 }
testcase	{ 0x62, 0x03, 0xfd, 0x4f, 0x09, 0xf5, 0xab                               }, { vrndscalepd zmm30{k7},zmm29,0xab                             }
testcase	{ 0x62, 0x03, 0xfd, 0xcf, 0x09, 0xf5, 0xab                               }, { vrndscalepd zmm30{k7}{z},zmm29,0xab                          }
testcase	{ 0x62, 0x03, 0xfd, 0x18, 0x09, 0xf5, 0xab                               }, { vrndscalepd zmm30,zmm29,{sae},0xab                           }
testcase	{ 0x62, 0x03, 0xfd, 0x48, 0x09, 0xf5, 0x7b                               }, { vrndscalepd zmm30,zmm29,0x7b                                 }
testcase	{ 0x62, 0x03, 0xfd, 0x18, 0x09, 0xf5, 0x7b                               }, { vrndscalepd zmm30,zmm29,{sae},0x7b                           }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x09, 0x31, 0x7b                               }, { vrndscalepd zmm30,ZWORD [rcx],0x7b                           }
testcase	{ 0x62, 0x23, 0xfd, 0x48, 0x09, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vrndscalepd zmm30,ZWORD [rax+r14*8+0x123],0x7b               }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x09, 0x31, 0x7b                               }, { vrndscalepd zmm30,QWORD [rcx]{1to8},0x7b                     }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x09, 0x72, 0x7f, 0x7b                         }, { vrndscalepd zmm30,ZWORD [rdx+0x1fc0],0x7b                    }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x09, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vrndscalepd zmm30,ZWORD [rdx+0x2000],0x7b                    }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x09, 0x72, 0x80, 0x7b                         }, { vrndscalepd zmm30,ZWORD [rdx-0x2000],0x7b                    }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x09, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vrndscalepd zmm30,ZWORD [rdx-0x2040],0x7b                    }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x09, 0x72, 0x7f, 0x7b                         }, { vrndscalepd zmm30,QWORD [rdx+0x3f8]{1to8},0x7b               }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x09, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vrndscalepd zmm30,QWORD [rdx+0x400]{1to8},0x7b               }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x09, 0x72, 0x80, 0x7b                         }, { vrndscalepd zmm30,QWORD [rdx-0x400]{1to8},0x7b               }
testcase	{ 0x62, 0x63, 0xfd, 0x58, 0x09, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vrndscalepd zmm30,QWORD [rdx-0x408]{1to8},0x7b               }
testcase	{ 0x62, 0x03, 0x7d, 0x48, 0x08, 0xf5, 0xab                               }, { vrndscaleps zmm30,zmm29,0xab                                 }
testcase	{ 0x62, 0x03, 0x7d, 0x4f, 0x08, 0xf5, 0xab                               }, { vrndscaleps zmm30{k7},zmm29,0xab                             }
testcase	{ 0x62, 0x03, 0x7d, 0xcf, 0x08, 0xf5, 0xab                               }, { vrndscaleps zmm30{k7}{z},zmm29,0xab                          }
testcase	{ 0x62, 0x03, 0x7d, 0x18, 0x08, 0xf5, 0xab                               }, { vrndscaleps zmm30,zmm29,{sae},0xab                           }
testcase	{ 0x62, 0x03, 0x7d, 0x48, 0x08, 0xf5, 0x7b                               }, { vrndscaleps zmm30,zmm29,0x7b                                 }
testcase	{ 0x62, 0x03, 0x7d, 0x18, 0x08, 0xf5, 0x7b                               }, { vrndscaleps zmm30,zmm29,{sae},0x7b                           }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x08, 0x31, 0x7b                               }, { vrndscaleps zmm30,ZWORD [rcx],0x7b                           }
testcase	{ 0x62, 0x23, 0x7d, 0x48, 0x08, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vrndscaleps zmm30,ZWORD [rax+r14*8+0x123],0x7b               }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x08, 0x31, 0x7b                               }, { vrndscaleps zmm30,DWORD [rcx]{1to16},0x7b                    }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x08, 0x72, 0x7f, 0x7b                         }, { vrndscaleps zmm30,ZWORD [rdx+0x1fc0],0x7b                    }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x08, 0xb2, 0x00, 0x20, 0x00, 0x00, 0x7b       }, { vrndscaleps zmm30,ZWORD [rdx+0x2000],0x7b                    }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x08, 0x72, 0x80, 0x7b                         }, { vrndscaleps zmm30,ZWORD [rdx-0x2000],0x7b                    }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x08, 0xb2, 0xc0, 0xdf, 0xff, 0xff, 0x7b       }, { vrndscaleps zmm30,ZWORD [rdx-0x2040],0x7b                    }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x08, 0x72, 0x7f, 0x7b                         }, { vrndscaleps zmm30,DWORD [rdx+0x1fc]{1to16},0x7b              }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x08, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vrndscaleps zmm30,DWORD [rdx+0x200]{1to16},0x7b              }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x08, 0x72, 0x80, 0x7b                         }, { vrndscaleps zmm30,DWORD [rdx-0x200]{1to16},0x7b              }
testcase	{ 0x62, 0x63, 0x7d, 0x58, 0x08, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vrndscaleps zmm30,DWORD [rdx-0x204]{1to16},0x7b              }
testcase	{ 0x62, 0x03, 0x95, 0x07, 0x0b, 0xf4, 0xab                               }, { vrndscalesd xmm30{k7},xmm29,xmm28,0xab                       }
testcase	{ 0x62, 0x03, 0x95, 0x87, 0x0b, 0xf4, 0xab                               }, { vrndscalesd xmm30{k7}{z},xmm29,xmm28,0xab                    }
testcase	{ 0x62, 0x03, 0x95, 0x17, 0x0b, 0xf4, 0xab                               }, { vrndscalesd xmm30{k7},xmm29,xmm28,{sae},0xab                 }
testcase	{ 0x62, 0x03, 0x95, 0x07, 0x0b, 0xf4, 0x7b                               }, { vrndscalesd xmm30{k7},xmm29,xmm28,0x7b                       }
testcase	{ 0x62, 0x03, 0x95, 0x17, 0x0b, 0xf4, 0x7b                               }, { vrndscalesd xmm30{k7},xmm29,xmm28,{sae},0x7b                 }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x0b, 0x31, 0x7b                               }, { vrndscalesd xmm30{k7},xmm29,QWORD [rcx],0x7b                 }
testcase	{ 0x62, 0x23, 0x95, 0x07, 0x0b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vrndscalesd xmm30{k7},xmm29,QWORD [rax+r14*8+0x123],0x7b     }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x0b, 0x72, 0x7f, 0x7b                         }, { vrndscalesd xmm30{k7},xmm29,QWORD [rdx+0x3f8],0x7b           }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x0b, 0xb2, 0x00, 0x04, 0x00, 0x00, 0x7b       }, { vrndscalesd xmm30{k7},xmm29,QWORD [rdx+0x400],0x7b           }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x0b, 0x72, 0x80, 0x7b                         }, { vrndscalesd xmm30{k7},xmm29,QWORD [rdx-0x400],0x7b           }
testcase	{ 0x62, 0x63, 0x95, 0x07, 0x0b, 0xb2, 0xf8, 0xfb, 0xff, 0xff, 0x7b       }, { vrndscalesd xmm30{k7},xmm29,QWORD [rdx-0x408],0x7b           }
testcase	{ 0x62, 0x03, 0x15, 0x07, 0x0a, 0xf4, 0xab                               }, { vrndscaless xmm30{k7},xmm29,xmm28,0xab                       }
testcase	{ 0x62, 0x03, 0x15, 0x87, 0x0a, 0xf4, 0xab                               }, { vrndscaless xmm30{k7}{z},xmm29,xmm28,0xab                    }
testcase	{ 0x62, 0x03, 0x15, 0x17, 0x0a, 0xf4, 0xab                               }, { vrndscaless xmm30{k7},xmm29,xmm28,{sae},0xab                 }
testcase	{ 0x62, 0x03, 0x15, 0x07, 0x0a, 0xf4, 0x7b                               }, { vrndscaless xmm30{k7},xmm29,xmm28,0x7b                       }
testcase	{ 0x62, 0x03, 0x15, 0x17, 0x0a, 0xf4, 0x7b                               }, { vrndscaless xmm30{k7},xmm29,xmm28,{sae},0x7b                 }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x0a, 0x31, 0x7b                               }, { vrndscaless xmm30{k7},xmm29,DWORD [rcx],0x7b                 }
testcase	{ 0x62, 0x23, 0x15, 0x07, 0x0a, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vrndscaless xmm30{k7},xmm29,DWORD [rax+r14*8+0x123],0x7b     }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x0a, 0x72, 0x7f, 0x7b                         }, { vrndscaless xmm30{k7},xmm29,DWORD [rdx+0x1fc],0x7b           }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x0a, 0xb2, 0x00, 0x02, 0x00, 0x00, 0x7b       }, { vrndscaless xmm30{k7},xmm29,DWORD [rdx+0x200],0x7b           }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x0a, 0x72, 0x80, 0x7b                         }, { vrndscaless xmm30{k7},xmm29,DWORD [rdx-0x200],0x7b           }
testcase	{ 0x62, 0x63, 0x15, 0x07, 0x0a, 0xb2, 0xfc, 0xfd, 0xff, 0xff, 0x7b       }, { vrndscaless xmm30{k7},xmm29,DWORD [rdx-0x204],0x7b           }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x8b, 0x31                                     }, { vpcompressq ZWORD [rcx],zmm30                                }
testcase	{ 0x62, 0x62, 0xfd, 0x4f, 0x8b, 0x31                                     }, { vpcompressq ZWORD [rcx]{k7},zmm30                            }
testcase	{ 0x62, 0x22, 0xfd, 0x48, 0x8b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vpcompressq ZWORD [rax+r14*8+0x123],zmm30                    }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x8b, 0x72, 0x7f                               }, { vpcompressq ZWORD [rdx+0x3f8],zmm30                          }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x8b, 0xb2, 0x00, 0x04, 0x00, 0x00             }, { vpcompressq ZWORD [rdx+0x400],zmm30                          }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x8b, 0x72, 0x80                               }, { vpcompressq ZWORD [rdx-0x400],zmm30                          }
testcase	{ 0x62, 0x62, 0xfd, 0x48, 0x8b, 0xb2, 0xf8, 0xfb, 0xff, 0xff             }, { vpcompressq ZWORD [rdx-0x408],zmm30                          }
testcase	{ 0x62, 0x02, 0xfd, 0x48, 0x8b, 0xee                                     }, { vpcompressq zmm30,zmm29                                      }
testcase	{ 0x62, 0x02, 0xfd, 0x4f, 0x8b, 0xee                                     }, { vpcompressq zmm30{k7},zmm29                                  }
testcase	{ 0x62, 0x02, 0xfd, 0xcf, 0x8b, 0xee                                     }, { vpcompressq zmm30{k7}{z},zmm29                               }
testcase	{ 0xc5, 0xcc, 0x41, 0xef                                                 }, { kandw  k5,k6,k7                                              }
testcase	{ 0xc5, 0xcc, 0x42, 0xef                                                 }, { kandnw k5,k6,k7                                              }
testcase	{ 0xc5, 0xcc, 0x45, 0xef                                                 }, { korw   k5,k6,k7                                              }
testcase	{ 0xc5, 0xcc, 0x46, 0xef                                                 }, { kxnorw k5,k6,k7                                              }
testcase	{ 0xc5, 0xcc, 0x47, 0xef                                                 }, { kxorw  k5,k6,k7                                              }
testcase	{ 0xc5, 0xf8, 0x44, 0xee                                                 }, { knotw  k5,k6                                                 }
testcase	{ 0xc5, 0xf8, 0x98, 0xee                                                 }, { kortestw k5,k6                                               }
testcase	{ 0xc4, 0xe3, 0xf9, 0x30, 0xee, 0xab                                     }, { kshiftrw k5,k6,0xab                                          }
testcase	{ 0xc4, 0xe3, 0xf9, 0x30, 0xee, 0x7b                                     }, { kshiftrw k5,k6,0x7b                                          }
testcase	{ 0xc4, 0xe3, 0xf9, 0x32, 0xee, 0xab                                     }, { kshiftlw k5,k6,0xab                                          }
testcase	{ 0xc4, 0xe3, 0xf9, 0x32, 0xee, 0x7b                                     }, { kshiftlw k5,k6,0x7b                                          }
testcase	{ 0xc5, 0xf8, 0x90, 0xee                                                 }, { kmovw  k5,k6                                                 }
testcase	{ 0xc5, 0xf8, 0x90, 0x29                                                 }, { kmovw  k5,WORD [rcx]                                         }
testcase	{ 0xc4, 0xa1, 0x78, 0x90, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00             }, { kmovw  k5,WORD [rax+r14*8+0x123]                             }
testcase	{ 0xc5, 0xf8, 0x91, 0x29                                                 }, { kmovw  WORD [rcx],k5                                         }
testcase	{ 0xc4, 0xa1, 0x78, 0x91, 0xac, 0xf0, 0x23, 0x01, 0x00, 0x00             }, { kmovw  WORD [rax+r14*8+0x123],k5                             }
testcase	{ 0xc5, 0xf8, 0x92, 0xe8                                                 }, { kmovw  k5,eax                                                }
testcase	{ 0xc5, 0xf8, 0x92, 0xed                                                 }, { kmovw  k5,ebp                                                }
testcase	{ 0xc4, 0xc1, 0x78, 0x92, 0xed                                           }, { kmovw  k5,r13d                                               }
testcase	{ 0xc5, 0xf8, 0x93, 0xc5                                                 }, { kmovw  eax,k5                                                }
testcase	{ 0xc5, 0xf8, 0x93, 0xed                                                 }, { kmovw  ebp,k5                                                }
testcase	{ 0xc5, 0x78, 0x93, 0xed                                                 }, { kmovw  r13d,k5                                               }
testcase	{ 0xc5, 0xcd, 0x4b, 0xef                                                 }, { kunpckbw k5,k6,k7                                            }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x1d, 0x31, 0xab                               }, { vcvtps2ph YWORD [rcx],zmm30,0xab                             }
testcase	{ 0x62, 0x63, 0x7d, 0x4f, 0x1d, 0x31, 0xab                               }, { vcvtps2ph YWORD [rcx]{k7},zmm30,0xab                         }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x1d, 0x31, 0x7b                               }, { vcvtps2ph YWORD [rcx],zmm30,0x7b                             }
testcase	{ 0x62, 0x23, 0x7d, 0x48, 0x1d, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vcvtps2ph YWORD [rax+r14*8+0x123],zmm30,0x7b                 }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x1d, 0x72, 0x7f, 0x7b                         }, { vcvtps2ph YWORD [rdx+0xfe0],zmm30,0x7b                       }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x1d, 0xb2, 0x00, 0x10, 0x00, 0x00, 0x7b       }, { vcvtps2ph YWORD [rdx+0x1000],zmm30,0x7b                      }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x1d, 0x72, 0x80, 0x7b                         }, { vcvtps2ph YWORD [rdx-0x1000],zmm30,0x7b                      }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x1d, 0xb2, 0xe0, 0xef, 0xff, 0xff, 0x7b       }, { vcvtps2ph YWORD [rdx-0x1020],zmm30,0x7b                      }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x19, 0x31, 0xab                               }, { vextractf32x4 OWORD [rcx],zmm30,0xab                         }
testcase	{ 0x62, 0x63, 0x7d, 0x4f, 0x19, 0x31, 0xab                               }, { vextractf32x4 OWORD [rcx]{k7},zmm30,0xab                     }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x19, 0x31, 0x7b                               }, { vextractf32x4 OWORD [rcx],zmm30,0x7b                         }
testcase	{ 0x62, 0x23, 0x7d, 0x48, 0x19, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vextractf32x4 OWORD [rax+r14*8+0x123],zmm30,0x7b             }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x19, 0x72, 0x7f, 0x7b                         }, { vextractf32x4 OWORD [rdx+0x7f0],zmm30,0x7b                   }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x19, 0xb2, 0x00, 0x08, 0x00, 0x00, 0x7b       }, { vextractf32x4 OWORD [rdx+0x800],zmm30,0x7b                   }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x19, 0x72, 0x80, 0x7b                         }, { vextractf32x4 OWORD [rdx-0x800],zmm30,0x7b                   }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x19, 0xb2, 0xf0, 0xf7, 0xff, 0xff, 0x7b       }, { vextractf32x4 OWORD [rdx-0x810],zmm30,0x7b                   }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x1b, 0x31, 0xab                               }, { vextractf64x4 YWORD [rcx],zmm30,0xab                         }
testcase	{ 0x62, 0x63, 0xfd, 0x4f, 0x1b, 0x31, 0xab                               }, { vextractf64x4 YWORD [rcx]{k7},zmm30,0xab                     }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x1b, 0x31, 0x7b                               }, { vextractf64x4 YWORD [rcx],zmm30,0x7b                         }
testcase	{ 0x62, 0x23, 0xfd, 0x48, 0x1b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vextractf64x4 YWORD [rax+r14*8+0x123],zmm30,0x7b             }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x1b, 0x72, 0x7f, 0x7b                         }, { vextractf64x4 YWORD [rdx+0xfe0],zmm30,0x7b                   }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x1b, 0xb2, 0x00, 0x10, 0x00, 0x00, 0x7b       }, { vextractf64x4 YWORD [rdx+0x1000],zmm30,0x7b                  }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x1b, 0x72, 0x80, 0x7b                         }, { vextractf64x4 YWORD [rdx-0x1000],zmm30,0x7b                  }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x1b, 0xb2, 0xe0, 0xef, 0xff, 0xff, 0x7b       }, { vextractf64x4 YWORD [rdx-0x1020],zmm30,0x7b                  }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x39, 0x31, 0xab                               }, { vextracti32x4 OWORD [rcx],zmm30,0xab                         }
testcase	{ 0x62, 0x63, 0x7d, 0x4f, 0x39, 0x31, 0xab                               }, { vextracti32x4 OWORD [rcx]{k7},zmm30,0xab                     }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x39, 0x31, 0x7b                               }, { vextracti32x4 OWORD [rcx],zmm30,0x7b                         }
testcase	{ 0x62, 0x23, 0x7d, 0x48, 0x39, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vextracti32x4 OWORD [rax+r14*8+0x123],zmm30,0x7b             }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x39, 0x72, 0x7f, 0x7b                         }, { vextracti32x4 OWORD [rdx+0x7f0],zmm30,0x7b                   }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x39, 0xb2, 0x00, 0x08, 0x00, 0x00, 0x7b       }, { vextracti32x4 OWORD [rdx+0x800],zmm30,0x7b                   }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x39, 0x72, 0x80, 0x7b                         }, { vextracti32x4 OWORD [rdx-0x800],zmm30,0x7b                   }
testcase	{ 0x62, 0x63, 0x7d, 0x48, 0x39, 0xb2, 0xf0, 0xf7, 0xff, 0xff, 0x7b       }, { vextracti32x4 OWORD [rdx-0x810],zmm30,0x7b                   }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x3b, 0x31, 0xab                               }, { vextracti64x4 YWORD [rcx],zmm30,0xab                         }
testcase	{ 0x62, 0x63, 0xfd, 0x4f, 0x3b, 0x31, 0xab                               }, { vextracti64x4 YWORD [rcx]{k7},zmm30,0xab                     }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x3b, 0x31, 0x7b                               }, { vextracti64x4 YWORD [rcx],zmm30,0x7b                         }
testcase	{ 0x62, 0x23, 0xfd, 0x48, 0x3b, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00, 0x7b }, { vextracti64x4 YWORD [rax+r14*8+0x123],zmm30,0x7b             }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x3b, 0x72, 0x7f, 0x7b                         }, { vextracti64x4 YWORD [rdx+0xfe0],zmm30,0x7b                   }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x3b, 0xb2, 0x00, 0x10, 0x00, 0x00, 0x7b       }, { vextracti64x4 YWORD [rdx+0x1000],zmm30,0x7b                  }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x3b, 0x72, 0x80, 0x7b                         }, { vextracti64x4 YWORD [rdx-0x1000],zmm30,0x7b                  }
testcase	{ 0x62, 0x63, 0xfd, 0x48, 0x3b, 0xb2, 0xe0, 0xef, 0xff, 0xff, 0x7b       }, { vextracti64x4 YWORD [rdx-0x1020],zmm30,0x7b                  }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x29, 0x31                                     }, { vmovapd ZWORD [rcx],zmm30                                    }
testcase	{ 0x62, 0x61, 0xfd, 0x4f, 0x29, 0x31                                     }, { vmovapd ZWORD [rcx]{k7},zmm30                                }
testcase	{ 0x62, 0x21, 0xfd, 0x48, 0x29, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovapd ZWORD [rax+r14*8+0x123],zmm30                        }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x29, 0x72, 0x7f                               }, { vmovapd ZWORD [rdx+0x1fc0],zmm30                             }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x29, 0xb2, 0x00, 0x20, 0x00, 0x00             }, { vmovapd ZWORD [rdx+0x2000],zmm30                             }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x29, 0x72, 0x80                               }, { vmovapd ZWORD [rdx-0x2000],zmm30                             }
testcase	{ 0x62, 0x61, 0xfd, 0x48, 0x29, 0xb2, 0xc0, 0xdf, 0xff, 0xff             }, { vmovapd ZWORD [rdx-0x2040],zmm30                             }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x29, 0x31                                     }, { vmovaps ZWORD [rcx],zmm30                                    }
testcase	{ 0x62, 0x61, 0x7c, 0x4f, 0x29, 0x31                                     }, { vmovaps ZWORD [rcx]{k7},zmm30                                }
testcase	{ 0x62, 0x21, 0x7c, 0x48, 0x29, 0xb4, 0xf0, 0x23, 0x01, 0x00, 0x00       }, { vmovaps ZWORD [rax+r14*8+0x123],zmm30                        }
testcase	{ 0x62, 0x61, 0x7c, 0x48, 0x29, 0x72, 0x7f                               }, { vmovaps ZWORD [rdx+0x1fc0],zmm30                             }
testcase	{ 0x62, 0x61, 0x7c, 