# Generators are not automatically loaded by Rails
require 'generators/rspec/helper/helper_generator'
require 'support/generators'

RSpec.describe Rspec::Generators::HelperGenerator, type: :generator do
  setup_default_destination

  subject { file('spec/helpers/posts_helper_spec.rb') }
  describe 'generated by default' do
    before do
      run_generator %w[posts]
    end

    describe 'the spec' do
      it { is_expected.to exist }
      it { is_expected.to contain(/require 'rails_helper'/) }
      it { is_expected.to contain(/^RSpec.describe PostsHelper, #{type_metatag(:helper)}/) }
    end
  end
  describe 'skipped with a flag' do
    before do
      run_generator %w[posts --no-helper_specs]
    end
    it { is_expected.not_to exist }
  end
end
