package ONVIF::Device::Types::NTPInformation;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %FromDHCP_of :ATTR(:get<FromDHCP>);
my %NTPFromDHCP_of :ATTR(:get<NTPFromDHCP>);
my %NTPManual_of :ATTR(:get<NTPManual>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        FromDHCP
        NTPFromDHCP
        NTPManual
        Extension

    ) ],
    {
        'FromDHCP' => \%FromDHCP_of,
        'NTPFromDHCP' => \%NTPFromDHCP_of,
        'NTPManual' => \%NTPManual_of,
        'Extension' => \%Extension_of,
    },
    {
        'FromDHCP' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'NTPFromDHCP' => 'ONVIF::Device::Types::NetworkHost',
        'NTPManual' => 'ONVIF::Device::Types::NetworkHost',
        'Extension' => 'ONVIF::Device::Types::NTPInformationExtension',
    },
    {

        'FromDHCP' => 'FromDHCP',
        'NTPFromDHCP' => 'NTPFromDHCP',
        'NTPManual' => 'NTPManual',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::NTPInformation

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
NTPInformation from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * FromDHCP


=item * NTPFromDHCP


=item * NTPManual


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::NTPInformation
   FromDHCP =>  $some_value, # boolean
   NTPFromDHCP =>  { # ONVIF::Device::Types::NetworkHost
     Type => $some_value, # NetworkHostType
     IPv4Address => $some_value, # IPv4Address
     IPv6Address => $some_value, # IPv6Address
     DNSname => $some_value, # DNSName
     Extension =>  { # ONVIF::Device::Types::NetworkHostExtension
     },
   },
   NTPManual =>  { # ONVIF::Device::Types::NetworkHost
     Type => $some_value, # NetworkHostType
     IPv4Address => $some_value, # IPv4Address
     IPv6Address => $some_value, # IPv6Address
     DNSname => $some_value, # DNSName
     Extension =>  { # ONVIF::Device::Types::NetworkHostExtension
     },
   },
   Extension =>  { # ONVIF::Device::Types::NTPInformationExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

